/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.resourcerate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algo.output.IgnoreOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.algox.function.PlanResourceRatePublishFunction;
import kd.macc.cad.algox.function.PlanResourceRatePublishMfgFunction;
import kd.macc.cad.algox.function.ResourceRateImportFunction;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanResourceRatePublishService {
    private static final Log logger = LogFactory.getLog(PlanResourceRatePublishService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> publish(Long orgId, Long costAccountId, Long planSchemeId, long costType, String progressId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        try {
            Serializable costCenter;
            int total = 3;
            ProgressHelper.refreshProgress((String)ResManager.loadKDString((String)"\u6570\u636e\u9884\u5904\u7406", (String)"PlanResourceRatePublishService_0", (String)"macc-cad-algox", (Object[])new Object[0]), (int)1, (int)total, (Boolean)Boolean.FALSE, (String)progressId);
            QFilter qFilter = new QFilter("org", "=", (Object)orgId);
            qFilter.and(new QFilter("costaccount", "=", (Object)costAccountId));
            qFilter.and(new QFilter("planscheme", "=", (Object)planSchemeId));
            List periodIds = PlanFeeAllocHelper.getPlanSchemeEnableUnclosePeriods((Long)planSchemeId);
            qFilter.and(new QFilter("period", "in", (Object)periodIds));
            logger.info("ResourceRateAutoService filter ==>{}", (Object)qFilter);
            resultMap.put("status", Boolean.TRUE);
            String selectFiled = "org,costaccount,period,manuorg,currency,costcenter,element,subelement,subelement.type subelementtype,expenseitem allocexpenseitem,planrate,mulresource.fbasedataid resource,mulresource.fbasedataid.name resourcename,1938502639356500992L calcruleid";
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ResourceRateAutoService_autoImportRateResource_plan", (String)"cad_resourcplanrate", (String)selectFiled, (QFilter[])new QFilter[]{qFilter}, null);
            DataSet notCombineDataSet = dataSet.copy().filter("allocexpenseitem>0").select(new String[]{"costcenter", "allocexpenseitem", "subelement"});
            HashMap<String, Long> costSubElementMap = new HashMap<String, Long>(256);
            while (notCombineDataSet.hasNext()) {
                Row row = notCombineDataSet.next();
                costCenter = row.getLong("costcenter");
                Long allocExpenseItem = row.getLong("allocexpenseitem");
                Long subElement = row.getLong("subelement");
                String costDataKey = String.format("%s@%s", costCenter, allocExpenseItem);
                if (costSubElementMap.containsKey(costDataKey)) {
                    Long subElementId = (Long)costSubElementMap.get(costDataKey);
                    if (subElement == null || subElement.equals(subElementId)) continue;
                    resultMap.put("status", Boolean.FALSE);
                    resultMap.put("error", ResManager.loadKDString((String)"\u5931\u8d25\u3002\u5f53\u4f7f\u7528\u4ef7\u683c\u6765\u6e90\u4e3a\uff1a\u8d44\u6e90\u8ba1\u5212\u8d39\u7387\uff0c\u540c\u4e00\u8d39\u7528\u9879\u76ee\u5bf9\u5e94\u7684\u6210\u672c\u5b50\u8981\u7d20\u5e94\u8be5\u76f8\u540c\u3002", (String)"PlanResourceRatePublishService_1", (String)"macc-cad-algox", (Object[])new Object[0]));
                    HashMap<String, Object> hashMap = resultMap;
                    return hashMap;
                }
                costSubElementMap.put(costDataKey, subElement);
            }
            costSubElementMap.clear();
            dataSet = dataSet.groupBy(new String[]{"org", "costaccount", "period", "manuorg", "currency", "costcenter", "element", "subelement", "subelementtype", "resource", "resourcename", "calcruleid"}).sum("planrate").finish();
            DataSet result = PlanResourceRatePublishService.getWorkCenter(dataSet, costType);
            if (result.isEmpty()) {
                resultMap.put("count", 0);
                costCenter = resultMap;
                return costCenter;
            }
            result = result.filter("workcenter is not null and workcenter>0");
            DataSet resDataSet = result.copy().filter("subelementtype in ('001','002','004','005')");
            HashMap<String, HashSet<Long>> groupPeriodMap = new HashMap<String, HashSet<Long>>();
            HashSet<Long> existPeriodIdSet = new HashSet<Long>();
            for (Row row : resDataSet.copy()) {
                Long workCenterId = row.getLong("workcenter");
                Long resourceId = row.getLong("resource");
                Long periodId = row.getLong("period");
                existPeriodIdSet.add(periodId);
                String key = workCenterId + "@" + resourceId;
                groupPeriodMap.computeIfAbsent(key, p -> new HashSet(10)).add(periodId);
            }
            Map periodDateMap = PeriodHelper.getPeriodStartAndEndTime(existPeriodIdSet);
            DataSet mfgDataSet = result.filter("subelementtype = '003'");
            DataSet countDataSet = resDataSet.copy().groupBy(new String[]{"org", "costaccount", "period", "manuorg", "currency", "costcenter", "workcenter", "element", "resource", "resourcename", "calcruleid"}).countDistinct(new String[]{"subelement"}, "count").finish();
            countDataSet = countDataSet.filter("count>1");
            countDataSet = countDataSet.groupBy(new String[]{"resource", "resourcename"}).finish();
            String msg = "";
            while (countDataSet.hasNext()) {
                Row row = countDataSet.next();
                String resourcename = row.getString("resourcename");
                if (CadEmptyUtils.isEmpty((String)resourcename)) continue;
                if (CadEmptyUtils.isEmpty((String)msg)) {
                    msg = resourcename;
                    continue;
                }
                msg = msg + "\u3001" + resourcename;
            }
            if (!CadEmptyUtils.isEmpty((String)msg)) {
                String tip = String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u3010%s\u3011\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u6570\u636e\u3002", (String)"PlanResourceRatePublishService_2", (String)"macc-cad-algox", (Object[])new Object[0]), msg);
                resultMap.put("tip", tip);
            }
            ProgressHelper.refreshProgress((String)ResManager.loadKDString((String)"\u6b63\u5728\u53d1\u5e03", (String)"PlanResourceRatePublishService_3", (String)"macc-cad-algox", (Object[])new Object[0]), (int)2, (int)total, (Boolean)Boolean.FALSE, (String)progressId);
            JobSession session = AlgoX.createSession((String)"ResourceRateAutoService_autoImportRateResource");
            DataSetInput input = new DataSetInput(resDataSet);
            DataSetX dataSetX = session.fromInput((Input)input);
            PlanResourceRatePublishFunction func = new PlanResourceRatePublishFunction(resDataSet.getRowMeta(), costType, new ArrayList<String>(), planSchemeId, groupPeriodMap, periodDateMap);
            DataSetX mainDs = dataSetX.groupBy(new String[]{"org", "costaccount", "period", "manuorg", "currency", "costcenter", "workcenter", "element", "subelement", "subelementtype", "resource"}).reduceGroup((GroupReduceFunction)func);
            DataSetOutput resultSet = new DataSetOutput(ResourceRateImportFunction.targetRowMeta);
            String resultId = resultSet.getId();
            mainDs.output((Output)resultSet);
            session.commit(60, TimeUnit.MINUTES);
            int row = session.readDataSet(resultId).count("row", false);
            resultMap.put("count", row);
            session = AlgoX.createSession((String)"ResourceRateAutoService_autoImportRateResource_mfg");
            DataSetInput mfgInput = new DataSetInput(mfgDataSet);
            DataSetX mfgDataSetX = session.fromInput((Input)mfgInput);
            PlanResourceRatePublishMfgFunction mfgFunc = new PlanResourceRatePublishMfgFunction(mfgDataSet.getRowMeta(), costType, planSchemeId, periodDateMap);
            mfgDataSetX = mfgDataSetX.groupBy(new String[]{"org", "costaccount", "period", "manuorg", "currency", "costcenter", "workcenter", "element", "subelement", "subelementtype", "resource"}).reduceGroup((GroupReduceFunction)mfgFunc);
            mfgDataSetX.output((Output)new IgnoreOutput());
            session.commit(60, TimeUnit.MINUTES);
            ProgressHelper.refreshProgress((String)ResManager.loadKDString((String)"\u53d1\u5e03\u5b8c\u6210", (String)"PlanResourceRatePublishService_4", (String)"macc-cad-algox", (Object[])new Object[0]), (int)3, (int)total, (Boolean)Boolean.FALSE, (String)progressId);
        }
        catch (Exception e) {
            resultMap.put("status", Boolean.FALSE);
            resultMap.put("error", String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8d39\u7387\u53d1\u5e03\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002%s", (String)"PlanResourceRatePublishService_5", (String)"macc-cad-algox", (Object[])new Object[0]), e.getMessage()));
            logger.error("\u53d1\u5e03\u5f02\u5e38\u3002\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
        }
        finally {
            ProgressHelper.refreshProgress((String)ResManager.loadKDString((String)"", (String)"PlanResourceRatePublishService_6", (String)"macc-cad-algox", (Object[])new Object[0]), (int)-1, (int)0, (Boolean)Boolean.FALSE, (String)progressId);
        }
        logger.info("\u8d44\u6e90\u8ba1\u5212\u8d39\u7387\u53d1\u5e03\u6570\u636e\u6210\u529f");
        return resultMap;
    }

    private static List<Long> getWorkCenterFilter(long costTypeId) {
        ArrayList<Long> manuOrgs = new ArrayList<Long>();
        QFilter filter = new QFilter("id", "=", (Object)costTypeId);
        filter.and("type", "=", (Object)"1");
        filter.and("costtypeentry.costtypeattr", "=", (Object)"0");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"costtypeentry.costtype as costtype", (QFilter[])new QFilter[]{filter});
        if (dynamicObject != null) {
            QFilter typeFilter = new QFilter("costtype", "=", (Object)dynamicObject.getLong("costtype"));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,storageorgunit", (QFilter[])new QFilter[]{typeFilter});
            if (!dynamicObjects.isEmpty()) {
                for (DynamicObject obj : dynamicObjects) {
                    long calOrg = obj.getLong("calorg");
                    long invOrg = obj.getLong("storageorgunit");
                    if (OrgHelper.isOrgEnableMultiFactory((Long)calOrg)) {
                        List allToOrg = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)invOrg, (String)"04", (boolean)true);
                        if (CadEmptyUtils.isEmpty((List)allToOrg)) continue;
                        manuOrgs.addAll(allToOrg);
                        continue;
                    }
                    List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)calOrg, (boolean)true);
                    if (CadEmptyUtils.isEmpty((List)productOrgs)) continue;
                    manuOrgs.addAll(productOrgs);
                }
            }
        }
        return manuOrgs;
    }

    private static DataSet getWorkCenter(DataSet result, Long costType) {
        result = result.filter("resource is not null");
        Iterator iterator = result.copy().iterator();
        ArrayList<Long> costCenterIds = new ArrayList<Long>(20);
        while (iterator.hasNext()) {
            Row next = (Row)iterator.next();
            costCenterIds.add(next.getLong("costcenter"));
        }
        Date now = new Date();
        QFilter ccFilter = new QFilter("costcenter", "in", costCenterIds);
        ccFilter.and("effectdate", "<=", (Object)now);
        ccFilter.and("expdate", ">", (Object)now);
        ccFilter.and("entryentity.sourcetype", "=", (Object)"mpdm_workcentre");
        List<Long> manuOrg = PlanResourceRatePublishService.getWorkCenterFilter(costType);
        if (!CadEmptyUtils.isEmpty(manuOrg)) {
            QFilter workCenterFilter = new QFilter("createorg", "in", manuOrg);
            List workCenterIds = QueryServiceHelper.queryPrimaryKeys((String)"mpdm_workcentre", (QFilter[])workCenterFilter.toArray(), null, (int)-1);
            if (!CadEmptyUtils.isEmpty((List)workCenterIds)) {
                ccFilter.and(new QFilter("entryentity.sourcedata", "in", (Object)workCenterIds));
            } else {
                ccFilter.and(new QFilter("id", "=", (Object)-1));
            }
        } else {
            ccFilter.and(new QFilter("id", "=", (Object)-1));
        }
        DataSet wsDs = QueryServiceHelper.queryDataSet((String)"ResourceRateAutoService_getWorkCenter", (String)"bos_costcentersourcemap", (String)"costcenter,entryentity.sourcedata as workcenter", (QFilter[])new QFilter[]{ccFilter}, null);
        result = !wsDs.isEmpty() ? result.leftJoin(wsDs).on("costcenter", "costcenter").select(result.getRowMeta().getFieldNames(), new String[]{"workcenter"}).finish() : result.addField("'0'", "workcenter");
        return result;
    }
}

