/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.resourcerate.function;

import java.math.BigDecimal;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.cad.algox.utils.BigDecimalUtil;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanResRateCalcFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        BigDecimal totalamount = BigDecimal.ZERO;
        BigDecimal sumQty = BigDecimal.ZERO;
        RowX baseRow = null;
        StringBuilder resourceSb = new StringBuilder();
        for (RowX row : iterable) {
            if (baseRow == null) {
                totalamount = BigDecimalUtil.getOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("totalamount")));
                baseRow = row;
            }
            BigDecimal qty = BigDecimalUtil.getOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("qty")));
            sumQty = sumQty.add(qty);
            Long resourceId = row.getLong(this.sourceRowMeta.getFieldIndex("resource"));
            if (CadEmptyUtils.isEmpty((Long)resourceId)) continue;
            if (resourceSb.length() > 0) {
                resourceSb.append(",");
            }
            resourceSb.append(resourceId);
        }
        if (baseRow == null) {
            return;
        }
        baseRow.set(this.sourceRowMeta.getFieldIndex("qty"), (Object)sumQty);
        if (sumQty.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal planRate = totalamount.divide(sumQty, 10, 4);
            baseRow.set(this.sourceRowMeta.getFieldIndex("planrate"), (Object)planRate);
        }
        baseRow.set(this.sourceRowMeta.getFieldIndex("mulresource"), (Object)resourceSb.toString());
        collector.collect(baseRow);
    }
}

