/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.resourcerate.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.utils.BigDecimalUtil;

public class PlanResUnitConvisionFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        BigDecimal rate = null;
        int resourceunitIndex = this.sourceRowMeta.getFieldIndex("resourceunit");
        int qtyIndex = this.sourceRowMeta.getFieldIndex("qty");
        boolean find = true;
        for (RowX rowX : iterable) {
            if (rate == null) {
                Long resourceunit = rowX.getLong(resourceunitIndex);
                if (resourceunit == null) {
                    resourceunit = 0L;
                }
                if (resourceunit == 10L) {
                    rate = new BigDecimal(60);
                } else if (resourceunit == 8L) {
                    rate = BigDecimal.ONE.divide(new BigDecimal(60), 10, RoundingMode.HALF_UP);
                } else if (resourceunit == 0L) {
                    rate = new BigDecimal(1);
                } else if (resourceunit == 9L) {
                    rate = new BigDecimal(1);
                } else {
                    QFilter srcMuIdFilter = new QFilter("srcmuid", "=", (Object)resourceunit);
                    QFilter desMuIdFilter = new QFilter("desmuid", "=", (Object)9L);
                    DynamicObject measureUnitObj = QueryServiceHelper.queryOne((String)"bd_measureunitconv", (String)"denominator, numerator, desmuid", (QFilter[])new QFilter[]{srcMuIdFilter, desMuIdFilter});
                    if (measureUnitObj == null) {
                        srcMuIdFilter = new QFilter("srcmuid", "=", (Object)9L);
                        desMuIdFilter = new QFilter("desmuid", "=", (Object)resourceunit);
                        measureUnitObj = QueryServiceHelper.queryOne((String)"bd_measureunitconv", (String)"denominator, numerator, desmuid", (QFilter[])new QFilter[]{srcMuIdFilter, desMuIdFilter});
                    }
                    if (measureUnitObj == null) {
                        find = false;
                    } else {
                        BigDecimal denominat = BigDecimalUtil.getOrZero(measureUnitObj.getBigDecimal("denominator"));
                        BigDecimal numerator = BigDecimalUtil.getOrZero(measureUnitObj.getBigDecimal("numerator"));
                        rate = denominat.compareTo(BigDecimal.ZERO) == 0 || numerator.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : (measureUnitObj.getLong("desmuid") == 9L ? numerator.divide(denominat, 10, RoundingMode.HALF_UP) : denominat.divide(numerator, 10, RoundingMode.HALF_UP));
                    }
                }
            }
            if (!find) {
                rowX.set(resourceunitIndex, (Object)-1L);
                collector.collect(rowX);
                continue;
            }
            rowX.set(resourceunitIndex, (Object)9L);
            BigDecimal qty = BigDecimalUtil.getOrZero(rowX.getBigDecimal(qtyIndex));
            BigDecimal targetQty = null;
            targetQty = rate == null || rate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : qty.multiply(rate).setScale(3, RoundingMode.HALF_UP);
            rowX.set(qtyIndex, (Object)targetQty);
            collector.collect(rowX);
        }
    }
}

