/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.utils;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.utils.IInfoMsgHandler;

public class CadDataSetXLogUtil {
    private static final Log logger = LogFactory.getLog(CadDataSetXLogUtil.class);

    public static DataSetX logDataSetX(DataSetX dsx, String colName, String compareVal, String message, IInfoMsgHandler infoMsgHandler) {
        if (StringUtils.isEmpty((String)compareVal)) {
            return dsx;
        }
        return CadDataSetXLogUtil.logDataSetX(dsx, null, colName, compareVal, message, infoMsgHandler);
    }

    public static void logDataSet(DataSet ds, String colName, String compareVal, String message, IInfoMsgHandler infoMsgHandler) {
        CadDataSetXLogUtil.logDataSet(ds, colName, compareVal, message, infoMsgHandler, true);
    }

    public static DataSetX logDataSetX(DataSetX dsx, String[] groupby, final String colName, final String compareVal, final String message, final IInfoMsgHandler infoMsgHandler) {
        if (StringUtils.isEmpty((String)compareVal)) {
            return dsx;
        }
        GroupReduceFunction groupFunc = new GroupReduceFunction(){

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public void reduce(Iterable<RowX> rows, Collector cols) {
                Iterator<RowX> it = rows.iterator();
                ArrayList<RowX> listRow = new ArrayList<RowX>();
                while (it.hasNext()) {
                    RowX rowx = it.next();
                    listRow.add(rowx);
                }
                DataSet ds = CadDataSetXLogUtil.getDsFromAlgoxRows(listRow, null, this.sourceRowMeta);
                CadDataSetXLogUtil.logDataSet(ds, colName, compareVal, message, infoMsgHandler, true);
                for (RowX rowx : listRow) {
                    cols.collect(rowx);
                }
            }
        };
        if (groupby != null) {
            return dsx.groupBy(groupby).reduceGroup(groupFunc);
        }
        return dsx.reduceGroup(groupFunc);
    }

    public static void logDataSet(DataSet srcDs, String colName, String compareVal, String message, IInfoMsgHandler infoMsgHandler, boolean copy) {
        if (StringUtils.isEmpty((String)compareVal)) {
            return;
        }
        int valueIndex = srcDs.getRowMeta().getFieldIndex(colName, false);
        if (valueIndex == -1) {
            return;
        }
        StringBuilder sbHead = new StringBuilder();
        sbHead.append('\n');
        sbHead.append("logDataSetX:");
        sbHead.append(message);
        sbHead.append('\n');
        DataSet ds = copy ? srcDs.copy() : srcDs;
        RowMeta rowMeta = srcDs.getRowMeta();
        int cols = rowMeta.getFieldCount();
        for (int i = 0; i < cols; ++i) {
            sbHead = sbHead.append(rowMeta.getFieldAlias(i)).append('\t');
        }
        sbHead.append('\n');
        StringBuilder sb = new StringBuilder();
        for (Row row : ds) {
            if (row.get(valueIndex) == null || !row.getString(valueIndex).equals(compareVal)) continue;
            for (int i = 0; i < cols; ++i) {
                Object obj = row.get(i);
                sb.append(obj);
                sb.append('\t');
            }
            sb.append('\n');
        }
        if (sb.length() == 0) {
            logger.info(message + ": \u672a\u627e\u5230\u6570\u636e");
            return;
        }
        String tmp = sbHead.append((CharSequence)sb).toString();
        if (infoMsgHandler == null) {
            while (tmp.length() > 8000) {
                logger.info(tmp.substring(0, 8000));
                tmp = tmp.substring(8000, tmp.length());
            }
            logger.info(tmp);
        } else {
            infoMsgHandler.dealInfoMsg(tmp);
        }
    }

    public static boolean isDevDebugMode() {
        List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
        boolean isDebug = false;
        for (String arg : args) {
            if (!arg.startsWith("-Xrunjdwp") && !arg.startsWith("-agentlib:jdwp")) continue;
            isDebug = true;
            break;
        }
        return isDebug;
    }

    public static List<RowX> getListFromIterable(Iterable<RowX> rows) {
        Iterator<RowX> it = rows.iterator();
        ArrayList<RowX> listRow = new ArrayList<RowX>();
        while (it.hasNext()) {
            RowX rowx = it.next();
            listRow.add(rowx);
        }
        return listRow;
    }

    public static DataSet getDsFromAlgoxRows(Iterable<RowX> rows, String[] orderArr, RowMeta rowMeta) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        for (RowX row : rows) {
            dataList.add(row.values());
        }
        DataSet ds = Algo.create((String)"kd.macc.cad.algox.utils.DatSetXUtils.getDsFromAlgoxRows").createDataSet(dataList.iterator(), rowMeta);
        if (orderArr == null) {
            return ds;
        }
        return ds.orderBy(orderArr);
    }
}

