/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.utils;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.RowX;

public class DatSetXUtils {
    public static DataSet getDsFromAlgoxRows(Iterable<RowX> rows, String[] orderArr, RowMeta rowMeta) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        for (RowX row : rows) {
            dataList.add(row.values());
        }
        DataSet ds = Algo.create((String)"kd.macc.cad.algox.utils.DatSetXUtils.DatSetXUtils").createDataSet(dataList.iterator(), rowMeta);
        if (orderArr == null) {
            return ds;
        }
        return ds.orderBy(orderArr);
    }

    public static DataSetX union(DataSetX dataSetX, DataSetX dataSetXOther) {
        dataSetXOther = dataSetXOther.select(dataSetX.getRowMeta().getFieldNames());
        dataSetX = dataSetX.union(dataSetXOther);
        return dataSetX;
    }

    public static DataSetX unionIfRowDiff(DataSetX dataSet1, DataSetX dataSet2) {
        ArrayList srcFileds = Lists.newArrayList((Object[])dataSet1.getRowMeta().getFields());
        ArrayList destFields = Lists.newArrayList((Object[])dataSet2.getRowMeta().getFields());
        srcFileds.removeAll(destFields);
        Object[] values = new Object[srcFileds.size()];
        for (int i = 0; i < srcFileds.size(); ++i) {
            DataType dt = ((Field)srcFileds.get(i)).getDataType();
            if (dt.equals((Object)DataType.BigDecimalType)) {
                values[i] = BigDecimal.ZERO;
                continue;
            }
            if (dt.equals((Object)DataType.BooleanType)) {
                values[i] = false;
                continue;
            }
            if (dt.equals((Object)DataType.DoubleType)) {
                values[i] = 0.0;
                continue;
            }
            if (dt.equals((Object)DataType.IntegerType)) {
                values[i] = 0;
                continue;
            }
            if (dt.equals((Object)DataType.LongType)) {
                values[i] = 0L;
                continue;
            }
            if (dt.equals((Object)DataType.StringType)) {
                values[i] = " ";
                continue;
            }
            if (!dt.equals((Object)DataType.TimestampType)) continue;
            values[i] = new Date();
        }
        if (srcFileds.size() > 0) {
            dataSet2 = dataSet2.addFields(srcFileds.toArray(new Field[0]), values);
        }
        dataSet2 = dataSet2.select(dataSet1.getRowMeta().getFieldNames());
        dataSet1 = dataSet1.union(dataSet2);
        return dataSet1;
    }

    public static DataSetX addIfRowDiff(DataSetX dataSet1, DataSetX dataSet2) {
        ArrayList srcFileds = Lists.newArrayList((Object[])dataSet1.getRowMeta().getFields());
        ArrayList destFields = Lists.newArrayList((Object[])dataSet2.getRowMeta().getFields());
        srcFileds.removeAll(destFields);
        Object[] values = new Object[srcFileds.size()];
        for (int i = 0; i < srcFileds.size(); ++i) {
            DataType dt = ((Field)srcFileds.get(i)).getDataType();
            if (dt.equals((Object)DataType.BigDecimalType)) {
                values[i] = BigDecimal.ZERO;
                continue;
            }
            if (dt.equals((Object)DataType.BooleanType)) {
                values[i] = false;
                continue;
            }
            if (dt.equals((Object)DataType.DoubleType)) {
                values[i] = 0.0;
                continue;
            }
            if (dt.equals((Object)DataType.IntegerType)) {
                values[i] = 0;
                continue;
            }
            if (dt.equals((Object)DataType.LongType)) {
                values[i] = 0L;
                continue;
            }
            if (dt.equals((Object)DataType.StringType)) {
                values[i] = " ";
                continue;
            }
            if (!dt.equals((Object)DataType.TimestampType)) continue;
            values[i] = new Date();
        }
        if (srcFileds.size() > 0) {
            dataSet2 = dataSet2.addFields(srcFileds.toArray(new Field[0]), values);
        }
        dataSet2 = dataSet2.select(dataSet1.getRowMeta().getFieldNames());
        return dataSet2;
    }
}

