/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.algox.function.CostCenterCalculateFunction;
import kd.macc.cad.algox.function.CostObjectCalculateFunction;
import kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocHelper;
import kd.macc.cad.common.constants.CostDriverIdConstant;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;

public class FormulaUtil {
    private static final Log logger = LogFactory.getLog(FormulaUtil.class);
    private static final String OPERATOR = "+-*/()";
    private static final String[] PRIORITY = new String[]{"+-", "*/", "()"};
    private static final String COSTCENTER = "COSTCENTER";
    private static final String COSTOBJECT = "COSTOBJECT";
    private static final String MATERIAL = "MATERIAL";
    private static final String MATERIALGROUP = "MATERIALGROUP";
    private static final String ENTITY_CAD_COSTDRIVER = "cad_costdriver";
    private static final String ENTITY_DIYCOSTDRIVER = "sca_diycostdriver";
    private static Comparator<String> comp = (first, second) -> {
        int fIndex = 0;
        int sIndex = 0;
        for (int i = 0; i < PRIORITY.length; ++i) {
            if (PRIORITY[i].indexOf((String)first) >= 0) {
                fIndex = i;
            }
            if (PRIORITY[i].indexOf((String)second) < 0) continue;
            sIndex = i;
        }
        return fIndex - sIndex;
    };

    public static List<String> analyticFormula(String formula) {
        if (StringUtils.isEmpty((CharSequence)formula)) {
            return null;
        }
        formula = formula.replaceAll("\\s*", "");
        ArrayList<String> suffixList = new ArrayList<String>(10);
        Stack<String> opStack = new Stack<String>();
        StringBuilder buf = new StringBuilder();
        for (char c : formula.toCharArray()) {
            if (OPERATOR.indexOf(c) >= 0) {
                if (buf.length() > 0) {
                    suffixList.add(buf.toString());
                    buf.delete(0, buf.length());
                }
                if (c == '(') {
                    opStack.push(String.valueOf(c));
                    continue;
                }
                if (c == ')') {
                    String last = "";
                    while (opStack.size() > 0 && !(last = (String)opStack.pop()).equals("(")) {
                        suffixList.add(last);
                    }
                    if ("(".equals(last)) continue;
                    logger.error("illegal express. exp is :{}", (Object)formula);
                    return null;
                }
                if (opStack.size() > 0) {
                    String currentOp = String.valueOf(c);
                    String last = (String)opStack.peek();
                    if (last.equals("(") || comp.compare(currentOp, last) > 0) {
                        opStack.push(currentOp);
                        continue;
                    }
                    last = (String)opStack.pop();
                    suffixList.add(last);
                    opStack.push(currentOp);
                    continue;
                }
                opStack.push(String.valueOf(c));
                continue;
            }
            buf.append(c);
        }
        if (buf.length() > 0) {
            suffixList.add(buf.toString());
        }
        while (opStack.size() > 0) {
            String last = (String)opStack.pop();
            if ("()".indexOf(last) >= 0) {
                logger.error("illegal express. exp is :{}", (Object)formula);
                return null;
            }
            suffixList.add(last);
        }
        return suffixList;
    }

    public static DataSet doCalculateOnCostCenter(List<String> postfixExp, Long orgId, Long costAccountId, Long periodId, String appId, boolean enableMulFactory, boolean planData, Long planschemeId) {
        DataSet totalDs;
        ArrayList<Long> costDriverIds = new ArrayList<Long>();
        for (String exp : postfixExp) {
            if (OPERATOR.indexOf(exp) >= 0 || !FormulaUtil.isInteger(exp)) continue;
            costDriverIds.add(Long.valueOf(exp));
        }
        DataSet diyCostDriverDs = FormulaUtil.getDiyDsOnCostCenter(costDriverIds, orgId, costAccountId, periodId, appId, planData, planschemeId);
        if ((diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,org,manuorg,costcenter,benefcostcenter,sum(value) value group by costdriver,org,manuorg,costcenter,benefcostcenter")) == null || diyCostDriverDs.copy().isEmpty()) {
            return null;
        }
        MfgfeeAllocHelper mfgfeeAllocHelper = new MfgfeeAllocHelper();
        DataSet notDiyDs = mfgfeeAllocHelper.getStdValueNotDiyByIds(costDriverIds, orgId, periodId, appId, costAccountId, planData, planschemeId);
        if ((notDiyDs = notDiyDs.executeSql("select costdriver,org,manuorg,costcenter,benefcostcenter,sum(value) value group by costdriver,org,manuorg,costcenter,benefcostcenter")) == null || notDiyDs.copy().isEmpty()) {
            totalDs = diyCostDriverDs;
        } else {
            notDiyDs = notDiyDs.select("costdriver,org,manuorg,benefcostcenter,value");
            totalDs = FormulaUtil.getTotalDsOnCostCenter(diyCostDriverDs, notDiyDs, enableMulFactory);
            totalDs = totalDs.filter("costcenter is not null and costcenter != 0");
        }
        JobSession session = AlgoX.createSession((String)"FormulaUtil.doCalculateOnCostCenter");
        DataSetInput processingAllocInput = new DataSetInput(totalDs);
        DataSetX dataSetX = session.fromInput((Input)processingAllocInput);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("exp", postfixExp);
        paramMap.put("enableMulFactory", enableMulFactory);
        CostCenterCalculateFunction function = new CostCenterCalculateFunction(totalDs.getRowMeta(), paramMap);
        DataSetX mainDataSet = dataSetX.groupBy(new String[]{"costcenter"}).reduceGroup((GroupReduceFunction)function);
        DataSetOutput dataSetOutput = new DataSetOutput(totalDs.getRowMeta());
        String resultId = dataSetOutput.getId();
        mainDataSet.output((Output)dataSetOutput);
        session.commit(60, TimeUnit.MINUTES);
        return session.readDataSet(resultId);
    }

    private static DataSet getTotalDsOnCostCenter(DataSet diyCostDriverDs, DataSet notDiyDs, boolean enableMulFactory) {
        DataSet totalDs;
        if (enableMulFactory) {
            DataSet leftDs = diyCostDriverDs.leftJoin(notDiyDs).on("manuorg", "manuorg").on("benefcostcenter", "benefcostcenter").select(new String[]{"costdriver", "org", "manuorg", "costcenter", "benefcostcenter", "value"}).finish();
            DataSet rightDs = notDiyDs.leftJoin(diyCostDriverDs).on("manuorg", "manuorg").on("benefcostcenter", "benefcostcenter").select(new String[]{"costdriver", "org", "manuorg", "costcenter", "benefcostcenter", "value"}).finish();
            totalDs = leftDs.union(rightDs).distinct();
        } else {
            DataSet leftDs = diyCostDriverDs.leftJoin(notDiyDs).on("benefcostcenter", "benefcostcenter").select(new String[]{"costdriver", "org", "costcenter", "benefcostcenter", "value"}).finish();
            DataSet rightDs = notDiyDs.leftJoin(diyCostDriverDs).on("benefcostcenter", "benefcostcenter").select(new String[]{"costdriver", "org", "costcenter", "benefcostcenter", "value"}).finish();
            totalDs = leftDs.union(rightDs).distinct();
            totalDs = totalDs.select(new String[]{"costdriver", "org", "0 as manuorg", "costcenter", "benefcostcenter", "value"});
        }
        totalDs = totalDs.executeSql("select costdriver,org,manuorg,costcenter,benefcostcenter,sum(value) value group by costdriver,org,manuorg,costcenter,benefcostcenter");
        return totalDs;
    }

    public static DataSet getDiyDsOnCostCenter(List<Long> costDriverId, Long orgId, Long costAccountId, Long periodId, String appId, boolean planData, Long planschemeId) {
        QFilter baseFilter = new QFilter("billstatus", "=", (Object)"C");
        baseFilter.and("appnum", "=", (Object)appId);
        MfgfeeAllocHelper mfgfeeAllocHelper = new MfgfeeAllocHelper();
        DataSet diyCostDriverDs = mfgfeeAllocHelper.getStdValueDiy(orgId, costAccountId, periodId, appId, new HashSet<Long>(costDriverId), planData, planschemeId);
        diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,billtypenum,sum(value) value group by costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,billtypenum");
        return diyCostDriverDs.select("costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,value,billtypenum");
    }

    public static DataSet getCostdriverStdValOnCostObject(Long costdriverId, Long orgId, Long costAccountId, Long periodId, String appId, boolean enableMulFactory) {
        String number = String.valueOf(costdriverId);
        MfgfeeAllocHelper mfgfeeAllocHelper = new MfgfeeAllocHelper();
        DataSet diyCostDriverDs = null;
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter accountFilter = new QFilter("accountorg", "=", (Object)orgId);
        QFilter dateFilter = FormulaUtil.getDatefilter(periodId);
        QFilter baseFilter = new QFilter("billstatus", "=", (Object)"C");
        baseFilter.and("appnum", "=", (Object)appId);
        QFilter bookDateFilter = mfgfeeAllocHelper.getBookDateFilter(periodId);
        boolean isSys = true;
        DataSet totalDriverDs = null;
        ArrayList<Long> materials = new ArrayList<Long>();
        if ("sca".equals(appId)) {
            switch (number) {
                case "844089614712364032": {
                    diyCostDriverDs = mfgfeeAllocHelper.getFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                    break;
                }
                case "1620330732428060672": {
                    diyCostDriverDs = mfgfeeAllocHelper.getIsreworkFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                    break;
                }
                case "844089614712364033": {
                    diyCostDriverDs = mfgfeeAllocHelper.getOutFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                    break;
                }
                case "844089929922698240": {
                    diyCostDriverDs = mfgfeeAllocHelper.getPlannedOutputOnCostObject(accountFilter, dateFilter, baseFilter, appId);
                    break;
                }
                case "1919774047680688128": {
                    diyCostDriverDs = mfgfeeAllocHelper.getMftStockOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                    break;
                }
                case "844090213742861312": {
                    diyCostDriverDs = mfgfeeAllocHelper.getOnProductOnCostObject(accountFilter, dateFilter, baseFilter, appId);
                    break;
                }
                case "1028144987130497024": {
                    DataSet humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                    diyCostDriverDs = mfgfeeAllocHelper.getMachineHourOnCostObject(humanAndMachineHour, appId);
                    break;
                }
                case "1028146107680647168": {
                    DataSet humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                    diyCostDriverDs = mfgfeeAllocHelper.getHumanHourOnCostObject(humanAndMachineHour, appId);
                    break;
                }
                case "1028146107680647169": {
                    DataSet humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                    diyCostDriverDs = mfgfeeAllocHelper.getOutHumanHourOnCostObject(humanAndMachineHour, appId);
                    break;
                }
                case "1028146107680647170": {
                    DataSet humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                    diyCostDriverDs = mfgfeeAllocHelper.getActualHourOnCostObject(humanAndMachineHour, appId);
                    break;
                }
                case "1028146107680647171": {
                    DataSet humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                    diyCostDriverDs = mfgfeeAllocHelper.getOutActualHourOnCostObject(humanAndMachineHour, appId);
                    break;
                }
                default: {
                    isSys = false;
                    diyCostDriverDs = FormulaUtil.getDiyCostDriverOnCostObject(Long.valueOf(number), orgId, costAccountId, periodId, appId, totalDriverDs, materials, enableMulFactory, false, 0L);
                    break;
                }
            }
        } else if ("aca".equals(appId)) {
            switch (number) {
                case "844089614712364043": {
                    diyCostDriverDs = mfgfeeAllocHelper.getFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                    break;
                }
                case "844089614712364044": {
                    diyCostDriverDs = mfgfeeAllocHelper.getOutFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                    break;
                }
                case "844089929922698251": {
                    diyCostDriverDs = mfgfeeAllocHelper.getPlannedOutputOnCostObject(accountFilter, dateFilter, baseFilter, appId);
                    break;
                }
                case "1919779931978696704": {
                    diyCostDriverDs = mfgfeeAllocHelper.getMftStockOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                    break;
                }
                case "844090213742861323": {
                    diyCostDriverDs = mfgfeeAllocHelper.getOnProductOnCostObject(accountFilter, dateFilter, baseFilter, appId);
                    break;
                }
                case "844090490004888577": {
                    DataSet humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                    diyCostDriverDs = mfgfeeAllocHelper.getMachineHourOnCostObject(humanAndMachineHour, appId);
                    break;
                }
                case "844090490004888578": {
                    DataSet humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                    diyCostDriverDs = mfgfeeAllocHelper.getHumanHourOnCostObject(humanAndMachineHour, appId);
                    break;
                }
                case "844090490004888579": {
                    DataSet humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                    diyCostDriverDs = mfgfeeAllocHelper.getOutHumanHourOnCostObject(humanAndMachineHour, appId);
                    break;
                }
                case "844090490004888580": {
                    DataSet humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                    diyCostDriverDs = mfgfeeAllocHelper.getActualHourOnCostObject(humanAndMachineHour, appId);
                    break;
                }
                case "844090490004888581": {
                    DataSet humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                    diyCostDriverDs = mfgfeeAllocHelper.getOutActualHourOnCostObject(humanAndMachineHour, appId);
                    break;
                }
                case "844090490004888582": {
                    diyCostDriverDs = mfgfeeAllocHelper.getIsreworkFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                    break;
                }
                case "844090490004888583": {
                    diyCostDriverDs = mfgfeeAllocHelper.getAssistFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                    break;
                }
                case "844090490004888584": {
                    diyCostDriverDs = mfgfeeAllocHelper.getOutAssistFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                    break;
                }
                case "844090490004888585": {
                    diyCostDriverDs = mfgfeeAllocHelper.getReWorkAssistFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                    break;
                }
                case "844090490004888586": {
                    diyCostDriverDs = mfgfeeAllocHelper.getEndInProduceQtyOnCostObject(orgId, costAccountId, periodId);
                    break;
                }
                case "844090490004888587": {
                    diyCostDriverDs = mfgfeeAllocHelper.getEquivalentOnCostObject(orgId, costAccountId, periodId);
                    break;
                }
                default: {
                    isSys = false;
                    diyCostDriverDs = FormulaUtil.getDiyCostDriverOnCostObject(Long.valueOf(number), orgId, costAccountId, periodId, appId, totalDriverDs, materials, enableMulFactory, false, 0L);
                }
            }
        }
        if (diyCostDriverDs != null && isSys) {
            diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,costcenter as benefcostcenter,costobject,material,value,billtypenum");
        }
        return diyCostDriverDs;
    }

    public static DataSet doCalculateOnCostObject(Long complexDriverId, List<String> postfixExp, Long orgId, Long costAccountId, Long periodId, String appId, boolean enableMulFactory, boolean planData, Long planschemeId) {
        long allocCalcReportId;
        DataSet totalDriverDs = null;
        ArrayList<Long> materials = new ArrayList<Long>();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter accountFilter = new QFilter("accountorg", "=", (Object)orgId);
        QFilter dateFilter = FormulaUtil.getDatefilter(periodId);
        QFilter baseFilter = new QFilter("billstatus", "=", (Object)"C");
        baseFilter.and("appnum", "=", (Object)appId);
        DataSet diyCostDriverDs = null;
        MfgfeeAllocHelper mfgfeeAllocHelper = new MfgfeeAllocHelper();
        QFilter bookDateFilter = mfgfeeAllocHelper.getBookDateFilter(periodId);
        DataSet classifiedMaterialDataSet = null;
        ArrayList<String> materialGroups = new ArrayList<String>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        if (postfixExp.contains(String.valueOf(CostDriverIdConstant.STANDARD_COST_ACA))) {
            DynamicObject costDriver = BusinessDataServiceHelper.loadSingleFromCache((Object)complexDriverId, (String)ENTITY_CAD_COSTDRIVER, (String)"costtype");
            paramMap.put("simulCostTypeId", costDriver == null ? 0L : costDriver.getLong("costtype.id"));
        }
        for (String number : postfixExp) {
            DataSet humanAndMachineHour;
            if (OPERATOR.indexOf(number) >= 0 || !FormulaUtil.isInteger(number)) continue;
            boolean isSys = true;
            if ("sca".equals(appId)) {
                switch (number) {
                    case "844089614712364032": {
                        diyCostDriverDs = mfgfeeAllocHelper.getFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                        break;
                    }
                    case "1620330732428060672": {
                        diyCostDriverDs = mfgfeeAllocHelper.getIsreworkFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                        break;
                    }
                    case "844089614712364033": {
                        diyCostDriverDs = mfgfeeAllocHelper.getOutFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                        break;
                    }
                    case "844089929922698240": {
                        diyCostDriverDs = mfgfeeAllocHelper.getPlannedOutputOnCostObject(accountFilter, dateFilter, baseFilter, appId);
                        break;
                    }
                    case "1919774047680688128": {
                        diyCostDriverDs = mfgfeeAllocHelper.getMftStockOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                        break;
                    }
                    case "844090213742861312": {
                        diyCostDriverDs = mfgfeeAllocHelper.getOnProductOnCostObject(accountFilter, dateFilter, baseFilter, appId);
                        break;
                    }
                    case "1028144987130497024": {
                        humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                        diyCostDriverDs = mfgfeeAllocHelper.getMachineHourOnCostObject(humanAndMachineHour, appId);
                        break;
                    }
                    case "1028146107680647168": {
                        humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                        diyCostDriverDs = mfgfeeAllocHelper.getHumanHourOnCostObject(humanAndMachineHour, appId);
                        break;
                    }
                    case "1028146107680647169": {
                        humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                        diyCostDriverDs = mfgfeeAllocHelper.getOutHumanHourOnCostObject(humanAndMachineHour, appId);
                        break;
                    }
                    case "1028146107680647170": {
                        humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                        diyCostDriverDs = mfgfeeAllocHelper.getActualHourOnCostObject(humanAndMachineHour, appId);
                        break;
                    }
                    case "1028146107680647171": {
                        humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                        diyCostDriverDs = mfgfeeAllocHelper.getOutActualHourOnCostObject(humanAndMachineHour, appId);
                        break;
                    }
                    default: {
                        isSys = false;
                        classifiedMaterialDataSet = FormulaUtil.buildMaterialGroupDs(Long.valueOf(number), orgId, costAccountId, periodId, appId, classifiedMaterialDataSet, materialGroups, paramMap);
                        totalDriverDs = FormulaUtil.getDiyCostDriverOnCostObject(Long.valueOf(number), orgId, costAccountId, periodId, appId, totalDriverDs, materials, enableMulFactory, planData, planschemeId);
                        break;
                    }
                }
            } else if ("aca".equals(appId)) {
                switch (number) {
                    case "844089614712364043": {
                        diyCostDriverDs = mfgfeeAllocHelper.getFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                        break;
                    }
                    case "844089614712364044": {
                        diyCostDriverDs = mfgfeeAllocHelper.getOutFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                        break;
                    }
                    case "844089929922698251": {
                        diyCostDriverDs = mfgfeeAllocHelper.getPlannedOutputOnCostObject(accountFilter, dateFilter, baseFilter, appId);
                        break;
                    }
                    case "1919779931978696704": {
                        diyCostDriverDs = mfgfeeAllocHelper.getMftStockOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                        break;
                    }
                    case "844090213742861323": {
                        diyCostDriverDs = mfgfeeAllocHelper.getOnProductOnCostObject(accountFilter, dateFilter, baseFilter, appId);
                        break;
                    }
                    case "844090490004888577": {
                        humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                        diyCostDriverDs = mfgfeeAllocHelper.getMachineHourOnCostObject(humanAndMachineHour, appId);
                        break;
                    }
                    case "844090490004888578": {
                        humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                        diyCostDriverDs = mfgfeeAllocHelper.getHumanHourOnCostObject(humanAndMachineHour, appId);
                        break;
                    }
                    case "844090490004888579": {
                        humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                        diyCostDriverDs = mfgfeeAllocHelper.getOutHumanHourOnCostObject(humanAndMachineHour, appId);
                        break;
                    }
                    case "844090490004888580": {
                        humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                        diyCostDriverDs = mfgfeeAllocHelper.getActualHourOnCostObject(humanAndMachineHour, appId);
                        break;
                    }
                    case "844090490004888581": {
                        humanAndMachineHour = mfgfeeAllocHelper.getAllHourOnCostObject(orgFilter, bookDateFilter, baseFilter);
                        diyCostDriverDs = mfgfeeAllocHelper.getOutActualHourOnCostObject(humanAndMachineHour, appId);
                        break;
                    }
                    case "844090490004888582": {
                        diyCostDriverDs = mfgfeeAllocHelper.getIsreworkFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                        break;
                    }
                    case "844090490004888583": {
                        diyCostDriverDs = mfgfeeAllocHelper.getAssistFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                        break;
                    }
                    case "844090490004888584": {
                        diyCostDriverDs = mfgfeeAllocHelper.getOutAssistFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                        break;
                    }
                    case "844090490004888585": {
                        diyCostDriverDs = mfgfeeAllocHelper.getReWorkAssistFinishInputOnCostObject(orgFilter, bookDateFilter, baseFilter, appId);
                        break;
                    }
                    case "844090490004888586": {
                        diyCostDriverDs = mfgfeeAllocHelper.getEndInProduceQtyOnCostObject(orgId, costAccountId, periodId);
                        break;
                    }
                    case "844090490004888587": {
                        diyCostDriverDs = mfgfeeAllocHelper.getEquivalentOnCostObject(orgId, costAccountId, periodId);
                        break;
                    }
                    default: {
                        isSys = false;
                        classifiedMaterialDataSet = FormulaUtil.buildMaterialGroupDs(Long.valueOf(number), orgId, costAccountId, periodId, appId, classifiedMaterialDataSet, materialGroups, paramMap);
                        totalDriverDs = FormulaUtil.getDiyCostDriverOnCostObject(Long.valueOf(number), orgId, costAccountId, periodId, appId, totalDriverDs, materials, enableMulFactory, false, 0L);
                        break;
                    }
                }
            } else {
                isSys = false;
                classifiedMaterialDataSet = FormulaUtil.buildMaterialGroupDs(Long.valueOf(number), orgId, costAccountId, periodId, appId, classifiedMaterialDataSet, materialGroups, paramMap);
                totalDriverDs = FormulaUtil.getDiyCostDriverOnCostObject(Long.valueOf(number), orgId, costAccountId, periodId, appId, totalDriverDs, materials, enableMulFactory, false, 0L);
            }
            if (diyCostDriverDs == null || !isSys) continue;
            diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,costcenter as benefcostcenter,costobject,material,value,billtypenum");
            totalDriverDs = FormulaUtil.union(totalDriverDs, diyCostDriverDs);
        }
        if (totalDriverDs == null || totalDriverDs.isEmpty()) {
            return null;
        }
        paramMap.put("exp", postfixExp);
        paramMap.put("materialGroup", materialGroups);
        paramMap.put("material", materials);
        paramMap.put("orgId", orgId);
        paramMap.put("costAccountId", costAccountId);
        paramMap.put("periodId", periodId);
        paramMap.put("appId", appId);
        paramMap.put("enableMulFactory", enableMulFactory);
        QFilter reportQFilter = new QFilter("org", "=", (Object)orgId);
        reportQFilter.and("costaccount", "=", (Object)costAccountId);
        reportQFilter.and("period", "=", (Object)periodId);
        reportQFilter.and("costdriver", "=", (Object)complexDriverId);
        reportQFilter.and("iscalcdata", "=", (Object)Boolean.TRUE);
        reportQFilter.and("appnum", "=", (Object)appId);
        DynamicObject allocCalcReportDy = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_alloccalcreport", (QFilter[])reportQFilter.toArray());
        if (allocCalcReportDy == null) {
            allocCalcReportDy = BusinessDataServiceHelper.newDynamicObject((String)"cad_alloccalcreport");
            allocCalcReportId = MfgfeeAllocHelper.getId();
            allocCalcReportDy.set("id", (Object)allocCalcReportId);
            allocCalcReportDy.set("org", (Object)orgId);
            allocCalcReportDy.set("costaccount", (Object)costAccountId);
            allocCalcReportDy.set("period", (Object)periodId);
            allocCalcReportDy.set("costdriver", (Object)complexDriverId);
            allocCalcReportDy.set("iscalcdata", (Object)Boolean.TRUE);
            allocCalcReportDy.set("appnum", (Object)appId);
        } else {
            allocCalcReportId = allocCalcReportDy.getLong("id");
            DynamicObjectCollection entryEntity = allocCalcReportDy.getDynamicObjectCollection("entryentity");
            entryEntity.clear();
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{allocCalcReportDy});
        paramMap.put("isDisableAllocCalcReport", mfgfeeAllocHelper.isDisableAllocCalcReport(appId));
        paramMap.put("allocCalcReportId", allocCalcReportId);
        boolean isConSiAux = false;
        if (!CadEmptyUtils.isEmpty(materials)) {
            QFilter qFilter = new QFilter("org", "=", (Object)orgId);
            qFilter.and(new QFilter("costaccount", "=", (Object)costAccountId));
            qFilter.and(new QFilter("appnum", "=", (Object)appId));
            qFilter.and(new QFilter("costdriver", "in", materials));
            qFilter.and(new QFilter("entryentity.matauxpty", "!=", (Object)0L));
            isConSiAux = QueryServiceHelper.exists((String)ENTITY_DIYCOSTDRIVER, (QFilter[])qFilter.toArray());
        }
        return FormulaUtil.startCostObjectCalculate(paramMap, totalDriverDs, classifiedMaterialDataSet, isConSiAux);
    }

    private static DataSet buildMaterialGroupDs(Long costDriverId, Long orgId, Long costAccountId, Long periodId, String appId, DataSet classifiedMaterialDataSet, List<String> materialGroups, Map<String, Object> paramMap) {
        String allocClass;
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("appnum", "=", (Object)appId).and("id", "=", (Object)costDriverId);
        DynamicObject costDriver = QueryServiceHelper.queryOne((String)ENTITY_CAD_COSTDRIVER, (String)"id,allocclass,ismatgroupcal", (QFilter[])qFilter.toArray());
        if (costDriver != null && MATERIALGROUP.equals(allocClass = costDriver.getString("allocclass"))) {
            DynamicObject[] diyCostDriverDys;
            QFilter filters = new QFilter("org", "=", (Object)orgId);
            filters.and(new QFilter("appnum", "=", (Object)appId));
            filters.and(new QFilter("costdriver.id", "=", (Object)costDriverId));
            filters.and(new QFilter("effectperiod", "!=", (Object)0L));
            filters.and(new QFilter("costaccount", "=", (Object)costAccountId));
            filters.and(FormulaUtil.getEffectDateFilter(periodId));
            for (DynamicObject diyCostDriverDy : diyCostDriverDys = BusinessDataServiceHelper.load((String)ENTITY_DIYCOSTDRIVER, (String)"costdriver,org,materialgroupstd,entryentity,entryentity.materialgroup", (QFilter[])filters.toArray())) {
                DynamicObject materialGroupStandard = diyCostDriverDy.getDynamicObject("materialgroupstd");
                DynamicObjectCollection entryEntity = diyCostDriverDy.getDynamicObjectCollection("entryentity");
                HashSet<DynamicObject> materialGroupSet = new HashSet<DynamicObject>(16);
                entryEntity.forEach(s -> materialGroupSet.add(s.getDynamicObject("materialgroup")));
                DataSet materialDataSet = FormulaUtil.getClassifiedMaterialDataSet(materialGroupSet, materialGroupStandard);
                classifiedMaterialDataSet = classifiedMaterialDataSet == null ? materialDataSet : classifiedMaterialDataSet.union(materialDataSet).distinct();
            }
            materialGroups.add(String.valueOf(costDriverId));
            paramMap.put(String.valueOf(costDriverId), costDriver.getBoolean("ismatgroupcal"));
        }
        return classifiedMaterialDataSet;
    }

    private static Boolean isSumAllocValue() {
        String sumAllocValue = CadBgParamUtils.getCadBgParamForString((String)"isSumAllocValue", (String)"0");
        return "1".equals(sumAllocValue);
    }

    public static DataSet startCostObjectCalculate(Map<String, Object> paramMap, DataSet allDriverDs, DataSet classifiedMaterialDataSet, boolean isConSiAux) {
        long orgId = (Long)paramMap.get("orgId");
        long costAccountId = (Long)paramMap.get("costAccountId");
        boolean enableMulFactory = (Boolean)paramMap.get("enableMulFactory");
        HashSet<Long> costTypeSet = new HashSet<Long>(8);
        List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)orgId, (boolean)true);
        if (enableMulFactory) {
            for (Long manuOrgId : productOrgs) {
                Long costTypeId = CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)costAccountId, (Long)orgId, (Long)manuOrgId);
                costTypeSet.add(costTypeId);
            }
        } else {
            Long costTypeId = CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)costAccountId, (Long)orgId, null);
            costTypeSet.add(costTypeId);
        }
        paramMap.put("costTypeIds", costTypeSet);
        Map hsCostTypeByOrg = CostTypeHelper.getHsCostTypeByOrg((Long)orgId, new HashSet(productOrgs));
        paramMap.put("hsCostTypeByOrg", hsCostTypeByOrg);
        boolean isSumAllocValue = FormulaUtil.isSumAllocValue();
        allDriverDs = allDriverDs.distinct();
        if (isSumAllocValue) {
            allDriverDs = allDriverDs.groupBy(new String[]{"costdriver", "org", "manuorg", "costcenter", "benefcostcenter", "costobject", "material"}).sum("value").finish();
            allDriverDs = allDriverDs.addFields(new String[]{"1L", "''", "''"}, new String[]{"id", "billno", "billtypenum"});
        }
        DataSet costObjectDriverDs = allDriverDs.copy().filter("costobject != 0L and costobject is not null");
        DataSet costCenterDriverDs = allDriverDs.filter("costobject == 0L or costobject is null");
        costObjectDriverDs = classifiedMaterialDataSet != null ? costObjectDriverDs.join(classifiedMaterialDataSet, JoinType.INNER).on("material", "material").select(costObjectDriverDs.getRowMeta().getFieldNames(), new String[]{"materialgroup"}).finish() : costObjectDriverDs.addField("0L", "materialgroup");
        HashSet<Long> costObjectIds = new HashSet<Long>(16);
        DataSet costObjectDs = costObjectDriverDs.copy().select("costobject").distinct();
        for (Row row : costObjectDs) {
            costObjectIds.add(row.getLong("costobject"));
        }
        QFilter qFilter = new QFilter("id", "in", costObjectIds);
        DataSet costObjectDataSet = QueryServiceHelper.queryDataSet((String)"FormulaUtil.getCostObjectInfo", (String)"cad_costobject", (String)"id,configuredcode,tracknumber,auxpty as materialauxpty", (QFilter[])qFilter.toArray(), null);
        String appId = (String)paramMap.get("appId");
        boolean isAca = "aca".equals(appId);
        costObjectDriverDs = isConSiAux ? (isAca ? costObjectDriverDs.join(costObjectDataSet, JoinType.INNER).on("costobject", "id").select(costObjectDriverDs.getRowMeta().getFieldNames(), new String[]{"0L configuredcode", "0L tracknumber", "materialauxpty"}).finish() : costObjectDriverDs.join(costObjectDataSet, JoinType.INNER).on("costobject", "id").select(costObjectDriverDs.getRowMeta().getFieldNames(), new String[]{"configuredcode", "tracknumber", "materialauxpty"}).finish()) : (isAca ? costObjectDriverDs.join(costObjectDataSet, JoinType.INNER).on("costobject", "id").select(costObjectDriverDs.getRowMeta().getFieldNames(), new String[]{"0L configuredcode", "0L tracknumber", "0L materialauxpty"}).finish() : costObjectDriverDs.join(costObjectDataSet, JoinType.INNER).on("costobject", "id").select(costObjectDriverDs.getRowMeta().getFieldNames(), new String[]{"configuredcode", "tracknumber", "0L materialauxpty"}).finish());
        costCenterDriverDs = costCenterDriverDs.addFields(new String[]{"0L", "0L", "0L", "0L"}, new String[]{"materialgroup", "configuredcode", "tracknumber", "materialauxpty"});
        JobSession session = AlgoX.createSession((String)"FormulaUtil.doCalculateOnCostObject");
        DataSet totalDriverDs = DataSetUtils.union((DataSet)costObjectDriverDs, (DataSet)costCenterDriverDs);
        DataSetInput processingAllocInput = new DataSetInput(totalDriverDs);
        DataSetX dataSetX = session.fromInput((Input)processingAllocInput);
        CostObjectCalculateFunction function = new CostObjectCalculateFunction(totalDriverDs.getRowMeta(), paramMap);
        DataSetX mainDataSet = dataSetX.groupBy(new String[]{"benefcostcenter"}).reduceGroup((GroupReduceFunction)function);
        DataSetOutput dataSetOutput = new DataSetOutput(totalDriverDs.getRowMeta());
        String resultId = dataSetOutput.getId();
        mainDataSet.output((Output)dataSetOutput);
        session.commit(60, TimeUnit.MINUTES);
        return session.readDataSet(resultId);
    }

    private static DataSet getClassifiedMaterialDataSet(Set<DynamicObject> materialGroupSet, DynamicObject materialGroupStandard) {
        Object pkValue = 730148448254487552L;
        if (materialGroupStandard != null) {
            pkValue = materialGroupStandard.getPkValue();
        }
        DataSet classifiedMaterialDataSet = null;
        if (materialGroupSet != null && materialGroupSet.size() > 0) {
            for (DynamicObject materialGroup : materialGroupSet) {
                long materialGroupId = materialGroup.getLong("id");
                QFilter filter = new QFilter("standard", "=", pkValue);
                filter.and(FormulaUtil.getGroupFilter(materialGroup, "group.longnumber"));
                DataSet materialGroupDataSet = QueryServiceHelper.queryDataSet((String)"FormulaUtil.getClassifiedMaterialDataSet", (String)"bd_materialgroupdetail", (String)(materialGroupId + " as materialgroup,material"), (QFilter[])filter.toArray(), (String)"group desc");
                if (classifiedMaterialDataSet == null) {
                    classifiedMaterialDataSet = materialGroupDataSet;
                    continue;
                }
                classifiedMaterialDataSet = classifiedMaterialDataSet.union(materialGroupDataSet).distinct();
            }
        }
        return classifiedMaterialDataSet;
    }

    public static QFilter getGroupFilter(DynamicObject materialGroup, String fieldName) {
        if (materialGroup != null) {
            DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"bd_materialgroup").getProperty("parent");
            GroupProp group = (GroupProp)property;
            String longNumberDLM = "";
            if (group instanceof ParentBasedataProp) {
                longNumberDLM = ((ParentBasedataProp)group).getLongNumberDLM();
            }
            QFilter groupFilter = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            HashSet<String> groupNumSet = new HashSet<String>(16);
            String longnumber = materialGroup.getString("longnumber");
            groupFilter.or(new QFilter(fieldName, "like", (Object)(longnumber + longNumberDLM + "%")));
            groupNumSet.add(longnumber);
            if (!groupNumSet.isEmpty()) {
                groupFilter.or(new QFilter(fieldName, "in", groupNumSet));
            }
            return groupFilter;
        }
        return QFilter.of((String)"1=1", (Object[])new Object[0]);
    }

    public static boolean isInteger(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    private static DataSet union(DataSet dataSet1, DataSet dataSet2) {
        if (dataSet1 == null && dataSet2 == null) {
            return null;
        }
        if (dataSet1 == null) {
            return dataSet2;
        }
        if (dataSet2 == null) {
            return dataSet1;
        }
        DataSet result = dataSet1.union(dataSet2);
        return result;
    }

    private static DataSet getDiyCostDriverOnCostObject(Long costDriverId, Long orgId, Long costAccountId, Long periodId, String appId, DataSet totalDriverDs, List<Long> materials, boolean enableMulFactory, boolean planData, Long planschemeId) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("appnum", "=", (Object)appId).and("id", "=", (Object)costDriverId);
        DynamicObject costDriver = QueryServiceHelper.queryOne((String)ENTITY_CAD_COSTDRIVER, (String)"id,allocclass", (QFilter[])qFilter.toArray());
        if (costDriver != null) {
            String algoKey = "kd.macc.cad.algox.utils.FormulaUtil#getDiyCostDriverOnCostObject";
            String allocClass = costDriver.getString("allocclass");
            if (COSTCENTER.equals(allocClass)) {
                ArrayList<Long> costDriverIds = new ArrayList<Long>();
                costDriverIds.add(costDriverId);
                DataSet diyCostDriverDs = FormulaUtil.getDiyDsOnCostCenter(costDriverIds, orgId, costAccountId, periodId, appId, planData, planschemeId);
                MfgfeeAllocHelper mfgfeeAllocHelper = new MfgfeeAllocHelper();
                DataSet notDiyDs = mfgfeeAllocHelper.getStdValueNotDiyByIds(costDriverIds, orgId, periodId, appId, costAccountId, planData, planschemeId);
                DataSet totalDs = diyCostDriverDs.union(notDiyDs);
                totalDs = totalDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,billtypenum,sum(value) value group by costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,billtypenum");
                totalDs = totalDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,0 as costobject,0 as material,value,billtypenum");
                totalDriverDs = FormulaUtil.union(totalDriverDs, totalDs);
            } else if (COSTOBJECT.equals(allocClass)) {
                ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
                QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                QFilter baseFilter = new QFilter("billstatus", "=", (Object)"C");
                baseFilter.and("appnum", "=", (Object)appId);
                filters.add(orgFilter);
                filters.add(new QFilter("appnum", "=", (Object)appId));
                filters.add(new QFilter("costdriver.id", "=", (Object)costDriverId));
                filters.add(new QFilter("costdriver.islinkresource", "=", (Object)Boolean.FALSE));
                filters.add(new QFilter("effectperiod", "!=", (Object)0L));
                filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
                filters.add(FormulaUtil.getEffectDateFilter(periodId));
                DataSet diyCostDriverDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)ENTITY_DIYCOSTDRIVER, (String)"costdriver,id,billno,org,manuorg,costcenter,entryentity.costobject as costobject,entryentity.costobject.material as material,entryentity.entryqty value,'sca_diycostdriver' as billtypenum", (QFilter[])filters.toArray(new QFilter[0]), null);
                MfgfeeAllocHelper mfgfeeAllocHelper = new MfgfeeAllocHelper();
                QFilter bookDateFilter = mfgfeeAllocHelper.getBookDateFilter(periodId);
                HashSet<Long> costDriverIds = new HashSet<Long>();
                costDriverIds.add(costDriverId);
                DataSet costObjectResourceUse = mfgfeeAllocHelper.getCOResourceUse(appId, orgFilter, bookDateFilter, baseFilter, costDriverIds, costAccountId, periodId, planData, planschemeId);
                costObjectResourceUse = costObjectResourceUse.select("costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,billtypenum");
                diyCostDriverDs = diyCostDriverDs.union(costObjectResourceUse);
                diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,costobject,material,billtypenum,sum(value) value group by costdriver,id,billno,org,manuorg,costcenter,costobject,material,billtypenum");
                diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,costcenter as benefcostcenter,costobject,material,value,billtypenum");
                totalDriverDs = FormulaUtil.union(totalDriverDs, diyCostDriverDs);
                DataSet joinAndSecOnCostObject = mfgfeeAllocHelper.getJoinAndSecOnCostObject(orgId, orgFilter, bookDateFilter, baseFilter, Collections.singleton(costDriverId));
                if (joinAndSecOnCostObject != null) {
                    joinAndSecOnCostObject = joinAndSecOnCostObject.executeSql("select costdriver,id,billno,org,manuorg,costcenter,costcenter as benefcostcenter,costobject,material,value,billtypenum");
                    totalDriverDs = FormulaUtil.union(totalDriverDs, joinAndSecOnCostObject);
                }
            } else if (MATERIAL.equals(allocClass)) {
                materials.add(costDriverId);
            }
        }
        return totalDriverDs;
    }

    public static QFilter getEffectDateFilter(Long periodId) {
        Date date = FormulaUtil.getEndDateByPeriod(periodId);
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
        dateFilter.and("expdate", ">", (Object)date);
        return dateFilter;
    }

    private static Date getEndDateByPeriod(Long periodId) {
        QFilter qFilter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,enddate", (QFilter[])qFilter.toArray());
        if (period == null) {
            return new Date();
        }
        return period.getDate("enddate");
    }

    private static QFilter getDatefilter(Long periodId) {
        QFilter idfilter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate,enddate", (QFilter[])idfilter.toArray());
        QFilter datefilter = new QFilter("bizdate", ">=", (Object)period.getDate("begindate"));
        datefilter.and("bizdate", "<=", (Object)period.getDate("enddate"));
        return datefilter;
    }

    public static String getCompleteFormula(String formula, String currentNumber, String currentName, long costDriverId) throws KDBizException {
        if (StringUtils.isNotEmpty((CharSequence)formula)) {
            List<Long> costDriverIds = FormulaUtil.getCostDriverIds(formula);
            QFilter qFilter = new QFilter("id", "in", costDriverIds);
            QFilter statusFilter = new QFilter("status", "!=", (Object)"C");
            statusFilter.or(new QFilter("enable", "=", (Object)"0"));
            boolean isExists = QueryServiceHelper.exists((String)ENTITY_CAD_COSTDRIVER, (QFilter[])new QFilter[]{qFilter, statusFilter});
            if (isExists) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s/%2$s\u201d\u516c\u5f0f\u4e2d\u5b58\u5728\u975e\u5df2\u5ba1\u6838\u6216\u7981\u7528\u72b6\u6001\u7684\u6210\u672c\u52a8\u56e0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FormulaUtil_2", (String)"macc-cad-algox", (Object[])new Object[0]), currentNumber, currentName));
            }
            qFilter.and(new QFilter("iscomplexcd", "=", (Object)Boolean.TRUE));
            DynamicObjectCollection costDrivers = QueryServiceHelper.query((String)ENTITY_CAD_COSTDRIVER, (String)"id,formula,name", (QFilter[])qFilter.toArray());
            for (DynamicObject costDriver : costDrivers) {
                String subFormula = costDriver.getString("formula");
                String id = costDriver.getString("id");
                List<Long> costDriverIdList = FormulaUtil.getCostDriverIds(subFormula);
                if (costDriverIdList.contains(costDriverId)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s/%2$s\u201d\u516c\u5f0f\u4e2d\u5b58\u5728\u5d4c\u5957\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FormulaUtil_3", (String)"macc-cad-algox", (Object[])new Object[0]), currentNumber, currentName));
                }
                if (StringUtils.isNotBlank((CharSequence)subFormula)) {
                    subFormula = "(" + subFormula + ")";
                }
                formula = formula.replaceAll(id, subFormula);
                FormulaUtil.getCompleteFormula(formula, currentNumber, currentName, costDriverId);
            }
        }
        return formula;
    }

    private static List<Long> getCostDriverIds(String formula) {
        String[] formulaArr;
        String formulaString = formula.replaceAll("\\s*", "");
        ArrayList<Long> costDriverIds = new ArrayList<Long>();
        if (StringUtils.isNotEmpty((CharSequence)formulaString) && (formulaArr = formulaString.split("\\D")) != null) {
            for (String id : formulaArr) {
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                costDriverIds.add(Long.valueOf(id));
            }
        }
        return costDriverIds;
    }
}

