/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.price.AdditionalCost;
import kd.macc.cad.common.price.CostInfoDetail;
import kd.macc.cad.common.price.PricePluginPojo;
import kd.macc.cad.common.price.PurchasePricing;
import kd.macc.cad.common.price.Supplier;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.mservice.api.AutoPricingService;

public class AutoPricingServiceImpl
extends PurchasePricing
implements AutoPricingService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> execute(String entityName, List<Long> orgList, List<Long> accountList, Long createId, Long costType, String appNum, String progressId) {
        logger.info("\u5b9e\u4f53==>{},\u8fdb\u5165\u81ea\u5b9a\u4e49\u91c7\u8d2d\u53d6\u4ef7", (Object)entityName);
        try (TXHandle txHandle = TX.required();){
            Map<String, Object> map = new HashMap<String, Boolean>();
            ArrayList<DLock> lockList = new ArrayList<DLock>(orgList.size());
            try {
                for (Long org : orgList) {
                    DLock lock = DLock.create((String)("AutoPricing_" + entityName + "_" + org), (String)ResManager.loadKDString((String)"\u91c7\u8d2d\u53d6\u4ef7\u9501", (String)"AutoPricingServiceImpl_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    lockList.add(lock);
                    boolean isLocked = lock.tryLock();
                    if (isLocked) continue;
                    DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)org)});
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u91c7\u8d2d\u53d6\u4ef7\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"AutoPricingServiceImpl_1", (String)"macc-cad-mservice", (Object[])new Object[0]), dynamicObject.getString("name")));
                }
                map = this.executeRulePlugin(entityName, orgList, accountList, createId, costType, appNum, progressId);
                map.put("status", true);
            }
            catch (Exception e) {
                txHandle.markRollback();
                logger.info("\u91c7\u8d2d\u53d6\u4ef7\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\uff0c\u53d6\u4ef7\u5b9e\u4f53==>{},error==>{}", (Object)entityName, (Object)e);
                map.put("status", false);
                map.put("errMsg", e.getMessage().length() > 500 ? e.getMessage().substring(0, 500) : e.getMessage());
            }
            finally {
                if (!lockList.isEmpty()) {
                    for (DLock lock : lockList) {
                        lock.close();
                    }
                }
                ProgressHelper.refreshProgress((String)ResManager.loadKDString((String)"", (String)"AutoPricingServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]), (int)-1, (int)0, (Boolean)Boolean.FALSE, (String)progressId);
            }
            logger.info("\u5b9e\u4f53==>{},\u81ea\u5b9a\u4e49\u91c7\u8d2d\u53d6\u4ef7\u5b8c\u6210", (Object)entityName);
            Map<String, Object> map2 = map;
            return map2;
        }
    }

    public int purPriceTransform(Long costType, long ruleId, Long createId, List<PricePluginPojo> results) {
        HashMap<String, PricePluginPojo> resultMap = new HashMap<String, PricePluginPojo>(16);
        HashMap<String, DynamicObject> dyoMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> expireMap = new HashMap<String, DynamicObject>();
        Date now = new Date();
        this.buildCompareMap("cad_purprices", costType, ruleId, results, resultMap, dyoMap, expireMap);
        ArrayList<PricePluginPojo> addList = new ArrayList<PricePluginPojo>(16);
        ArrayList<DynamicObject> invalidateList = new ArrayList<DynamicObject>(16);
        for (Map.Entry resultEntry : resultMap.entrySet()) {
            DynamicObjectCollection purSupEntry;
            Object dynamicObject2;
            String key = (String)resultEntry.getKey();
            PricePluginPojo value = (PricePluginPojo)resultEntry.getValue();
            DynamicObject obj = (DynamicObject)dyoMap.get(key);
            if (obj == null) {
                if (expireMap.get(key) == null) {
                    value.setEffFlag(true);
                }
                addList.add(value);
                continue;
            }
            DynamicObjectCollection entryEntity = obj.getDynamicObjectCollection("entryentity");
            ArrayList<String> entryKeyList = new ArrayList<String>(10);
            for (Object dynamicObject2 : entryEntity) {
                if (dynamicObject2.getBigDecimal("rate").compareTo(BigDecimal.ZERO) != 0) continue;
                entryKeyList.add(dynamicObject2.getLong("element.id") + "@" + dynamicObject2.getLong("subelement.id") + "@" + dynamicObject2.getBigDecimal("price").setScale(10, 4));
            }
            ArrayList<String> costInfoKeyList = new ArrayList<String>(10);
            dynamicObject2 = value.getCostInfoDetailList().iterator();
            while (dynamicObject2.hasNext()) {
                CostInfoDetail costInfoDetail = (CostInfoDetail)dynamicObject2.next();
                costInfoKeyList.add(costInfoDetail.getElement() + "@" + costInfoDetail.getSubElement() + "@" + costInfoDetail.getPrice().setScale(10, 4));
            }
            if (entryKeyList.size() == costInfoKeyList.size() && entryKeyList.containsAll(costInfoKeyList) && costInfoKeyList.containsAll(entryKeyList) && (purSupEntry = obj.getDynamicObjectCollection("pursupentry")).size() == value.getSuppliers().size()) {
                ArrayList<String> supEntryKey = new ArrayList<String>(5);
                for (DynamicObject object : purSupEntry) {
                    supEntryKey.add(object.getLong("supplier.id") + "@" + object.getBigDecimal("quotaratio").setScale(10, 4) + "@" + object.getBigDecimal("unitprice").setScale(10, 4));
                }
                ArrayList<String> supKeys = new ArrayList<String>(5);
                for (Supplier supplier : value.getSuppliers()) {
                    supKeys.add(supplier.getSupplierId() + "@" + supplier.getQuoaratio().setScale(10, 4) + "@" + supplier.getUnitPrice().setScale(10, 4));
                }
                if (supEntryKey.containsAll(supKeys) && supKeys.containsAll(supEntryKey)) continue;
            }
            value.setEffFlag(false);
            addList.add(value);
            invalidateList.add(obj);
        }
        this.invalidBill(now, invalidateList, "cad_purprices");
        this.addPurPriceBill(now, costType, ruleId, createId, addList);
        logger.info("\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u5355\u636e\u8f6c\u6362\u5b8c\u6210\uff0c\u6210\u672c\u7c7b\u578b\uff1a{}\uff0c\u89c4\u5219\uff1a{}\uff0c\u6570\u91cf\uff1a{}", new Object[]{costType, ruleId, addList.size()});
        return addList.size();
    }

    protected int outPriceTransform(Long costType, long ruleId, Long createId, List<PricePluginPojo> results) {
        HashMap<String, PricePluginPojo> resultMap = new HashMap<String, PricePluginPojo>(16);
        HashMap<String, DynamicObject> dyoMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> expireMap = new HashMap<String, DynamicObject>();
        this.buildCompareMap("cad_outsourceprice", costType, ruleId, results, resultMap, dyoMap, expireMap);
        Date now = new Date();
        ArrayList<PricePluginPojo> addList = new ArrayList<PricePluginPojo>(16);
        ArrayList<DynamicObject> invalidateList = new ArrayList<DynamicObject>(16);
        for (Map.Entry resultEntry : resultMap.entrySet()) {
            DynamicObjectCollection outSupEntry;
            String key = (String)resultEntry.getKey();
            PricePluginPojo value = (PricePluginPojo)resultEntry.getValue();
            DynamicObject obj = (DynamicObject)dyoMap.get(key);
            if (obj == null) {
                if (expireMap.get(key) == null) {
                    value.setEffFlag(true);
                }
                addList.add(value);
                continue;
            }
            BigDecimal price = obj.getBigDecimal("price");
            DynamicObjectCollection entryentity = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryentity) {
                BigDecimal attaAmt = dynamicObject.getBigDecimal("amount");
                price = price.add(attaAmt);
            }
            BigDecimal resultPrice = value.getAmount();
            List additionalCosts = value.getAdditionalCosts();
            for (AdditionalCost additionalCost : additionalCosts) {
                resultPrice = resultPrice.add(additionalCost.getAmount());
            }
            if (resultPrice.compareTo(price) == 0 && (outSupEntry = obj.getDynamicObjectCollection("outsupentry")).size() == value.getSuppliers().size()) {
                ArrayList<String> supEntryKey = new ArrayList<String>(5);
                for (DynamicObject object : outSupEntry) {
                    supEntryKey.add(object.getLong("supplier.id") + "@" + object.getBigDecimal("quotaratio").setScale(10, 4) + "@" + object.getBigDecimal("unitprice").setScale(10, 4));
                }
                ArrayList<String> supKeys = new ArrayList<String>(5);
                for (Supplier supplier : value.getSuppliers()) {
                    supKeys.add(supplier.getSupplierId() + "@" + supplier.getQuoaratio().setScale(10, 4) + "@" + supplier.getUnitPrice().setScale(10, 4));
                }
                if (supEntryKey.containsAll(supKeys) && supKeys.containsAll(supEntryKey)) continue;
            }
            value.setEffFlag(false);
            addList.add(value);
            invalidateList.add(obj);
        }
        this.invalidBill(now, invalidateList, "cad_outsourceprice");
        this.addOutPriceBill(now, costType, ruleId, createId, addList);
        return addList.size();
    }

    protected int outResourcePriceTransform(Long costType, long ruleId, Long createId, List<PricePluginPojo> results) {
        HashMap<String, PricePluginPojo> resultMap = new HashMap<String, PricePluginPojo>(16);
        HashMap<String, DynamicObject> dyoMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> expireMap = new HashMap<String, DynamicObject>();
        this.buildCompareMap("cad_resourceout", costType, ruleId, results, resultMap, dyoMap, expireMap);
        Date now = new Date();
        ArrayList<PricePluginPojo> addList = new ArrayList<PricePluginPojo>(16);
        ArrayList<DynamicObject> invalidateList = new ArrayList<DynamicObject>(16);
        for (Map.Entry resultEntry : resultMap.entrySet()) {
            DynamicObjectCollection resSupEntry;
            DynamicObjectCollection entryentity;
            String key = (String)resultEntry.getKey();
            PricePluginPojo value = (PricePluginPojo)resultEntry.getValue();
            DynamicObject obj = (DynamicObject)dyoMap.get(key);
            if (obj == null) {
                if (expireMap.get(key) == null) {
                    value.setEffFlag(true);
                }
                addList.add(value);
                continue;
            }
            String calcBasis = value.getCalcBasis();
            BigDecimal billPrice = BigDecimal.ZERO;
            BigDecimal resultPrice = BigDecimal.ZERO;
            if ("001".equals(calcBasis)) {
                billPrice = obj.getBigDecimal("qty");
                entryentity = obj.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : entryentity) {
                    BigDecimal attaQty = dynamicObject.getBigDecimal("attaqty");
                    billPrice = billPrice.add(attaQty);
                }
                resultPrice = value.getQty();
            } else {
                billPrice = obj.getBigDecimal("amount");
                entryentity = obj.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : entryentity) {
                    BigDecimal attaAmt = dynamicObject.getBigDecimal("attaamt");
                    billPrice = billPrice.add(attaAmt);
                }
                resultPrice = value.getAmount();
            }
            List additionalCosts = value.getAdditionalCosts();
            for (AdditionalCost additionalCost : additionalCosts) {
                resultPrice = resultPrice.add(additionalCost.getAmount());
            }
            if (billPrice.compareTo(resultPrice) == 0 && (resSupEntry = obj.getDynamicObjectCollection("ressupentry")).size() == value.getSuppliers().size()) {
                ArrayList<String> supEntryKey = new ArrayList<String>(5);
                for (DynamicObject object : resSupEntry) {
                    supEntryKey.add(object.getLong("supplier.id") + "@" + object.getBigDecimal("quotaratio").setScale(10, 4) + "@" + object.getBigDecimal("unitprice").setScale(10, 4));
                }
                ArrayList<String> supKeys = new ArrayList<String>(5);
                for (Supplier supplier : value.getSuppliers()) {
                    supKeys.add(supplier.getSupplierId() + "@" + supplier.getQuoaratio().setScale(10, 4) + "@" + supplier.getUnitPrice().setScale(10, 4));
                }
                if (supEntryKey.containsAll(supKeys) && supKeys.containsAll(supEntryKey)) continue;
            }
            value.setEffFlag(false);
            addList.add(value);
            invalidateList.add(obj);
        }
        this.invalidBill(now, invalidateList, "cad_resourceout");
        this.addOutResourceBill(now, costType, ruleId, createId, addList);
        return addList.size();
    }

    protected int selfResourcePriceTransform(Long costType, long ruleId, Long createId, List<PricePluginPojo> results) {
        HashMap<String, PricePluginPojo> resultMap = new HashMap<String, PricePluginPojo>(16);
        HashMap<String, DynamicObject> dyoMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> expireMap = new HashMap<String, DynamicObject>();
        this.buildCompareMap("cad_resourcerate", costType, ruleId, results, resultMap, dyoMap, expireMap);
        Date now = new Date();
        ArrayList<PricePluginPojo> addList = new ArrayList<PricePluginPojo>(16);
        ArrayList<DynamicObject> invalidateList = new ArrayList<DynamicObject>(16);
        for (Map.Entry resultEntry : resultMap.entrySet()) {
            DynamicObjectCollection entryentity;
            String key = (String)resultEntry.getKey();
            PricePluginPojo value = (PricePluginPojo)resultEntry.getValue();
            DynamicObject obj = (DynamicObject)dyoMap.get(key);
            if (obj == null) {
                if (expireMap.get(key) == null) {
                    value.setEffFlag(true);
                }
                addList.add(value);
                continue;
            }
            String calcBasis = value.getCalcBasis();
            BigDecimal billPrice = BigDecimal.ZERO;
            BigDecimal resultPrice = BigDecimal.ZERO;
            if ("001".equals(calcBasis)) {
                billPrice = obj.getBigDecimal("qty");
                entryentity = obj.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : entryentity) {
                    BigDecimal attaQty = dynamicObject.getBigDecimal("attaqty");
                    billPrice = billPrice.add(attaQty);
                }
                resultPrice = value.getQty();
            } else {
                billPrice = obj.getBigDecimal("amount");
                entryentity = obj.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : entryentity) {
                    BigDecimal attaAmt = dynamicObject.getBigDecimal("attaamt");
                    billPrice = billPrice.add(attaAmt);
                }
                resultPrice = value.getAmount();
            }
            List additionalCosts = value.getAdditionalCosts();
            for (AdditionalCost additionalCost : additionalCosts) {
                resultPrice = resultPrice.add(additionalCost.getAmount());
            }
            if (billPrice.compareTo(resultPrice) == 0) continue;
            value.setEffFlag(false);
            addList.add(value);
            invalidateList.add(obj);
        }
        this.invalidBill(now, invalidateList, "cad_resourcerate");
        this.addSelfResourceBill(now, costType, ruleId, createId, addList);
        return addList.size();
    }

    private void addPurPriceBill(Date now, long costType, long ruleId, long createId, List<PricePluginPojo> addList) {
        logger.info("\u81ea\u5b9a\u4e49\u91c7\u8d2d\u53d6\u4ef7\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u5355\u636e\u65b0\u589e\u5355\u636e\u6761\u6570==>{}", (Object)addList.size());
        if (!addList.isEmpty()) {
            String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"cad_purprices", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_purprices"), (String)RequestContext.get().getLoginOrg(), (int)addList.size());
            Date effectdate = DateUtils.getDayStartTime((Date)now);
            DynamicObject rateSetting = this.getRateSetting(costType);
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
            int billNoIndex = 0;
            for (PricePluginPojo pricePluginPojo : addList) {
                DynamicObject purPrice = BusinessDataServiceHelper.newDynamicObject((String)"cad_purprices");
                purPrice.set("costtype", (Object)costType);
                if (batchNumber != null) {
                    purPrice.set("billno", (Object)batchNumber[billNoIndex]);
                } else {
                    purPrice.set("billno", (Object)ID.genStringId());
                }
                ++billNoIndex;
                purPrice.set("currency", (Object)pricePluginPojo.getCurrency());
                purPrice.set("datasrc", (Object)pricePluginPojo.getDataSrc());
                purPrice.set("effectdate", (Object)(pricePluginPojo.isEffFlag() ? DateUtils.getDefaultEffectDate() : effectdate));
                purPrice.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                purPrice.set("material", (Object)pricePluginPojo.getMaterialId());
                purPrice.set("auxpty", (Object)pricePluginPojo.getAuxptyId());
                purPrice.set("pricerule", (Object)ruleId);
                Keycol calcKey = CalcKeyHelper.getCalcKey((DynamicObject)purPrice, (boolean)true);
                purPrice.set("keycol", (Object)calcKey.getKeycol());
                purPrice.set("keycolid", (Object)calcKey.getId());
                purPrice.set("createtime", (Object)now);
                purPrice.set("modifytime", (Object)now);
                purPrice.set("auditdate", (Object)now);
                purPrice.set("creator", (Object)createId);
                purPrice.set("creator_id", (Object)createId);
                purPrice.set("modifier", (Object)createId);
                purPrice.set("modifier_id", (Object)createId);
                purPrice.set("auditor", (Object)createId);
                purPrice.set("auditor_id", (Object)createId);
                purPrice.set("billstatus", (Object)"C");
                DynamicObjectCollection supEntry = purPrice.getDynamicObjectCollection("pursupentry");
                int i = 1;
                for (Supplier supplier : pricePluginPojo.getSuppliers()) {
                    DynamicObject object = supEntry.addNew();
                    object.set("seq", (Object)i++);
                    object.set("supplier", (Object)supplier.getSupplierId());
                    object.set("quotaratio", (Object)supplier.getQuoaratio());
                    object.set("unitprice", (Object)supplier.getUnitPrice());
                    object.set("manualprice", (Object)supplier.isManualPrice());
                    this.supperExtField(object, supplier);
                }
                DynamicObjectCollection entryEntity = purPrice.getDynamicObjectCollection("entryentity");
                BigDecimal amount = BigDecimal.ZERO;
                BigDecimal rateAmount = BigDecimal.ZERO;
                for (int j = 0; j < pricePluginPojo.getCostInfoDetailList().size(); ++j) {
                    CostInfoDetail costInfoDetail = (CostInfoDetail)pricePluginPojo.getCostInfoDetailList().get(j);
                    DynamicObject object = entryEntity.addNew();
                    object.set("seq", (Object)(j + 1));
                    object.set("element", (Object)costInfoDetail.getElement());
                    object.set("subelement", (Object)costInfoDetail.getSubElement());
                    object.set("price", (Object)costInfoDetail.getPrice());
                    amount = amount.add(costInfoDetail.getPrice());
                    if (costInfoDetail.getElement() != 773126985240072192L) continue;
                    rateAmount = rateAmount.add(costInfoDetail.getPrice());
                }
                if (rateSetting != null) {
                    DynamicObjectCollection dynamicObjects = rateSetting.getDynamicObjectCollection("entryentity");
                    int j = pricePluginPojo.getCostInfoDetailList().size();
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        BigDecimal stdRate = dynamicObject.getBigDecimal("stdrate");
                        if (stdRate.compareTo(BigDecimal.ZERO) == 0) continue;
                        BigDecimal price = stdRate.divide(new BigDecimal("100"), 10, 4).multiply(rateAmount);
                        DynamicObject obj = entryEntity.addNew();
                        obj.set("seq", (Object)j++);
                        obj.set("element", (Object)dynamicObject.getLong("element.id"));
                        obj.set("subelement", (Object)dynamicObject.getLong("subelement.id"));
                        obj.set("rate", (Object)stdRate);
                        obj.set("price", (Object)price);
                        amount = amount.add(price);
                    }
                }
                purPrice.set("amount", (Object)amount);
                list.add(purPrice);
            }
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
    }

    private void addOutPriceBill(Date now, Long costType, long ruleId, long createId, List<PricePluginPojo> addList) {
        logger.info("\u81ea\u5b9a\u4e49\u91c7\u8d2d\u53d6\u4ef7\u4ea7\u54c1\u59d4\u5916\u6807\u51c6\u4ef7\u76ee\u8868\u5355\u636e\u65b0\u589e\u5355\u636e\u6761\u6570==>{}", (Object)addList.size());
        if (!addList.isEmpty()) {
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
            String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"cad_outsourceprice", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_outsourceprice"), (String)RequestContext.get().getLoginOrg(), (int)addList.size());
            int billNoIndex = 0;
            Date effectdate = DateUtils.getDayStartTime((Date)now);
            for (PricePluginPojo pricePluginPojo : addList) {
                DynamicObject outPrice = BusinessDataServiceHelper.newDynamicObject((String)"cad_outsourceprice");
                outPrice.set("costtype", (Object)costType);
                if (batchNumber != null && batchNumber.length > 0) {
                    outPrice.set("billno", (Object)batchNumber[billNoIndex]);
                } else {
                    outPrice.set("billno", (Object)ID.genStringId());
                }
                ++billNoIndex;
                outPrice.set("currency", (Object)pricePluginPojo.getCurrency());
                outPrice.set("effectdate", (Object)(pricePluginPojo.isEffFlag() ? DateUtils.getDefaultEffectDate() : effectdate));
                outPrice.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                outPrice.set("material", (Object)pricePluginPojo.getMaterialId());
                outPrice.set("auxpty", (Object)pricePluginPojo.getAuxptyId());
                outPrice.set("pricerule", (Object)ruleId);
                outPrice.set("element", (Object)pricePluginPojo.getElementId());
                outPrice.set("subelement", (Object)pricePluginPojo.getSubElementId());
                outPrice.set("price", (Object)pricePluginPojo.getAmount());
                Keycol calcKey = CalcKeyHelper.getCalcKey((DynamicObject)outPrice, (boolean)true);
                outPrice.set("keycol", (Object)calcKey.getKeycol());
                outPrice.set("keycolid", (Object)calcKey.getId());
                outPrice.set("createtime", (Object)now);
                outPrice.set("modifytime", (Object)now);
                outPrice.set("auditdate", (Object)now);
                outPrice.set("creator", (Object)createId);
                outPrice.set("creator_id", (Object)createId);
                outPrice.set("modifier", (Object)createId);
                outPrice.set("modifier_id", (Object)createId);
                outPrice.set("auditor", (Object)createId);
                outPrice.set("auditor_id", (Object)createId);
                outPrice.set("billstatus", (Object)"C");
                DynamicObjectCollection entryEntity = outPrice.getDynamicObjectCollection("entryentity");
                int j = 1;
                for (AdditionalCost additionalCost : pricePluginPojo.getAdditionalCosts()) {
                    DynamicObject object = entryEntity.addNew();
                    object.set("seq", (Object)j++);
                    object.set("extelement", (Object)additionalCost.getElement());
                    object.set("extsubelement", (Object)additionalCost.getSubElement());
                    object.set("amount", (Object)additionalCost.getAmount());
                }
                DynamicObjectCollection outEntry = outPrice.getDynamicObjectCollection("outsupentry");
                int i = 1;
                for (Supplier supplier : pricePluginPojo.getSuppliers()) {
                    DynamicObject object = outEntry.addNew();
                    object.set("seq", (Object)i++);
                    object.set("supplier", (Object)supplier.getSupplierId());
                    object.set("quotaratio", (Object)supplier.getQuoaratio());
                    object.set("unitprice", (Object)supplier.getUnitPrice());
                    object.set("manualprice", (Object)supplier.isManualPrice());
                    this.supperExtField(object, supplier);
                }
                saveList.add(outPrice);
            }
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        }
    }

    private void addOutResourceBill(Date now, Long costType, long ruleId, long createId, List<PricePluginPojo> addList) {
        logger.info("\u81ea\u5b9a\u4e49\u91c7\u8d2d\u53d6\u4ef7\u5916\u534f\u8d44\u6e90\u6807\u51c6\u4ef7\u76ee\u8868\u5355\u636e\u65b0\u589e\u5355\u636e\u6761\u6570==>{}", (Object)addList.size());
        if (!addList.isEmpty()) {
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
            String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"cad_resourceout", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_resourceout"), (String)RequestContext.get().getLoginOrg(), (int)addList.size());
            int billNoIndex = 0;
            Date effectdate = DateUtils.getDayStartTime((Date)now);
            HashSet<String> existPriceBills = new HashSet<String>(10);
            for (PricePluginPojo pricePluginPojo : addList) {
                long manuOrgId = pricePluginPojo.getManuOrgId();
                long routeId = pricePluginPojo.getRouteId();
                String processSeq = pricePluginPojo.getProcessSeq();
                String operationNo = pricePluginPojo.getOperationNo();
                String key = manuOrgId + "@" + routeId + "@" + processSeq + "@" + operationNo;
                if (existPriceBills.contains(key)) continue;
                DynamicObject resourcePrice = BusinessDataServiceHelper.newDynamicObject((String)"cad_resourceout");
                resourcePrice.set("costtype", (Object)costType);
                resourcePrice.set("manuorg", (Object)pricePluginPojo.getManuOrgId());
                resourcePrice.set("srcroute", (Object)pricePluginPojo.getSrcRoute());
                resourcePrice.set("route", (Object)pricePluginPojo.getRouteId());
                resourcePrice.set("pdmrouteid", (Object)pricePluginPojo.getPdmRouteId());
                resourcePrice.set("processseq", (Object)pricePluginPojo.getProcessSeq());
                resourcePrice.set("operationno", (Object)pricePluginPojo.getOperationNo());
                resourcePrice.set("operation", (Object)pricePluginPojo.getOperation());
                resourcePrice.set("operationdesc", (Object)pricePluginPojo.getOperationDesc());
                resourcePrice.set("workstation", (Object)pricePluginPojo.getWorkStation());
                if (batchNumber != null && batchNumber.length > 0) {
                    resourcePrice.set("billno", (Object)batchNumber[billNoIndex]);
                } else {
                    resourcePrice.set("billno", (Object)ID.genStringId());
                }
                ++billNoIndex;
                resourcePrice.set("currency", (Object)pricePluginPojo.getCurrency());
                resourcePrice.set("datasrc", (Object)pricePluginPojo.getDataSrc());
                resourcePrice.set("effectdate", (Object)(pricePluginPojo.isEffFlag() ? DateUtils.getDefaultEffectDate() : effectdate));
                resourcePrice.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                resourcePrice.set("material", (Object)pricePluginPojo.getMaterialId());
                resourcePrice.set("resource", (Object)pricePluginPojo.getResourceId());
                resourcePrice.set("element", (Object)pricePluginPojo.getElementId());
                resourcePrice.set("subelement", (Object)pricePluginPojo.getSubElementId());
                resourcePrice.set("pricerule", (Object)ruleId);
                resourcePrice.set("calcbasis", (Object)pricePluginPojo.getCalcBasis());
                resourcePrice.set("resourceunit", (Object)pricePluginPojo.getResourceUnit());
                if (!CadEmptyUtils.isEmpty((Long)pricePluginPojo.getMaterialId())) {
                    HashMap<String, Long> values = new HashMap<String, Long>(5);
                    values.put("material", pricePluginPojo.getMaterialId());
                    Keycol calcKey = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)true);
                    resourcePrice.set("keycol", (Object)calcKey.getKeycol());
                    resourcePrice.set("keycolid", (Object)calcKey.getId());
                }
                if ("001".equals(pricePluginPojo.getCalcBasis())) {
                    resourcePrice.set("qty", (Object)pricePluginPojo.getQty());
                } else {
                    resourcePrice.set("amount", (Object)pricePluginPojo.getAmount());
                }
                resourcePrice.set("createtime", (Object)now);
                resourcePrice.set("modifytime", (Object)now);
                resourcePrice.set("auditdate", (Object)now);
                resourcePrice.set("creator", (Object)createId);
                resourcePrice.set("creator_id", (Object)createId);
                resourcePrice.set("modifier", (Object)createId);
                resourcePrice.set("modifier_id", (Object)createId);
                resourcePrice.set("auditor", (Object)createId);
                resourcePrice.set("auditor_id", (Object)createId);
                resourcePrice.set("billstatus", (Object)"C");
                DynamicObjectCollection entryEntity = resourcePrice.getDynamicObjectCollection("entryentity");
                int j = 1;
                for (AdditionalCost additionalCost : pricePluginPojo.getAdditionalCosts()) {
                    DynamicObject object = entryEntity.addNew();
                    object.set("seq", (Object)j++);
                    object.set("attaelement", (Object)additionalCost.getElement());
                    object.set("attasubelement", (Object)additionalCost.getSubElement());
                    if (!"001".equals(pricePluginPojo.getCalcBasis())) {
                        object.set("attaamt", (Object)additionalCost.getAmount());
                        continue;
                    }
                    object.set("attaqty", (Object)additionalCost.getAmount());
                }
                DynamicObjectCollection resourceEntry = resourcePrice.getDynamicObjectCollection("ressupentry");
                int i = 1;
                for (Supplier supplier : pricePluginPojo.getSuppliers()) {
                    DynamicObject object = resourceEntry.addNew();
                    object.set("seq", (Object)i++);
                    object.set("supplier", (Object)supplier.getSupplierId());
                    object.set("quotaratio", (Object)supplier.getQuoaratio());
                    object.set("unitprice", (Object)supplier.getUnitPrice());
                    object.set("manualprice", (Object)supplier.isManualPrice());
                    this.supperExtField(object, supplier);
                }
                saveList.add(resourcePrice);
                existPriceBills.add(key);
            }
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        }
    }

    private void addSelfResourceBill(Date now, Long costType, long ruleId, long createId, List<PricePluginPojo> addList) {
        logger.info("\u81ea\u5b9a\u4e49\u91c7\u8d2d\u53d6\u4ef7\u81ea\u5236\u8d44\u6e90\u6807\u51c6\u4ef7\u76ee\u8868\u5355\u636e\u65b0\u589e\u5355\u636e\u6761\u6570==>{}", (Object)addList.size());
        if (!addList.isEmpty()) {
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
            String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"cad_resourcerate", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_resourcerate"), (String)RequestContext.get().getLoginOrg(), (int)addList.size());
            int billNoIndex = 0;
            Date effectdate = DateUtils.getDayStartTime((Date)now);
            for (PricePluginPojo pricePluginPojo : addList) {
                DynamicObject resourcePrice = BusinessDataServiceHelper.newDynamicObject((String)"cad_resourcerate");
                resourcePrice.set("costtype", (Object)costType);
                resourcePrice.set("workcenter", (Object)pricePluginPojo.getWorkCenterId());
                if (batchNumber != null && batchNumber.length > 0) {
                    resourcePrice.set("billno", (Object)batchNumber[billNoIndex]);
                } else {
                    resourcePrice.set("billno", (Object)ID.genStringId());
                }
                ++billNoIndex;
                resourcePrice.set("currency", (Object)pricePluginPojo.getCurrency());
                resourcePrice.set("effectdate", (Object)(pricePluginPojo.isEffFlag() ? DateUtils.getDefaultEffectDate() : effectdate));
                resourcePrice.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                resourcePrice.set("resource", (Object)pricePluginPojo.getResourceId());
                resourcePrice.set("element", (Object)pricePluginPojo.getElementId());
                resourcePrice.set("subelement", (Object)pricePluginPojo.getSubElementId());
                resourcePrice.set("pricerule", (Object)ruleId);
                resourcePrice.set("datasrc", (Object)pricePluginPojo.getDataSrc());
                resourcePrice.set("calcbasis", (Object)pricePluginPojo.getCalcBasis());
                resourcePrice.set("resourceunit", (Object)pricePluginPojo.getResourceUnit());
                if ("001".equals(pricePluginPojo.getCalcBasis())) {
                    resourcePrice.set("qty", (Object)pricePluginPojo.getQty());
                } else {
                    resourcePrice.set("amount", (Object)pricePluginPojo.getAmount());
                }
                resourcePrice.set("createtime", (Object)now);
                resourcePrice.set("modifytime", (Object)now);
                resourcePrice.set("auditdate", (Object)now);
                resourcePrice.set("creator", (Object)createId);
                resourcePrice.set("creator_id", (Object)createId);
                resourcePrice.set("modifier", (Object)createId);
                resourcePrice.set("modifier_id", (Object)createId);
                resourcePrice.set("auditor", (Object)createId);
                resourcePrice.set("auditor_id", (Object)createId);
                resourcePrice.set("billstatus", (Object)"C");
                DynamicObjectCollection entryEntity = resourcePrice.getDynamicObjectCollection("entryentity");
                int j = 1;
                for (AdditionalCost additionalCost : pricePluginPojo.getAdditionalCosts()) {
                    DynamicObject object = entryEntity.addNew();
                    object.set("seq", (Object)j++);
                    object.set("attaelement", (Object)additionalCost.getElement());
                    object.set("attasubelement", (Object)additionalCost.getSubElement());
                    if (!"001".equals(pricePluginPojo.getCalcBasis())) {
                        object.set("attaamt", (Object)additionalCost.getAmount());
                        continue;
                    }
                    object.set("attaqty", (Object)additionalCost.getAmount());
                }
                saveList.add(resourcePrice);
            }
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        }
    }

    private void buildCompareMap(String entityName, Long costType, long ruleId, List<PricePluginPojo> results, Map<String, PricePluginPojo> resultMap, Map<String, DynamicObject> dyoMap, Map<String, DynamicObject> expireMap) {
        String key;
        DynamicObjectCollection expDynamicObjects;
        String key2;
        DynamicObjectCollection dynamicObjects;
        HashSet<Long> materialSet = new HashSet<Long>(50);
        HashSet<Long> resourceSet = new HashSet<Long>(50);
        for (PricePluginPojo result : results) {
            String key3;
            if ("cad_purprices".equals(entityName)) {
                key3 = costType + "@" + ruleId + "@" + result.getMaterialId() + "@" + result.getAuxptyId();
                resultMap.put(key3, result);
            } else if ("cad_outsourceprice".equals(entityName)) {
                key3 = costType + "@" + ruleId + "@" + result.getMaterialId() + "@" + result.getElementId() + "@" + result.getSubElementId() + "@" + result.getAuxptyId();
                resultMap.put(key3, result);
            } else if ("cad_resourceout".equals(entityName)) {
                key3 = costType + "@" + ruleId + "@" + result.getMaterialId() + "@" + result.getResourceId() + "@" + result.getElementId() + "@" + result.getSubElementId() + "@" + result.getManuOrgId() + "@" + result.getRouteId() + "@" + result.getProcessSeq() + "@" + result.getOperationNo();
                resultMap.put(key3, result);
                resourceSet.add(result.getResourceId());
            } else if ("cad_resourcerate".equals(entityName)) {
                key3 = costType + "@" + ruleId + "@" + result.getWorkCenterId() + "@" + result.getResourceId() + "@" + result.getElementId() + "@" + result.getSubElementId();
                resultMap.put(key3, result);
                resourceSet.add(result.getResourceId());
            }
            materialSet.add(result.getMaterialId());
        }
        Date now = new Date();
        QFilter filter = new QFilter("costtype", "=", (Object)costType);
        filter.and("pricerule", "=", (Object)ruleId);
        filter.and("effectdate", "<=", (Object)now);
        filter.and("expdate", ">", (Object)now);
        QFilter expireFilter = new QFilter("costtype", "=", (Object)costType);
        expireFilter.and("pricerule", "=", (Object)ruleId);
        expireFilter.and("expdate", "<", (Object)now);
        if (!"cad_resourceout".equals(entityName) && !"cad_resourcerate".equals(entityName)) {
            filter.and("material", "in", materialSet);
            filter.and("configuredcode", "=", (Object)0L);
            filter.and("tracknumber", "=", (Object)0L);
            filter.and("project", "=", (Object)0L);
            expireFilter.and("material", "in", materialSet);
            expireFilter.and("configuredcode", "=", (Object)0L);
            expireFilter.and("tracknumber", "=", (Object)0L);
            expireFilter.and("project", "=", (Object)0L);
        } else {
            filter.and("resource", "in", resourceSet);
            expireFilter.and("resource", "in", resourceSet);
        }
        if ("cad_purprices".equals(entityName)) {
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_purprices", (String)"id,costtype,pricerule,material,auxpty,expdate,amount,entryentity.element,entryentity.subelement,entryentity.price,entryentity.rate,pursupentry.supplier,pursupentry.quotaratio,pursupentry.unitprice", (QFilter[])new QFilter[]{filter})) {
                key2 = costType + "@" + ruleId + "@" + dynamicObject.getLong("material.id") + "@" + dynamicObject.getLong("auxpty.id");
                dyoMap.put(key2, dynamicObject);
            }
            expDynamicObjects = QueryServiceHelper.query((String)"cad_purprices", (String)"material,auxpty", (QFilter[])new QFilter[]{expireFilter});
            for (DynamicObject dynamicObject : expDynamicObjects) {
                key = costType + "@" + ruleId + "@" + dynamicObject.getLong("material") + "@" + dynamicObject.getLong("auxpty");
                expireMap.put(key, dynamicObject);
            }
        }
        if ("cad_outsourceprice".equals(entityName)) {
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_outsourceprice", (String)"id,costtype,pricerule,material,auxpty,expdate,element,subelement,price,entryentity.amount,outsupentry.supplier,outsupentry.quotaratio,outsupentry.unitprice", (QFilter[])new QFilter[]{filter})) {
                key2 = costType + "@" + ruleId + "@" + dynamicObject.getLong("material.id") + "@" + dynamicObject.getLong("element.id") + "@" + dynamicObject.getLong("subelement.id") + "@" + dynamicObject.getLong("auxpty.id");
                dyoMap.put(key2, dynamicObject);
            }
            expDynamicObjects = QueryServiceHelper.query((String)"cad_outsourceprice", (String)"material,element,subelement,auxpty", (QFilter[])new QFilter[]{expireFilter});
            for (DynamicObject dynamicObject : expDynamicObjects) {
                key = costType + "@" + ruleId + "@" + dynamicObject.getLong("material") + "@" + dynamicObject.getLong("element") + "@" + dynamicObject.getLong("subelement") + "@" + dynamicObject.getLong("auxpty");
                expireMap.put(key, dynamicObject);
            }
        }
        if ("cad_resourceout".equals(entityName)) {
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_resourceout", (String)"id,costtype,pricerule,material,resource,expdate,element,subelement,manuorg,route,processseq,operationno,calcbasis,qty,amount,entryentity.attaqty,entryentity.attaamt,ressupentry.supplier,ressupentry.quotaratio,ressupentry.unitprice", (QFilter[])new QFilter[]{filter})) {
                key2 = costType + "@" + ruleId + "@" + dynamicObject.getLong("material.id") + "@" + dynamicObject.getLong("resource.id") + "@" + dynamicObject.getLong("element.id") + "@" + dynamicObject.getLong("subelement.id") + "@" + dynamicObject.getLong("manuorg.id") + "@" + dynamicObject.getLong("route.id") + "@" + dynamicObject.getString("processseq") + "@" + dynamicObject.getString("operationno");
                dyoMap.put(key2, dynamicObject);
            }
            expDynamicObjects = QueryServiceHelper.query((String)"cad_resourceout", (String)"material,resource,element,subelement,manuorg,route,processseq,operationno", (QFilter[])new QFilter[]{expireFilter});
            for (DynamicObject dynamicObject : expDynamicObjects) {
                key = costType + "@" + ruleId + "@" + dynamicObject.getLong("material") + "@" + dynamicObject.getLong("resource") + "@" + dynamicObject.getLong("element") + "@" + dynamicObject.getLong("subelement") + "@" + dynamicObject.getLong("manuorg") + "@" + dynamicObject.getLong("route") + "@" + dynamicObject.getString("processseq") + "@" + dynamicObject.getString("operationno");
                expireMap.put(key, dynamicObject);
            }
        }
        if ("cad_resourcerate".equals(entityName)) {
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_resourcerate", (String)"id,costtype,pricerule,workcenter,resource,expdate,element,subelement,calcbasis,qty,amount,entryentity.attaqty,entryentity.attaamt", (QFilter[])new QFilter[]{filter})) {
                key2 = costType + "@" + ruleId + "@" + dynamicObject.getLong("workcenter.id") + "@" + dynamicObject.getLong("resource.id") + "@" + dynamicObject.getLong("element.id") + "@" + dynamicObject.getLong("subelement.id");
                dyoMap.put(key2, dynamicObject);
            }
            expDynamicObjects = QueryServiceHelper.query((String)"cad_resourcerate", (String)"workcenter,resource,element,subelement", (QFilter[])new QFilter[]{expireFilter});
            for (DynamicObject dynamicObject : expDynamicObjects) {
                key = costType + "@" + ruleId + "@" + dynamicObject.getLong("workcenter") + "@" + dynamicObject.getLong("resource") + "@" + dynamicObject.getLong("element") + "@" + dynamicObject.getLong("subelement");
                expireMap.put(key, dynamicObject);
            }
        }
    }

    private DynamicObject getRateSetting(long costType) {
        QFilter filter = new QFilter("costtype", "=", (Object)costType);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"cad_stdratesetting", (String)"entryentity.element,entryentity.subelement,entryentity.stdrate", (QFilter[])new QFilter[]{filter});
        if (load.length > 0) {
            return load[0];
        }
        return null;
    }

    private void supperExtField(DynamicObject dyo, Supplier supplier) {
        Map extFieldMap = supplier.getExtFieldMap();
        for (Map.Entry fieldMap : extFieldMap.entrySet()) {
            if (!dyo.containsProperty((String)fieldMap.getKey())) continue;
            dyo.set((String)fieldMap.getKey(), fieldMap.getValue());
        }
    }
}

