/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.mservice.api.CostObjectService;
import kd.macc.cad.mservice.costobject.CostObjectArgs;
import kd.macc.cad.mservice.costobject.CostObjectContext;
import kd.macc.cad.mservice.costobject.CostObjectResultInfoBuilder;
import kd.macc.cad.mservice.costobject.ICostObjectAction;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CostObjectServiceImpl
implements CostObjectService {
    private static final Log logger = LogFactory.getLog(CostObjectServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> importCostObject(Map<String, Object> collectParamMap, List<Long> mftOrderEntryIds, Long acctOrgId, List<Long> costCenterIds, List<Long> manuOrgIds, String appNum, String progressId) {
        boolean isGetLock = true;
        String lockId = acctOrgId == null ? "0" : acctOrgId.toString();
        try {
            String lockErr = SimpleMutexHelper.checkAndRequireXMutex((String)"costobject-import", (Object)lockId);
            if (StringUtils.isNotEmpty((CharSequence)lockErr)) {
                HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
                MsgUtils.putMsg2Map((String)"mutex", (String)lockErr, errorMsgMap);
                isGetLock = false;
                ProgressHelper.showError((String)progressId, (String)lockErr);
                HashMap<String, String> hashMap = errorMsgMap;
                return hashMap;
            }
            Map<String, String> errorMsgMap = this.executeImport(collectParamMap, mftOrderEntryIds, acctOrgId, costCenterIds, manuOrgIds, appNum, progressId);
            return errorMsgMap;
        }
        catch (Exception ex) {
            logger.error("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f52\u96c6\u5f02\u5e38", (Throwable)ex);
            HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5b58\u5728\u5f02\u5e38:%s\u3002", (String)"CostObjectServiceImpl_4", (String)"macc-cad-mservice", (Object[])new Object[0]), ex.getMessage());
            MsgUtils.putMsg2Map((String)"tip", (String)errorMsg, errorMsgMap);
            ProgressHelper.clearProgressParam((String)progressId);
            HashMap<String, String> hashMap = errorMsgMap;
            return hashMap;
        }
        finally {
            if (isGetLock) {
                SimpleMutexHelper.releaseXMutex((String)"costobject-import", (Object)lockId);
            }
        }
    }

    private Map<String, String> executeImport(Map<String, Object> collectParamMap, List<Long> mftOrderEntryIds, Long acctOrgId, List<Long> costCenterIds, List<Long> manuOrgIds, String appNum, String progressId) {
        HashMap<Long, List<Long>> acctOrgCostCentersMap = new HashMap<Long, List<Long>>(16);
        HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
        errorMsgMap.put("successQty", "0");
        boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)acctOrgId);
        if (CadEmptyUtils.isEmpty(manuOrgIds) && isEnableMultiFactory) {
            manuOrgIds = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)acctOrgId, (String)"cad_costobject", (String)appNum);
        }
        if (CadEmptyUtils.isEmpty(costCenterIds)) {
            costCenterIds = isEnableMultiFactory ? new ArrayList(OrgHelper.getCenterIdsByManuOrgIds((Long)acctOrgId, (List)manuOrgIds, (String)appNum)) : OrgHelper.getCostCentersByOrg((long)acctOrgId);
        }
        if (CadEmptyUtils.isEmpty((Long)acctOrgId) || CadEmptyUtils.isEmpty(costCenterIds)) {
            MsgUtils.putMsg2Map((String)"tip", (String)ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostObjectServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]), errorMsgMap);
            return errorMsgMap;
        }
        List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)Long.parseLong(RequestContext.get().getUserId()), Collections.singletonList(acctOrgId), (Set)Sets.newHashSet(costCenterIds), (String)"cad_costobject", (String)appNum);
        if (CollectionUtils.isEmpty((Collection)enableCostCenters)) {
            MsgUtils.putMsg2Map((String)"tip", (String)ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostObjectServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]), errorMsgMap);
            return errorMsgMap;
        }
        acctOrgCostCentersMap.put(acctOrgId, enableCostCenters);
        CostObjectArgs costObjectArgs = new CostObjectArgs();
        costObjectArgs.setProgressId(progressId);
        costObjectArgs.setAppNum(appNum);
        costObjectArgs.setManuOrgs(manuOrgIds);
        costObjectArgs.setEnableMultiFactory(isEnableMultiFactory);
        costObjectArgs.setAcctOrgCostCentersMap(acctOrgCostCentersMap);
        costObjectArgs.setMftOrderEntryIds(mftOrderEntryIds);
        costObjectArgs.setCollectParamMap(collectParamMap);
        CostObjectContext costObjectContext = new CostObjectContext();
        costObjectContext.setCostObjectArgs(costObjectArgs);
        costObjectContext.getCollectReport().logBaseInfo(acctOrgId, CollectObjectEnum.COST_OBJECT, appNum);
        List<ICostObjectAction> costObjectActions = ICostObjectAction.initialize(appNum);
        try {
            for (ICostObjectAction costObjectAction : costObjectActions) {
                costObjectAction.setContext(costObjectContext);
                costObjectAction.execute();
            }
        }
        catch (Exception e) {
            logger.error("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f52\u96c6\u5f02\u5e38", (Throwable)e);
            if (!CollectReportHelper.disableCollectReport()) {
                String errorMsg = ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf\u9519\u8bef", (String)"CostObjectServiceImpl_1", (String)"macc-cad-mservice", (Object[])new Object[0]);
                costObjectContext.getCollectReport().logError((Throwable)e, errorMsg);
                ProgressHelper.clearProgressParam((String)progressId);
            }
            throw e;
        }
        return new CostObjectResultInfoBuilder(costObjectContext).buildResult();
    }
}

