/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.mservice.api.DiyCostDriverService;
import kd.macc.cad.mservice.diycostdriver.DiyCostDriverArgs;
import kd.macc.cad.mservice.diycostdriver.DiyCostDriverContext;
import kd.macc.cad.mservice.diycostdriver.DiyCostDriverResultBuilder;
import kd.macc.cad.mservice.diycostdriver.IDiyCostDriverAction;
import org.apache.commons.lang3.StringUtils;

public class DiyCostDriverServiceImpl
implements DiyCostDriverService {
    private static final Log logger = LogFactory.getLog(DiyCostDriverServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> importDiyCostDriver(Long orgId, Long costAccountId, List<Long> costCenters, List<Long> manuOrgIds, String appNum, String progressId, String entityType) {
        boolean isGetLock = true;
        String lockId = orgId == null ? "0" : orgId.toString();
        try {
            String lockErr = SimpleMutexHelper.checkAndRequireXMutex((String)"diycostdriver-import", (Object)lockId);
            if (StringUtils.isNotEmpty((CharSequence)lockErr)) {
                isGetLock = false;
                HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
                MsgUtils.putMsg2Map((String)"error", (String)lockErr, errorMsgMap);
                ProgressHelper.clearProgressParam((String)progressId);
                HashMap<String, String> hashMap = errorMsgMap;
                return hashMap;
            }
            Map<String, String> errorMsgMap = this.executeImport(orgId, costAccountId, costCenters, manuOrgIds, appNum, progressId, entityType);
            return errorMsgMap;
        }
        catch (Exception ex) {
            logger.error("\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u5f52\u96c6\u5f02\u5e38\u3002", (Throwable)ex);
            HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5b58\u5728\u5f02\u5e38:%s\u3002", (String)"DiyCostDriverServiceImpl_0", (String)"macc-cad-mservice", (Object[])new Object[0]), ex.getMessage());
            MsgUtils.putMsg2Map((String)"tip", (String)errorMsg, errorMsgMap);
            ProgressHelper.clearProgressParam((String)progressId);
            HashMap<String, String> hashMap = errorMsgMap;
            return hashMap;
        }
        finally {
            if (isGetLock) {
                SimpleMutexHelper.releaseXMutex((String)"diycostdriver-import", (Object)lockId);
            }
        }
    }

    private Map<String, String> executeImport(Long acctOrgId, Long costAccountId, List<Long> costCenterIds, List<Long> manuOrgIds, String appNum, String progressId, String entityType) {
        boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)acctOrgId);
        if (CadEmptyUtils.isEmpty(manuOrgIds) && isEnableMultiFactory) {
            manuOrgIds = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)acctOrgId, (String)entityType, (String)appNum);
        }
        if (CadEmptyUtils.isEmpty(costCenterIds)) {
            costCenterIds = isEnableMultiFactory ? new ArrayList(OrgHelper.getCenterIdsByManuOrgIds((Long)acctOrgId, (List)manuOrgIds, (String)appNum)) : OrgHelper.getCostCentersByOrg((long)acctOrgId);
        }
        List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)Long.parseLong(RequestContext.get().getUserId()), Collections.singletonList(acctOrgId), (Set)Sets.newHashSet((Iterable)costCenterIds), (String)"sca_diycostdriver", (String)appNum);
        DiyCostDriverArgs diyCostDriverArgs = new DiyCostDriverArgs();
        diyCostDriverArgs.setProgressId(progressId);
        diyCostDriverArgs.setAcctOrgId(acctOrgId);
        diyCostDriverArgs.setCostAccountId(costAccountId);
        diyCostDriverArgs.setCostCenterIds(enableCostCenters);
        diyCostDriverArgs.setManuOrgs(manuOrgIds);
        diyCostDriverArgs.setAppNum(appNum);
        DiyCostDriverContext diyCostDriverContext = new DiyCostDriverContext();
        diyCostDriverContext.setDiyCostDriverArgs(diyCostDriverArgs);
        long time = System.currentTimeMillis();
        List<IDiyCostDriverAction> diyCostDriverActions = IDiyCostDriverAction.initialize(appNum);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                for (IDiyCostDriverAction diyCostDriverAction : diyCostDriverActions) {
                    long actionTime = System.currentTimeMillis();
                    diyCostDriverAction.setContext(diyCostDriverContext);
                    diyCostDriverAction.execute();
                    logger.info("\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u5f52\u96c6-action{},\u8017\u65f6\uff1a{}ms", (Object)diyCostDriverAction.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                logger.error("\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u5f52\u96c6\u5f02\u5e38\u3002", (Throwable)e);
                throw e;
            }
            finally {
                logger.info("\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u5f52\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
            }
        }
        return new DiyCostDriverResultBuilder(diyCostDriverContext).buildResult();
    }
}

