/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.enums.CollectStatus;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.mservice.api.FactnedOutputService;
import kd.macc.cad.mservice.factedoutput.CompletionArgs;
import kd.macc.cad.mservice.factedoutput.CompletionContext;
import kd.macc.cad.mservice.factedoutput.CompletionResultBuilder;
import kd.macc.cad.mservice.factedoutput.ICompletionAction;
import org.apache.commons.lang3.StringUtils;

public class FactnedOutPutServiceImpl
implements FactnedOutputService {
    private static final Log logger = LogFactory.getLog(FactnedOutPutServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> importCompletion(Map<String, Object> collectParamMap, List<Long> mftOrderEntryIds, Long acctOrgId, List<Long> costCenterIds, List<Long> manuOrgIds, String appNum, String progressId) {
        boolean isGetLock = true;
        String lockId = acctOrgId == null ? "0" : acctOrgId.toString();
        try {
            String lockErr = SimpleMutexHelper.checkAndRequireXMutex((String)"fact-import", (Object)lockId);
            if (StringUtils.isNotEmpty((CharSequence)lockErr)) {
                HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
                MsgUtils.putMsg2Map((String)"mutex", (String)lockErr, errorMsgMap);
                isGetLock = false;
                ProgressHelper.showError((String)progressId, (String)lockErr);
                HashMap<String, String> hashMap = errorMsgMap;
                return hashMap;
            }
            Map<String, String> errorMsgMap = this.executeImport(collectParamMap, mftOrderEntryIds, acctOrgId, costCenterIds, manuOrgIds, appNum, progressId);
            return errorMsgMap;
        }
        catch (Exception ex) {
            logger.error("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5f02\u5e38\u3002", (Throwable)ex);
            HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5b58\u5728\u5f02\u5e38:%s\u3002", (String)"FactnedOutPutServiceImpl_4", (String)"macc-cad-mservice", (Object[])new Object[0]), ex.getMessage());
            MsgUtils.putMsg2Map((String)"tip", (String)errorMsg, errorMsgMap);
            ProgressHelper.clearProgressParam((String)progressId);
            HashMap<String, String> hashMap = errorMsgMap;
            return hashMap;
        }
        finally {
            if (isGetLock) {
                SimpleMutexHelper.releaseXMutex((String)"fact-import", (Object)lockId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> executeImport(Map<String, Object> collectParamMap, List<Long> mftOrderEntryIds, Long acctOrgId, List<Long> costCenterIds, List<Long> manuOrgIds, String appNum, String progressId) {
        CompletionContext completionContext;
        block23: {
            boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)acctOrgId);
            if (CadEmptyUtils.isEmpty(manuOrgIds) && isEnableMultiFactory) {
                manuOrgIds = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)acctOrgId, (String)"cad_factnedoutputbill", (String)appNum);
            }
            if (CadEmptyUtils.isEmpty(costCenterIds)) {
                costCenterIds = isEnableMultiFactory ? new ArrayList(OrgHelper.getCenterIdsByManuOrgIds((Long)acctOrgId, (List)manuOrgIds, (String)appNum)) : OrgHelper.getCostCentersByOrg((long)acctOrgId);
            }
            List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)Long.parseLong(RequestContext.get().getUserId()), Collections.singletonList(acctOrgId), (Set)Sets.newHashSet((Iterable)costCenterIds), (String)"cad_factnedoutputbill", (String)appNum);
            CompletionArgs completionArgs = new CompletionArgs();
            completionArgs.setProgressId(progressId);
            completionArgs.setMftOrderEntryIds(mftOrderEntryIds);
            completionArgs.setCollectParamMap(collectParamMap);
            completionArgs.setAcctOrgId(acctOrgId);
            completionArgs.setCostCenterIds(enableCostCenters);
            completionArgs.setManuOrgs(manuOrgIds);
            completionArgs.setAppNum(appNum);
            completionContext = new CompletionContext();
            completionContext.setCompletionArgs(completionArgs);
            completionContext.getCollectReport().logBaseInfo(acctOrgId, CollectObjectEnum.FACTNED_OUT, appNum);
            long time = System.currentTimeMillis();
            Boolean startCollConfigScheme = ImportServiceHelper.isStartCollConfigScheme();
            List<ICompletionAction> completionActions = ICompletionAction.initialize(appNum, startCollConfigScheme);
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    for (ICompletionAction completionAction : completionActions) {
                        long actionTime = System.currentTimeMillis();
                        completionAction.setContext(completionContext);
                        completionAction.execute();
                        logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6-action{},\u8017\u65f6\uff1a{}ms", (Object)completionAction.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
                    }
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    logger.error("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5f02\u5e38\u3002", (Throwable)e);
                    if (!CollectReportHelper.disableCollectReport()) {
                        String message = e.getMessage();
                        if (completionContext.isValidate()) {
                            completionContext.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"FactnedOutPutServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]), message);
                            completionContext.getCollectReport().logCheckDesc(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"FactnedOutPutServiceImpl_3", (String)"macc-cad-mservice", (Object[])new Object[0]));
                            completionContext.getCollectReport().setError(true);
                            completionContext.getCollectReport().logStatusChange(CollectStatus.FAILURE, ResManager.loadKDString((String)"\u63d0\u793a", (String)"FactnedOutPutServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{completionContext.getCollectReport().transfer2Dynamic()});
                        } else {
                            String errorMsg = ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf\u9519\u8bef", (String)"FactnedOutPutServiceImpl_0", (String)"macc-cad-mservice", (Object[])new Object[0]);
                            completionContext.getCollectReport().logError((Throwable)e, errorMsg);
                        }
                        ProgressHelper.clearProgressParam((String)progressId);
                        break block23;
                    }
                    throw e;
                }
                finally {
                    logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
                }
            }
        }
        return new CompletionResultBuilder(completionContext).buildResult();
    }
}

