/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.enums.CollectStatus;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.mservice.api.MatAllocConfigService;
import kd.macc.cad.mservice.matalloc.IMatAllocAction;
import kd.macc.cad.mservice.matalloc.MatAllocArgs;
import kd.macc.cad.mservice.matalloc.MatAllocContext;
import kd.macc.cad.mservice.matalloc.MatAllocResultBuilder;
import org.apache.commons.lang3.StringUtils;

public class MatAllocConfigServiceImpl
implements MatAllocConfigService {
    private static final Log logger = LogFactory.getLog(MatAllocConfigServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> importMatAlloc(Long acctOrgId, Long costAccountId, String appNum, String entityId, String progressId) {
        boolean isGetLock = true;
        String lockId = acctOrgId == null ? "0" : acctOrgId.toString();
        try {
            String lockErr = SimpleMutexHelper.checkAndRequireXMutex((String)"importcollc", (Object)lockId);
            if (StringUtils.isNotEmpty((CharSequence)lockErr)) {
                HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
                MsgUtils.putMsg2Map((String)"mutex", (String)lockErr, errorMsgMap);
                isGetLock = false;
                ProgressHelper.showError((String)progressId, (String)lockErr);
                HashMap<String, String> hashMap = errorMsgMap;
                return hashMap;
            }
            Map<String, String> errorMsgMap = this.executeImport(acctOrgId, costAccountId, appNum, entityId, progressId);
            return errorMsgMap;
        }
        catch (Exception ex) {
            logger.error("\u6750\u6599\u8017\u7528\u5f52\u96c6\u5f02\u5e38\u3002", (Throwable)ex);
            HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5b58\u5728\u5f02\u5e38:%s\u3002", (String)"MatAllocConfigServiceImpl_0", (String)"macc-cad-mservice", (Object[])new Object[0]), ex.getMessage());
            MsgUtils.putMsg2Map((String)"tip", (String)errorMsg, errorMsgMap);
            ProgressHelper.showError((String)progressId, (String)errorMsg);
            HashMap<String, String> hashMap = errorMsgMap;
            return hashMap;
        }
        finally {
            if (isGetLock) {
                SimpleMutexHelper.releaseXMutex((String)"importcollc", (Object)lockId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> executeImport(Long acctOrgId, Long costAccountId, String appNum, String entityId, String progressId) {
        MatAllocContext matAllocContext;
        block9: {
            List costCenterIds = OrgHelper.getCostCentersByOrg((long)acctOrgId);
            List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)RequestContext.get().getCurrUserId(), Collections.singletonList(acctOrgId), (Set)Sets.newHashSet((Iterable)costCenterIds), (String)entityId, (String)appNum);
            MatAllocArgs allocArgs = new MatAllocArgs();
            allocArgs.setProgressId(progressId);
            allocArgs.setAcctOrgId(acctOrgId);
            allocArgs.setCostAccountId(costAccountId);
            allocArgs.setCostCenterIds(enableCostCenters);
            allocArgs.setAppNum(appNum);
            allocArgs.setEntityId(entityId);
            matAllocContext = new MatAllocContext();
            matAllocContext.setMatAllocArgs(allocArgs);
            matAllocContext.getCollectReport().logBaseInfo(acctOrgId, CollectObjectEnum.MAT_ALLOC, appNum);
            long time = System.currentTimeMillis();
            Boolean startCollConfigScheme = ImportServiceHelper.isStartCollConfigScheme();
            List<IMatAllocAction> matAllocActions = IMatAllocAction.initialize(appNum, startCollConfigScheme);
            try {
                for (IMatAllocAction matAllocAction : matAllocActions) {
                    long actionTime = System.currentTimeMillis();
                    matAllocAction.setContext(matAllocContext);
                    matAllocAction.execute();
                    logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-action\uff1a{},\u8017\u65f6\uff1a{}ms", (Object)matAllocAction.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
                }
            }
            catch (Exception e) {
                logger.error("\u6750\u6599\u8017\u7528\u5206\u914d\u5f02\u5e38\u3002", (Throwable)e);
                if (!CollectReportHelper.disableCollectReport()) {
                    String message = e.getMessage();
                    if (matAllocContext.isValidate()) {
                        matAllocContext.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"MatAllocConfigServiceImpl_1", (String)"macc-cad-mservice", (Object[])new Object[0]), message);
                        matAllocContext.getCollectReport().logCheckDesc(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"MatAllocConfigServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        matAllocContext.getCollectReport().setError(true);
                        matAllocContext.getCollectReport().logStatusChange(CollectStatus.FAILURE, ResManager.loadKDString((String)"\u63d0\u793a", (String)"MatAllocConfigServiceImpl_1", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{matAllocContext.getCollectReport().transfer2Dynamic()});
                    } else {
                        String errorMsg = ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf\u9519\u8bef", (String)"MatAllocConfigServiceImpl_3", (String)"macc-cad-mservice", (Object[])new Object[0]);
                        matAllocContext.getCollectReport().logError((Throwable)e, errorMsg);
                    }
                    ProgressHelper.clearProgressParam((String)progressId);
                    break block9;
                }
                throw e;
            }
            finally {
                logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
            }
        }
        return new MatAllocResultBuilder(matAllocContext).buildResult();
    }
}

