/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.constants.ElementConstant;
import kd.macc.cad.common.constants.MatCostParam;
import kd.macc.cad.common.constants.PriorityParam;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.cad.common.helper.MatDimensionHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.mservice.api.MatCostInfoPriceService;

public class MatCostInfoPriceServiceImpl
implements MatCostInfoPriceService {
    private static Log logger = LogFactory.getLog(MatCostInfoPriceService.class);
    private static final String subMatItem = "2";
    private static final String subMatComItem = "3";
    private static final String totalPrice = "4";
    private static final String EFF_PRICE = "eff";
    private static final String MAT_PRICE = "mat";

    public Map<String, List<Map<String, Object>>> getMatCost(List<Map<String, Object>> params, Long org, Long costAccount, String datatype, String appId) {
        MatCostParam matCostParam = new MatCostParam();
        long start = System.currentTimeMillis();
        HashMap<String, List<Map<String, Object>>> costInfoResult = null;
        if (datatype != null && datatype.equals(totalPrice)) {
            if (params.size() > 50000) {
                logger.info("params length cannot More than 50000");
                return matCostParam.getResult();
            }
        } else if (params.size() > 20000) {
            logger.info("params length cannot More than 20000");
            return matCostParam.getResult();
        }
        logger.info("MatCostInfoPriceService getMatCost start,params ==>{},org ==>{},costAccount ==>{},datatype==>{},appId==>{}", new Object[]{params, org, costAccount, datatype, appId});
        if (!this.checkParams(matCostParam, params, org, costAccount, datatype, appId)) {
            return matCostParam.getResult();
        }
        try {
            this.getMatDimension(matCostParam);
            this.setKeyCol(matCostParam, params);
            costInfoResult = this.getCostInfoResult(matCostParam, params);
            logger.info("MatCostInfoPriceService getMatCost end,time consuming==>{} \u6beb\u79d2,return result==>{}", (Object)(System.currentTimeMillis() - start), costInfoResult);
        }
        catch (Throwable e) {
            costInfoResult = new HashMap(16);
            logger.info("\u53d6\u4ef7\u63a5\u53e3\u5f02\u5e38==>{},\u53c2\u6570 == >{}", (Object)e, params);
        }
        return costInfoResult;
    }

    private void setKeyCol(MatCostParam matCostParam, List<Map<String, Object>> params) {
        for (Map<String, Object> param : params) {
            this.getKeyCol(param, matCostParam);
        }
    }

    private Map<String, List<Map<String, Object>>> getCostInfoResult(MatCostParam matCostParam, List<Map<String, Object>> params) {
        List<Map<String, Object>> list;
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(10);
        this.getMatCostInfo(matCostParam, params);
        for (Map<String, Object> param : params) {
            list = this.getStandPriceByParam(MAT_PRICE, matCostParam, param);
            list = this.filterSubElement(list, param, matCostParam);
            if (totalPrice.equals(matCostParam.getDatatype())) {
                if (!list.isEmpty()) {
                    BigDecimal totalPrice = new BigDecimal("0.00");
                    long matCostInfoId = 0L;
                    for (Map<String, Object> map : list) {
                        if (matCostInfoId == 0L) {
                            matCostInfoId = Long.parseLong(map.get("matcostinfoid").toString());
                            totalPrice = totalPrice.add(new BigDecimal(map.get("standardcost").toString()));
                            continue;
                        }
                        long currentMatCostInfoId = Long.parseLong(map.get("matcostinfoid").toString());
                        if (matCostInfoId != currentMatCostInfoId) continue;
                        totalPrice = totalPrice.add(new BigDecimal(map.get("standardcost").toString()));
                    }
                    HashMap<String, Object> map = new HashMap<String, Object>(5);
                    map.put("matcostinfoid", list.get(0).get("matcostinfoid"));
                    map.put("keycol", list.get(0).get("keycol"));
                    map.put("keycolid", list.get(0).get("keycolid"));
                    map.put("totalprice", totalPrice);
                    map.put("costtype", this.getCostTypeByParam(param, matCostParam));
                    list.clear();
                    list.add(map);
                } else {
                    result.put(param.get("uniqueID").toString(), list);
                }
            }
            result.put(param.get("uniqueID").toString(), list);
        }
        if (subMatItem.equals(matCostParam.getDatatype()) || subMatComItem.equals(matCostParam.getDatatype())) {
            this.setMatIds(matCostParam, result);
            this.getStructureData(matCostParam);
            for (Map<String, Object> param : params) {
                list = this.getStandPriceByParam(EFF_PRICE, matCostParam, param);
                if (list.isEmpty() && subMatItem.equals(matCostParam.getDatatype()) && !(list = this.getStandPriceByParam(MAT_PRICE, matCostParam, param)).isEmpty()) {
                    this.transformResult(list);
                }
                result.put(param.get("uniqueID").toString(), list);
            }
        }
        return result;
    }

    private void setMatIds(MatCostParam matCostParam, Map<String, List<Map<String, Object>>> result) {
        for (Map.Entry<String, List<Map<String, Object>>> listEntry : result.entrySet()) {
            for (Map<String, Object> map : listEntry.getValue()) {
                matCostParam.getMatIds().add(Long.parseLong(map.get("matcostinfoid").toString()));
            }
        }
        result.clear();
    }

    private List<Map<String, Object>> filterSubElement(List<Map<String, Object>> list, Map<String, Object> param, MatCostParam matCostParam) {
        Object subElementType = param.get("subelementtype");
        if (subElementType == null || CadEmptyUtils.isEmpty((String)subElementType.toString())) {
            return list;
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        for (Map<String, Object> map : list) {
            String type = subElementType.toString();
            long subElementId = 0L;
            if ("SE001".equals(type)) {
                Long materialId = Long.parseLong(param.get("material").toString());
                subElementId = matCostParam.getMatSubElementMap().get(materialId) == null ? 773175233367685120L : ((Long[])matCostParam.getMatSubElementMap().get(materialId))[1];
            } else {
                Object subElement = param.get("subelement");
                if (subElement != null) {
                    subElementId = Long.parseLong(subElement.toString());
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("MatCostInfoPriceService filterSubElement\uff0c\u6839\u636e\u5b50\u8981\u7d20\u8fc7\u6ee4\uff0c\u8fc7\u6ee4\u7684\u5b50\u8981\u7d20==>{}", (Object)subElementId);
            }
            if (CadEmptyUtils.isEmpty((Long)subElementId)) continue;
            long subElement = Long.parseLong(map.get("subelement").toString());
            if (logger.isDebugEnabled()) {
                logger.debug("MatCostInfoPriceService filterSubElement\uff0c\u6839\u636e\u5b50\u8981\u7d20\u8fc7\u6ee4\uff0c\u67e5\u8be2\u7ed3\u679c\u4e2d\u7684\u5b50\u8981\u7d20==>{}", (Object)subElement);
            }
            if (subElement != subElementId) continue;
            resultList.add(map);
        }
        return resultList;
    }

    private void transformResult(List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            map.put("qty", 1);
            map.put("price", map.get("standardcost"));
            map.put("stdprice", map.get("standardcost"));
        }
    }

    private void copyMatAndEffectResult(List<PriorityParam> priorityParams, Long org, Long costAccount) {
        logger.info("copyMatAndEffectResult priorityParams size==>{}", (Object)priorityParams.size());
        MainEntityType effEntityType = EntityMetadataCache.getDataEntityType((String)"cad_calceffectiveresult");
        MainEntityType purEntityType = EntityMetadataCache.getDataEntityType((String)"cad_purprices");
        MainEntityType matEntityType = EntityMetadataCache.getDataEntityType((String)"cad_matcostinfo");
        ArrayList<DynamicObject> matList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> effList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> purList = new ArrayList<DynamicObject>(16);
        ArrayList<Long> existMatIds = new ArrayList<Long>(10);
        CloneUtils cloneUtils = new CloneUtils(true, true);
        for (PriorityParam priorityParam : priorityParams) {
            DynamicObject matNewDataEntity;
            Long keyColId;
            Long matId = priorityParam.getMatId();
            Long effectId = priorityParam.getEffectId();
            if (CadEmptyUtils.isEmpty((Long)matId)) {
                logger.info("\u4f18\u5148\u7ea7\u53d6\u4ef7\u672a\u627e\u5230\u5173\u8054\u5355\u636e,\u590d\u5236\u7c7b\u578b=>{},\u7269\u6599\u6210\u672c\u4fe1\u606fID==>{}", (Object)priorityParam.getCopyType(), (Object)matId);
                continue;
            }
            if (existMatIds.contains(matId)) {
                logger.info("\u4f18\u5148\u7ea7\u53d6\u4ef7\u5f53\u524d\u7269\u6599\u6210\u672c\u4fe1\u606fID\u5df2\u590d\u5236\uff0c\u81ea\u52a8\u8df3\u8fc7\uff0c\u7269\u6599\u6210\u672c\u4fe1\u606fID==>{}", (Object)matId);
                continue;
            }
            String copyType = priorityParam.getCopyType();
            DynamicObject matLoad = BusinessDataServiceHelper.loadSingle((Object)matId, (DynamicObjectType)matEntityType);
            boolean dataExist = this.checkDataIsExist(matLoad.getLong("costtype.id"), priorityParam);
            if (dataExist) continue;
            long matCreatorId = matLoad.getLong("creator.id");
            String remark = "";
            remark = "1".equals(priorityParam.getPriority()) ? ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6309\u4f18\u5148\u7ea7\u53d6\u4ef7\u590d\u5236\u751f\u6210\uff0c\u53d6\u4ef7\u4f18\u5148\u7ea7\u4e3a\u201c\u7269\u6599+\u914d\u7f6e\u53f7\u201d\u3002", (String)"MatCostInfoPriceServiceImpl_0", (String)"macc-cad-mservice", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6309\u4f18\u5148\u7ea7\u53d6\u4ef7\u590d\u5236\u751f\u6210\uff0c\u53d6\u4ef7\u4f18\u5148\u7ea7\u4e3a\u7269\u6599\u3002", (String)"MatCostInfoPriceServiceImpl_1", (String)"macc-cad-mservice", (Object[])new Object[0]);
            if ("1".equals(copyType)) {
                keyColId = this.getKeyColId(priorityParam.getKeyCol());
                matNewDataEntity = (DynamicObject)cloneUtils.clone((IDataEntityBase)matLoad);
                matNewDataEntity.set("id", (Object)ID.genLongId());
                matNewDataEntity.set("configuredcode", (Object)priorityParam.getConfiguredCode());
                matNewDataEntity.set("configuredcode_id", (Object)priorityParam.getConfiguredCode());
                matNewDataEntity.set("tracknumber", (Object)priorityParam.getTrackNumber());
                matNewDataEntity.set("tracknumber_id", (Object)priorityParam.getTrackNumber());
                matNewDataEntity.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
                matNewDataEntity.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                matNewDataEntity.set("keycol", (Object)priorityParam.getKeyCol());
                matNewDataEntity.set("keycolid", (Object)keyColId);
                matNewDataEntity.set("keycolid_id", (Object)keyColId);
                matNewDataEntity.set("modifier", (Object)matCreatorId);
                matNewDataEntity.set("modifier_id", (Object)matCreatorId);
                matNewDataEntity.set("auditor", (Object)matCreatorId);
                matNewDataEntity.set("auditor_id", (Object)matCreatorId);
                matNewDataEntity.set("datasource", (Object)"syscopy");
                matNewDataEntity.set("remark", (Object)remark);
                matNewDataEntity.set("srckeycol", (Object)matLoad.getString("keycol"));
                if (!CadEmptyUtils.isEmpty((Long)effectId)) {
                    DynamicObject effLoad = BusinessDataServiceHelper.loadSingle((Object)effectId, (DynamicObjectType)effEntityType);
                    long effCreateId = effLoad.getLong("creator.id");
                    DynamicObject effNewDataEntity = (DynamicObject)cloneUtils.clone((IDataEntityBase)effLoad);
                    effNewDataEntity.set("configuredcode", (Object)priorityParam.getConfiguredCode());
                    effNewDataEntity.set("configuredcode_id", (Object)priorityParam.getConfiguredCode());
                    effNewDataEntity.set("tracknumber", (Object)priorityParam.getTrackNumber());
                    effNewDataEntity.set("tracknumber_id", (Object)priorityParam.getTrackNumber());
                    effNewDataEntity.set("matcostid", (Object)matNewDataEntity.getLong("id"));
                    effNewDataEntity.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
                    effNewDataEntity.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                    effNewDataEntity.set("keycol", (Object)priorityParam.getKeyCol());
                    effNewDataEntity.set("keycolid", (Object)keyColId);
                    effNewDataEntity.set("keycolid_id", (Object)keyColId);
                    effNewDataEntity.set("modifier", (Object)effCreateId);
                    effNewDataEntity.set("modifier_id", (Object)effCreateId);
                    effNewDataEntity.set("auditor", (Object)effCreateId);
                    effNewDataEntity.set("auditor_id", (Object)effCreateId);
                    effNewDataEntity.set("ismaindata", (Object)1);
                    effNewDataEntity.set("isleaf", (Object)"0");
                    effList.add(effNewDataEntity);
                }
                matList.add(matNewDataEntity);
            } else {
                keyColId = this.getKeyColId(priorityParam.getKeyCol());
                matNewDataEntity = (DynamicObject)cloneUtils.clone((IDataEntityBase)matLoad);
                matNewDataEntity.set("id", (Object)ID.genLongId());
                matNewDataEntity.set("configuredcode", (Object)priorityParam.getConfiguredCode());
                matNewDataEntity.set("configuredcode_id", (Object)priorityParam.getConfiguredCode());
                matNewDataEntity.set("tracknumber", (Object)priorityParam.getTrackNumber());
                matNewDataEntity.set("tracknumber_id", (Object)priorityParam.getTrackNumber());
                matNewDataEntity.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
                matNewDataEntity.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                matNewDataEntity.set("keycol", (Object)priorityParam.getKeyCol());
                matNewDataEntity.set("keycolid", (Object)keyColId);
                matNewDataEntity.set("keycolid_id", (Object)keyColId);
                matNewDataEntity.set("modifier", (Object)matCreatorId);
                matNewDataEntity.set("modifier_id", (Object)matCreatorId);
                matNewDataEntity.set("auditor", (Object)matCreatorId);
                matNewDataEntity.set("auditor_id", (Object)matCreatorId);
                matNewDataEntity.set("datasource", (Object)"syscopy");
                matNewDataEntity.set("remark", (Object)remark);
                matNewDataEntity.set("srckeycol", (Object)matLoad.getString("keycol"));
                if (!CadEmptyUtils.isEmpty((Long)effectId)) {
                    DynamicObject purLoad = BusinessDataServiceHelper.loadSingle((Object)effectId, (DynamicObjectType)purEntityType);
                    long purCreateId = purLoad.getLong("creator.id");
                    DynamicObject purNewDataEntity = (DynamicObject)cloneUtils.clone((IDataEntityBase)purLoad);
                    purNewDataEntity.set("configuredcode", (Object)priorityParam.getConfiguredCode());
                    purNewDataEntity.set("configuredcode_id", (Object)priorityParam.getConfiguredCode());
                    purNewDataEntity.set("tracknumber", (Object)priorityParam.getTrackNumber());
                    purNewDataEntity.set("tracknumber_id", (Object)priorityParam.getTrackNumber());
                    purNewDataEntity.set("matcostid", (Object)matNewDataEntity.getLong("id"));
                    purNewDataEntity.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
                    purNewDataEntity.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                    purNewDataEntity.set("keycol", (Object)priorityParam.getKeyCol());
                    purNewDataEntity.set("keycolid", (Object)keyColId);
                    purNewDataEntity.set("keycolid_id", (Object)keyColId);
                    purNewDataEntity.set("modifier", (Object)purCreateId);
                    purNewDataEntity.set("modifier_id", (Object)purCreateId);
                    purNewDataEntity.set("auditor", (Object)purCreateId);
                    purNewDataEntity.set("auditor_id", (Object)purCreateId);
                    purNewDataEntity.set("remark", (Object)remark);
                    purList.add(purNewDataEntity);
                }
                matList.add(matNewDataEntity);
            }
            existMatIds.add(matId);
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                if (!matList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])matList.toArray(new DynamicObject[0]));
                }
                if (!effList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])effList.toArray(new DynamicObject[0]));
                }
                if (!purList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])purList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                handle.markRollback();
                throw e;
            }
        }
        this.generateAttachDataCheck(priorityParams, org, costAccount);
    }

    private void generateAttachDataCheck(List<PriorityParam> priorityParams, Long org, Long costAccount) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)org), new QFilter("enable", "=", (Object)true)};
        Object[] truckNumberSettings = BusinessDataServiceHelper.load((String)"cad_tracknumber_setting", (String)"matgrpstd,entryentityupdate.matgrp,entryentityupdate.attachorg", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((Object[])truckNumberSettings)) {
            logger.info("\u6ca1\u6709\u914d\u7f6e-\u8ddf\u8e2a\u53f7\u6210\u672c\u53d1\u5e03\u89c4\u5219");
            return;
        }
        HashMap<Long, List<Long>> matGrpAttachOrgs = new HashMap<Long, List<Long>>(16);
        for (Object truckNumberSetting : truckNumberSettings) {
            DynamicObjectCollection entrys = truckNumberSetting.getDynamicObjectCollection("entryentityupdate");
            Iterator iterator = entrys.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                Long matGrpId = entry.getLong("matgrp.id");
                ArrayList<Long> attachOrgIds = new ArrayList<Long>(16);
                DynamicObjectCollection attachorgs = entry.getDynamicObjectCollection("attachorg");
                for (DynamicObject attachorg : attachorgs) {
                    attachOrgIds.add(attachorg.getDynamicObject("fbasedataid").getLong("id"));
                }
                if (CadEmptyUtils.isEmpty((Long)matGrpId) || CadEmptyUtils.isEmpty(attachOrgIds)) continue;
                matGrpAttachOrgs.put(matGrpId, attachOrgIds);
            }
        }
        if (CadEmptyUtils.isEmpty(matGrpAttachOrgs)) {
            logger.info("\u8ddf\u8e2a\u53f7\u6210\u672c\u53d1\u5e03\u89c4\u5219\uff0c\u83b7\u53d6\u6570\u636e\u540e\u5904\u7406\u4e3a\u7a7a");
            return;
        }
        Long matGrpStdId = truckNumberSettings[0].getLong("matgrpstd.id");
        if (CadEmptyUtils.isEmpty((Long)matGrpStdId)) {
            logger.info("\u7269\u6599\u5206\u7c7b\u6807\u51c6\u4e3a\u7a7a");
            return;
        }
        ArrayList materialIds = new ArrayList(16);
        priorityParams.forEach(p -> materialIds.add(p.getMaterial()));
        if (CadEmptyUtils.isEmpty(materialIds)) {
            logger.info("\u83b7\u53d6\u7684\u7269\u6599\u4e3a\u7a7a");
            return;
        }
        filters = new QFilter[]{new QFilter("standard", "=", (Object)matGrpStdId), new QFilter("material", "in", materialIds)};
        DynamicObjectCollection matGrpDetails = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"group,material", (QFilter[])filters);
        HashMap<Long, Long> matGrps = new HashMap<Long, Long>(matGrpDetails.size());
        for (DynamicObject matGrpDetail : matGrpDetails) {
            matGrps.put(matGrpDetail.getLong("material"), matGrpDetail.getLong("group"));
        }
        if (CadEmptyUtils.isEmpty(matGrps)) {
            logger.info("\u7269\u6599\u5206\u7c7b\u6807\u51c6\u4e3a\u7a7a\uff0c\u53d6\u7269\u6599\u4e0e\u7269\u6599\u5206\u7c7b");
            return;
        }
        Date date = TimeServiceHelper.now();
        filters = new QFilter[]{new QFilter("calorg", "=", (Object)org), new QFilter("costaccount", "=", (Object)costAccount), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        DynamicObjectCollection costTypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,storageorgunit,costtype", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costTypeOrgs)) {
            logger.info("\u6210\u672c\u7c7b\u578b\u4e0e\u7ec4\u7ec7\u5bf9\u5e94\u5173\u7cfb\u4e0d\u5b58\u5728");
            return;
        }
        HashMap<Long, Long> orgCostTypes = new HashMap<Long, Long>(16);
        boolean enableFactory = OrgHelper.isOrgEnableMultiFactory((Long)org);
        for (DynamicObject costTypeOrg : costTypeOrgs) {
            if (enableFactory) {
                orgCostTypes.put(costTypeOrg.getLong("storageorgunit"), costTypeOrg.getLong("costtype"));
                continue;
            }
            orgCostTypes.put(costTypeOrg.getLong("calorg"), costTypeOrg.getLong("costtype"));
        }
        try {
            this.generateAttachData(priorityParams, matGrps, matGrpAttachOrgs, orgCostTypes);
        }
        catch (Exception ex) {
            logger.info("\u53d1\u5e03\u5230\u5b9a\u6807\u7ec4\u7ec7\u5931\u8d25\uff1a" + ex.toString());
            logger.error((Throwable)ex);
        }
    }

    private void generateAttachData(List<PriorityParam> priorityParams, Map<Long, Long> matGrps, Map<Long, List<Long>> matGrpAttachOrgs, Map<Long, Long> orgCostTypes) {
        MainEntityType effEntityType = EntityMetadataCache.getDataEntityType((String)"cad_calceffectiveresult");
        MainEntityType purEntityType = EntityMetadataCache.getDataEntityType((String)"cad_purprices");
        MainEntityType matEntityType = EntityMetadataCache.getDataEntityType((String)"cad_matcostinfo");
        ArrayList<DynamicObject> matList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> effList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> purList = new ArrayList<DynamicObject>(16);
        CloneUtils cloneUtils = new CloneUtils(true, true);
        for (PriorityParam priorityParam : priorityParams) {
            Long materialId = priorityParam.getMaterial();
            Long matGrpId = matGrps.get(materialId);
            if (CadEmptyUtils.isEmpty((Long)matGrpId)) {
                logger.info("materialId={}\u65e0\u7269\u6599\u5206\u7c7b", (Object)materialId);
                continue;
            }
            List<Long> attachOrgIds = matGrpAttachOrgs.get(matGrpId);
            if (CadEmptyUtils.isEmpty(attachOrgIds)) {
                logger.info("matGrpId={}\u65e0\u5b9a\u6807\u7ec4\u7ec7", (Object)matGrpId);
                continue;
            }
            HashSet<Long> orgIds = new HashSet<Long>(attachOrgIds);
            for (Long attachOrgId : orgIds) {
                DynamicObject matNewDataEntity;
                Long keyColId;
                Long targetCostTypeId = orgCostTypes.get(attachOrgId);
                if (CadEmptyUtils.isEmpty((Long)targetCostTypeId)) {
                    logger.info("attachOrgId={}\u65e0\u5bf9\u5e94\u7684\u6210\u672c\u7c7b\u578b", (Object)attachOrgId);
                    continue;
                }
                Long matId = priorityParam.getMatId();
                Long effectId = priorityParam.getEffectId();
                if (CadEmptyUtils.isEmpty((Long)matId)) {
                    logger.info("\u9644\u52a0\u4f18\u5148\u7ea7\u53d6\u4ef7\u672a\u627e\u5230\u5173\u8054\u5355\u636e,\u590d\u5236\u7c7b\u578b=>{},\u7269\u6599\u6210\u672c\u4fe1\u606fID==>{}", (Object)priorityParam.getCopyType(), (Object)matId);
                    continue;
                }
                boolean dataExist = this.checkDataIsExist(targetCostTypeId, priorityParam);
                if (dataExist) {
                    logger.info("\u9644\u52a0\u5b9a\u6807\u7ec4\u7ec7\u5f85\u590d\u5236\u6570\u636e\u5df2\u5b58\u5728\uff0c\u81ea\u52a8\u9003\u8fc7\uff0c\u5f53\u524dkeycol\u4e3a==>{}", (Object)priorityParam.getKeyCol());
                    continue;
                }
                String copyType = priorityParam.getCopyType();
                DynamicObject matLoad = BusinessDataServiceHelper.loadSingle((Object)matId, (DynamicObjectType)matEntityType);
                long matCreatorId = matLoad.getLong("creator.id");
                String remark = "";
                remark = "1".equals(priorityParam.getPriority()) ? ResManager.loadKDString((String)"\u9644\u52a0_\u5f53\u524d\u5355\u636e\u6309\u4f18\u5148\u7ea7\u53d6\u4ef7\u590d\u5236\u751f\u6210\uff0c\u53d6\u4ef7\u4f18\u5148\u7ea7\u4e3a\u201c\u7269\u6599+\u914d\u7f6e\u53f7\u201d\u3002", (String)"MatCostInfoPriceServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]) : (subMatItem.equals(priorityParam.getPriority()) ? ResManager.loadKDString((String)"\u9644\u52a0_\u5f53\u524d\u5355\u636e\u6309\u4f18\u5148\u7ea7\u53d6\u4ef7\u590d\u5236\u751f\u6210\uff0c\u53d6\u4ef7\u4f18\u5148\u7ea7\u4e3a\u7269\u6599\u3002", (String)"MatCostInfoPriceServiceImpl_3", (String)"macc-cad-mservice", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9644\u52a0_\u5f53\u524d\u5355\u636e\u6309\u4f18\u5148\u7ea7\u53d6\u4ef7\u590d\u5236\u751f\u6210\uff0c\u53d6\u4ef7\u4f18\u5148\u7ea7\u4e3a\u8ba1\u5212\u6210\u672c\u3002", (String)"MatCostInfoPriceServiceImpl_4", (String)"macc-cad-mservice", (Object[])new Object[0]));
                if ("1".equals(copyType)) {
                    keyColId = this.getKeyColId(priorityParam.getKeyCol());
                    matNewDataEntity = (DynamicObject)cloneUtils.clone((IDataEntityBase)matLoad);
                    matNewDataEntity.set("id", (Object)ID.genLongId());
                    matNewDataEntity.set("costtype", (Object)targetCostTypeId);
                    matNewDataEntity.set("costtype_id", (Object)targetCostTypeId);
                    matNewDataEntity.set("configuredcode", (Object)priorityParam.getConfiguredCode());
                    matNewDataEntity.set("configuredcode_id", (Object)priorityParam.getConfiguredCode());
                    matNewDataEntity.set("tracknumber", (Object)priorityParam.getTrackNumber());
                    matNewDataEntity.set("tracknumber_id", (Object)priorityParam.getTrackNumber());
                    matNewDataEntity.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
                    matNewDataEntity.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                    matNewDataEntity.set("keycol", (Object)priorityParam.getKeyCol());
                    matNewDataEntity.set("keycolid", (Object)keyColId);
                    matNewDataEntity.set("keycolid_id", (Object)keyColId);
                    matNewDataEntity.set("modifier", (Object)matCreatorId);
                    matNewDataEntity.set("modifier_id", (Object)matCreatorId);
                    matNewDataEntity.set("auditor", (Object)matCreatorId);
                    matNewDataEntity.set("auditor_id", (Object)matCreatorId);
                    matNewDataEntity.set("datasource", (Object)"syscopy");
                    matNewDataEntity.set("remark", (Object)remark);
                    matNewDataEntity.set("srckeycol", (Object)matLoad.getString("keycol"));
                    if (!CadEmptyUtils.isEmpty((Long)effectId)) {
                        DynamicObject effLoad = BusinessDataServiceHelper.loadSingle((Object)effectId, (DynamicObjectType)effEntityType);
                        long effCreateId = effLoad.getLong("creator.id");
                        DynamicObject effNewDataEntity = (DynamicObject)cloneUtils.clone((IDataEntityBase)effLoad);
                        effNewDataEntity.set("costtype", (Object)targetCostTypeId);
                        effNewDataEntity.set("costtype_id", (Object)targetCostTypeId);
                        effNewDataEntity.set("configuredcode", (Object)priorityParam.getConfiguredCode());
                        effNewDataEntity.set("configuredcode_id", (Object)priorityParam.getConfiguredCode());
                        effNewDataEntity.set("tracknumber", (Object)priorityParam.getTrackNumber());
                        effNewDataEntity.set("tracknumber_id", (Object)priorityParam.getTrackNumber());
                        effNewDataEntity.set("matcostid", (Object)matNewDataEntity.getLong("id"));
                        effNewDataEntity.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
                        effNewDataEntity.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                        effNewDataEntity.set("keycol", (Object)priorityParam.getKeyCol());
                        effNewDataEntity.set("keycolid", (Object)keyColId);
                        effNewDataEntity.set("keycolid_id", (Object)keyColId);
                        effNewDataEntity.set("modifier", (Object)effCreateId);
                        effNewDataEntity.set("modifier_id", (Object)effCreateId);
                        effNewDataEntity.set("auditor", (Object)effCreateId);
                        effNewDataEntity.set("auditor_id", (Object)effCreateId);
                        effNewDataEntity.set("ismaindata", (Object)1);
                        effNewDataEntity.set("isleaf", (Object)"0");
                        effList.add(effNewDataEntity);
                    }
                    matList.add(matNewDataEntity);
                    continue;
                }
                keyColId = this.getKeyColId(priorityParam.getKeyCol());
                matNewDataEntity = (DynamicObject)cloneUtils.clone((IDataEntityBase)matLoad);
                matNewDataEntity.set("id", (Object)ID.genLongId());
                matNewDataEntity.set("costtype", (Object)targetCostTypeId);
                matNewDataEntity.set("costtype_id", (Object)targetCostTypeId);
                matNewDataEntity.set("configuredcode", (Object)priorityParam.getConfiguredCode());
                matNewDataEntity.set("configuredcode_id", (Object)priorityParam.getConfiguredCode());
                matNewDataEntity.set("tracknumber", (Object)priorityParam.getTrackNumber());
                matNewDataEntity.set("tracknumber_id", (Object)priorityParam.getTrackNumber());
                matNewDataEntity.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
                matNewDataEntity.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                matNewDataEntity.set("keycol", (Object)priorityParam.getKeyCol());
                matNewDataEntity.set("keycolid", (Object)keyColId);
                matNewDataEntity.set("keycolid_id", (Object)keyColId);
                matNewDataEntity.set("modifier", (Object)matCreatorId);
                matNewDataEntity.set("modifier_id", (Object)matCreatorId);
                matNewDataEntity.set("auditor", (Object)matCreatorId);
                matNewDataEntity.set("auditor_id", (Object)matCreatorId);
                matNewDataEntity.set("datasource", (Object)"syscopy");
                matNewDataEntity.set("remark", (Object)remark);
                matNewDataEntity.set("srckeycol", (Object)matLoad.getString("keycol"));
                if (!CadEmptyUtils.isEmpty((Long)effectId)) {
                    DynamicObject purLoad = BusinessDataServiceHelper.loadSingle((Object)effectId, (DynamicObjectType)purEntityType);
                    long purCreateId = purLoad.getLong("creator.id");
                    DynamicObject purNewDataEntity = (DynamicObject)cloneUtils.clone((IDataEntityBase)purLoad);
                    purNewDataEntity.set("costtype", (Object)targetCostTypeId);
                    purNewDataEntity.set("costtype_id", (Object)targetCostTypeId);
                    purNewDataEntity.set("configuredcode", (Object)priorityParam.getConfiguredCode());
                    purNewDataEntity.set("configuredcode_id", (Object)priorityParam.getConfiguredCode());
                    purNewDataEntity.set("tracknumber", (Object)priorityParam.getTrackNumber());
                    purNewDataEntity.set("tracknumber_id", (Object)priorityParam.getTrackNumber());
                    purNewDataEntity.set("matcostid", (Object)matNewDataEntity.getLong("id"));
                    purNewDataEntity.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
                    purNewDataEntity.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                    purNewDataEntity.set("keycol", (Object)priorityParam.getKeyCol());
                    purNewDataEntity.set("keycolid", (Object)keyColId);
                    purNewDataEntity.set("keycolid_id", (Object)keyColId);
                    purNewDataEntity.set("modifier", (Object)purCreateId);
                    purNewDataEntity.set("modifier_id", (Object)purCreateId);
                    purNewDataEntity.set("auditor", (Object)purCreateId);
                    purNewDataEntity.set("auditor_id", (Object)purCreateId);
                    purNewDataEntity.set("remark", (Object)remark);
                    purList.add(purNewDataEntity);
                }
                matList.add(matNewDataEntity);
            }
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                if (!matList.isEmpty()) {
                    logger.info("matList={}", (Object)matList.size());
                    SaveServiceHelper.save((DynamicObject[])matList.toArray(new DynamicObject[0]));
                }
                if (!effList.isEmpty()) {
                    logger.info("effList={}", (Object)effList.size());
                    SaveServiceHelper.save((DynamicObject[])effList.toArray(new DynamicObject[0]));
                }
                if (!purList.isEmpty()) {
                    logger.info("purList={}", (Object)purList.size());
                    SaveServiceHelper.save((DynamicObject[])purList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                handle.markRollback();
                throw e;
            }
        }
    }

    private boolean checkDataIsExist(Long targetCostTypeId, PriorityParam priorityParam) {
        QFilter filter = new QFilter("keycol", "=", (Object)priorityParam.getKeyCol());
        filter.and("costtype", "=", (Object)targetCostTypeId);
        filter.and("effectdate", "<=", (Object)priorityParam.getDate());
        filter.and("expdate", ">", (Object)priorityParam.getDate());
        return QueryServiceHelper.exists((String)"cad_matcostinfo", (QFilter[])new QFilter[]{filter});
    }

    private Long getKeyColId(String keyCol) {
        QFilter filter = new QFilter("keycol", "=", (Object)keyCol);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_keycol", (String)"id", (QFilter[])new QFilter[]{filter});
        if (dynamicObject == null) {
            return 0L;
        }
        return dynamicObject.getLong("id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getStandPriceByParam(String type, MatCostParam matCostParam, Map<String, Object> param) {
        List list;
        ArrayList<Map<String, Object>> reList = new ArrayList<Map<String, Object>>(5);
        String preKey = this.getCostTypeByParam(param, matCostParam) + "@" + param.get("material");
        String keyCol = param.get("keycol").toString();
        String key = preKey + "@" + keyCol;
        List list2 = list = type.equals(EFF_PRICE) ? (List)matCostParam.getEffectiveResult().get(key) : (List)matCostParam.getResult().get(key);
        if (list != null) {
            this.getResultData(list, reList, param);
            if (!reList.isEmpty()) {
                return reList;
            }
        }
        if (matCostParam.isPriority() && param.get("configTrackKeyCol") != null) {
            DLock lock = null;
            try {
                Long costType = this.getCostTypeByParam(param, matCostParam);
                String lockKey = "priorityLockId_" + costType;
                lock = DLock.create((String)lockKey, (String)ResManager.loadKDString((String)"\u4f18\u5148\u7ea7\u53d6\u4ef7keyCol\u9501", (String)"MatCostInfoPriceServiceImpl_5", (String)"macc-cad-mservice", (Object[])new Object[0]));
                logger.info("\u8fdb\u5165\u4f18\u5148\u7ea7\u53d6\u4ef7\u9501,lockKey==>{},", (Object)lockKey);
                lock.lock();
                List<Map<String, Object>> confirmList = this.confirmQueryByKeyCol(type, param, matCostParam);
                if (!confirmList.isEmpty()) {
                    reList.addAll(confirmList);
                    ArrayList<Map<String, Object>> arrayList = reList;
                    return arrayList;
                }
                ArrayList<PriorityParam> priorityParams = new ArrayList<PriorityParam>(16);
                for (String priorityKey : matCostParam.getPriorityList()) {
                    Object configCodeKeyCol;
                    PriorityParam priorityParam = new PriorityParam();
                    priorityParam.setCopyType("1");
                    priorityParam.setMaterial(Long.valueOf(Long.parseLong(param.get("material").toString())));
                    priorityParam.setConfiguredCode(Long.valueOf(Long.parseLong(param.get("configuredcode").toString())));
                    priorityParam.setTrackNumber(Long.valueOf(Long.parseLong(param.get("tracknumber").toString())));
                    priorityParam.setKeyCol(keyCol);
                    priorityParam.setDate((Date)param.get("date"));
                    if (SysParamEnum.TRACK_MAT_CON.getValue().equals(priorityKey) && (configCodeKeyCol = param.get("configCodeKeyCol")) != null) {
                        logger.info("\u7269\u6599{}\u672a\u6839\u636e\u914d\u7f6e\u53f7+\u8ddf\u8e2a\u53f7\u83b7\u53d6\u5230\u6807\u51c6\u4ef7\uff0c\u8fdb\u5165\u4f18\u5148\u7ea7\u53d6\u4ef7", param.get("material"));
                        List list3 = list = type.equals(EFF_PRICE) ? (List)matCostParam.getEffectiveResult().get(preKey + "@" + configCodeKeyCol) : (List)matCostParam.getResult().get(preKey + "@" + configCodeKeyCol);
                        if (list != null) {
                            this.getResultData(list, reList, param);
                            if (!reList.isEmpty()) {
                                priorityParam.setType("1");
                                priorityParam.setMatId((Long)((Map)reList.get(0)).get("matcostinfoid"));
                                priorityParam.setEffectId(type.equals(EFF_PRICE) ? (Long)((Map)reList.get(0)).get("id") : this.getEffectId(priorityParam));
                                priorityParam.setPriority("1");
                                priorityParams.add(priorityParam);
                                this.copyMatAndEffectResult(priorityParams, matCostParam.getOrg(), matCostParam.getCostAccount());
                                logger.info("\u4f18\u5148\u7ea7\u53d6\u4ef7\u6210\u529f\uff0c\u5f53\u524d\u4f18\u5148\u7ea7\u4e3a\u7269\u6599+\u914d\u7f6e\u53f7\uff0c\u7269\u6599==>{}\uff0c\u5bf9\u5e94keycol\u4e3a==>{}", param.get("material"), configCodeKeyCol);
                                ArrayList<Map<String, Object>> arrayList = reList;
                                return arrayList;
                            }
                        }
                    }
                    if (SysParamEnum.TRACK_MAT.getValue().equals(priorityKey)) {
                        String materialKeyCol = param.get("materialKeyCol").toString();
                        List list4 = list = type.equals(EFF_PRICE) ? (List)matCostParam.getEffectiveResult().get(preKey + "@" + materialKeyCol) : (List)matCostParam.getResult().get(preKey + "@" + materialKeyCol);
                        if (list != null) {
                            this.getResultData(list, reList, param);
                            if (!reList.isEmpty()) {
                                priorityParam.setType(subMatItem);
                                priorityParam.setMatId((Long)((Map)reList.get(0)).get("matcostinfoid"));
                                priorityParam.setEffectId(type.equals(EFF_PRICE) ? (Long)((Map)reList.get(0)).get("id") : this.getEffectId(priorityParam));
                                priorityParam.setPriority(subMatItem);
                                priorityParams.add(priorityParam);
                                this.copyMatAndEffectResult(priorityParams, matCostParam.getOrg(), matCostParam.getCostAccount());
                                logger.info("\u4f18\u5148\u7ea7\u53d6\u4ef7\u6210\u529f\uff0c\u5f53\u524d\u4f18\u5148\u7ea7\u4e3a\u7269\u6599\uff0c\u7269\u6599==>{}\uff0c\u5bf9\u5e94keycol\u4e3a==>{}", param.get("material"), (Object)materialKeyCol);
                                ArrayList<Map<String, Object>> arrayList = reList;
                                return arrayList;
                            }
                        }
                    }
                    if (!SysParamEnum.TRACK_PLAN.getValue().equals(priorityKey)) continue;
                    logger.info("\u8fdb\u5165\u8ba1\u5212\u6210\u672c\u53d6\u4ef7\uff0c\u5f53\u524d\u7269\u6599==>{}", param.get("material"));
                    this.getPlanCostInfo(priorityParam, reList, matCostParam, param, type);
                    if (reList.isEmpty()) continue;
                    logger.info("\u4f18\u5148\u7ea7\u53d6\u4ef7\u6210\u529f\uff0c\u5f53\u524d\u4f18\u5148\u7ea7\u4e3a\u5de5\u5355\u8ba1\u5212\u6210\u672c\uff0c\u7269\u6599==>{}\uff0c\u5bf9\u5e94keycol\u4e3a==>{}", param.get("material"), param.get("configTrackKeyCol"));
                    ArrayList<Map<String, Object>> arrayList = reList;
                    return arrayList;
                }
            }
            catch (Exception e) {
                reList = new ArrayList();
                logger.info("\u4f18\u5148\u7ea7\u590d\u5236\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38,\u53c2\u6570==>{}\uff0c\u5f02\u5e38\u4fe1\u606f==>{}", param.get("configTrackKeyCol"), (Object)e);
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                    logger.info("\u4f18\u5148\u7ea7\u53d6\u4ef7\u9501\u91ca\u653e\u6210\u529f");
                }
            }
        }
        return reList;
    }

    private Long getEffectId(PriorityParam priorityParam) {
        QFilter filter = new QFilter("matcostid", "=", (Object)priorityParam.getMatId());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_calceffectiveresult", (String)"id", (QFilter[])new QFilter[]{filter});
        if (dynamicObject == null) {
            logger.info("\u672a\u6839\u636e\u7269\u6599\u6210\u672c\u4fe1\u606f\u83b7\u53d6\u5230\u751f\u6548\u5377\u7b97\u7ed3\u679c\u8868\uff0c\u67e5\u8be2\u5916\u8d2d\u7269\u6599\u4ef7\u76ee\u8868\u5f00\u59cb\uff0c\u7269\u6599\u6210\u672c\u4fe1\u606fID==>{}", (Object)priorityParam.getMatId());
            priorityParam.setCopyType(subMatItem);
            DynamicObject purObj = QueryServiceHelper.queryOne((String)"cad_purprices", (String)"id", (QFilter[])new QFilter[]{filter});
            if (purObj != null) {
                return purObj.getLong("id");
            }
            return 0L;
        }
        priorityParam.setCopyType("1");
        return dynamicObject.getLong("id");
    }

    private void getResultData(List<Map<String, Object>> list, List<Map<String, Object>> reList, Map<String, Object> param) {
        for (Map<String, Object> map : list) {
            Date date = (Date)param.get("date");
            Date effectDate = (Date)map.get("effectdate");
            Date expDate = (Date)map.get("expdate");
            if (logger.isDebugEnabled()) {
                logger.debug("getResultData filter date==>{},effectDate==>{},expDate==>{}", new Object[]{date, effectDate, expDate});
            }
            if (effectDate.compareTo(date) > 0 || expDate.compareTo(date) <= 0) continue;
            reList.add(map);
        }
    }

    private void getStructureData(MatCostParam matCostParam) {
        String selectFields = "id,costtype,matcostid,material,keycol,keycolid,effectdate,expdate,entryentity.resource resource,entryentity.element element,entryentity.subelement subelement,entryentity.qty qty,entryentity.price price,entryentity.stdprice stdprice,entryentity.submaterial submaterial,entryentity.submatvers submatvers,entryentity.subauxproperty subauxproperty,entryentity.activity activity,entryentity.datatype datatype,entryentity.calcbasis calcbasis,entryentity.subkeycol subkeycol,entryentity.subkeycolid subkeycolid";
        QFilter filter = new QFilter("costtype", "in", (Object)matCostParam.getCostTypeIds());
        filter.and("material", "in", (Object)matCostParam.getQueryMatIds());
        filter.and("matcostid", "in", (Object)matCostParam.getMatIds());
        logger.info("query getStructureData param,costtype ==>{},material==>{},matId==>{}", new Object[]{matCostParam.getCostTypeIds(), matCostParam.getQueryMatIds(), matCostParam.getMatIds()});
        if (subMatItem.equals(matCostParam.getDatatype())) {
            filter.and("entryentity.datatype", "in", (Object)Sets.newHashSet((Object[])new String[]{subMatItem, subMatComItem}));
        }
        if (subMatComItem.equals(matCostParam.getDatatype())) {
            filter.and("entryentity.datatype", "in", (Object)Sets.newHashSet((Object[])new String[]{subMatItem, totalPrice}));
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_calceffectiveresult", (String)selectFields, (QFilter[])new QFilter[]{filter});
        HashMap<String, List> resultMap = new HashMap<String, List>(10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String key = dynamicObject.getString("costtype") + "@" + dynamicObject.getString("material") + "@" + dynamicObject.getString("keycol");
            HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
            dataMap.put("id", dynamicObject.getLong("id"));
            dataMap.put("matcostinfoid", dynamicObject.getLong("matcostid"));
            dataMap.put("costtype", dynamicObject.getLong("costtype"));
            dataMap.put("keycol", dynamicObject.getString("keycol"));
            dataMap.put("keycolid", dynamicObject.getLong("keycolid"));
            dataMap.put("material", dynamicObject.getLong("material"));
            dataMap.put("effectdate", dynamicObject.getDate("effectdate"));
            dataMap.put("expdate", dynamicObject.getDate("expdate"));
            dataMap.put("subkeycol", dynamicObject.getString("subkeycol"));
            dataMap.put("subkeycolid", dynamicObject.getLong("subkeycolid"));
            dataMap.put("resource", dynamicObject.getLong("resource"));
            dataMap.put("element", dynamicObject.getLong("element"));
            dataMap.put("subelement", dynamicObject.getLong("subelement"));
            dataMap.put("qty", dynamicObject.getBigDecimal("qty"));
            dataMap.put("price", dynamicObject.getBigDecimal("price"));
            dataMap.put("stdprice", dynamicObject.getBigDecimal("stdprice"));
            dataMap.put("submaterial", dynamicObject.getLong("submaterial"));
            dataMap.put("submatvers", dynamicObject.getLong("submatvers"));
            dataMap.put("subauxproperty", dynamicObject.getLong("subauxproperty"));
            dataMap.put("activity", dynamicObject.getLong("activity"));
            dataMap.put("datatype", dynamicObject.getString("datatype"));
            dataMap.put("calcbasis", dynamicObject.getString("calcbasis"));
            resultMap.computeIfAbsent(key, s -> new ArrayList()).add(dataMap);
        }
        matCostParam.setEffectiveResult(resultMap);
    }

    private void getKeyCol(Map<String, Object> param, MatCostParam matCostParam) {
        DynamicObject dynamicObject;
        Long material = Long.parseLong(param.get("material").toString());
        Long costType = this.getCostTypeByParam(param, matCostParam);
        Long simCostType = (Long)matCostParam.getCostMap().get(costType);
        Map map = (Map)matCostParam.getMatDimensionIdMap().get(simCostType);
        HashMap<String, Object> keyColMap = new HashMap<String, Object>(10);
        keyColMap.put("material", material);
        ArrayList<String> extColList = new ArrayList<String>(10);
        boolean flag = true;
        if (map != null && (dynamicObject = (DynamicObject)map.get(material)) != null) {
            Set<String> dimensionsFields = this.getDimensions(dynamicObject.getString("dimension"));
            for (String field : dimensionsFields) {
                Object value = param.get(field);
                if (value == null || CadEmptyUtils.isEmpty((String)value.toString())) {
                    logger.info("\u5f53\u524d\u7269\u6599==>{},\u5bf9\u5e94\u7684\u5377\u7b97\u7ef4\u5ea6\u503c\u4e3a\u7a7a==>{}", param.get("material"), (Object)field);
                    flag = false;
                    break;
                }
                if ("assist".equals(field)) {
                    keyColMap.put("auxproperty", value);
                    continue;
                }
                keyColMap.put(field, value);
            }
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject obj : entryEntity) {
                String field = obj.getString("field");
                Object value = param.get(field);
                if (field == null || CadEmptyUtils.isEmpty((String)value.toString())) {
                    logger.info("\u5f53\u524d\u7269\u6599==>{},\u5bf9\u5e94\u7684\u5377\u7b97\u7ef4\u5ea6\u503c\u4e3a\u7a7a==>{}", param.get("material"), (Object)field);
                    flag = false;
                    break;
                }
                extColList.add(field);
                keyColMap.put(field, value);
            }
        }
        if (flag) {
            String keyCol = CalcKeyHelper.getCalcKey(keyColMap, extColList, (boolean)false).getKeycol();
            if (logger.isDebugEnabled()) {
                logger.debug("\u5f53\u524d\u7269\u6599==>{},\u83b7\u53d6\u5230keyCol\u4e3a ==>{}", (Object)material, (Object)keyCol);
            }
            param.put("keycol", keyCol);
            matCostParam.getKeyCols().add(keyCol);
            if (matCostParam.isPriority() && keyColMap.size() == 3 && keyColMap.keySet().containsAll(Sets.newHashSet((Object[])new String[]{"material", "configuredcode", "tracknumber"}))) {
                if (param.get("configuredcode") == null || "0".equals(param.get("configuredcode").toString()) || param.get("tracknumber") == null || "0".equals(param.get("tracknumber").toString())) {
                    logger.info("\u5f53\u524d\u7269\u6599==>{}\u5bf9\u5e94\u7684\u914d\u7f6e\u53f7\u6216\u8ddf\u8e2a\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301\u4f18\u5148\u7ea7\u53d6\u4ef7", (Object)material);
                    return;
                }
                if (CadEmptyUtils.isEmpty((String)param.get("keycol").toString())) {
                    param.put("keycol", CalcKeyHelper.getCalcKey(keyColMap, extColList, (boolean)true).getKeycol());
                    matCostParam.getKeyCols().add(param.get("keycol").toString());
                }
                param.put("configTrackKeyCol", param.get("keycol"));
                if (matCostParam.getPriorityList().contains("B")) {
                    keyColMap.remove("tracknumber");
                    String configCodeKeyCol = CalcKeyHelper.getCalcKey(keyColMap, extColList, (boolean)false).getKeycol();
                    logger.info("\u5f53\u524d\u7269\u6599==>{},\u83b7\u53d6\u5230\u7269\u6599+\u914d\u7f6e\u53f7\u7ef4\u5ea6keyCol\u4e3a ==>{}", (Object)material, (Object)configCodeKeyCol);
                    param.put("configCodeKeyCol", configCodeKeyCol);
                    matCostParam.getKeyCols().add(configCodeKeyCol);
                }
                if (matCostParam.getPriorityList().contains("D")) {
                    keyColMap.remove("tracknumber");
                    keyColMap.remove("configuredcode");
                    String materialKeyCol = CalcKeyHelper.getCalcKey(keyColMap, extColList, (boolean)false).getKeycol();
                    logger.info("\u5f53\u524d\u7269\u6599==>{},\u83b7\u53d6\u5230\u7269\u6599keyCol\u4e3a ==>{}", (Object)material, (Object)materialKeyCol);
                    param.put("materialKeyCol", materialKeyCol);
                    matCostParam.getKeyCols().add(materialKeyCol);
                }
            }
        } else {
            param.put("keycol", "-1");
        }
    }

    private Long getCostTypeByParam(Map<String, Object> param, MatCostParam matCostParam) {
        Long org = matCostParam.getOrg();
        if (matCostParam.isMulFactory()) {
            org = Long.parseLong(param.get("invorg").toString());
        }
        return (Long)matCostParam.getOrgCostMap().get(org);
    }

    private void getMatCostInfo(MatCostParam matCostParam, List<Map<String, Object>> params) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("material", "in", (Object)matCostParam.getQueryMatIds()));
        filters.add(new QFilter("costtype", "in", (Object)matCostParam.getCostTypeIds()));
        filters.add(new QFilter("keycol", "in", (Object)matCostParam.getKeyCols()));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        if (params.size() == 1) {
            Date date = (Date)params.get(0).get("date");
            filters.add(new QFilter("effectdate", "<=", (Object)date));
            filters.add(new QFilter("expdate", ">", (Object)date));
        } else {
            this.addDateFilter(filters, params);
        }
        logger.info("query getMatCostInfo param,costtype ==>{},material==>{},keycol==>{}", new Object[]{matCostParam.getCostTypeIds(), matCostParam.getQueryMatIds(), matCostParam.getKeyCols()});
        String selectFields = "id,costtype,material,keycol,keycolid,effectdate,expdate,entryentity.element.id element,entryentity.subelement.id subelement,entryentity.standardcost standardcost,entryentity.stepamt stepamt";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_matcostinfo", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
        HashMap<String, List> resultMap = new HashMap<String, List>(10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long id = dynamicObject.getLong("id");
            String key = dynamicObject.getString("costtype") + "@" + dynamicObject.getString("material") + "@" + dynamicObject.getString("keycol");
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("matcostinfoid", id);
            dataMap.put("costtype", dynamicObject.getLong("costtype"));
            dataMap.put("keycol", dynamicObject.getString("keycol"));
            dataMap.put("keycolid", dynamicObject.getLong("keycolid"));
            dataMap.put("material", dynamicObject.getLong("material"));
            dataMap.put("effectdate", dynamicObject.getDate("effectdate"));
            dataMap.put("expdate", dynamicObject.getDate("expdate"));
            dataMap.put("element", dynamicObject.getLong("element"));
            dataMap.put("subelement", dynamicObject.getLong("subelement"));
            dataMap.put("standardcost", dynamicObject.getBigDecimal("standardcost"));
            dataMap.put("stepamt", dynamicObject.getBigDecimal("stepamt"));
            if (logger.isDebugEnabled()) {
                logger.debug("\u83b7\u53d6\u7269\u6599\u6210\u672c\u4fe1\u606f\u7ec4\u88c5key\u4e3a==>{}", (Object)key);
            }
            resultMap.computeIfAbsent(key, s -> new ArrayList()).add(dataMap);
        }
        matCostParam.setResult(resultMap);
    }

    private void getPlanCostInfo(PriorityParam priorityParam, List<Map<String, Object>> reList, MatCostParam matCostParam, Map<String, Object> param, String type) {
        Object configTrackKeyCol = param.get("configTrackKeyCol");
        if (configTrackKeyCol != null) {
            DynamicObjectCollection entryEntity;
            Date date = (Date)param.get("date");
            QFilter filter = new QFilter("material", "=", param.get("material"));
            filter.and("costtype", "=", (Object)this.getCostTypeByParam(param, matCostParam));
            filter.and("keycol", "=", configTrackKeyCol);
            filter.and("effectdate", "<=", (Object)date);
            filter.and("expdate", ">", (Object)date);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"sca_plancostcalcresult", (String)"id,calcdate", (QFilter[])new QFilter[]{filter});
            if (dynamicObjects.isEmpty()) {
                logger.info("\u6839\u636e\u4f18\u5148\u7ea7\u83b7\u53d6\u5de5\u5355\u8ba1\u5212\u6210\u672c\u4e3a\u7a7a\uff0c\u67e5\u8be2\u6761\u4ef6==>{}", (Object)filter);
                return;
            }
            long planCostId = 0L;
            Date effDate = null;
            for (DynamicObject dynamicObject : dynamicObjects) {
                long id = dynamicObject.getLong("id");
                Date effectDate = dynamicObject.getDate("calcdate");
                if (CadEmptyUtils.isEmpty((Long)planCostId) && effDate == null) {
                    planCostId = id;
                    effDate = effectDate;
                    continue;
                }
                if (!effectDate.after(effDate)) continue;
                effDate = effectDate;
                planCostId = id;
            }
            String selectFields = "id,billno,orderentryid,org,costtype,material,planqty,outamount,configuredcode,tracknumber,keycol,keycolid,effectdate,expdate,entryentity.calcbasis,entryentity.caltype,entryentity.submaterial,entryentity.needqty,entryentity.resource,entryentity.needamount,entryentity.subelement";
            DynamicObject planDynamicObj = BusinessDataServiceHelper.load((String)"sca_plancostcalcresult", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)planCostId)})[0];
            logger.info("\u6839\u636e\u4f18\u5148\u7ea7\u83b7\u53d6\u5230\u5de5\u5355\u8ba1\u5212\u6210\u672c,\u5355\u636e\u7f16\u53f7==>{},\u751f\u6548\u65f6\u95f4==>{}", (Object)planDynamicObj.getString("billno"), (Object)planDynamicObj.getDate("effectdate"));
            List list = (List)matCostParam.getPlanCostResult().get(planDynamicObj.getLong("id"));
            if (list != null) {
                reList.addAll(list);
                return;
            }
            DynamicObject effInfoObj = this.createEffInfoObj(planDynamicObj);
            if (effInfoObj.getDynamicObjectCollection("entryentity").isEmpty()) {
                return;
            }
            DynamicObject matCostInfoObj = this.createMatCostInfoObj(planDynamicObj, effInfoObj);
            if (EFF_PRICE.equals(type)) {
                entryEntity = effInfoObj.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : entryEntity) {
                    HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
                    dataMap.put("id", effInfoObj.getLong("id"));
                    dataMap.put("matcostinfoid", effInfoObj.getLong("matcostid"));
                    dataMap.put("costtype", effInfoObj.getLong("costtype"));
                    dataMap.put("keycol", effInfoObj.getString("keycol"));
                    dataMap.put("keycolid", effInfoObj.getLong("keycolid"));
                    dataMap.put("material", effInfoObj.getLong("material"));
                    dataMap.put("effectdate", effInfoObj.getDate("effectdate"));
                    dataMap.put("expdate", effInfoObj.getDate("expdate"));
                    dataMap.put("resource", dynamicObject.getLong("resource"));
                    dataMap.put("element", dynamicObject.getLong("element"));
                    dataMap.put("subelement", dynamicObject.getLong("subelement"));
                    dataMap.put("qty", dynamicObject.getBigDecimal("qty"));
                    dataMap.put("price", dynamicObject.getBigDecimal("price"));
                    dataMap.put("stdprice", dynamicObject.getBigDecimal("stdprice"));
                    dataMap.put("submaterial", dynamicObject.getLong("submaterial"));
                    dataMap.put("submatvers", dynamicObject.getLong("submatvers"));
                    dataMap.put("subauxproperty", dynamicObject.getLong("subauxproperty"));
                    dataMap.put("activity", dynamicObject.getLong("activity"));
                    dataMap.put("datatype", dynamicObject.getString("datatype"));
                    dataMap.put("calcbasis", dynamicObject.getString("calcbasis"));
                    reList.add(dataMap);
                }
            } else {
                entryEntity = matCostInfoObj.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : entryEntity) {
                    HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                    dataMap.put("matcostinfoid", matCostInfoObj.getLong("id"));
                    dataMap.put("costtype", matCostInfoObj.getLong("costtype"));
                    dataMap.put("keycol", matCostInfoObj.getString("keycol"));
                    dataMap.put("keycolid", matCostInfoObj.getLong("keycolid"));
                    dataMap.put("material", matCostInfoObj.getLong("material"));
                    dataMap.put("effectdate", matCostInfoObj.getDate("effectdate"));
                    dataMap.put("expdate", matCostInfoObj.getDate("expdate"));
                    dataMap.put("element", dynamicObject.getLong("element"));
                    dataMap.put("subelement", dynamicObject.getLong("subelement"));
                    dataMap.put("standardcost", dynamicObject.getBigDecimal("standardcost"));
                    dataMap.put("stepamt", dynamicObject.getBigDecimal("stepamt"));
                    reList.add(dataMap);
                }
            }
            matCostParam.getPlanCostResult().put(planDynamicObj.getLong("id"), reList);
            TXHandle handle = TX.required();
            Object object = null;
            try {
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{matCostInfoObj});
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{effInfoObj});
                }
                catch (Exception e) {
                    handle.markRollback();
                    logger.info("\u8ba1\u5212\u6210\u672c\u4f18\u5148\u7ea7\u53d6\u4ef7\u590d\u5236\u5f02\u5e38==>{}", (Object)e);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (handle != null) {
                    if (object != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        handle.close();
                    }
                }
            }
            logger.info("\u8ba1\u5212\u6210\u672c\u4f18\u5148\u7ea7\u53d6\u4ef7\u5b8c\u6210\uff0c\u5f00\u59cb\u8fdb\u884c\u9644\u52a0\u6210\u672c\u7c7b\u578b\u590d\u5236");
            priorityParam.setType(subMatComItem);
            priorityParam.setMatId(Long.valueOf(matCostInfoObj.getLong("id")));
            priorityParam.setEffectId(Long.valueOf(effInfoObj.getLong("id")));
            priorityParam.setPriority(subMatComItem);
            ArrayList<PriorityParam> priorityParams = new ArrayList<PriorityParam>(3);
            priorityParams.add(priorityParam);
            this.generateAttachDataCheck(priorityParams, matCostParam.getOrg(), matCostParam.getCostAccount());
        }
    }

    private void getMatDimension(MatCostParam matCostParam) {
        if (!CadEmptyUtils.isEmpty((Set)matCostParam.getSimCostTypes())) {
            for (Long simCostType : matCostParam.getSimCostTypes()) {
                Map map = MatDimensionHelper.getDimensionByMatIds((Long)simCostType, (Set)matCostParam.getMaterIds());
                matCostParam.getMatDimensionIdMap().put(simCostType, map);
            }
        }
    }

    private void setCostType(MatCostParam matCostParam) {
        Date date = TimeServiceHelper.now();
        QFilter filter = new QFilter("costaccount", "=", (Object)matCostParam.getCostAccount());
        filter.and("bizstatus", "=", (Object)"1");
        filter.and("effectdate", "<=", (Object)date);
        filter.and("invaliddate", ">", (Object)date);
        filter.and("costtype.type", "=", (Object)"0");
        StringJoiner selectField = new StringJoiner(",");
        selectField.add("costtype,costtype.name as name");
        if (matCostParam.isMulFactory()) {
            selectField.add("storageorgunit as org");
            filter.and("storageorgunit", "in", (Object)matCostParam.getInvOrg());
        } else {
            filter.and("calorg", "=", (Object)matCostParam.getOrg());
            selectField.add("calorg as org");
        }
        DynamicObjectCollection costTypes = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)selectField.toString(), (QFilter[])new QFilter[]{filter});
        HashSet<Long> costTypeIds = new HashSet<Long>(16);
        HashMap<Long, Long> orgCostMap = new HashMap<Long, Long>(16);
        for (DynamicObject costType : costTypes) {
            costTypeIds.add(costType.getLong("costtype"));
            orgCostMap.put(costType.getLong("org"), costType.getLong("costtype"));
            logger.info("\u53d6\u4ef7\u63a5\u53e3\u67e5\u8be2\u5bf9\u5e94\u7684\u6838\u7b97\u6210\u672c\u7c7b\u578b\u4e3a==>{}", (Object)costType.getString("name"));
        }
        matCostParam.setCostTypeIds(costTypeIds);
        matCostParam.setOrgCostMap(orgCostMap);
        if (!costTypeIds.isEmpty()) {
            DynamicObject[] load;
            HashSet<Long> simCostTypes = new HashSet<Long>(16);
            HashMap<Long, Long> costMap = new HashMap<Long, Long>();
            block1: for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((Object[])costTypeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_costtype"))) {
                DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("costtypeentry");
                for (DynamicObject obj : entry) {
                    if (!"1".equals(obj.getString("costtypeattr"))) continue;
                    simCostTypes.add(obj.getLong("costtype.id"));
                    costMap.put(dynamicObject.getLong("id"), obj.getLong("costtype.id"));
                    continue block1;
                }
            }
            matCostParam.setSimCostTypes(simCostTypes);
            matCostParam.setCostMap(costMap);
        }
    }

    private boolean checkParams(MatCostParam matCostParam, List<Map<String, Object>> params, Long org, Long costAccount, String datatype, String appid) {
        if (CadEmptyUtils.isEmpty((Long)org) || CadEmptyUtils.isEmpty((String)datatype) || CadEmptyUtils.isEmpty((String)appid)) {
            logger.info("\u6838\u7b97\u7ec4\u7ec7==>{}, \u53d6\u4ef7\u7c7b\u522b==>{},\u5e94\u7528==>{},\u4e0d\u80fd\u4e3a\u7a7a", new Object[]{org, datatype, appid});
            return false;
        }
        if (CadEmptyUtils.isEmpty((Long)costAccount)) {
            Long costAccountByCalOrg = this.getCostAccountByCalOrg(org);
            if (costAccountByCalOrg == null) {
                logger.info("\u672a\u6839\u636e\u6838\u7b97\u7ec4\u7ec7\u83b7\u53d6\u5bf9\u5e94\u7684\u6210\u672c\u8d26\u8584");
                return false;
            }
            costAccount = costAccountByCalOrg;
        }
        matCostParam.setMulFactory(OrgHelper.isOrgEnableMultiFactory((Long)org));
        matCostParam.setDatatype(datatype);
        matCostParam.setOrg(org);
        matCostParam.setCostAccount(costAccount);
        HashSet<Long> invOrgSet = new HashSet<Long>(16);
        for (Map<String, Object> param : params) {
            Object invOrg;
            Object material = param.get("material");
            if (material != null) {
                matCostParam.getMaterIds().add(Long.parseLong(material.toString()));
                matCostParam.getQueryMatIds().add(Long.parseLong(material.toString()));
            }
            if ((invOrg = param.get("invorg")) == null) continue;
            invOrgSet.add(Long.parseLong(invOrg.toString()));
        }
        if (matCostParam.getMaterIds().isEmpty() || invOrgSet.isEmpty()) {
            logger.info("MatCostInfoPriceService.checkParams not pass,materIds or invOrgSet is null");
            return false;
        }
        matCostParam.setInvOrg(invOrgSet);
        this.setCostType(matCostParam);
        if (CadEmptyUtils.isEmpty((Set)matCostParam.getCostTypeIds())) {
            logger.info("MatCostInfoPriceServiceImpl checkParams not pass, costType not find");
            return false;
        }
        this.setSubElement(org, params, matCostParam);
        this.setPriority(matCostParam, params, appid);
        return true;
    }

    private void setPriority(MatCostParam matCostParam, List<Map<String, Object>> params, String appId) {
        if (!"cal".equals(appId)) {
            return;
        }
        if (params.get(0).get("priority") != null && "0".equals(params.get(0).get("priority").toString())) {
            logger.info("\u5b58\u8d27\u6838\u7b97\u8c03\u7528\uff0c\u4e0d\u6309\u4f18\u5148\u7ea7\u53d6\u4ef7");
            return;
        }
        QFilter filter = new QFilter("org", "=", (Object)matCostParam.getOrg());
        filter.and("enable", "=", (Object)true);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_tracknumber_setting", (String)"istrack,trackpriority", (QFilter[])new QFilter[]{filter});
        if (dynamicObject != null && dynamicObject.getBoolean("istrack")) {
            matCostParam.setPriority(true);
            String trackPriority = dynamicObject.getString("trackpriority");
            if (!CadEmptyUtils.isEmpty((String)trackPriority)) {
                trackPriority = trackPriority.substring(1, trackPriority.length() - 1);
                for (String level : trackPriority.split(",")) {
                    if ("A".equals(level)) continue;
                    matCostParam.getPriorityList().add(level);
                }
                logger.info("\u6839\u636e\u5f53\u524d\u7ec4\u7ec7\u83b7\u53d6\u5230\u4f18\u5148\u7ea7\u53d6\u4ef7\u914d\u7f6e\u4e3a==>{}", (Object)matCostParam.getPriorityList());
            }
        }
    }

    private void setSubElement(Long org, List<Map<String, Object>> params, MatCostParam matCostParam) {
        HashSet<Long> ids = new HashSet<Long>(10);
        for (Map<String, Object> param : params) {
            Object subElementType = param.get("subelementtype");
            if (subElementType == null || CadEmptyUtils.isEmpty((String)subElementType.toString())) continue;
            String type = subElementType.toString();
            if ("SE001".equals(type)) {
                ids.add(Long.parseLong(param.get("material").toString()));
            }
            if ("SE002".equals(type)) {
                param.put("subelement", 773175492709890048L);
            }
            if ("SE003".equals(type)) {
                param.put("subelement", 773177997665679360L);
            }
            if ("SE004".equals(type)) {
                param.put("subelement", 773176352911296512L);
            }
            if (!"SE005".equals(type)) continue;
            param.put("subelement", 773176488857077760L);
        }
        if (!ids.isEmpty()) {
            Map matEleMap = ElementHelper.getDefSubEles((Long)org, ids, (boolean)false);
            matCostParam.getMatSubElementMap().putAll(matEleMap);
        }
    }

    public Map<Long, String> getMaterialDimension(Long costType, List<Long> materialIds) {
        HashSet<Long> matIds = new HashSet<Long>(materialIds);
        QFilter filter = new QFilter("id", "=", (Object)costType);
        filter.and("costtypeentry.costtypeattr", "=", (Object)"1");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"costtypeentry.costtype as costtype", (QFilter[])new QFilter[]{filter});
        if (dynamicObject == null) {
            return null;
        }
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        Map costtype = MatDimensionHelper.getDimensionByMatIds((Long)dynamicObject.getLong("costtype"), matIds);
        for (Long materialId : materialIds) {
            DynamicObject object = (DynamicObject)costtype.get(materialId);
            if (object == null) {
                result.put(materialId, "material");
                continue;
            }
            String dimension = object.getString("dimension");
            result.put(materialId, dimension.substring(1) + "material");
        }
        return result;
    }

    private Set<String> getDimensions(String dimension) {
        HashSet<String> set = new HashSet<String>(16);
        if (dimension.length() != 0) {
            String[] split;
            dimension = dimension.substring(1, dimension.length() - 1);
            for (String item : split = dimension.split(",")) {
                set.add(item);
            }
        }
        return set;
    }

    public Long getCostAccountByCalOrg(Long org) {
        QFilter q = new QFilter("calorg", "=", (Object)org).and("enable", "=", (Object)true);
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,ismainaccount", (QFilter[])q.toArray());
        DynamicObject mainCostAccount = null;
        if (costAccounts == null || costAccounts.isEmpty()) {
            return null;
        }
        mainCostAccount = (DynamicObject)costAccounts.get(0);
        for (DynamicObject costAccount : costAccounts) {
            if (!costAccount.getBoolean("ismainaccount")) continue;
            mainCostAccount = costAccount;
            break;
        }
        return mainCostAccount.getLong("id");
    }

    private DynamicObject createMatCostInfoObj(DynamicObject planDynamicObj, DynamicObject effInfoObj) {
        Date now = new Date();
        DynamicObject matCostInfoOb = BusinessDataServiceHelper.newDynamicObject((String)"cad_matcostinfo");
        matCostInfoOb.set("id", (Object)ID.genLongId());
        matCostInfoOb.set("costtype", (Object)planDynamicObj.getLong("costtype.id"));
        matCostInfoOb.set("currency", (Object)planDynamicObj.getLong("costtype.currency.id"));
        matCostInfoOb.set("material", (Object)planDynamicObj.getLong("material.id"));
        matCostInfoOb.set("configuredcode", (Object)planDynamicObj.getLong("configuredcode.id"));
        matCostInfoOb.set("tracknumber", (Object)planDynamicObj.getLong("tracknumber.id"));
        matCostInfoOb.set("remark", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6309\u4f18\u5148\u7ea7\u53d6\u4ef7\u590d\u5236\u751f\u6210\uff0c\u53d6\u4ef7\u4f18\u5148\u7ea7\u4e3a\u5de5\u5355\u8ba1\u5212\u6210\u672c\u3002", (String)"MatCostInfoPriceServiceImpl_6", (String)"macc-cad-mservice", (Object[])new Object[0]));
        matCostInfoOb.set("datasource", (Object)"syscopy");
        matCostInfoOb.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
        matCostInfoOb.set("expdate", (Object)DateUtils.getDeFaultExpDate());
        matCostInfoOb.set("enable", (Object)"1");
        matCostInfoOb.set("status", (Object)"C");
        matCostInfoOb.set("keycol", (Object)planDynamicObj.getString("keycol"));
        matCostInfoOb.set("keycolid", (Object)planDynamicObj.getLong("keycolid.id"));
        matCostInfoOb.set("keycolid_id", (Object)planDynamicObj.getLong("keycolid.id"));
        matCostInfoOb.set("creator", (Object)1L);
        matCostInfoOb.set("createtime", (Object)now);
        matCostInfoOb.set("modifier", (Object)1L);
        matCostInfoOb.set("modifytime", (Object)now);
        matCostInfoOb.set("auditor", (Object)1L);
        matCostInfoOb.set("audittime", (Object)now);
        DynamicObjectCollection planEntryEntity = planDynamicObj.getDynamicObjectCollection("entryentity");
        Set subElements = planEntryEntity.stream().map(r -> r.getLong("subelement.id")).collect(Collectors.toSet());
        HashMap<Long, Long> subElementMap = new HashMap<Long, Long>(subElements.size());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement,element", (QFilter[])new QFilter[]{new QFilter("subelement", "in", subElements)});
        for (DynamicObject dynamicObject : dynamicObjects) {
            subElementMap.put(dynamicObject.getLong("subelement"), dynamicObject.getLong("element"));
        }
        HashMap<Long, BigDecimal> subElementCostMap = new HashMap<Long, BigDecimal>(20);
        HashMap<Long, BigDecimal> subStepAmtMap = new HashMap<Long, BigDecimal>(20);
        DynamicObjectCollection effInfoObjects = effInfoObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject effInfoObject : effInfoObjects) {
            long subElement;
            String datatype = effInfoObject.getString("datatype");
            if (subMatItem.equals(datatype) || subMatComItem.equals(datatype)) {
                subElement = effInfoObject.getLong("subelement");
                if (subElementCostMap.get(subElement) == null) {
                    subElementCostMap.put(subElement, effInfoObject.getBigDecimal("stdprice"));
                } else {
                    subElementCostMap.put(subElement, ((BigDecimal)subElementCostMap.get(subElement)).add(effInfoObject.getBigDecimal("stdprice")));
                }
            }
            if (!subMatItem.equals(datatype) && !totalPrice.equals(datatype)) continue;
            subElement = effInfoObject.getLong("subelement");
            if (subStepAmtMap.get(subElement) == null) {
                subStepAmtMap.put(subElement, effInfoObject.getBigDecimal("stdprice"));
                continue;
            }
            subStepAmtMap.put(subElement, ((BigDecimal)subStepAmtMap.get(subElement)).add(effInfoObject.getBigDecimal("stdprice")));
        }
        int i = 0;
        DynamicObjectCollection matCostInfoObEntry = matCostInfoOb.getDynamicObjectCollection("entryentity");
        for (Map.Entry entry : subElementCostMap.entrySet()) {
            DynamicObject dynamicObject = matCostInfoObEntry.addNew();
            dynamicObject.set("seq", (Object)i++);
            if (subElementMap.get(entry.getKey()) != null) {
                dynamicObject.set("element", subElementMap.get(entry.getKey()));
            }
            dynamicObject.set("subelement", entry.getKey());
            dynamicObject.set("standardcost", entry.getValue());
            if (subStepAmtMap.get(entry.getKey()) == null) continue;
            dynamicObject.set("stepamt", subStepAmtMap.get(entry.getKey()));
        }
        effInfoObj.set("matcostid", (Object)matCostInfoOb.getLong("id"));
        return matCostInfoOb;
    }

    private DynamicObject createEffInfoObj(DynamicObject planDynamicObj) {
        DynamicObject effInfoObj = BusinessDataServiceHelper.newDynamicObject((String)"cad_calceffectiveresult");
        effInfoObj.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
        effInfoObj.set("expdate", (Object)DateUtils.getDeFaultExpDate());
        effInfoObj.set("costtype", (Object)planDynamicObj.getLong("costtype.id"));
        effInfoObj.set("material", (Object)planDynamicObj.getLong("material.id"));
        effInfoObj.set("configuredcode", (Object)planDynamicObj.getLong("configuredcode.id"));
        effInfoObj.set("tracknumber", (Object)planDynamicObj.getLong("tracknumber.id"));
        effInfoObj.set("rootnode", (Object)planDynamicObj.getString("id"));
        effInfoObj.set("keycol", (Object)planDynamicObj.getString("keycol"));
        effInfoObj.set("keycolid", (Object)planDynamicObj.getLong("keycolid.id"));
        effInfoObj.set("keycolid_id", (Object)planDynamicObj.getLong("keycolid.id"));
        effInfoObj.set("ismaindata", (Object)1);
        effInfoObj.set("isleaf", (Object)"0");
        DynamicObjectCollection effInfoObEntry = effInfoObj.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection planEntryEntity = planDynamicObj.getDynamicObjectCollection("entryentity");
        Set subElements = planEntryEntity.stream().map(r -> r.getLong("subelement.id")).collect(Collectors.toSet());
        HashMap<Long, Long> subElementMap = new HashMap<Long, Long>(subElements.size());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement,element", (QFilter[])new QFilter[]{new QFilter("subelement", "in", subElements)});
        for (DynamicObject dynamicObject : dynamicObjects) {
            subElementMap.put(dynamicObject.getLong("subelement"), dynamicObject.getLong("element"));
        }
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal totalStandPrice = BigDecimal.ZERO;
        BigDecimal totalPrice = BigDecimal.ZERO;
        for (DynamicObject planObj : planEntryEntity) {
            BigDecimal qty = BigDecimal.ZERO;
            BigDecimal stdPrice = BigDecimal.ZERO;
            BigDecimal price = BigDecimal.ZERO;
            String calcBasis = planObj.getString("calcbasis");
            BigDecimal planQty = planDynamicObj.getBigDecimal("planqty");
            BigDecimal needAmount = planObj.getBigDecimal("needamount");
            if (needAmount == null || needAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            qty = planObj.getBigDecimal("needqty").divide(planQty, 10, 4);
            stdPrice = needAmount.divide(planQty, 10, 4);
            price = stdPrice.divide(qty, 10, 4);
            DynamicObject dynamicObject = effInfoObEntry.addNew();
            if ("0".equals(calcBasis)) {
                dynamicObject.set("resource", (Object)planObj.getLong("resource.id"));
                dynamicObject.set("element", subElementMap.get(planObj.getLong("subelement.id")));
                dynamicObject.set("subelement", (Object)planObj.getLong("subelement.id"));
                dynamicObject.set("datatype", (Object)subMatItem);
                dynamicObject.set("calcbasis", (Object)planObj.getString("caltype"));
                dynamicObject.set("qty", (Object)qty);
                dynamicObject.set("price", (Object)price);
                dynamicObject.set("stdprice", (Object)stdPrice);
            } else {
                dynamicObject.set("element", subElementMap.get(planObj.getLong("subelement.id")));
                dynamicObject.set("subelement", (Object)planObj.getLong("subelement.id"));
                dynamicObject.set("qty", (Object)qty);
                dynamicObject.set("price", (Object)price);
                dynamicObject.set("stdprice", (Object)stdPrice);
                dynamicObject.set("submaterial", (Object)planObj.getLong("submaterial.id"));
                dynamicObject.set("datatype", (Object)subMatComItem);
                DynamicObject sumDynamicObj = effInfoObEntry.addNew();
                sumDynamicObj.set("element", subElementMap.get(planObj.getLong("subelement.id")));
                sumDynamicObj.set("subelement", (Object)planObj.getLong("subelement.id"));
                sumDynamicObj.set("qty", (Object)qty);
                sumDynamicObj.set("price", (Object)price);
                sumDynamicObj.set("stdprice", (Object)stdPrice);
                sumDynamicObj.set("submaterial", (Object)planObj.getLong("submaterial.id"));
                sumDynamicObj.set("datatype", (Object)totalPrice);
            }
            totalQty = totalQty.add(qty);
            totalStandPrice = totalStandPrice.add(stdPrice);
            totalPrice = totalPrice.add(price);
        }
        DynamicObject totalDynamicObject = effInfoObEntry.addNew();
        totalDynamicObject.set("element", (Object)ElementConstant.MATERIAL_ID);
        totalDynamicObject.set("subelement", (Object)773175233367685120L);
        totalDynamicObject.set("qty", (Object)totalQty);
        totalDynamicObject.set("price", (Object)totalPrice);
        totalDynamicObject.set("stdprice", (Object)totalStandPrice);
        totalDynamicObject.set("datatype", (Object)"1");
        return effInfoObj;
    }

    private void addDateFilter(List<QFilter> filters, List<Map<String, Object>> params) {
        Date effectDate = null;
        Date expDate = null;
        for (Map<String, Object> param : params) {
            Date date = (Date)param.get("date");
            if (effectDate == null) {
                effectDate = date;
                expDate = date;
                continue;
            }
            if (date.before(effectDate)) {
                effectDate = date;
            }
            if (!date.after(expDate)) continue;
            expDate = date;
        }
        filters.add(new QFilter("effectdate", "<=", effectDate));
        filters.add(new QFilter("expdate", ">", (Object)expDate));
    }

    private List<Map<String, Object>> confirmQueryByKeyCol(String type, Map<String, Object> param, MatCostParam matCostParam) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
        QFilter filter = new QFilter("keycol", "=", (Object)param.get("configTrackKeyCol").toString());
        filter.and("costtype", "=", (Object)this.getCostTypeByParam(param, matCostParam));
        filter.and("effectdate", "<=", (Object)((Date)param.get("date")));
        filter.and("expdate", ">", (Object)((Date)param.get("date")));
        if (MAT_PRICE.equals(type)) {
            String selectFields = "id,costtype,material,keycol,keycolid,effectdate,expdate,entryentity.element.id element,entryentity.subelement.id subelement,entryentity.standardcost standardcost,entryentity.stepamt stepamt";
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_matcostinfo", (String)selectFields, (QFilter[])new QFilter[]{filter});
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long id = dynamicObject.getLong("id");
                HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                dataMap.put("matcostinfoid", id);
                dataMap.put("costtype", dynamicObject.getLong("costtype"));
                dataMap.put("keycol", dynamicObject.getString("keycol"));
                dataMap.put("keycolid", dynamicObject.getLong("keycolid"));
                dataMap.put("material", dynamicObject.getLong("material"));
                dataMap.put("effectdate", dynamicObject.getDate("effectdate"));
                dataMap.put("expdate", dynamicObject.getDate("expdate"));
                dataMap.put("element", dynamicObject.getLong("element"));
                dataMap.put("subelement", dynamicObject.getLong("subelement"));
                dataMap.put("standardcost", dynamicObject.getBigDecimal("standardcost"));
                dataMap.put("stepamt", dynamicObject.getBigDecimal("stepamt"));
                list.add(dataMap);
            }
        } else {
            String selectFields = "id,costtype,matcostid,material,keycol,keycolid,effectdate,expdate,entryentity.resource resource,entryentity.element element,entryentity.subelement subelement,entryentity.qty qty,entryentity.price price,entryentity.stdprice stdprice,entryentity.submaterial submaterial,entryentity.submatvers submatvers,entryentity.subauxproperty subauxproperty,entryentity.activity activity,entryentity.datatype datatype,entryentity.calcbasis calcbasis,entryentity.subkeycol subkeycol,entryentity.subkeycolid subkeycolid";
            if (subMatItem.equals(matCostParam.getDatatype())) {
                filter.and("entryentity.datatype", "in", (Object)Sets.newHashSet((Object[])new String[]{subMatItem, subMatComItem}));
            }
            if (subMatComItem.equals(matCostParam.getDatatype())) {
                filter.and("entryentity.datatype", "in", (Object)Sets.newHashSet((Object[])new String[]{subMatItem, totalPrice}));
            }
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_calceffectiveresult", (String)selectFields, (QFilter[])new QFilter[]{filter});
            for (DynamicObject dynamicObject : dynamicObjects) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
                dataMap.put("id", dynamicObject.getLong("id"));
                dataMap.put("matcostinfoid", dynamicObject.getLong("matcostid"));
                dataMap.put("costtype", dynamicObject.getLong("costtype"));
                dataMap.put("keycol", dynamicObject.getString("keycol"));
                dataMap.put("keycolid", dynamicObject.getLong("keycolid"));
                dataMap.put("material", dynamicObject.getLong("material"));
                dataMap.put("effectdate", dynamicObject.getDate("effectdate"));
                dataMap.put("expdate", dynamicObject.getDate("expdate"));
                dataMap.put("subkeycol", dynamicObject.getString("subkeycol"));
                dataMap.put("subkeycolid", dynamicObject.getLong("subkeycolid"));
                dataMap.put("resource", dynamicObject.getLong("resource"));
                dataMap.put("element", dynamicObject.getLong("element"));
                dataMap.put("subelement", dynamicObject.getLong("subelement"));
                dataMap.put("qty", dynamicObject.getBigDecimal("qty"));
                dataMap.put("price", dynamicObject.getBigDecimal("price"));
                dataMap.put("stdprice", dynamicObject.getBigDecimal("stdprice"));
                dataMap.put("submaterial", dynamicObject.getLong("submaterial"));
                dataMap.put("submatvers", dynamicObject.getLong("submatvers"));
                dataMap.put("subauxproperty", dynamicObject.getLong("subauxproperty"));
                dataMap.put("activity", dynamicObject.getLong("activity"));
                dataMap.put("datatype", dynamicObject.getString("datatype"));
                dataMap.put("calcbasis", dynamicObject.getString("calcbasis"));
                list.add(dataMap);
            }
        }
        if (!list.isEmpty()) {
            logger.info("\u4f18\u5148\u7ea7\u53d6\u4ef7\u786e\u8ba4\u67e5\u8be2\u6570\u636e\u6210\u529f\uff0c\u53c2\u6570==>{},\u8fd4\u56de\u6570\u636e==>{}", param, list);
        }
        return list;
    }
}

