/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.algox.utils.DataSetUtils;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.api.MatCostInfoService;
import org.apache.commons.lang.StringUtils;

public class MatCostInfoServiceImp
implements MatCostInfoService {
    private static Log logger = LogFactory.getLog(MatCostInfoServiceImp.class);
    private static final String[] FIELDS = new String[]{"org", "invorg", "costaccount", "material", "matversion", "auxpty", "date"};

    public Map<String, List<Map<String, Object>>> getMatCost(Set<Map<String, Object>> params, boolean isfetchPrice) {
        Long startTime = System.currentTimeMillis();
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(16);
        logger.info("start getMatCost mservice, isfetchPrice ={}", (Object)isfetchPrice);
        Long costAccountId = this.getCostAccountParam(params);
        if (costAccountId == null) {
            return result;
        }
        boolean isMulFactory = CostAccountHelper.isEnableMulFactory((Long)costAccountId);
        logger.info("\u6210\u672c\u8d26\u7c3f={}\uff0c\u542f\u7528\u591a\u5de5\u5382\u6838\u7b97={}\uff0c\u83b7\u53d6{}\u4e0a\u8bbe\u7f6e\u7684\u6210\u672c\u7c7b\u578b", new Object[]{costAccountId, isMulFactory ? "\u5f00" : "\u5173", isMulFactory ? "\u5e93\u5b58\u7ec4\u7ec7" : "\u6838\u7b97\u7ec4\u7ec7"});
        RowMeta rowMeta = this.getParamRowMeta();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        Field[] fields = rowMeta.getFields();
        Object[] rowData = null;
        HashSet<String> resultKey = new HashSet<String>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        for (Map<String, Object> param : params) {
            rowData = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                rowData[i] = param.get(fields[i].getName());
            }
            resultKey.add(StringUtils.join((Object[])rowData, (String)"#"));
            dataList.add(rowData);
            orgIds.add(Long.parseLong(param.get(isMulFactory ? "invorg" : "org").toString()));
            costAccountIds.add(Long.parseLong(param.get("costaccount").toString()));
        }
        logger.info("\u8f93\u5165\u53c2\u6570resultKey = {}", (Object)StringUtils.join(resultKey, (String)"||"));
        if (dataList.size() == 0) {
            return null;
        }
        DataSet paramDataSet = Algo.create((String)"macc.cad.MatCostInfoServiceImp").createDataSet(dataList.iterator(), rowMeta);
        DataSet costType = this.getCostType(orgIds, costAccountIds, isMulFactory);
        paramDataSet = isMulFactory ? paramDataSet.leftJoin(costType).on("invorg", "invorg").on("costaccount", "costaccount").select(new String[]{"org", "invorg", "costaccount", "material", "matversion", "auxpty", "date"}, new String[]{"costtype"}).finish() : paramDataSet.leftJoin(costType).on("org", "org").on("costaccount", "costaccount").select(new String[]{"org", "invorg", "costaccount", "material", "matversion", "auxpty", "date"}, new String[]{"costtype"}).finish();
        DataSet matDataSet = paramDataSet.copy().select(new String[]{"costtype", "material"});
        HashSet<Long> costTypeIds = new HashSet<Long>(16);
        HashSet<Long> materialIds = new HashSet<Long>(16);
        for (Row row : matDataSet) {
            costTypeIds.add(row.getLong("costtype"));
            materialIds.add(row.getLong("material"));
        }
        DataSet matCostDataSet = this.getMatCostInfo(costTypeIds, materialIds);
        DataSet allData = paramDataSet.copy().leftJoin(matCostDataSet).on("costtype", "costtype").on("material", "material").on("matversion", "matversion").on("auxpty", "auxpty").select(new String[]{"org", "invorg", "costaccount", "costtype", "date"}, new String[]{"id", "material", "matversion", "auxpty", "effectdate", "expdate"}).finish();
        allData = allData.where("material is not null and date >= effectdate and date < expdate");
        Set<Long> matCostIds = this.getMatCostIds(resultKey, allData.copy());
        if (isfetchPrice) {
            logger.info("\u53d6\u7269\u6599\u6210\u672c\u4fe1\u606f:{},matCostIds\uff1a{}:", (Object)matCostIds.size(), (Object)this.getSetStr(matCostIds));
            this.matCostData(resultKey, matCostIds, allData.copy(), result);
        } else {
            logger.info("\u53d6\u6570\u524d:{},matCostIds\uff1a{}:", (Object)matCostIds.size(), (Object)this.getSetStr(matCostIds));
            this.effectData(resultKey, matCostIds, allData.copy(), result);
            this.purPriceData(resultKey, matCostIds, allData.copy(), result);
            if (matCostIds.size() > 0) {
                logger.info("\u53d6\u751f\u6548\u5377\u7b97\u7ed3\u679c\u8868:{},matCostIds\uff1a{}:", (Object)matCostIds.size(), (Object)this.getSetStr(matCostIds));
                this.effectDataNew(resultKey, matCostIds, allData.copy(), result, costTypeIds, materialIds, paramDataSet.copy());
                logger.info("\u53d6\u5916\u8d2d\u4ef7\u76ee\u8868:{}, matCostIds\uff1a{}:", (Object)matCostIds.size(), (Object)this.getSetStr(matCostIds));
                this.purPriceDataNew(resultKey, matCostIds, allData.copy(), result, costTypeIds, materialIds, paramDataSet.copy());
            }
        }
        DataSetUtils.colse((DataSet[])new DataSet[]{paramDataSet, allData});
        logger.info("getMatCost\u8fd4\u56de\u7ed3\u679c\uff1a{}\u6761\uff0c\u8017\u65f6{} ms", (Object)result.size(), (Object)(System.currentTimeMillis() - startTime));
        return result;
    }

    private void purPriceData(Set<String> resultKey, Set<Long> matCostIds, DataSet purData, Map<String, List<Map<String, Object>>> result) {
        if (CadEmptyUtils.isEmpty(matCostIds)) {
            return;
        }
        String selectFields = "id,matcostid,entryentity.element element,entryentity.subelement subelement,entryentity.price price,entryentity.rate rate";
        QFilter[] filters = new QFilter[]{new QFilter("matcostid", "in", matCostIds)};
        String algoKey = "kd.macc.cad.mservice.MatCostInfoServiceImp.purPriceData";
        DataSet purPrices = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_purprices", (String)selectFields, (QFilter[])filters, null);
        purPrices = purData.leftJoin(purPrices).on("id", "matcostid").select(new String[]{"org", "invorg", "costaccount", "costtype", "material", "matversion", "auxpty", "date"}, new String[]{"id", "matcostid", "element", "subelement", "price", "rate"}).finish();
        Iterator it = purPrices.iterator();
        HashMap<String, Number> detailInfo = null;
        while (it.hasNext()) {
            Row row = (Row)it.next();
            String key = this.includeNeedData(resultKey, row) + "#" + row.getString("costtype");
            List<Map<String, Object>> val = result.get(key);
            if (val == null) {
                val = new ArrayList<Map<String, Object>>(10);
            }
            detailInfo = new HashMap<String, Number>(5);
            detailInfo.put("id", row.getLong("id"));
            detailInfo.put("element", row.getLong("element"));
            detailInfo.put("subelement", row.getLong("subelement"));
            detailInfo.put("price", row.getBigDecimal("price"));
            detailInfo.put("stdprice", row.getBigDecimal("price"));
            detailInfo.put("rate", row.getBigDecimal("rate"));
            detailInfo.put("matcostid", row.getLong("matcostid"));
            val.add(detailInfo);
            result.put(key, val);
            Long matCostId = row.getLong("matcostid");
            if (CadEmptyUtils.isEmpty(matCostIds)) continue;
            matCostIds.remove(matCostId);
        }
    }

    private void purPriceDataNew(Set<String> resultKey, Set<Long> matCostIds, DataSet purData, Map<String, List<Map<String, Object>>> result, Set<Long> costTypeIds, Set<Long> materialIds, DataSet paramDataSet) {
        if (CadEmptyUtils.isEmpty(matCostIds)) {
            return;
        }
        String selectFields = "id,matcostid,entryentity.element element,entryentity.subelement subelement,entryentity.price price,entryentity.rate rate,costtype,material,matversion,auxpty,effectdate,expdate";
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "in", costTypeIds), new QFilter("material", "in", materialIds)};
        String algoKey = "kd.macc.cad.mservice.MatCostInfoServiceImp.purPriceData";
        DataSet purPrices = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_purprices", (String)selectFields, (QFilter[])filters, null);
        purData = purData.filter(String.format("id in (%s)", this.getSetStr(matCostIds)));
        purPrices = purData.leftJoin(purPrices).on("costtype", "costtype").on("material", "material").on("matversion", "matversion").on("auxpty", "auxpty").select(new String[]{"org", "invorg", "costaccount", "costtype", "date", "id matcostid"}, new String[]{"material", "matversion", "auxpty", "effectdate", "expdate", "id", "element", "subelement", "price", "rate"}).finish();
        purPrices = purPrices.where("material is not null and date >= effectdate and date < expdate");
        Iterator it = purPrices.iterator();
        HashMap<String, Number> detailInfo = null;
        while (it.hasNext()) {
            Row row = (Row)it.next();
            String key = this.includeNeedData(resultKey, row) + "#" + row.getString("costtype");
            List<Map<String, Object>> val = result.get(key);
            if (val == null) {
                val = new ArrayList<Map<String, Object>>(10);
            }
            detailInfo = new HashMap<String, Number>(5);
            detailInfo.put("id", row.getLong("id"));
            detailInfo.put("element", row.getLong("element"));
            detailInfo.put("subelement", row.getLong("subelement"));
            detailInfo.put("price", row.getBigDecimal("price"));
            detailInfo.put("stdprice", row.getBigDecimal("price"));
            detailInfo.put("rate", row.getBigDecimal("rate"));
            val.add(detailInfo);
            result.put(key, val);
            Long matCostId = row.getLong("matcostid");
            if (CadEmptyUtils.isEmpty(matCostIds)) continue;
            matCostIds.remove(matCostId);
        }
    }

    private void effectData(Set<String> resultKey, Set<Long> matCostIds, DataSet effData, Map<String, List<Map<String, Object>>> result) {
        String selectFields = "id,matcostid,entryentity.resource resource,entryentity.element element,entryentity.subelement subelement,entryentity.qty qty,entryentity.price price,entryentity.stdprice stdprice,entryentity.submaterial submaterial,entryentity.submatvers submatvers,entryentity.subauxproperty subauxproperty,entryentity.activity activity,entryentity.datatype datatype,entryentity.calcbasis calcbasis";
        QFilter[] filters = new QFilter[]{new QFilter("matcostid", "in", matCostIds)};
        String algoKey = "kd.macc.cad.mservice.MatCostInfoServiceImp.effectData";
        DataSet effectiveResult = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_calceffectiveresult", (String)selectFields, (QFilter[])filters, null);
        effectiveResult = effData.leftJoin(effectiveResult).on("id", "matcostid").select(new String[]{"org", "invorg", "costaccount", "costtype", "material", "matversion", "auxpty", "date"}, new String[]{"id", "matcostid", "resource", "element", "subelement", "qty", "price", "stdprice", "submaterial", "submatvers", "subauxproperty", "activity", "datatype", "calcbasis"}).finish();
        Iterator it = effectiveResult.iterator();
        HashMap<String, Object> detailInfo = null;
        while (it.hasNext()) {
            Row row = (Row)it.next();
            String key = this.includeNeedData(resultKey, row) + "#" + row.getString("costtype");
            List<Map<String, Object>> val = result.get(key);
            if (val == null) {
                val = new ArrayList<Map<String, Object>>(10);
            }
            if (CadEmptyUtils.isEmpty((Long)row.getLong("id"))) continue;
            detailInfo = new HashMap<String, Object>(12);
            detailInfo.put("id", row.getLong("id"));
            detailInfo.put("resource", row.getLong("resource"));
            detailInfo.put("element", row.getLong("element"));
            detailInfo.put("subelement", row.getLong("subelement"));
            detailInfo.put("qty", row.getBigDecimal("qty"));
            detailInfo.put("price", row.getBigDecimal("price"));
            detailInfo.put("stdprice", row.getBigDecimal("stdprice"));
            detailInfo.put("submaterial", row.getLong("submaterial"));
            detailInfo.put("submatvers", row.getLong("submatvers"));
            detailInfo.put("subauxproperty", row.getLong("subauxproperty"));
            detailInfo.put("activity", row.getLong("activity"));
            detailInfo.put("datatype", row.getString("datatype"));
            detailInfo.put("calcbasis", row.getString("calcbasis"));
            detailInfo.put("matcostid", row.getLong("matcostid"));
            val.add(detailInfo);
            result.put(key, val);
            Long matCostId = row.getLong("matcostid");
            if (CadEmptyUtils.isEmpty(matCostIds)) continue;
            matCostIds.remove(matCostId);
        }
    }

    private String getSetStr(Set<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return "-1";
        }
        StringBuilder sb = new StringBuilder();
        for (Long id : ids) {
            sb.append(id).append(",");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    private void effectDataNew(Set<String> resultKey, Set<Long> matCostIds, DataSet effData, Map<String, List<Map<String, Object>>> result, Set<Long> costTypeIds, Set<Long> materialIds, DataSet paramDataSet) {
        String selectFields = "id,matcostid,entryentity.resource resource,costtype,material,matvers matversion,auxproperty auxpty,effectdate,expdate,entryentity.element element,entryentity.subelement subelement,entryentity.qty qty,entryentity.price price,entryentity.stdprice stdprice,entryentity.submaterial submaterial,entryentity.submatvers submatvers,entryentity.subauxproperty subauxproperty,entryentity.activity activity,entryentity.datatype datatype,entryentity.calcbasis calcbasis";
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "in", costTypeIds), new QFilter("material", "in", materialIds), new QFilter("ismaindata", "=", (Object)1), new QFilter("isleaf", "=", (Object)"0"), new QFilter("entryentity.datatype", "in", Arrays.asList("2", "3"))};
        String algoKey = "kd.macc.cad.mservice.MatCostInfoServiceImp.effectData";
        DataSet effectiveResult = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_calceffectiveresult", (String)selectFields, (QFilter[])filters, null);
        effData = effData.filter(String.format("id in (%s)", this.getSetStr(matCostIds)));
        effectiveResult = effData.leftJoin(effectiveResult).on("costtype", "costtype").on("material", "material").on("matversion", "matversion").on("auxpty", "auxpty").select(new String[]{"org", "invorg", "costaccount", "costtype", "date", "id matcostid"}, new String[]{"material", "matversion", "auxpty", "effectdate", "expdate", "id", "resource", "element", "subelement", "qty", "price", "stdprice", "submaterial", "submatvers", "subauxproperty", "activity", "datatype", "calcbasis"}).finish();
        effectiveResult = effectiveResult.where("material is not null and date >= effectdate and date < expdate");
        Iterator it = effectiveResult.iterator();
        HashMap<String, Object> detailInfo = null;
        while (it.hasNext()) {
            Row row = (Row)it.next();
            String key = this.includeNeedData(resultKey, row) + "#" + row.getString("costtype");
            List<Map<String, Object>> val = result.get(key);
            if (val == null) {
                val = new ArrayList<Map<String, Object>>(10);
            }
            detailInfo = new HashMap<String, Object>(12);
            detailInfo.put("id", row.getLong("id"));
            detailInfo.put("resource", row.getLong("resource"));
            detailInfo.put("element", row.getLong("element"));
            detailInfo.put("subelement", row.getLong("subelement"));
            detailInfo.put("qty", row.getBigDecimal("qty"));
            detailInfo.put("price", row.getBigDecimal("price"));
            detailInfo.put("stdprice", row.getBigDecimal("stdprice"));
            detailInfo.put("submaterial", row.getLong("submaterial"));
            detailInfo.put("submatvers", row.getLong("submatvers"));
            detailInfo.put("subauxproperty", row.getLong("subauxproperty"));
            detailInfo.put("activity", row.getLong("activity"));
            detailInfo.put("datatype", row.getString("datatype"));
            detailInfo.put("calcbasis", row.getString("calcbasis"));
            val.add(detailInfo);
            result.put(key, val);
            Long matCostId = row.getLong("matcostid");
            if (CadEmptyUtils.isEmpty(matCostIds)) continue;
            matCostIds.remove(matCostId);
        }
    }

    private void matCostData(Set<String> resultKey, Set<Long> matCostIds, DataSet matData, Map<String, List<Map<String, Object>>> result) {
        String algoKey = this.getClass().getName() + ".matCostData";
        String selectFields = "id,entryentity.element.id element,entryentity.subelement.id subelement,entryentity.standardcost standardcost,entryentity.stepamt stepamt";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", matCostIds)};
        DataSet matCostInfo = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_matcostinfo", (String)selectFields, (QFilter[])filters, null);
        matCostInfo = matData.leftJoin(matCostInfo).on("id", "id").select(new String[]{"org", "invorg", "costaccount", "material", "matversion", "auxpty", "date"}, new String[]{"element", "subelement", "standardcost", "stepamt"}).finish();
        for (Row row : matCostInfo) {
            String key = this.includeNeedData(resultKey, row);
            List<Map<String, Object>> value = result.get(key);
            if (value == null) {
                value = new ArrayList<Map<String, Object>>(1);
            }
            HashMap<String, Number> val = new HashMap<String, Number>(4);
            val.put("element", row.getLong("element"));
            val.put("subelement", row.getLong("subelement"));
            val.put("standardcost", row.getBigDecimal("standardcost"));
            val.put("stepamt", row.getBigDecimal("stepamt"));
            value.add(val);
            result.put(key, value);
        }
    }

    private Set<Long> getMatCostIds(Set<String> resultKey, DataSet allData) {
        HashSet<Long> matCostIds = new HashSet<Long>(16);
        for (Row row : allData) {
            String key = this.includeNeedData(resultKey, row);
            if (key == null) continue;
            matCostIds.add(row.getLong("id"));
        }
        DataSetUtils.colse((DataSet)allData);
        return matCostIds;
    }

    private String includeNeedData(Set<String> resultKey, Row row) {
        StringBuilder sb = new StringBuilder();
        for (String field : FIELDS) {
            sb.append("#");
            sb.append(row.getString(field));
        }
        String key = sb.substring(1);
        if (resultKey.contains(key)) {
            return key;
        }
        return null;
    }

    private DataSet getMatCostInfo(Set<Long> costTypeIds, Set<Long> materialIds) {
        String algoKey = this.getClass().getName() + ".getMatCostInfo";
        String selectFields = "id,costtype.id costtype,material.id material,matversion.id matversion,auxpty.id auxpty,effectdate,expdate";
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "in", costTypeIds), new QFilter("material", "in", materialIds), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DataSet matCostInfo = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_matcostinfo", (String)selectFields, (QFilter[])filters, null);
        return matCostInfo;
    }

    private DataSet getCostType(Set<Long> orgIds, Set<Long> costAccountIds, boolean isMulFactory) {
        String algoKey = this.getClass().getName() + ".getCostType";
        String selectFields = null;
        Date date = TimeServiceHelper.now();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costaccount", "in", costAccountIds));
        filters.add(new QFilter("bizstatus", "=", (Object)"1"));
        filters.add(new QFilter("effectdate", "<=", (Object)date));
        filters.add(new QFilter("invaliddate", ">=", (Object)date));
        if (isMulFactory) {
            selectFields = "storageorgunit invorg,costaccount,costtype";
            filters.add(new QFilter("storageorgunit", "in", orgIds));
        } else {
            selectFields = "calorg org,costaccount,costtype";
            filters.add(new QFilter("calorg", "in", orgIds));
        }
        DataSet costTypeDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cal_bd_costtypeorg", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        return costTypeDataSet;
    }

    private Long getCostAccountParam(Set<Map<String, Object>> params) {
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        for (Map<String, Object> param : params) {
            costAccountIds.add(Long.valueOf(String.valueOf(param.get("costaccount").toString())));
        }
        if (costAccountIds.size() == 1) {
            Iterator it = costAccountIds.iterator();
            return (Long)it.next();
        }
        return null;
    }

    private RowMeta getParamRowMeta() {
        Field[] fields = new Field[]{new Field("org", (DataType)DataType.LongType), new Field("invorg", (DataType)DataType.LongType), new Field("costaccount", (DataType)DataType.LongType), new Field("material", (DataType)DataType.LongType), new Field("matversion", (DataType)DataType.LongType), new Field("auxpty", (DataType)DataType.LongType), new Field("date", (DataType)DataType.DateType)};
        return new RowMeta(fields);
    }
}

