/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.enums.CollectStatus;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.mservice.api.MatUseService;
import kd.macc.cad.mservice.matuse.IMatUseAction;
import kd.macc.cad.mservice.matuse.MatUseArgs;
import kd.macc.cad.mservice.matuse.MatUseContext;
import kd.macc.cad.mservice.matuse.MatUseResultBuilder;
import org.apache.commons.lang3.StringUtils;

public class MatUseServiceImpl
implements MatUseService {
    private static final Log logger = LogFactory.getLog(MatUseServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> importMatUse(Long orgId, List<Map<String, Object>> orgCostAccountList, String progressId, String appNum, String entityId) {
        MatUseContext matUseContext;
        block12: {
            MatUseArgs matUseArgs = new MatUseArgs();
            matUseArgs.setProgressId(progressId);
            matUseArgs.setAcctOrgId(orgId);
            HashMap<Long, Long> costAccountPeriodMap = new HashMap<Long, Long>(2);
            HashMap<Long, Long> costAccountCurrencyMap = new HashMap<Long, Long>(2);
            for (Map<String, Object> orgCostAccount : orgCostAccountList) {
                Object costAccountId = orgCostAccount.get("costaccountId");
                Object periodId = orgCostAccount.get("currentperiodId");
                Object currencyId = orgCostAccount.get("currencyId");
                if (costAccountId != null && periodId != null) {
                    costAccountPeriodMap.put(Long.valueOf(costAccountId.toString()), Long.valueOf(periodId.toString()));
                }
                if (costAccountId == null || currencyId == null) continue;
                costAccountCurrencyMap.put(Long.valueOf(costAccountId.toString()), Long.valueOf(currencyId.toString()));
            }
            matUseArgs.setCostAccountPeriodMap(costAccountPeriodMap);
            matUseArgs.setCostAccountCurrencyMap(costAccountCurrencyMap);
            HashMap<Long, List<Long>> acctOrgCostCentersMap = new HashMap<Long, List<Long>>(1);
            List<Long> costCenterIds = this.getCostCenterByOrg(orgId);
            if (!costCenterIds.isEmpty()) {
                acctOrgCostCentersMap.put(orgId, costCenterIds);
            }
            matUseArgs.setAcctOrgCostCentersMap(acctOrgCostCentersMap);
            matUseArgs.setCostCenterIds(costCenterIds);
            matUseArgs.setOrgCostAccountList(orgCostAccountList);
            matUseArgs.setAppNum(appNum);
            matUseArgs.setEntityId(entityId);
            matUseContext = new MatUseContext();
            matUseContext.setMatUseArgs(matUseArgs);
            if ("eca".equals(appNum)) {
                matUseContext.getCollectReport().logBaseInfo(orgId, CollectObjectEnum.MAT_ALLOC, appNum);
            } else {
                matUseContext.getCollectReport().logBaseInfo(orgId, CollectObjectEnum.MAT_USE, appNum);
            }
            long time = System.currentTimeMillis();
            List<IMatUseAction> iMatUseActions = IMatUseAction.initialize(appNum, Boolean.TRUE);
            try {
                for (IMatUseAction iMatUseAction : iMatUseActions) {
                    long actionTime = System.currentTimeMillis();
                    iMatUseAction.setContext(matUseContext);
                    iMatUseAction.execute();
                    logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-action\uff1a{},\u8017\u65f6\uff1a{}ms", (Object)iMatUseAction.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
                }
            }
            catch (Exception e) {
                logger.error("\u6750\u6599\u8017\u7528\u5206\u914d\u5f02\u5e38\u3002", (Throwable)e);
                if (!CollectReportHelper.disableCollectReport()) {
                    String errorMsg = ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf\u9519\u8bef", (String)"MatUseServiceImpl_0", (String)"macc-cad-mservice", (Object[])new Object[0]);
                    matUseContext.getCollectReport().logError((Throwable)e, errorMsg);
                    break block12;
                }
                throw e;
            }
            finally {
                logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
            }
        }
        return new MatUseResultBuilder(matUseContext).buildResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> importMatUse(Map<String, Object> collectParamMap, List<Long> mftOrderEntryIds, Long acctOrgId, List<Long> costCenterIds, List<Long> manuOrgIds, String appNum, String entityId, String progressId) {
        boolean isGetLock = true;
        String lockId = acctOrgId == null ? "0" : acctOrgId.toString();
        try {
            String lockErr = SimpleMutexHelper.checkAndRequireXMutex((String)"mat-import", (Object)lockId);
            if (StringUtils.isNotEmpty((CharSequence)lockErr)) {
                HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
                MsgUtils.putMsg2Map((String)"mutex", (String)lockErr, errorMsgMap);
                isGetLock = false;
                ProgressHelper.showError((String)progressId, (String)lockErr);
                HashMap<String, String> hashMap = errorMsgMap;
                return hashMap;
            }
            Map<String, String> errorMsgMap = this.executeImport(collectParamMap, mftOrderEntryIds, acctOrgId, costCenterIds, manuOrgIds, appNum, entityId, progressId);
            return errorMsgMap;
        }
        catch (Exception ex) {
            logger.error("\u6750\u6599\u8017\u7528\u5f52\u96c6\u5f02\u5e38\u3002", (Throwable)ex);
            HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5b58\u5728\u5f02\u5e38:%s\u3002", (String)"MatUseServiceImpl_4", (String)"macc-cad-mservice", (Object[])new Object[0]), ex.getMessage());
            MsgUtils.putMsg2Map((String)"tip", (String)errorMsg, errorMsgMap);
            ProgressHelper.clearProgressParam((String)progressId);
            HashMap<String, String> hashMap = errorMsgMap;
            return hashMap;
        }
        finally {
            if (isGetLock) {
                SimpleMutexHelper.releaseXMutex((String)"mat-import", (Object)lockId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> executeImport(Map<String, Object> collectParamMap, List<Long> mftOrderEntryIds, Long acctOrgId, List<Long> costCenterIds, List<Long> manuOrgIds, String appNum, String entityId, String progressId) {
        MatUseContext matUseContext;
        block11: {
            boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)acctOrgId);
            if (CadEmptyUtils.isEmpty(manuOrgIds) && isEnableMultiFactory) {
                manuOrgIds = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)acctOrgId, (String)entityId, (String)appNum);
            }
            if (CadEmptyUtils.isEmpty(costCenterIds)) {
                costCenterIds = isEnableMultiFactory ? new ArrayList(OrgHelper.getCenterIdsByManuOrgIds((Long)acctOrgId, (List)manuOrgIds, (String)appNum)) : OrgHelper.getCostCentersByOrg((long)acctOrgId);
            }
            List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)RequestContext.get().getCurrUserId(), Collections.singletonList(acctOrgId), (Set)Sets.newHashSet((Iterable)costCenterIds), (String)entityId, (String)appNum);
            MatUseArgs matUseArgs = new MatUseArgs();
            matUseArgs.setProgressId(progressId);
            matUseArgs.setAcctOrgId(acctOrgId);
            matUseArgs.setCostCenterIds(enableCostCenters);
            matUseArgs.setMftOrderEntryIds(mftOrderEntryIds);
            matUseArgs.setCollectParamMap(collectParamMap);
            matUseArgs.setManuOrgs(manuOrgIds);
            matUseArgs.setAppNum(appNum);
            matUseArgs.setEntityId(entityId);
            matUseContext = new MatUseContext();
            matUseContext.setMatUseArgs(matUseArgs);
            matUseContext.getCollectReport().logBaseInfo(acctOrgId, CollectObjectEnum.MAT_USE, appNum);
            long time = System.currentTimeMillis();
            Boolean startCollConfigScheme = ImportServiceHelper.isStartCollConfigScheme();
            List<IMatUseAction> iMatUseActions = IMatUseAction.initialize(appNum, startCollConfigScheme);
            try {
                for (IMatUseAction iMatUseAction : iMatUseActions) {
                    long actionTime = System.currentTimeMillis();
                    iMatUseAction.setContext(matUseContext);
                    iMatUseAction.execute();
                    logger.info("\u6750\u6599\u8017\u7528\u5f52\u96c6\u5f15\u5165-action\uff1a{},\u8017\u65f6\uff1a{}ms", (Object)iMatUseAction.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
                }
            }
            catch (Exception e) {
                logger.error("\u6750\u6599\u8017\u7528\u5f52\u96c6\u5f02\u5e38\u3002", (Throwable)e);
                if (!CollectReportHelper.disableCollectReport()) {
                    String message = e.getMessage();
                    if (matUseContext.isValidate()) {
                        matUseContext.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"MatUseServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]), message);
                        matUseContext.getCollectReport().logCheckDesc(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"MatUseServiceImpl_3", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        matUseContext.getCollectReport().setError(true);
                        matUseContext.getCollectReport().logStatusChange(CollectStatus.FAILURE, ResManager.loadKDString((String)"\u63d0\u793a", (String)"MatUseServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{matUseContext.getCollectReport().transfer2Dynamic()});
                    } else {
                        String errorMsg = ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf\u9519\u8bef", (String)"MatUseServiceImpl_0", (String)"macc-cad-mservice", (Object[])new Object[0]);
                        matUseContext.getCollectReport().logError((Throwable)e, errorMsg);
                    }
                    ProgressHelper.clearProgressParam((String)progressId);
                    break block11;
                }
                throw e;
            }
            finally {
                logger.info("\u6750\u6599\u8017\u7528\u5f52\u96c6\u5f15\u5165\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
            }
        }
        return new MatUseResultBuilder(matUseContext).buildResult();
    }

    private List<Long> getCostCenterByOrg(Long orgId) {
        QFilter orgFilter = new QFilter("accountorg", "=", (Object)orgId);
        QFilter orgdutyFilter = new QFilter("orgduty", "=", (Object)4L);
        ArrayList<Long> ids = new ArrayList<Long>(1);
        QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])new QFilter[]{orgFilter, orgdutyFilter}, null, (int)-1).forEach(p -> ids.add((Long)p));
        return ids;
    }
}

