/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.algox.constants.AllocResultEnum;
import kd.macc.cad.business.feealloc.MfgFeeAllocBase;
import kd.macc.cad.business.feealloc.MfgFeeAuxProdAllocService;
import kd.macc.cad.business.feealloc.MfgFeeBasicAllocService;
import kd.macc.cad.business.feealloc.MfgFeeInnerCostcenterAllocService;
import kd.macc.cad.business.feealloc.MfgFeeNonProdAllocService;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.output.MfgAllocResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.api.MfgAllocService;
import org.apache.commons.lang.StringUtils;

public class MfgAllocServiceImpl
extends MfgFeeAllocBase
implements MfgAllocService {
    protected static final Log logger = LogFactory.getLog(MfgAllocServiceImpl.class);
    private static final String TYPE_SUCCESS = "success";
    private static final String TYPE_TIP = "tip";
    private static final String TYPE_ERROR = "error";
    private static final String KEY_TYPE = "type";
    private static final String KEY_MSG = "msg";
    public static final String ErrorCons = "Error";
    public static final String SuccessCons = "Success";
    public static final String FalseCons = "False";

    public Map<String, String> doImportMfgAlloc(String importDto, String entityName) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        MfgFeeAllocImportParam importParam = MfgAllocServiceImpl.fromJSONString(importDto);
        if (!this.doMfgAlloc(importParam, entityName, true, resultMap)) {
            return resultMap;
        }
        if (entityName.equals("cad_auxprodalloc") && !this.doMfgAlloc(importParam, entityName, false, resultMap)) {
            return resultMap;
        }
        return resultMap;
    }

    private boolean doMfgAlloc(MfgFeeAllocImportParam importParam, String entity, boolean isDoImport, Map<String, String> resultMap) {
        Map<Object, Object> importResult = new HashMap(2);
        if (isDoImport) {
            try (TXHandle handle = TX.notSupported();){
                importResult = this.importMfgAllocData(importParam, entity);
            }
            logger.error("\u5f15\u5165\u7ed3\u679c\uff1a{}", importResult);
        }
        if (TYPE_ERROR.equals(importResult.get(KEY_TYPE)) || TYPE_TIP.equals(importResult.get(KEY_TYPE))) {
            resultMap.putAll(importResult);
            return false;
        }
        Map<Object, Object> allocResult = new HashMap(16);
        List<Long> billIds = this.getAllocBillIds(importParam, entity, "0");
        if (!billIds.isEmpty()) {
            allocResult = this.doMfgAlloc(importParam, billIds, entity);
            logger.error("\u5206\u914d\u7ed3\u679c\uff1a{}", allocResult);
        }
        if (TYPE_ERROR.equals(allocResult.get(KEY_TYPE))) {
            resultMap.putAll(allocResult);
            return false;
        }
        boolean isSuccess = true;
        String errorMsg = "";
        List<Long> confirmIds = this.getAllocBillIds(importParam, entity, "1");
        if (!CadEmptyUtils.isEmpty(confirmIds)) {
            try (TXHandle handle = TX.notSupported();){
                if ("cad_auxprodalloc".equals(entity)) {
                    MfgFeeAuxProdAllocService auxProdAllocService = new MfgFeeAuxProdAllocService();
                    List confirmResultMgs = auxProdAllocService.doSelectConfirm(confirmIds, importParam.getAppnum(), "cad_auxprodalloc");
                    if (confirmResultMgs != null && !confirmResultMgs.isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        confirmResultMgs.forEach(t -> sb.append((String)t).append("\r\n"));
                        errorMsg = this.getErrorMsg(entity, sb.toString(), 3);
                        isSuccess = false;
                    }
                } else {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ishasright", "true");
                    OperationResult confirmResult = OperationServiceHelper.executeOperate((String)"op_confirm", (String)entity, (Object[])confirmIds.toArray(), (OperateOption)option);
                    if (!confirmResult.isSuccess()) {
                        errorMsg = this.getErrorMsg(entity, confirmResult.getMessage(), 3);
                        isSuccess = false;
                    }
                }
            }
        }
        if (isSuccess) {
            this.setStatusMsg(TYPE_SUCCESS, "", resultMap);
        } else {
            this.setStatusMsg(TYPE_ERROR, errorMsg, resultMap);
        }
        logger.error("\u786e\u8ba4\u7ed3\u679c\uff1a{}", resultMap);
        return isSuccess;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> importMfgAllocData(MfgFeeAllocImportParam importParam, String entityName) {
        HashMap hashMap = new HashMap(2);
        try (TXHandle handle = TX.notSupported();){
            void var3_8;
            switch (entityName) {
                case "cad_nonprodalloc": {
                    Map<String, String> map = this.doNonProdAllocImport(importParam);
                    return var3_8;
                }
                case "cad_auxprodalloc": {
                    Map<String, String> map = this.doAuxProdAllocImport(importParam);
                    return var3_8;
                }
                case "cad_basicalloc": {
                    Map<String, String> map = this.doBasicAllocImport(importParam);
                    return var3_8;
                }
                case "cad_mfgfeeallocco": {
                    Map<String, String> map = this.doInnerAllocImport(importParam);
                    return var3_8;
                }
            }
            return var3_8;
        }
    }

    private Map<String, String> doInnerAllocImport(MfgFeeAllocImportParam importParam) {
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        MfgFeeInnerCostcenterAllocService innerAllocService = new MfgFeeInnerCostcenterAllocService();
        boolean isAuxNotAllConfirm = innerAllocService.isHasNotConfirmBill(importParam, "cad_auxprodalloc");
        if (isAuxNotAllConfirm) {
            this.setStatusMsg(TYPE_ERROR, ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u672a\u5168\u90e8\u786e\u8ba4\uff0c\u8bf7\u8fdb\u884c\u5904\u7406\u3002", (String)"MfgAllocServiceImpl_0", (String)"macc-cad-mservice", (Object[])new Object[0]), resultMap);
            return resultMap;
        }
        boolean billHasData = innerAllocService.isBillHasData(importParam, "cad_mfgfeeallocco");
        if (billHasData && !"eca".equals(importParam.getAppnum()) && importParam.isMergeBill()) {
            if (innerAllocService.isBillGenVounums(importParam, "cad_mfgfeeallocco")) {
                this.setStatusMsg(TYPE_ERROR, ResManager.loadKDString((String)"\u5206\u914d\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u5bfc\u5165\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u518d\u64cd\u4f5c\u3002", (String)"MfgAllocServiceImpl_1", (String)"macc-cad-mservice", (Object[])new Object[0]), resultMap);
                return resultMap;
            }
            if (innerAllocService.isBillHasData(importParam, "cad_mfgfeeallocco", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) {
                this.setStatusMsg(TYPE_ERROR, ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff0c\u5f53\u524d\u5206\u914d\u5355\u9700\u8981\u5168\u90e8\u53cd\u786e\u8ba4\uff0c\u624d\u80fd\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"MfgAllocServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]), resultMap);
                return resultMap;
            }
        }
        if (billHasData) {
            innerAllocService.deleteInnerCostcenterBills(importParam);
        }
        ExecuteResult result = innerAllocService.feeAllocInnerCostcenterImport(importParam, null);
        return this.getResultMap(result, resultMap, false);
    }

    private Map<String, String> getResultMap(ExecuteResult result, Map<String, String> resultMap, boolean isNeedIn) {
        String successMsg = ResManager.loadKDString((String)"\u6210\u529f\u751f\u6210%s\u5f20\u5355\u636e\u3002", (String)"MfgAllocServiceImpl_3", (String)"macc-cad-mservice", (Object[])new Object[0]);
        if (isNeedIn) {
            successMsg = ResManager.loadKDString((String)"\u6210\u529f\u751f\u6210%s\u5f20\u5355\u636e\uff0c\u4e0b\u6e38\u5206\u914d\u5355\u9700\u8981\u91cd\u65b0\u5f15\u5165\u3002", (String)"MfgAllocServiceImpl_7", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        String infoTip = ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"MfgAllocServiceImpl_18", (String)"macc-cad-mservice", (Object[])new Object[0]);
        if (result.isSuccess()) {
            if (result.getSuccessQty() > 0) {
                this.setStatusMsg(TYPE_SUCCESS, String.format(successMsg, result.getSuccessQty()), resultMap);
            } else {
                this.setStatusMsg(TYPE_TIP, infoTip, resultMap);
            }
        } else if (result.getFalseInfo().containsKey(ErrorCons)) {
            this.setStatusMsg(TYPE_ERROR, (String)result.getFalseInfo().get(ErrorCons), resultMap);
        } else if (result.getFalseInfo().containsKey(FalseCons)) {
            this.setStatusMsg(TYPE_TIP, (String)result.getFalseInfo().get(FalseCons), resultMap);
        } else {
            this.setStatusMsg(TYPE_TIP, infoTip, resultMap);
        }
        return resultMap;
    }

    private Map<String, String> doBasicAllocImport(MfgFeeAllocImportParam importParam) {
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        MfgFeeBasicAllocService basicAllocService = new MfgFeeBasicAllocService();
        if (basicAllocService.getAuxProdBillIsAllConfirm(importParam)) {
            this.setStatusMsg(TYPE_ERROR, ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u672a\u5168\u90e8\u786e\u8ba4\uff0c\u8bf7\u8fdb\u884c\u5904\u7406\u3002", (String)"MfgAllocServiceImpl_5", (String)"macc-cad-mservice", (Object[])new Object[0]), resultMap);
            return resultMap;
        }
        HashSet errorInfo = new HashSet(10);
        String error = basicAllocService.validateAllocStand(importParam, errorInfo);
        if (StringUtils.isNotBlank((String)error)) {
            this.setStatusMsg(TYPE_ERROR, error, resultMap);
            return resultMap;
        }
        if (basicAllocService.isBillHasData(importParam, "cad_basicalloc")) {
            if (basicAllocService.isBillGenVounums(importParam, "cad_basicalloc")) {
                this.setStatusMsg(TYPE_ERROR, ResManager.loadKDString((String)"\u5206\u914d\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u5bfc\u5165\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u518d\u64cd\u4f5c\u3002", (String)"MfgAllocServiceImpl_1", (String)"macc-cad-mservice", (Object[])new Object[0]), resultMap);
                return resultMap;
            }
            if (basicAllocService.isBillGenVounums(importParam, "cad_mfgfeeallocco")) {
                this.setStatusMsg(TYPE_ERROR, ResManager.loadKDString((String)"\u4e0b\u6e38\u7684\u5206\u914d\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u5bfc\u5165\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u518d\u64cd\u4f5c\u3002", (String)"MfgAllocServiceImpl_6", (String)"macc-cad-mservice", (Object[])new Object[0]), resultMap);
                return resultMap;
            }
            if (basicAllocService.isBillHasData(importParam, "cad_basicalloc", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) {
                this.setStatusMsg(TYPE_ERROR, ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff0c\u5f53\u524d\u5206\u914d\u5355\u9700\u8981\u5168\u90e8\u53cd\u786e\u8ba4\uff0c\u624d\u80fd\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"MfgAllocServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]), resultMap);
                return resultMap;
            }
            basicAllocService.delRelateBills(importParam, Boolean.valueOf(false));
        }
        ExecuteResult result = basicAllocService.pooBillAndNonProdAndAuxImport(importParam, null);
        return this.getResultMap(result, resultMap, true);
    }

    private Map<String, String> doAuxProdAllocImport(MfgFeeAllocImportParam importParam) {
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        MfgFeeAuxProdAllocService auxProdAllocService = new MfgFeeAuxProdAllocService();
        if (auxProdAllocService.isBillHasData(importParam, "cad_auxprodalloc")) {
            if (auxProdAllocService.isBillGenVounums(importParam, "cad_auxprodalloc")) {
                this.setStatusMsg(TYPE_ERROR, ResManager.loadKDString((String)"\u5206\u914d\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u5bfc\u5165\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u518d\u64cd\u4f5c\u3002", (String)"MfgAllocServiceImpl_1", (String)"macc-cad-mservice", (Object[])new Object[0]), resultMap);
                return resultMap;
            }
            if (auxProdAllocService.isBillGenVounums(importParam, "cad_basicalloc") || auxProdAllocService.isBillGenVounums(importParam, "cad_mfgfeeallocco")) {
                this.setStatusMsg(TYPE_ERROR, ResManager.loadKDString((String)"\u4e0b\u6e38\u7684\u5206\u914d\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u5bfc\u5165\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u518d\u64cd\u4f5c\u3002", (String)"MfgAllocServiceImpl_6", (String)"macc-cad-mservice", (Object[])new Object[0]), resultMap);
                return resultMap;
            }
            if (auxProdAllocService.isBillHasData(importParam, "cad_auxprodalloc", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) {
                this.setStatusMsg(TYPE_ERROR, ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff0c\u5f53\u524d\u5206\u914d\u5355\u9700\u8981\u5168\u90e8\u53cd\u786e\u8ba4\uff0c\u624d\u80fd\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"MfgAllocServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]), resultMap);
                return resultMap;
            }
            auxProdAllocService.deleteAuxProdAndRelaBills(importParam, true);
        }
        ExecuteResult result = auxProdAllocService.feeAllocAuxProdImport(importParam, null);
        return this.getResultMap(result, resultMap, true);
    }

    private Map<String, String> doNonProdAllocImport(MfgFeeAllocImportParam importParam) {
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        MfgFeeNonProdAllocService nonProdAllocService = new MfgFeeNonProdAllocService();
        if (this.isBillHasData(importParam, "cad_nonprodalloc")) {
            if (this.isBillGenVounums(importParam, "cad_nonprodalloc")) {
                this.setStatusMsg(TYPE_ERROR, ResManager.loadKDString((String)"\u5206\u914d\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u5bfc\u5165\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u518d\u64cd\u4f5c\u3002", (String)"MfgAllocServiceImpl_1", (String)"macc-cad-mservice", (Object[])new Object[0]), resultMap);
                return resultMap;
            }
            if (this.isBillGenVounums(importParam, "cad_auxprodalloc") || this.isBillGenVounums(importParam, "cad_basicalloc") || this.isBillGenVounums(importParam, "cad_mfgfeeallocco")) {
                this.setStatusMsg(TYPE_ERROR, ResManager.loadKDString((String)"\u4e0b\u6e38\u7684\u5206\u914d\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u5bfc\u5165\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u518d\u64cd\u4f5c\u3002", (String)"MfgAllocServiceImpl_6", (String)"macc-cad-mservice", (Object[])new Object[0]), resultMap);
                return resultMap;
            }
            if (this.isBillHasData(importParam, "cad_nonprodalloc", ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue())) {
                this.setStatusMsg(TYPE_ERROR, ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff0c\u5f53\u524d\u5206\u914d\u5355\u9700\u8981\u5168\u90e8\u53cd\u786e\u8ba4\uff0c\u624d\u80fd\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"MfgAllocServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]), resultMap);
                return resultMap;
            }
            nonProdAllocService.deleteNonProdAndRelaBills(importParam, true);
        }
        ExecuteResult result = nonProdAllocService.feeAllocNonProdImport(importParam, null);
        return this.getResultMap(result, resultMap, true);
    }

    private Map<String, String> doMfgAlloc(MfgFeeAllocImportParam importParam, List<Long> billIds, String entityName) {
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        try {
            MfgAllocResult allocResult = new MfgAllocResult();
            switch (entityName) {
                case "cad_nonprodalloc": {
                    MfgFeeNonProdAllocService nonProdAllocService = new MfgFeeNonProdAllocService();
                    allocResult = nonProdAllocService.doAlloc(billIds, importParam.getAppnum(), null, false, Long.valueOf(0L));
                    break;
                }
                case "cad_auxprodalloc": {
                    MfgFeeAuxProdAllocService auxProdAllocService = new MfgFeeAuxProdAllocService();
                    allocResult = auxProdAllocService.doSelectAlloc(billIds, importParam.getAppnum(), null, false);
                    break;
                }
                case "cad_basicalloc": {
                    MfgFeeBasicAllocService basicAllocService = new MfgFeeBasicAllocService();
                    allocResult = basicAllocService.doAlloc(billIds, importParam.getAppnum(), null, false, Long.valueOf(0L));
                    break;
                }
                case "cad_mfgfeeallocco": {
                    MfgFeeInnerCostcenterAllocService innerAllocService = new MfgFeeInnerCostcenterAllocService();
                    allocResult = innerAllocService.doAlloc(billIds, importParam.getAppnum(), null);
                    break;
                }
            }
            if (allocResult.getVerifyMsgs() != null && !allocResult.getVerifyMsgs().isEmpty()) {
                String errorTip;
                if (allocResult.getVerifyMsgs().size() == 1 && ((String)allocResult.getVerifyMsgs().get(0)).length() <= 50) {
                    errorTip = (String)allocResult.getVerifyMsgs().get(0);
                } else {
                    StringBuilder sb = new StringBuilder();
                    allocResult.getVerifyMsgs().forEach(t -> sb.append((String)t).append("\r\n"));
                    errorTip = sb.toString();
                }
                resultMap.put(KEY_TYPE, TYPE_ERROR);
                resultMap.put(KEY_MSG, errorTip);
                return resultMap;
            }
            if (AllocResultEnum.ALLSUCCESS.getResult().equals(allocResult.getAllocStatus())) {
                this.setStatusMsg(TYPE_SUCCESS, ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f", (String)"MfgAllocServiceImpl_8", (String)"macc-cad-mservice", (Object[])new Object[0]), resultMap);
            } else if (AllocResultEnum.PartSUCCESS.getResult().equals(allocResult.getAllocStatus())) {
                this.setStatusMsg(TYPE_ERROR, ResManager.loadKDString((String)"\u5206\u914d\u5b8c\u6bd5\uff0c\u6709\u90e8\u5206\u5355\u636e\u5206\u914d\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u70b9\u51fb\u5206\u914d\u62a5\u544a\u67e5\u8be2\u3002", (String)"MfgAllocServiceImpl_9", (String)"macc-cad-mservice", (Object[])new Object[0]), resultMap);
            } else if (AllocResultEnum.Failure.getResult().equals(allocResult.getAllocStatus())) {
                this.setStatusMsg(TYPE_ERROR, ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u70b9\u51fb\u5206\u914d\u62a5\u544a\u67e5\u8be2\u3002", (String)"MfgAllocServiceImpl_10", (String)"macc-cad-mservice", (Object[])new Object[0]), resultMap);
            }
        }
        catch (Exception ex) {
            this.setStatusMsg(TYPE_ERROR, ex.getMessage(), resultMap);
        }
        return resultMap;
    }

    private void setStatusMsg(String type, String msg, Map<String, String> resultMap) {
        resultMap.put(KEY_TYPE, type);
        resultMap.put(KEY_MSG, msg);
    }

    private String getErrorMsg(String entity, String message, int type) {
        String entityName = "";
        switch (entity) {
            case "cad_nonprodalloc": {
                entityName = ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5355", (String)"MfgAllocServiceImpl_11", (String)"macc-cad-mservice", (Object[])new Object[0]);
                break;
            }
            case "cad_auxprodalloc": {
                entityName = ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355", (String)"MfgAllocServiceImpl_12", (String)"macc-cad-mservice", (Object[])new Object[0]);
                break;
            }
            case "cad_basicalloc": {
                entityName = ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355", (String)"MfgAllocServiceImpl_13", (String)"macc-cad-mservice", (Object[])new Object[0]);
                break;
            }
            case "cad_mfgfeeallocco": {
                entityName = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355", (String)"MfgAllocServiceImpl_14", (String)"macc-cad-mservice", (Object[])new Object[0]);
                break;
            }
        }
        String errorMsg = type == 1 ? String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5bfc\u5165\u5931\u8d25\uff1a%2$s\u3002", (String)"MfgAllocServiceImpl_15", (String)"macc-cad-mservice", (Object[])new Object[0]), entityName, message) : (type == 2 ? String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5206\u914d\u5931\u8d25\uff1a%2$s\u3002", (String)"MfgAllocServiceImpl_16", (String)"macc-cad-mservice", (Object[])new Object[0]), entityName, message) : String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u786e\u8ba4\u5931\u8d25\uff1a%2$s\u3002", (String)"MfgAllocServiceImpl_17", (String)"macc-cad-mservice", (Object[])new Object[0]), entityName, message));
        return errorMsg;
    }

    private List<Long> getAllocBillIds(MfgFeeAllocImportParam importParam, String entityName, String status) {
        ArrayList<Long> ids = new ArrayList<Long>();
        QFilter filter = new QFilter("org", "=", (Object)importParam.getOrg());
        filter.and("costaccount", "=", (Object)importParam.getCostaccount());
        filter.and("period", "=", (Object)importParam.getPeriod());
        filter.and("allocstatus", "=", (Object)status);
        filter.and("planscheme", "=", (Object)importParam.getPlanscheme());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.business.feealloc.MfgFeeNonProdAllocService.getUnAllocBillIds", (String)entityName, (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong(0));
            }
        }
        return ids;
    }

    private static MfgFeeAllocImportParam fromJSONString(String importDto) {
        return (MfgFeeAllocImportParam)JSON.parseObject((String)importDto, MfgFeeAllocImportParam.class);
    }
}

