/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.dto.MfgFeeImportReport;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.api.MfgfeeService;
import kd.macc.cad.mservice.mfgfee.IMfgFeeAction;
import kd.macc.cad.mservice.mfgfee.MfgFeeArgs;
import kd.macc.cad.mservice.mfgfee.MfgFeeContext;
import kd.macc.cad.mservice.mfgfee.MfgFeeResultBuilder;

public class MfgFeeServiceImpl
implements MfgfeeService {
    private static final Log logger = LogFactory.getLog(MfgFeeServiceImpl.class);

    public Map<String, Object> inSysImport(Long acctOrgId, Long[] costCenterIds, OperateOption option) {
        return null;
    }

    public Map<String, String> importMfgBills(Long acctOrg, Set<Long> costAccountSet, List<Long> costCenters, String targetEntity, Map<String, Object> paramMap) {
        MfgFeeArgs mfgFeeArgs = new MfgFeeArgs();
        mfgFeeArgs.setAccountOrgId(acctOrg);
        mfgFeeArgs.setCostAccountIds(costAccountSet);
        mfgFeeArgs.setCostCenterIds(costCenters);
        String appNum = String.valueOf(paramMap.get("appnum"));
        mfgFeeArgs.setAppNum(appNum);
        Map<Long, Long> costAccountPeriodMap = mfgFeeArgs.getCostAccountPeriodMap();
        Map<Long, Long> costAccountCurrencyMap = mfgFeeArgs.getCostAccountCurrencyMap();
        costAccountSet.forEach(costAccountId -> {
            if (paramMap.get(String.valueOf(costAccountId)) != null) {
                costAccountPeriodMap.put((Long)costAccountId, Long.parseLong(String.valueOf(paramMap.get(String.valueOf(costAccountId)))));
            }
            if (paramMap.get("currency" + costAccountId) != null) {
                costAccountCurrencyMap.put((Long)costAccountId, Long.parseLong(String.valueOf(paramMap.get("currency" + costAccountId))));
            }
        });
        ArrayList<Long> manuOrgs = new ArrayList<Long>();
        if (paramMap.get("manuorg") != null) {
            List userHasPermProOrg;
            long manuOrg = Long.parseLong(String.valueOf(paramMap.get("manuorg")));
            if (manuOrg == 0L && !CadEmptyUtils.isEmpty((List)(userHasPermProOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)acctOrg, (String)targetEntity, (String)appNum)))) {
                manuOrgs.addAll(userHasPermProOrg);
            }
            manuOrgs.add(manuOrg);
        }
        mfgFeeArgs.setManuOrgs(manuOrgs);
        MfgFeeContext mfgFeeContext = new MfgFeeContext();
        mfgFeeContext.setMfgFeeArgs(mfgFeeArgs);
        mfgFeeContext.setTargetEntity(targetEntity);
        if (paramMap.get("collectReport") != null) {
            mfgFeeContext.setReport((MfgFeeImportReport)paramMap.get("collectReport"));
        }
        long time = System.currentTimeMillis();
        List<IMfgFeeAction> iMfgFeeAction = IMfgFeeAction.initialize(appNum);
        try {
            for (IMfgFeeAction mfgFeeAction : iMfgFeeAction) {
                long actionTime = System.currentTimeMillis();
                mfgFeeAction.setContext(mfgFeeContext);
                mfgFeeAction.execute();
                logger.info("\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5f15\u5165-action\uff1a{},\u8017\u65f6\uff1a{}ms", (Object)mfgFeeAction.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
            }
        }
        catch (Exception e) {
            logger.error("\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5f15\u5165\u5f02\u5e38\u3002", (Throwable)e);
            throw e;
        }
        finally {
            logger.info("\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5f15\u5165\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        }
        MfgFeeResultBuilder mfgFeeResultBuilder = new MfgFeeResultBuilder(mfgFeeContext);
        return mfgFeeResultBuilder.buildResult();
    }
}

