/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.calc.PlanCostCalcHelper;
import kd.macc.cad.common.utils.TimeUtils;
import kd.macc.cad.mservice.api.PlanCostService;

public class PlanCostServiceImpl
implements PlanCostService {
    private static final Integer BATCH_SIZE = 100;
    private static final Log logger = LogFactory.getLog(PlanCostServiceImpl.class);

    public Map<String, Object> autoCalc(Set<Long> orgs) {
        LocalDateTime dateTime = LocalDateTime.of(LocalDate.now().minusDays(1L), LocalTime.MIN);
        Date startTime = Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
        QFilter filter = new QFilter("syncdate", ">=", (Object)startTime);
        filter.and("syncdate", "<=", (Object)TimeUtils.getDayEndTime((Date)new Date()));
        filter.and("status", "not in", (Object)Sets.newHashSet((Object[])new String[]{"01", "02"}));
        filter.and("trytimes", "<", (Object)5);
        if (!orgs.isEmpty()) {
            filter.and("org", "in", orgs);
        }
        return this.executeCalc(filter);
    }

    public Map<String, Object> selCalc(Set<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        return this.executeCalc(filter);
    }

    private Map<String, Object> executeCalc(QFilter filter) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"sca_plancostcalclog", (String)"id,org,billtype,accountcosttype.id as accountcosttype,plancosttype.id as plancosttype,orderentryid,releasedate", (QFilter[])new QFilter[]{filter});
            logger.info("\u8ba1\u5212\u6210\u672c\u8ba1\u7b97\u91cd\u65b0\u6267\u884c,\u5f53\u524d\u6267\u884c\u65f6\u95f4==>{},\u83b7\u53d6\u6b64\u6b21\u67e5\u8be2\u8303\u56f4 ==>{},\u672c\u6b21\u67e5\u8be2\u6761\u6570==>{}", new Object[]{new Date(), filter, dynamicObjects.size()});
            if (!dynamicObjects.isEmpty()) {
                HashMap<String, List> map = new HashMap<String, List>(20);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    String key = dynamicObject.getString("billtype");
                    map.computeIfAbsent(key, r -> new ArrayList()).add(dynamicObject);
                }
                for (Map.Entry entry : map.entrySet()) {
                    String entityNum = (String)entry.getKey();
                    List partition = Lists.partition((List)((List)entry.getValue()), (int)BATCH_SIZE);
                    for (List list : partition) {
                        PlanCostCalcHelper.planCostCalc((String)entityNum, (List)list, (Boolean)false);
                    }
                }
            }
            result.put("status", true);
            result.put("count", dynamicObjects.size());
        }
        catch (Exception e) {
            logger.error("\u8ba1\u5212\u6210\u672c\u8ba1\u7b97\u91cd\u65b0\u6267\u884c\u5931\u8d25\uff1a", (Throwable)e);
            result.put("status", false);
            result.put("count", 0);
        }
        return result;
    }
}

