/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.enums.CollectStatus;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.mservice.api.PlanResourceService;
import kd.macc.cad.mservice.planresource.IPlanResourceAction;
import kd.macc.cad.mservice.planresource.PlanResourceArgs;
import kd.macc.cad.mservice.planresource.PlanResourceContext;
import kd.macc.cad.mservice.planresource.PlanResourceResultBuilder;
import org.apache.commons.lang3.StringUtils;

public class PlanResourceServiceImpl
implements PlanResourceService {
    private static final Log logger = LogFactory.getLog(PlanResourceServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> importPlanResource(Long acctOrgId, Long costAccountId, Long planSchemeId, List<Long> costCenterIds, List<Long> manuOrgIds, String appNum, String progressId) {
        boolean isGetLock = true;
        String lockId = acctOrgId == null ? "0" : acctOrgId.toString();
        try {
            String lockErr = SimpleMutexHelper.checkAndRequireXMutex((String)"plan-resource-import", (Object)lockId);
            if (StringUtils.isNotEmpty((CharSequence)lockErr)) {
                isGetLock = false;
                HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
                MsgUtils.putMsg2Map((String)"error", (String)lockErr, errorMsgMap);
                ProgressHelper.clearProgressParam((String)progressId);
                HashMap<String, String> hashMap = errorMsgMap;
                return hashMap;
            }
            Map<String, String> errorMsgMap = this.executeImport(acctOrgId, costAccountId, planSchemeId, costCenterIds, manuOrgIds, appNum, progressId);
            return errorMsgMap;
        }
        catch (Exception ex) {
            logger.error("\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5f02\u5e38\u3002", (Throwable)ex);
            HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5b58\u5728\u5f02\u5e38:%s", (String)"PlanResourceServiceImpl_4", (String)"macc-cad-mservice", (Object[])new Object[0]), ex.getMessage());
            MsgUtils.putMsg2Map((String)"tip", (String)errorMsg, errorMsgMap);
            ProgressHelper.clearProgressParam((String)progressId);
            HashMap<String, String> hashMap = errorMsgMap;
            return hashMap;
        }
        finally {
            if (isGetLock) {
                SimpleMutexHelper.releaseXMutex((String)"plan-resource-import", (Object)lockId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> executeImport(Long acctOrgId, Long costAccountId, Long planSchemeId, List<Long> costCenterIds, List<Long> manuOrgIds, String appNum, String progressId) {
        PlanResourceContext planResourceContext;
        block11: {
            boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)acctOrgId);
            if (CadEmptyUtils.isEmpty(manuOrgIds) && isEnableMultiFactory) {
                manuOrgIds = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)acctOrgId, (String)"cad_planresource", (String)appNum);
            }
            if (CadEmptyUtils.isEmpty(costCenterIds)) {
                costCenterIds = isEnableMultiFactory ? new ArrayList(OrgHelper.getCenterIdsByManuOrgIds((Long)acctOrgId, (List)manuOrgIds, (String)appNum)) : OrgHelper.getCostCentersByOrg((long)acctOrgId);
            }
            List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)Long.parseLong(RequestContext.get().getUserId()), Collections.singletonList(acctOrgId), (Set)Sets.newHashSet((Iterable)costCenterIds), (String)"cad_planresource", (String)appNum);
            PlanResourceArgs resourceUseArgs = new PlanResourceArgs();
            resourceUseArgs.setProgressId(progressId);
            resourceUseArgs.setAcctOrgId(acctOrgId);
            resourceUseArgs.setCostAccountId(costAccountId);
            resourceUseArgs.setAppNum(appNum);
            resourceUseArgs.setCostCenterIds(enableCostCenters);
            resourceUseArgs.setManuOrgs(manuOrgIds);
            resourceUseArgs.setPlanSchemeId(planSchemeId);
            DynamicObject planScheme = BusinessDataServiceHelper.loadSingle((Object)planSchemeId, (String)"cad_planscheme");
            resourceUseArgs.setPlanSchemeNumber(planScheme.getString("number"));
            planResourceContext = new PlanResourceContext();
            planResourceContext.setPlanResourceArgs(resourceUseArgs);
            planResourceContext.getCollectReport().logBaseInfo(acctOrgId, CollectObjectEnum.PLAN_RESOURCE, appNum);
            long time = System.currentTimeMillis();
            Boolean startCollConfigScheme = ImportServiceHelper.isStartCollConfigScheme();
            List<IPlanResourceAction> planResourceActions = IPlanResourceAction.initialize(appNum, startCollConfigScheme);
            try {
                for (IPlanResourceAction planResourceAction : planResourceActions) {
                    long actionTime = System.currentTimeMillis();
                    planResourceAction.setContext(planResourceContext);
                    planResourceAction.execute();
                    logger.info("\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5f15\u5165-action{},\u8017\u65f6\uff1a{}ms", (Object)planResourceAction.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
                }
            }
            catch (Exception e) {
                logger.error("\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
                if (!CollectReportHelper.disableCollectReport()) {
                    String message = e.getMessage();
                    if (planResourceContext.isValidate()) {
                        planResourceContext.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"PlanResourceServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]), message);
                        planResourceContext.getCollectReport().logCheckDesc(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef", (String)"PlanResourceServiceImpl_3", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        planResourceContext.getCollectReport().setError(true);
                        planResourceContext.getCollectReport().logStatusChange(CollectStatus.FAILURE, ResManager.loadKDString((String)"\u63d0\u793a", (String)"PlanResourceServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{planResourceContext.getCollectReport().transfer2Dynamic()});
                    } else {
                        String errorMsg = ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf\u9519\u8bef", (String)"PlanResourceServiceImpl_0", (String)"macc-cad-mservice", (Object[])new Object[0]);
                        planResourceContext.getCollectReport().logError((Throwable)e, errorMsg);
                    }
                    ProgressHelper.clearProgressParam((String)progressId);
                    break block11;
                }
                throw e;
            }
            finally {
                logger.info("\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5f15\u5165\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
            }
        }
        return new PlanResourceResultBuilder(planResourceContext).buildResult();
    }
}

