/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.enums.CollectStatus;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.mservice.api.PlannedOutputService;
import kd.macc.cad.mservice.plannedoutput.IPlannedAction;
import kd.macc.cad.mservice.plannedoutput.PlannedArgs;
import kd.macc.cad.mservice.plannedoutput.PlannedContext;
import kd.macc.cad.mservice.plannedoutput.PlannedResultBuilder;
import org.apache.commons.lang3.StringUtils;

public class PlannedOutputServiceImpl
implements PlannedOutputService {
    private static final Log logger = LogFactory.getLog(PlannedOutputServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> importPlannedOut(Map<String, Object> collectParamMap, Long acctOrg, List<Long> costCenters, List<Long> mftorderentryids, List<Long> manuOrgIds, String appNum, String progressId) {
        boolean isGetLock = true;
        String lockId = acctOrg == null ? "0" : acctOrg.toString();
        try {
            String lockErr = SimpleMutexHelper.checkAndRequireXMutex((String)"plan-import", (Object)lockId);
            if (StringUtils.isNotEmpty((CharSequence)lockErr)) {
                HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
                MsgUtils.putMsg2Map((String)"mutex", (String)lockErr, errorMsgMap);
                isGetLock = false;
                ProgressHelper.showError((String)progressId, (String)lockErr);
                HashMap<String, String> hashMap = errorMsgMap;
                return hashMap;
            }
            Map<String, String> errorMsgMap = this.executeImport(collectParamMap, acctOrg, costCenters, mftorderentryids, manuOrgIds, appNum, progressId);
            return errorMsgMap;
        }
        catch (Exception ex) {
            logger.error("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5f02\u5e38\u3002", (Throwable)ex);
            HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5b58\u5728\u5f02\u5e38:%s\u3002", (String)"PlannedOutputServiceImpl_4", (String)"macc-cad-mservice", (Object[])new Object[0]), ex.getMessage());
            MsgUtils.putMsg2Map((String)"tip", (String)errorMsg, errorMsgMap);
            ProgressHelper.clearProgressParam((String)progressId);
            HashMap<String, String> hashMap = errorMsgMap;
            return hashMap;
        }
        finally {
            if (isGetLock) {
                SimpleMutexHelper.releaseXMutex((String)"plan-import", (Object)lockId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> executeImport(Map<String, Object> collectParamMap, Long acctOrg, List<Long> costCenters, List<Long> mftorderentryids, List<Long> manuOrgIds, String appNum, String progressId) {
        PlannedContext plannedContext;
        block11: {
            boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)acctOrg);
            if (CadEmptyUtils.isEmpty(manuOrgIds) && isEnableMultiFactory) {
                manuOrgIds = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)acctOrg, (String)"cad_plannedoutputbill", (String)appNum);
            }
            if (CadEmptyUtils.isEmpty(costCenters)) {
                costCenters = isEnableMultiFactory ? new ArrayList(OrgHelper.getCenterIdsByManuOrgIds((Long)acctOrg, (List)manuOrgIds, (String)appNum)) : OrgHelper.getCostCentersByOrg((long)acctOrg);
            }
            List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)Long.parseLong(RequestContext.get().getUserId()), Collections.singletonList(acctOrg), (Set)Sets.newHashSet((Iterable)costCenters), (String)"cad_plannedoutputbill", (String)appNum);
            PlannedArgs plannedArgs = new PlannedArgs();
            plannedArgs.setProgressId(progressId);
            plannedArgs.setAccountOrgId(acctOrg);
            plannedArgs.setCostCenterIds(enableCostCenters);
            plannedArgs.setMftOrderEntryIds(mftorderentryids);
            plannedArgs.setCollectParamMap(collectParamMap);
            plannedArgs.setManuOrgs(manuOrgIds);
            plannedArgs.setAppNum(appNum);
            plannedContext = new PlannedContext();
            plannedContext.setPlannedArgs(plannedArgs);
            plannedContext.getCollectReport().logBaseInfo(acctOrg, CollectObjectEnum.PLAN_OUT, appNum);
            List importScopeDate = SysParamHelper.getImportScopeDate((Long)acctOrg, (String)appNum);
            CostCenterHelper.getWorkCenter(costCenters, (List)importScopeDate, (CollectReport)plannedContext.getCollectReport());
            CostCenterHelper.getAdminOrg(costCenters, (List)importScopeDate, (CollectReport)plannedContext.getCollectReport());
            CostCenterHelper.getBosOrgs(costCenters, (List)importScopeDate, (CollectReport)plannedContext.getCollectReport());
            long time = System.currentTimeMillis();
            Boolean startCollConfigScheme = ImportServiceHelper.isStartCollConfigScheme();
            List<IPlannedAction> plannedActions = IPlannedAction.initialize(appNum, startCollConfigScheme);
            try {
                for (IPlannedAction plannedAction : plannedActions) {
                    long actionTime = System.currentTimeMillis();
                    plannedAction.setContext(plannedContext);
                    plannedAction.execute();
                    logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6-action\uff1a{},\u8017\u65f6\uff1a{}ms", (Object)plannedAction.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
                }
            }
            catch (Exception e) {
                logger.error("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5f02\u5e38\u3002", (Throwable)e);
                if (!CollectReportHelper.disableCollectReport()) {
                    String message = e.getMessage();
                    if (plannedContext.isValidate()) {
                        plannedContext.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"PlannedOutputServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]), message);
                        plannedContext.getCollectReport().logCheckDesc(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"PlannedOutputServiceImpl_3", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        plannedContext.getCollectReport().setError(true);
                        plannedContext.getCollectReport().logStatusChange(CollectStatus.FAILURE, ResManager.loadKDString((String)"\u63d0\u793a", (String)"PlannedOutputServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plannedContext.getCollectReport().transfer2Dynamic()});
                    } else {
                        String errorMsg = ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf\u9519\u8bef", (String)"PlannedOutputServiceImpl_0", (String)"macc-cad-mservice", (Object[])new Object[0]);
                        plannedContext.getCollectReport().logError((Throwable)e, errorMsg);
                    }
                    ProgressHelper.clearProgressParam((String)progressId);
                    break block11;
                }
                throw e;
            }
            finally {
                logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
            }
        }
        PlannedResultBuilder plannedResultBuilder = new PlannedResultBuilder(plannedContext);
        return plannedResultBuilder.buildResult();
    }
}

