/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.enums.CollectStatus;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.mservice.api.ResourceUseService;
import kd.macc.cad.mservice.resourceuse.IResourceUseAction;
import kd.macc.cad.mservice.resourceuse.ResourceResultBuilder;
import kd.macc.cad.mservice.resourceuse.ResourceUseArgs;
import kd.macc.cad.mservice.resourceuse.ResourceUseContext;
import org.apache.commons.lang3.StringUtils;

public class ResourceUseServiceImpl
implements ResourceUseService {
    private static final Log logger = LogFactory.getLog(ResourceUseServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> importResourceUse(Map<String, Object> collectParamMap, List<Long> mftOrderEntryIds, Long acctOrgId, List<Long> costCenterIds, List<Long> manuOrgIds, String appNum, String progressId) {
        boolean isGetLock = true;
        String lockId = acctOrgId == null ? "0" : acctOrgId.toString();
        try {
            String lockErr = SimpleMutexHelper.checkAndRequireXMutex((String)"resource-import", (Object)lockId);
            if (StringUtils.isNotEmpty((CharSequence)lockErr)) {
                isGetLock = false;
                HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
                MsgUtils.putMsg2Map((String)"error", (String)lockErr, errorMsgMap);
                ProgressHelper.clearProgressParam((String)progressId);
                HashMap<String, String> hashMap = errorMsgMap;
                return hashMap;
            }
            Map<String, String> errorMsgMap = this.executeImport(collectParamMap, mftOrderEntryIds, acctOrgId, costCenterIds, manuOrgIds, appNum, progressId);
            return errorMsgMap;
        }
        catch (Exception ex) {
            logger.error("\u6750\u6599\u8017\u7528\u5f52\u96c6\u5f02\u5e38\u3002", (Throwable)ex);
            HashMap<String, String> errorMsgMap = new HashMap<String, String>(3);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5b58\u5728\u5f02\u5e38:%s\u3002", (String)"ResourceUseServiceImpl_4", (String)"macc-cad-mservice", (Object[])new Object[0]), ex.getMessage());
            MsgUtils.putMsg2Map((String)"tip", (String)errorMsg, errorMsgMap);
            ProgressHelper.clearProgressParam((String)progressId);
            HashMap<String, String> hashMap = errorMsgMap;
            return hashMap;
        }
        finally {
            if (isGetLock) {
                SimpleMutexHelper.releaseXMutex((String)"resource-import", (Object)lockId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> executeImport(Map<String, Object> collectParamMap, List<Long> mftOrderEntryIds, Long acctOrgId, List<Long> costCenterIds, List<Long> manuOrgIds, String appNum, String progressId) {
        ResourceUseContext resourceUseContext;
        block11: {
            boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)acctOrgId);
            if (CadEmptyUtils.isEmpty(manuOrgIds) && isEnableMultiFactory) {
                manuOrgIds = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)acctOrgId, (String)"sca_resourceuse", (String)appNum);
            }
            if (CadEmptyUtils.isEmpty(costCenterIds)) {
                costCenterIds = isEnableMultiFactory ? new ArrayList(OrgHelper.getCenterIdsByManuOrgIds((Long)acctOrgId, (List)manuOrgIds, (String)appNum)) : OrgHelper.getCostCentersByOrg((long)acctOrgId);
            }
            List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)Long.parseLong(RequestContext.get().getUserId()), Collections.singletonList(acctOrgId), (Set)Sets.newHashSet((Iterable)costCenterIds), (String)"sca_resourceuse", (String)appNum);
            ResourceUseArgs resourceUseArgs = new ResourceUseArgs();
            resourceUseArgs.setProgressId(progressId);
            resourceUseArgs.setAcctOrgId(acctOrgId);
            resourceUseArgs.setAppNum(appNum);
            resourceUseArgs.setCostCenterIds(enableCostCenters);
            resourceUseArgs.setManuOrgs(manuOrgIds);
            resourceUseArgs.setMftOrderEntryIds(mftOrderEntryIds);
            resourceUseArgs.setCollectParamMap(collectParamMap);
            resourceUseContext = new ResourceUseContext();
            resourceUseContext.setResourceUseArgs(resourceUseArgs);
            resourceUseContext.getCollectReport().logBaseInfo(acctOrgId, CollectObjectEnum.RESOURCE_USE, appNum);
            long time = System.currentTimeMillis();
            Boolean startCollConfigScheme = ImportServiceHelper.isStartCollConfigScheme();
            List<IResourceUseAction> resourceUseActions = IResourceUseAction.initialize(appNum, startCollConfigScheme);
            try {
                for (IResourceUseAction resourceUseAction : resourceUseActions) {
                    long actionTime = System.currentTimeMillis();
                    resourceUseAction.setContext(resourceUseContext);
                    resourceUseAction.execute();
                    logger.info("\u8d44\u6e90\u8017\u7528\u5f52\u96c6\u5f15\u5165-action{},\u8017\u65f6\uff1a{}ms", (Object)resourceUseAction.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
                }
            }
            catch (Exception e) {
                logger.error("\u8d44\u6e90\u8017\u7528\u5f52\u96c6\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
                if (!CollectReportHelper.disableCollectReport()) {
                    String message = e.getMessage();
                    if (resourceUseContext.isValidate()) {
                        resourceUseContext.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"ResourceUseServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]), message);
                        resourceUseContext.getCollectReport().logCheckDesc(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"ResourceUseServiceImpl_3", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        resourceUseContext.getCollectReport().setError(true);
                        resourceUseContext.getCollectReport().logStatusChange(CollectStatus.FAILURE, ResManager.loadKDString((String)"\u63d0\u793a", (String)"ResourceUseServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{resourceUseContext.getCollectReport().transfer2Dynamic()});
                    } else {
                        String errorMsg = ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf\u9519\u8bef", (String)"ResourceUseServiceImpl_0", (String)"macc-cad-mservice", (Object[])new Object[0]);
                        resourceUseContext.getCollectReport().logError((Throwable)e, errorMsg);
                    }
                    ProgressHelper.clearProgressParam((String)progressId);
                    break block11;
                }
                throw e;
            }
            finally {
                logger.info("\u8d44\u6e90\u8017\u7528\u5f52\u96c6\u5f15\u5165\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
            }
        }
        return new ResourceResultBuilder(resourceUseContext).buildResult();
    }
}

