/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.StandCostCalculateService;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.business.update.CostUpdateTask;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.dto.ProgressParamDto;
import kd.macc.cad.common.dto.UpdateParam;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.OperationResultHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.StdCalculateHelper;
import kd.macc.cad.common.lock.RedisBatchLock;
import kd.macc.cad.common.thread.TaskType;
import kd.macc.cad.common.thread.ThreadHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.TimeUtils;
import kd.macc.cad.mservice.api.StdCostService;
import net.sf.json.JSONObject;

public class StdCostServiceImpl
implements StdCostService {
    private static final Log logger = LogFactory.getLog(StdCostServiceImpl.class);
    private int STDCALCBATCH_BILLCOUNT = 100;
    private int STDCALCBATCH_CONFIGCODE = 50;
    private Boolean SALORDERLOG_REFRESHTRANSMITTIME = false;

    public List<Long> doCalc(Set<Long> orgs, Set<Long> manuOrgs) {
        this.initStdCalcBatch();
        if (this.SALORDERLOG_REFRESHTRANSMITTIME.booleanValue()) {
            StdCalculateHelper.updateSalOrderLogTime(null, new ArrayList<Long>(orgs));
        }
        QFilter filter = this.getQFilter(orgs, manuOrgs);
        if (CadBgParamUtils.getScmParamForInt((String)"saleOrderSingleExe", (int)0) == 1) {
            return this.executeCalcForSingle(filter, Boolean.TRUE, null);
        }
        return this.executeCalc(filter, Boolean.TRUE, null);
    }

    public void doUpdate(Set<Long> orgs, Set<Long> manuOrgs) {
        boolean isIn = false;
        try {
            String strStartTime = "3:00";
            String strEndTime = "4:00";
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            String now = sdf.format(new Date());
            Date nowTime = sdf.parse(now);
            Date startTime = sdf.parse(strStartTime);
            Date endTime = sdf.parse(strEndTime);
            isIn = StdCostServiceImpl.isEffectiveDate(nowTime, startTime, endTime);
        }
        catch (Exception e) {
            logger.error("\u65f6\u95f4\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        List<QFilter> filters = this.getQFilterForUpdate(orgs, manuOrgs, isIn);
        this.execUpdate(filters);
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public Map<String, String> doUpdateForManu(List<Long> saleOrderLogIds) {
        QFilter filter = new QFilter("id", "in", saleOrderLogIds);
        ArrayList filters = Lists.newArrayList();
        filters.add(filter);
        return this.execUpdate(filters);
    }

    public void doCalcForManu(List<Long> saleOrderLogIds, String progressId) {
        this.initStdCalcBatch();
        QFilter filter = new QFilter("id", "in", saleOrderLogIds);
        if (CadBgParamUtils.getScmParamForInt((String)"saleOrderSingleExe", (int)0) == 1) {
            this.executeCalcForSingle(filter, Boolean.FALSE, progressId);
        } else {
            this.executeCalc(filter, Boolean.FALSE, progressId);
        }
    }

    private Map<String, String> execUpdate(List<QFilter> filter) {
        HashMap<String, String> resultMsgMap = new HashMap<String, String>(16);
        DynamicObjectCollection stdCalcLogs = null;
        String select = "id,org,manuorg,costtype,targetcosttype,operationtype,material,configuredcode,tracknumber,salorderentryid,salorderaudittime,status,srcbill";
        for (int i = 0; i < filter.size(); ++i) {
            DynamicObjectCollection calcLog = QueryServiceHelper.query((String)"sca_salorderstdcalclog", (String)select, (QFilter[])new QFilter[]{filter.get(i)}, (String)"salorderaudittime desc");
            if (i == 0) {
                stdCalcLogs = calcLog;
                continue;
            }
            if (stdCalcLogs == null) {
                stdCalcLogs = calcLog;
                continue;
            }
            stdCalcLogs.addAll((Collection)calcLog);
        }
        logger.info("\u81ea\u52a8\u6267\u884c\u6807\u51c6\u6210\u672c\u66f4\u65b0\uff0c\u5f53\u524d\u6267\u884c\u65f6\u95f4==>{}\uff0c\u83b7\u53d6\u6b64\u6b21\u67e5\u8be2\u8303\u56f4 ==>{}\uff0c\u672c\u6b21\u67e5\u8be2\u6761\u6570==>{}", new Object[]{TimeServiceHelper.now(), filter, stdCalcLogs == null ? 0 : stdCalcLogs.size()});
        if (stdCalcLogs == null || stdCalcLogs.isEmpty()) {
            return resultMsgMap;
        }
        QFilter accountFilter = null;
        HashMap<String, List<DynamicObject>> groups = new HashMap<String, List<DynamicObject>>(stdCalcLogs.size());
        Map<Long, Set<Long>> orgOrderEntryIdMap = this.getOrgOrderEntryIdMap(DynamicObjectHelper.getIdList((DynamicObjectCollection)stdCalcLogs, (String)"org"), DynamicObjectHelper.getIdList((DynamicObjectCollection)stdCalcLogs, (String)"salorderentryid"));
        ArrayList<Long> notCalcSalOrderLogEntryIds = new ArrayList<Long>(16);
        HashSet existsKey = Sets.newHashSet();
        for (DynamicObject stdCalcLog : stdCalcLogs) {
            long org = stdCalcLog.getLong("org");
            long salOrderEntryId = stdCalcLog.getLong("salorderentryid");
            Set<Long> orderEntryIds = orgOrderEntryIdMap.get(org);
            if ("sm_salorder".equals(stdCalcLog.getString("srcbill")) && (CadEmptyUtils.isEmpty(orderEntryIds) || !orderEntryIds.contains(salOrderEntryId))) {
                notCalcSalOrderLogEntryIds.add(salOrderEntryId);
                continue;
            }
            Long tarCostTypeId = stdCalcLog.getLong("targetcosttype");
            if (CadEmptyUtils.isEmpty((Long)tarCostTypeId)) {
                logger.info("\u76ee\u6807\u6210\u672c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002tarCostTypeId={}", (Object)stdCalcLog.getString("targetcosttype"));
                continue;
            }
            String key = String.join((CharSequence)"&", stdCalcLog.getString("costtype"), stdCalcLog.getString("targetcosttype"));
            Long material = stdCalcLog.getLong("material");
            Long configuredcode = stdCalcLog.getLong("configuredcode");
            Long tracknumber = stdCalcLog.getLong("tracknumber");
            String uniqueKey = String.join((CharSequence)"&", key, material.toString(), configuredcode.toString(), tracknumber.toString());
            if (!existsKey.add(uniqueKey)) continue;
            groups.computeIfAbsent(key, p -> new ArrayList()).add(stdCalcLog);
            QFilter tempFilter = new QFilter("calorg", "=", (Object)stdCalcLog.getLong("org"));
            tempFilter.and("costtype", "=", (Object)stdCalcLog.getLong("targetcosttype"));
            if (accountFilter == null) {
                accountFilter = tempFilter;
                continue;
            }
            accountFilter.or(tempFilter);
        }
        if (!CadEmptyUtils.isEmpty(notCalcSalOrderLogEntryIds)) {
            StdCalculateHelper.updateLogStatusInfo(notCalcSalOrderLogEntryIds, (String)"F", (String)ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u8ddf\u8e2a\u53f7\u5377\u7b97\u89c4\u5219\u3002", (String)"StdCostServiceImpl_1", (String)"macc-cad-mservice", (Object[])new Object[0]), (Boolean)Boolean.FALSE);
        }
        logger.info(String.format("\u8ddf\u8e2a\u53f7\u5377\u7b97\u9700\u8981\u66f4\u65b0\u7684\u96c6\u5408:%s", existsKey));
        if (CadEmptyUtils.isEmpty(groups)) {
            logger.info("\u6ca1\u6709\u5f85\u66f4\u65b0\u7684\u5355\u636e\uff0c\u672c\u6b21\u81ea\u52a8\u66f4\u65b0\u7ed3\u675f\u3002");
            return resultMsgMap;
        }
        List<DynamicObject> updateBills = this.generateUpdateBill(groups, accountFilter);
        ArrayList updateBillIds = new ArrayList(10);
        Lists.partition(updateBills, (int)1000).forEach(list -> {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_costupdatenew", (DynamicObject[])list.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            List successPkIds = operationResult.getSuccessPkIds();
            if (!CadEmptyUtils.isEmpty((List)successPkIds)) {
                updateBillIds.addAll(successPkIds);
            }
            if (!operationResult.isSuccess()) {
                String errorInfo = OperationResultHelper.errorMsgHandle((OperationResult)operationResult);
                resultMsgMap.put("error", errorInfo);
            }
        });
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", updateBillIds)};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"cad_costupdatenew", (String)"id,srccosttype,targetcosttype,entryentity.tracknumber,entryentity.configuredcode", (QFilter[])filters);
        boolean i = false;
        for (DynamicObject bill : bills) {
            UpdateParam updateParam = new UpdateParam();
            updateParam.setRc(RequestContext.get());
            updateParam.setPageId(null);
            updateParam.setQuickUpdateFlag(Boolean.FALSE);
            updateParam.setIsPurMat(Boolean.FALSE);
            updateParam.setSrcCostTypeId(Long.valueOf(bill.getLong("srccosttype.id")));
            updateParam.setUpdatBillIds((List)Lists.newArrayList((Object[])new Long[]{bill.getLong("id")}));
            logger.info(String.format("\u66f4\u65b0\u7533\u8bf7\u5355%s,\u8ddf\u8e2a\u53f7\u66f4\u65b0=true", bill.getLong("id")));
            Boolean isTrackUpdate = Boolean.FALSE;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (CadEmptyUtils.isEmpty((Long)entry.getLong("tracknumber.id")) && CadEmptyUtils.isEmpty((Long)entry.getLong("configuredcode.id"))) continue;
                isTrackUpdate = Boolean.TRUE;
            }
            if (Boolean.FALSE.equals(isTrackUpdate)) {
                updateParam.setIsConfigUpdate(Boolean.TRUE);
            } else {
                updateParam.setIsConfigUpdate(Boolean.FALSE);
            }
            updateParam.setIsTrackUpdate(isTrackUpdate);
            CostUpdateTask updateTask = new CostUpdateTask(updateParam);
            try {
                ThreadHelper.execute((Runnable)updateTask, (TaskType)TaskType.CAD_COSTUPDATE);
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
        }
        return resultMsgMap;
    }

    private List<DynamicObject> generateUpdateBill(Map<String, List<DynamicObject>> groups, QFilter accountFilter) {
        ArrayList<DynamicObject> updateBills = new ArrayList<DynamicObject>(groups.size());
        if (CadEmptyUtils.isEmpty(groups)) {
            return updateBills;
        }
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (Map.Entry<String, List<DynamicObject>> group : groups.entrySet()) {
            List<DynamicObject> values = group.getValue();
            for (DynamicObject value : values) {
                orgIds.add(value.getLong("org"));
            }
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIds)};
        DynamicObject[] truckNumberSettings = BusinessDataServiceHelper.load((String)"cad_tracknumber_setting", (String)"org,costaccount,entryentityupdate.matgrp,entryentityupdate.attachorg", (QFilter[])filters);
        Date date = TimeServiceHelper.now();
        HashMap<String, Long> orgCostAccounts = new HashMap<String, Long>(16);
        if (accountFilter != null) {
            filters = new QFilter[]{accountFilter, new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,costtype,costaccount", (QFilter[])filters);
            for (DynamicObject dynamicObject : dynamicObjects) {
                orgCostAccounts.put(dynamicObject.getString("calorg") + '@' + dynamicObject.getString("costtype"), dynamicObject.getLong("costaccount"));
            }
        }
        int i = 1;
        for (Map.Entry<String, List<DynamicObject>> group : groups.entrySet()) {
            List<DynamicObject> values = group.getValue();
            if (CadEmptyUtils.isEmpty(values)) continue;
            ArrayList ids = new ArrayList(10);
            values.forEach(p -> ids.add(p.getLong("id")));
            String select = "id,org,manuorg,costtype,targetcosttype,operationtype,material,configuredcode,tracknumber,salorderentryid,salorderaudittime,status,srcbill";
            Object[] calcLogs = BusinessDataServiceHelper.load((String)"sca_salorderstdcalclog", (String)select, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            if (CadEmptyUtils.isEmpty((Object[])calcLogs)) continue;
            for (Object value : calcLogs) {
                HashSet<Long> matIds = new HashSet<Long>(1);
                matIds.add(value.getLong("material.id"));
                DynamicObject updateBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew");
                this.createNewBill(updateBill, (DynamicObject)value, i++, matIds, truckNumberSettings, orgCostAccounts);
                DynamicObjectCollection entrys = updateBill.getDynamicObjectCollection("entryentity");
                Boolean isTrackUpdate = Boolean.FALSE;
                DynamicObject entry = entrys.addNew();
                entry.set("material", value.get("material"));
                entry.set("configuredcode", value.get("configuredcode"));
                entry.set("tracknumber", value.get("tracknumber"));
                entry.set("salcalclogid", (Object)value.getLong("id"));
                if (!CadEmptyUtils.isEmpty((Long)value.getLong("tracknumber.id"))) {
                    isTrackUpdate = Boolean.TRUE;
                }
                updateBill.set("iscalccurlevel", (Object)isTrackUpdate);
                updateBills.add(updateBill);
            }
        }
        return updateBills;
    }

    private void createNewBill(DynamicObject updateBill, DynamicObject targetData, int i, Set<Long> matIds, DynamicObject[] truckNumberSettings, Map<String, Long> orgCostAccounts) {
        String billNo = this.getCodeRuleNumber("cad_costupdatenew");
        if (StringUtils.isEmpty((String)billNo)) {
            billNo = "CBGX-" + String.valueOf(System.currentTimeMillis()) + i;
        }
        updateBill.set("billno", (Object)billNo);
        updateBill.set("srccosttype", targetData.get("costtype"));
        updateBill.set("targetcosttype", targetData.get("targetcosttype"));
        DynamicObjectCollection attachtargetcosttype = updateBill.getDynamicObjectCollection("attachtargetcosttype");
        String key = targetData.getString("org.id") + '@' + targetData.getLong("targetcosttype.id");
        Long costAccountId = CadEmptyUtils.isEmpty((Long)orgCostAccounts.get(key)) ? Long.valueOf(0L) : orgCostAccounts.get(key);
        String orgAccountKey = targetData.getString("org.id") + '@' + String.valueOf(costAccountId);
        ArrayList<Long> attachOrgIds = new ArrayList<Long>(16);
        for (DynamicObject truckNumberSetting : truckNumberSettings) {
            if (!orgAccountKey.equals(truckNumberSetting.getString("org.id") + '@' + truckNumberSetting.getString("costaccount.id"))) continue;
            DynamicObjectCollection entrys = truckNumberSetting.getDynamicObjectCollection("entryentityupdate");
            for (DynamicObject entry : entrys) {
                if (!this.matInMatGrp(entry.getLong("matgrp.id"), matIds)) continue;
                DynamicObjectCollection attachorgs = entry.getDynamicObjectCollection("attachorg");
                for (DynamicObject attachorg : attachorgs) {
                    attachOrgIds.add(attachorg.getDynamicObject("fbasedataid").getLong("id"));
                }
            }
        }
        if (!CadEmptyUtils.isEmpty(attachOrgIds)) {
            Long orgId = targetData.getLong("org.id");
            boolean enableFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
            QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
            if (enableFactory) {
                filter.and("storageorgunit", "in", attachOrgIds);
            } else {
                filter.and("calorg", "in", attachOrgIds);
            }
            filter.and("bizstatus", "=", (Object)"1");
            filter.and("effectdate", "<=", (Object)new Date());
            filter.and("invaliddate", ">", (Object)new Date());
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"costtype", (QFilter[])new QFilter[]{filter});
            ArrayList<Long> attachCostTypeIds = new ArrayList<Long>(16);
            for (DynamicObject dynamicObject : dynamicObjects) {
                attachCostTypeIds.add(dynamicObject.getLong("costtype"));
            }
            if (!CadEmptyUtils.isEmpty(attachCostTypeIds)) {
                Map costTypes = BusinessDataServiceHelper.loadFromCache((Object[])attachCostTypeIds.toArray(), (String)"cad_costtype");
                for (DynamicObject costType : costTypes.values()) {
                    DynamicObject entry = attachtargetcosttype.addNew();
                    entry.set("fbasedataid", (Object)costType);
                }
            }
        }
        updateBill.set("matgrpstd", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)730148448254487552L, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_materialgroupstandard")));
        updateBill.set("isspecifymaterial", (Object)Boolean.TRUE);
        updateBill.set("iscalccurlevel", (Object)Boolean.TRUE);
        updateBill.set("isallupdate", (Object)Boolean.FALSE);
        updateBill.set("billstatus", (Object)"C");
        updateBill.set("updatestatus", (Object)"N");
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Date date = TimeServiceHelper.now();
        updateBill.set("creator", (Object)userId);
        updateBill.set("createtime", (Object)date);
        updateBill.set("modifier", (Object)userId);
        updateBill.set("modifytime", (Object)date);
        updateBill.set("auditor", (Object)userId);
        updateBill.set("auditdate", (Object)date);
        updateBill.set("period", (Object)PeriodHelper.getPeriodByDate((Date)new Date(), (Long)CostUpdateHelper.getCostAccountByCostType((Long)targetData.getLong("targetcosttype.id"))).getLong("id"));
    }

    private boolean matInMatGrp(Long matGrpId, Set<Long> matIds) {
        if (CadEmptyUtils.isEmpty(matIds)) {
            return false;
        }
        QFilter[] filters = new QFilter[]{new QFilter("group", "=", (Object)matGrpId), new QFilter("material", "in", matIds)};
        Map results = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroupdetail", (String)"material", (QFilter[])filters);
        return matIds.size() == results.size();
    }

    private String getCodeRuleNumber(String entityId) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        if (codeRuleService == null) {
            codeRuleService = (ICodeRuleService)TypesContainer.createInstance((String)"kd.bos.coderule.service.CodeRuleServiceImp");
        }
        DynamicObject obj = new DynamicObject((DynamicObjectType)dataEntityType);
        return codeRuleService.getNumber(entityId, obj, null);
    }

    private List<Long> executeCalc(QFilter filter, Boolean isAutoCalc, String progressId) {
        this.refreshProgress(ResManager.loadKDString((String)"\u5904\u7406\u72b6\u6001\u4e3a\u8fd0\u884c\u4e2d\u7684\u5f02\u5e38\u6570\u636e\u3002", (String)"StdCostServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]), 1, 5, Boolean.FALSE, progressId);
        StdCalculateHelper.updateDataStatus();
        this.refreshProgress(ResManager.loadKDString((String)"\u83b7\u53d6\u9500\u552e\u8ba2\u5355", (String)"StdCostServiceImpl_3", (String)"macc-cad-mservice", (Object[])new Object[0]), 2, 5, Boolean.FALSE, progressId);
        DynamicObjectCollection stdCalcLogs = QueryServiceHelper.query((String)"sca_salorderstdcalclog", (String)"id,org,manuorg,costtype,costtype.currency.priceprecision priceprecision,salorderno,salorderseq,salorderentryid,operationtype,material,auxpty,configuredcode,tracknumber,salorderaudittime,status,srcbill", (QFilter[])new QFilter[]{filter}, null, (int)this.STDCALCBATCH_BILLCOUNT);
        logger.info("\u6807\u51c6\u6210\u672c\u5377\u7b97\u91cd\u65b0\u6267\u884c,\u5f53\u524d\u6267\u884c\u65f6\u95f4==>{},\u83b7\u53d6\u6b64\u6b21\u67e5\u8be2\u8303\u56f4 ==>{},\u672c\u6b21\u67e5\u8be2\u6761\u6570==>{}", new Object[]{new Date(), filter, stdCalcLogs.size()});
        List salOrderIds = DynamicObjectHelper.getIdList((DynamicObjectCollection)stdCalcLogs, (String)"id");
        if (CadEmptyUtils.isEmpty((List)salOrderIds)) {
            return salOrderIds;
        }
        if (!isAutoCalc.booleanValue() && salOrderIds.size() > 50) {
            this.refreshProgress(ResManager.loadKDString((String)"\u5377\u7b97\u7ed3\u675f", (String)"StdCostServiceImpl_4", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, Boolean.FALSE, progressId);
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6700\u591a\u9009\u62e950\u6761\u3002", (String)"StdCostServiceImpl_5", (String)"macc-cad-mservice", (Object[])new Object[0]));
        }
        Map<Long, Set<Long>> orgOrderEntryIdMap = this.getOrgOrderEntryIdMap(DynamicObjectHelper.getIdList((DynamicObjectCollection)stdCalcLogs, (String)"org"), DynamicObjectHelper.getIdList((DynamicObjectCollection)stdCalcLogs, (String)"salorderentryid"));
        ArrayList notCalcSalOrderLogEntryIds = new ArrayList(16);
        int[] batch = new int[]{1};
        Date sysCalcDate = new Date();
        logger.info("stdcalcparam->log_refreshTransmitTime->SALORDERLOG_REFRESHTRANSMITTIME\uff1a{}", (Object)this.SALORDERLOG_REFRESHTRANSMITTIME);
        Lists.partition((List)stdCalcLogs, (int)this.STDCALCBATCH_BILLCOUNT).forEach(list -> {
            this.refreshProgress(String.format(ResManager.loadKDString((String)"\u7b2c{}\u6279\u9500\u552e\u8ba2\u5355\u5377\u7b97", (String)"StdCostServiceImpl_6", (String)"macc-cad-mservice", (Object[])new Object[0]), batch[0]), 3, 5, Boolean.FALSE, progressId);
            HashMap<Long, Map> costTypeSalOrderInfoMap = new HashMap<Long, Map>(16);
            HashMap<Long, Long> costTypeManuOrgMap = new HashMap<Long, Long>(16);
            HashMap<Long, Integer> costTypePrecisionMap = new HashMap<Long, Integer>(16);
            for (DynamicObject stdCalcLog : list) {
                long costType = stdCalcLog.getLong("costtype");
                long manuOrg = stdCalcLog.getLong("manuorg");
                Date salOrderAuditTime = this.SALORDERLOG_REFRESHTRANSMITTIME != false ? sysCalcDate : stdCalcLog.getDate("salorderaudittime");
                Map salOrderInfoMap = costTypeSalOrderInfoMap.computeIfAbsent(stdCalcLog.getLong("costtype"), p -> new HashMap());
                salOrderInfoMap.computeIfAbsent(salOrderAuditTime, p -> new ArrayList()).add(stdCalcLog);
                if (costTypePrecisionMap.get(costType) == null) {
                    costTypePrecisionMap.put(costType, stdCalcLog.getInt("priceprecision"));
                }
                if (costTypeManuOrgMap.containsKey(costType)) continue;
                costTypeManuOrgMap.put(costType, manuOrg);
            }
            this.refreshProgress(ResManager.loadKDString((String)"\u5377\u7b97\u9884\u5904\u7406", (String)"StdCostServiceImpl_7", (String)"macc-cad-mservice", (Object[])new Object[0]), 3, 5, Boolean.FALSE, progressId);
            Map<Long, String> costTypeInfoMap = this.getCostTypeInfo(costTypeSalOrderInfoMap.keySet());
            for (Map.Entry costTypeSalOrderInfo : costTypeSalOrderInfoMap.entrySet()) {
                Long costType = (Long)costTypeSalOrderInfo.getKey();
                Map salOrderInfoMap = (Map)costTypeSalOrderInfo.getValue();
                for (Map.Entry salOrderInfo : salOrderInfoMap.entrySet()) {
                    Date calcDate = (Date)salOrderInfo.getKey();
                    List salOrders = (List)salOrderInfo.getValue();
                    if (CadEmptyUtils.isEmpty((List)salOrders)) continue;
                    ArrayList resultMapList = new ArrayList(10);
                    HashMap<Long, List> resultMap = null;
                    for (DynamicObject salOrder2 : salOrders) {
                        if (resultMap == null || resultMap.size() > this.STDCALCBATCH_CONFIGCODE) {
                            resultMap = new HashMap<Long, List>(16);
                            resultMapList.add(resultMap);
                        }
                        long l = salOrder2.getLong("configuredcode");
                        resultMap.computeIfAbsent(l, p -> new ArrayList()).add(salOrder2);
                    }
                    this.refreshProgress(String.format(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u5377\u7b97\u3002", (String)"StdCostServiceImpl_8", (String)"macc-cad-mservice", (Object[])new Object[0]), costTypeInfoMap.get(costType)), 1, 0, Boolean.TRUE, progressId);
                    int count = 1;
                    for (Map map : resultMapList) {
                        logger.info("\u6210\u672c\u7c7b\u578b\uff1a{}\uff0c\u7b2c {} \u6279\u6b21\u8ba1\u7b97\u5f00\u59cb\u3002", (Object)costType, (Object)count);
                        this.refreshProgress(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6279\u6b21\u6b63\u5728\u8fdb\u884c\u5377\u7b97\u3002", (String)"StdCostServiceImpl_9", (String)"macc-cad-mservice", (Object[])new Object[0]), count), 1, 0, Boolean.TRUE, progressId);
                        HashMap<String, Set<Long>> matConfigCodeTrackNumMap = new HashMap<String, Set<Long>>(16);
                        ArrayList<Long> materialIds = new ArrayList<Long>(100);
                        ArrayList<Long> salOrderLogEntryIds = new ArrayList<Long>(100);
                        HashMap keycolSalOrderIdMap = new HashMap(16);
                        ArrayList<String> wizardMatScopInfos = new ArrayList<String>(10);
                        Long manuOrg = (Long)costTypeManuOrgMap.get(costType);
                        for (List resDyo : map.values()) {
                            resDyo.forEach(salOrder -> {
                                Long org = salOrder.getLong("org");
                                long salOrderEntryId = salOrder.getLong("salorderentryid");
                                long material = salOrder.getLong("material");
                                Set orderEntryIds = (Set)orgOrderEntryIdMap.get(org);
                                if (!CadEmptyUtils.isEmpty((Set)orderEntryIds) && orderEntryIds.contains(salOrderEntryId) || !"sm_salorder".equals(salOrder.getString("srcbill"))) {
                                    materialIds.add(material);
                                    salOrderLogEntryIds.add(salOrderEntryId);
                                } else {
                                    notCalcSalOrderLogEntryIds.add(salOrderEntryId);
                                }
                            });
                        }
                        Map<Long, String> matProInfoMap = this.getMatProInfoMap(manuOrg, materialIds);
                        HashMap coEntryKeycolMap = new HashMap(16);
                        for (List resDyo : map.values()) {
                            resDyo.forEach(salOrder -> {
                                long salOrderEntryId = salOrder.getLong("salorderentryid");
                                if (notCalcSalOrderLogEntryIds.contains(salOrderEntryId)) {
                                    return;
                                }
                                long material = salOrder.getLong("material");
                                long auxpty = salOrder.getLong("auxpty");
                                long configuredcode = salOrder.getLong("configuredcode");
                                long trackNumber = salOrder.getLong("tracknumber");
                                String materialAttr = matProInfoMap.get(material) == null ? " " : (String)matProInfoMap.get(material);
                                coEntryKeycolMap.clear();
                                coEntryKeycolMap.put("material", material);
                                coEntryKeycolMap.put("configuredcode", configuredcode);
                                Keycol calcKey = CalcKeyHelper.getCalcKey((Map)coEntryKeycolMap, new ArrayList(), (boolean)true);
                                coEntryKeycolMap.put("tracknumber", trackNumber);
                                Keycol calcKeyForTrack = CalcKeyHelper.getCalcKey((Map)coEntryKeycolMap, new ArrayList(), (boolean)true);
                                matConfigCodeTrackNumMap.computeIfAbsent(calcKey.getKeycol(), t -> new HashSet()).add(trackNumber);
                                keycolSalOrderIdMap.computeIfAbsent(calcKey.getKeycol(), p -> new ArrayList()).add(salOrderEntryId);
                                String matScopInfo = material + "@" + auxpty + "@" + configuredcode + "@" + trackNumber + "@ @0@" + materialAttr + "@" + calcKeyForTrack.getKeycol() + "@" + calcKey.getKeycol();
                                wizardMatScopInfos.add(matScopInfo);
                            });
                        }
                        if (CadEmptyUtils.isEmpty(materialIds) || CadEmptyUtils.isEmpty(salOrderLogEntryIds)) continue;
                        RedisBatchLock redisBatchLock = new RedisBatchLock("stdcalc", costType, matConfigCodeTrackNumMap.keySet(), "sca");
                        redisBatchLock.lock();
                        Set lockFailedKeys = redisBatchLock.getLockFailedKeys();
                        if (!CadEmptyUtils.isEmpty((Set)lockFailedKeys)) {
                            logger.info("\u6210\u672c\u7c7b\u578b\uff1a{}\uff0c\u7269\u6599keycol\uff1a{}\uff0c\u5df2\u5728\u8fdb\u884c\u9500\u552e\u8ba2\u5355\u6210\u672c\u5377\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (Object)costType, (Object)lockFailedKeys);
                        }
                        for (String lockFailedKey : lockFailedKeys) {
                            matConfigCodeTrackNumMap.remove(lockFailedKey);
                            List salOrderIdsList = (List)keycolSalOrderIdMap.get(lockFailedKey);
                            if (CadEmptyUtils.isEmpty((List)salOrderIdsList)) continue;
                            salOrderLogEntryIds.removeAll(salOrderIdsList);
                        }
                        if (CadEmptyUtils.isEmpty(matConfigCodeTrackNumMap)) {
                            logger.info("\u6210\u672c\u7c7b\u578b\uff1a{}\uff0c\u672c\u6279\u6b21\u6ca1\u6709\u9700\u8981\u8ba1\u7b97\u7684\u7269\u6599\u548c\u914d\u7f6e\u53f7\uff0c\u8ba1\u7b97\u7ed3\u675f\u3002", (Object)costType);
                            continue;
                        }
                        this.doBatchCalc(costType, manuOrg, materialIds, new ArrayList<Long>(map.keySet()), (Integer)costTypePrecisionMap.get(costType), calcDate, matConfigCodeTrackNumMap, salOrderLogEntryIds, wizardMatScopInfos, redisBatchLock);
                        logger.info("\u6210\u672c\u7c7b\u578b\uff1a{}\uff0c\u7b2c {} \u6279\u6b21\u8ba1\u7b97\u7ed3\u675f\u3002", (Object)costType, (Object)count);
                        ++count;
                    }
                }
            }
            batch[0] = batch[0] + 1;
        });
        if (!CadEmptyUtils.isEmpty(notCalcSalOrderLogEntryIds)) {
            StdCalculateHelper.updateLogStatusInfo(notCalcSalOrderLogEntryIds, (String)"05", (String)ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u8ddf\u8e2a\u53f7\u5377\u7b97\u89c4\u5219\u3002", (String)"StdCostServiceImpl_1", (String)"macc-cad-mservice", (Object[])new Object[0]), (Boolean)Boolean.TRUE);
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u5377\u7b97\u540e\u5904\u7406", (String)"StdCostServiceImpl_10", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, Boolean.FALSE, progressId);
        return salOrderIds;
    }

    private List<Long> executeCalcForSingle(QFilter filter, Boolean isAutoCalc, String progressId) {
        this.refreshProgress(ResManager.loadKDString((String)"\u5904\u7406\u72b6\u6001\u4e3a\u8fd0\u884c\u4e2d\u7684\u5f02\u5e38\u6570\u636e\u3002", (String)"StdCostServiceImpl_2", (String)"macc-cad-mservice", (Object[])new Object[0]), 1, 5, Boolean.FALSE, progressId);
        StdCalculateHelper.updateDataStatus();
        this.refreshProgress(ResManager.loadKDString((String)"\u83b7\u53d6\u9500\u552e\u8ba2\u5355", (String)"StdCostServiceImpl_3", (String)"macc-cad-mservice", (Object[])new Object[0]), 2, 5, Boolean.FALSE, progressId);
        DynamicObjectCollection stdCalcLogs = QueryServiceHelper.query((String)"sca_salorderstdcalclog", (String)"id,org,manuorg,costtype,costtype.currency.priceprecision priceprecision,salorderno,salorderseq,salorderentryid,operationtype,material,auxpty,configuredcode,tracknumber,salorderaudittime,status,srcbill", (QFilter[])new QFilter[]{filter}, null, (int)this.STDCALCBATCH_BILLCOUNT);
        logger.info("\u6807\u51c6\u6210\u672c\u5377\u7b97\u91cd\u65b0\u6267\u884c,\u5f53\u524d\u6267\u884c\u65f6\u95f4==>{},\u83b7\u53d6\u6b64\u6b21\u67e5\u8be2\u8303\u56f4 ==>{},\u672c\u6b21\u67e5\u8be2\u6761\u6570==>{}", new Object[]{new Date(), filter, stdCalcLogs.size()});
        List salOrderIds = DynamicObjectHelper.getIdList((DynamicObjectCollection)stdCalcLogs, (String)"id");
        if (CadEmptyUtils.isEmpty((List)salOrderIds)) {
            return salOrderIds;
        }
        if (!isAutoCalc.booleanValue() && salOrderIds.size() > 50) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6700\u591a\u9009\u62e950\u6761\u3002", (String)"StdCostServiceImpl_11", (String)"macc-cad-mservice", (Object[])new Object[0]));
        }
        Map<Long, Set<Long>> orgOrderEntryIdMap = this.getOrgOrderEntryIdMap(DynamicObjectHelper.getIdList((DynamicObjectCollection)stdCalcLogs, (String)"org"), DynamicObjectHelper.getIdList((DynamicObjectCollection)stdCalcLogs, (String)"salorderentryid"));
        ArrayList notCalcSalOrderLogEntryIds = new ArrayList(16);
        int[] batch = new int[]{1};
        Lists.partition((List)stdCalcLogs, (int)this.STDCALCBATCH_BILLCOUNT).forEach(list -> {
            this.refreshProgress(String.format(ResManager.loadKDString((String)"\u7b2c{}\u6279\u9500\u552e\u8ba2\u5355\u5377\u7b97", (String)"StdCostServiceImpl_6", (String)"macc-cad-mservice", (Object[])new Object[0]), batch[0]), 3, 5, Boolean.FALSE, progressId);
            HashMap<Long, Map> costTypeSalOrderInfoMap = new HashMap<Long, Map>(16);
            HashMap<Long, Long> costTypeManuOrgMap = new HashMap<Long, Long>(16);
            HashMap<Long, Integer> costTypePrecisionMap = new HashMap<Long, Integer>(16);
            for (DynamicObject stdCalcLog : list) {
                long costType = stdCalcLog.getLong("costtype");
                long manuOrg = stdCalcLog.getLong("manuorg");
                Date salOrderAuditTime = stdCalcLog.getDate("salorderaudittime");
                Map salOrderInfoMap = costTypeSalOrderInfoMap.computeIfAbsent(stdCalcLog.getLong("costtype"), p -> new HashMap());
                salOrderInfoMap.computeIfAbsent(salOrderAuditTime, p -> new ArrayList()).add(stdCalcLog);
                if (costTypePrecisionMap.get(costType) == null) {
                    costTypePrecisionMap.put(costType, stdCalcLog.getInt("priceprecision"));
                }
                if (costTypeManuOrgMap.containsKey(costType)) continue;
                costTypeManuOrgMap.put(costType, manuOrg);
            }
            this.refreshProgress(ResManager.loadKDString((String)"\u5377\u7b97\u9884\u5904\u7406", (String)"StdCostServiceImpl_7", (String)"macc-cad-mservice", (Object[])new Object[0]), 3, 5, Boolean.FALSE, progressId);
            Map<Long, String> costTypeInfoMap = this.getCostTypeInfo(costTypeSalOrderInfoMap.keySet());
            for (Map.Entry costTypeSalOrderInfo : costTypeSalOrderInfoMap.entrySet()) {
                Long costType = (Long)costTypeSalOrderInfo.getKey();
                Map salOrderInfoMap = (Map)costTypeSalOrderInfo.getValue();
                for (Map.Entry salOrderInfo : salOrderInfoMap.entrySet()) {
                    Date calcDate = (Date)salOrderInfo.getKey();
                    List salOrders = (List)salOrderInfo.getValue();
                    if (CadEmptyUtils.isEmpty((List)salOrders)) continue;
                    ArrayList resultMapList = new ArrayList(10);
                    HashMap<Long, List> resultMap = null;
                    for (DynamicObject salOrder2 : salOrders) {
                        if (resultMap == null || resultMap.size() > this.STDCALCBATCH_CONFIGCODE) {
                            resultMap = new HashMap<Long, List>(16);
                            resultMapList.add(resultMap);
                        }
                        long l = salOrder2.getLong("configuredcode");
                        resultMap.computeIfAbsent(l, p -> new ArrayList()).add(salOrder2);
                    }
                    this.refreshProgress(String.format(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u5377\u7b97\u3002", (String)"StdCostServiceImpl_8", (String)"macc-cad-mservice", (Object[])new Object[0]), costTypeInfoMap.get(costType)), 1, 0, Boolean.TRUE, progressId);
                    int count = 1;
                    for (Map map : resultMapList) {
                        for (Map.Entry mapSingle : map.entrySet()) {
                            logger.info("\u6210\u672c\u7c7b\u578b\uff1a{}\uff0c\u7b2c {} \u6279\u6b21\u8ba1\u7b97\u5f00\u59cb\u3002", (Object)costType, (Object)count);
                            this.refreshProgress(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6279\u6b21\u6b63\u5728\u8fdb\u884c\u5377\u7b97\u3002", (String)"StdCostServiceImpl_9", (String)"macc-cad-mservice", (Object[])new Object[0]), count), 1, 0, Boolean.TRUE, progressId);
                            HashMap<String, Set<Long>> matConfigCodeTrackNumMap = new HashMap<String, Set<Long>>(16);
                            ArrayList<Long> materialIds = new ArrayList<Long>(100);
                            ArrayList<Long> salOrderLogEntryIds = new ArrayList<Long>(100);
                            HashMap keycolSalOrderIdMap = new HashMap(16);
                            ArrayList<String> wizardMatScopInfos = new ArrayList<String>(10);
                            Long manuOrg = (Long)costTypeManuOrgMap.get(costType);
                            ((List)mapSingle.getValue()).forEach(salOrder -> {
                                Long org = salOrder.getLong("org");
                                long salOrderEntryId = salOrder.getLong("salorderentryid");
                                long material = salOrder.getLong("material");
                                Set orderEntryIds = (Set)orgOrderEntryIdMap.get(org);
                                if (!CadEmptyUtils.isEmpty((Set)orderEntryIds) && orderEntryIds.contains(salOrderEntryId) || !"sm_salorder".equals(salOrder.getString("srcbill"))) {
                                    materialIds.add(material);
                                    salOrderLogEntryIds.add(salOrderEntryId);
                                } else {
                                    notCalcSalOrderLogEntryIds.add(salOrderEntryId);
                                }
                            });
                            Map<Long, String> matProInfoMap = this.getMatProInfoMap(manuOrg, materialIds);
                            ((List)mapSingle.getValue()).forEach(salOrder -> {
                                long salOrderEntryId = salOrder.getLong("salorderentryid");
                                if (notCalcSalOrderLogEntryIds.contains(salOrderEntryId)) {
                                    return;
                                }
                                long material = salOrder.getLong("material");
                                long auxpty = salOrder.getLong("auxpty");
                                long configuredcode = salOrder.getLong("configuredcode");
                                long trackNumber = salOrder.getLong("tracknumber");
                                String materialAttr = (String)matProInfoMap.get(material);
                                HashMap<String, Long> coEntryKeycolMap = new HashMap<String, Long>(16);
                                coEntryKeycolMap.put("material", material);
                                coEntryKeycolMap.put("configuredcode", salOrder.getLong("configuredcode"));
                                Keycol calcKey = CalcKeyHelper.getCalcKey(coEntryKeycolMap, new ArrayList(), (boolean)true);
                                matConfigCodeTrackNumMap.computeIfAbsent(calcKey.getKeycol(), t -> new HashSet()).add(trackNumber);
                                keycolSalOrderIdMap.computeIfAbsent(calcKey.getKeycol(), p -> new ArrayList()).add(salOrderEntryId);
                                String matScopInfo = material + "@" + auxpty + "@" + configuredcode + "@" + trackNumber + "@ @0@" + materialAttr + "@0";
                                wizardMatScopInfos.add(matScopInfo);
                            });
                            if (CadEmptyUtils.isEmpty(materialIds) || CadEmptyUtils.isEmpty(salOrderLogEntryIds)) continue;
                            RedisBatchLock redisBatchLock = new RedisBatchLock("stdcalc", costType, matConfigCodeTrackNumMap.keySet(), "sca");
                            redisBatchLock.lock();
                            Set lockFailedKeys = redisBatchLock.getLockFailedKeys();
                            if (!CadEmptyUtils.isEmpty((Set)lockFailedKeys)) {
                                logger.info("\u6210\u672c\u7c7b\u578b\uff1a{}\uff0c\u7269\u6599keycol\uff1a{}\uff0c\u5df2\u5728\u8fdb\u884c\u9500\u552e\u8ba2\u5355\u6210\u672c\u5377\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (Object)costType, (Object)lockFailedKeys);
                            }
                            for (String lockFailedKey : lockFailedKeys) {
                                matConfigCodeTrackNumMap.remove(lockFailedKey);
                                List salOrderIdsList = (List)keycolSalOrderIdMap.get(lockFailedKey);
                                if (CadEmptyUtils.isEmpty((List)salOrderIdsList)) continue;
                                salOrderLogEntryIds.removeAll(salOrderIdsList);
                            }
                            if (CadEmptyUtils.isEmpty(matConfigCodeTrackNumMap)) {
                                logger.info("\u6210\u672c\u7c7b\u578b\uff1a{}\uff0c\u672c\u6279\u6b21\u6ca1\u6709\u9700\u8981\u8ba1\u7b97\u7684\u7269\u6599\u548c\u914d\u7f6e\u53f7\uff0c\u8ba1\u7b97\u7ed3\u675f\u3002", (Object)costType);
                                continue;
                            }
                            this.doBatchCalc(costType, manuOrg, materialIds, new ArrayList<Long>(map.keySet()), (Integer)costTypePrecisionMap.get(costType), calcDate, matConfigCodeTrackNumMap, salOrderLogEntryIds, wizardMatScopInfos, redisBatchLock);
                            logger.info("\u6210\u672c\u7c7b\u578b\uff1a{}\uff0c\u7b2c {} \u6279\u6b21\u8ba1\u7b97\u7ed3\u675f\u3002", (Object)costType, (Object)count);
                            ++count;
                        }
                    }
                }
            }
            batch[0] = batch[0] + 1;
        });
        if (!CadEmptyUtils.isEmpty(notCalcSalOrderLogEntryIds)) {
            StdCalculateHelper.updateLogStatusInfo(notCalcSalOrderLogEntryIds, (String)"05", (String)ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u8ddf\u8e2a\u53f7\u5377\u7b97\u89c4\u5219\u3002", (String)"StdCostServiceImpl_1", (String)"macc-cad-mservice", (Object[])new Object[0]), (Boolean)Boolean.TRUE);
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u5377\u7b97\u540e\u5904\u7406", (String)"StdCostServiceImpl_10", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, Boolean.FALSE, progressId);
        return salOrderIds;
    }

    private Map<Long, Set<Long>> getOrgOrderEntryIdMap(List<Long> orgIds, List<Long> orderEntryIds) {
        HashMap<Long, Set<Long>> orgOrderEntryIdMap = new HashMap<Long, Set<Long>>(16);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        orgFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        orgFilter.and(new QFilter("istrack", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection trackSettings = QueryServiceHelper.query((String)"cad_tracknumber_setting", (String)"org,filter_tag", (QFilter[])new QFilter[]{orgFilter});
        for (DynamicObject trackSetting : trackSettings) {
            QFilter ruleFilter = null;
            Long org = trackSetting.getLong("org");
            String filterStr = trackSetting.getString("filter_tag");
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
            if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"sm_salorder");
                FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
                filterBuilder.buildFilter();
                ruleFilter = filterBuilder.getQFilter();
            }
            orgOrderEntryIdMap.computeIfAbsent(org, p -> new HashSet()).addAll(this.getOrderEntryIdMap(orderEntryIds, ruleFilter));
        }
        return orgOrderEntryIdMap;
    }

    private List<Long> getOrderEntryIdMap(List<Long> orderEntryIds, QFilter ruleFilter) {
        QFilter entryIdFilter = new QFilter("billentry.id", "in", orderEntryIds);
        DynamicObjectCollection salOrders = QueryServiceHelper.query((String)"sm_salorder", (String)"billentry.id entryid", (QFilter[])new QFilter[]{entryIdFilter, ruleFilter});
        return DynamicObjectHelper.getIdList((DynamicObjectCollection)salOrders, (String)"entryid");
    }

    private Map<Long, String> getMatProInfoMap(Long productOrg, List<Long> ids) {
        QFilter orgFilter = new QFilter("createorg", "=", (Object)productOrg);
        QFilter matInfoFilter = new QFilter("masterid", "in", ids);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getMatProduceInfo", (String)"bd_materialmftinfo", (String)"masterid,materialattr", (QFilter[])new QFilter[]{orgFilter, matInfoFilter, statusFilter, enableFilter}, null);
        HashMap<Long, String> matProInfoMap = new HashMap<Long, String>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long masterId = row.getLong("masterid");
            String materialAttr = row.getString("materialattr");
            String matprop = "";
            matprop = "10030".equals(materialAttr) ? "A" : ("10040".equals(materialAttr) ? "B" : ("10050".equals(materialAttr) ? "C" : ("10020".equals(materialAttr) ? "D" : "B")));
            matProInfoMap.put(masterId, matprop);
        }
        return matProInfoMap;
    }

    private Map<Long, String> getCostTypeInfo(Set<Long> ids) {
        HashMap<Long, String> costTypeIdNameMap = new HashMap<Long, String>(16);
        DynamicObjectCollection costTypes = QueryServiceHelper.query((String)"cad_costtype", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        for (DynamicObject costType : costTypes) {
            long id = costType.getLong("id");
            if (costTypeIdNameMap.containsKey(id)) continue;
            costTypeIdNameMap.put(id, costType.getString("name"));
        }
        return costTypeIdNameMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBatchCalc(Long costTypeId, Long manuOrg, List<Long> materials, List<Long> configCodeIds, int precision, Date calcDate, Map<String, Set<Long>> matConfigCodeTrackNumMap, List<Long> salOrderLogEntryIds, List<String> wizardMatScopInfos, RedisBatchLock redisBatchLock) {
        try {
            StdCalculateHelper.updateSalOrderLogs(salOrderLogEntryIds, null, (String)"01", (Boolean)true, null, (Long)0L);
            List configBomInfoJsStrList = StdCalculateHelper.getConfigBomInfoJsStrNew((Long)manuOrg, configCodeIds, (Date)calcDate, (boolean)false, (Set)Sets.newHashSetWithExpectedSize((int)16));
            if (CadEmptyUtils.isEmpty((List)configBomInfoJsStrList)) {
                StdCalculateHelper.updateSalOrderLogs(salOrderLogEntryIds, null, (String)"03", (Boolean)true, (String)ResManager.loadKDString((String)"\u5236\u9020\u4ea7\u54c1\u9009\u914d\u63a5\u53e3\u672a\u8fd4\u56deBOM\u7ed3\u6784\u4fe1\u606f\u3002", (String)"StdCostServiceImpl_0", (String)"macc-cad-mservice", (Object[])new Object[0]), (Long)0L);
                return;
            }
            StandCostCalcParam param = new StandCostCalcParam();
            param.setCalcDate(calcDate);
            param.setCostTypeId(String.valueOf(costTypeId));
            param.setPriceprecision(precision);
            param.setMatids(materials);
            HashMap<Long, List> manuOrgConfigBomInfoJsStrList = new HashMap<Long, List>(16);
            manuOrgConfigBomInfoJsStrList.put(manuOrg, configBomInfoJsStrList);
            param.setManuOrgConfigBomInfoJsStrList(manuOrgConfigBomInfoJsStrList);
            param.setScopetype(1);
            param.setCalcCurLevel(Boolean.TRUE.booleanValue());
            param.setAppNum("sca");
            param.setTrackCalc(Boolean.TRUE);
            param.setCheckType(1);
            param.setPriceRuleScheme(Long.valueOf(1561685000242660352L));
            param.setWizardMatScopInfos(wizardMatScopInfos);
            param.setCheckSuccessProducts(this.getCalcKelcols(wizardMatScopInfos));
            Long priceSchemeId = StdCalculateHelper.getPriceSchemeId((Long)costTypeId);
            if (!CadEmptyUtils.isEmpty((Long)priceSchemeId)) {
                param.setPriceRuleScheme(priceSchemeId);
            }
            param.setMatConfigCodeTrackNumMap(matConfigCodeTrackNumMap);
            StandCostCalculateService standCostCalculateService = new StandCostCalculateService();
            standCostCalculateService.calculateForStruct(param);
            List<String> existResultKcs = this.getExistResultKcs(param.getTaskId());
            StdCalculateHelper.updateSalOrderLogs(salOrderLogEntryIds, existResultKcs, (String)"", (Boolean)true, (String)ResManager.loadKDString((String)"\u8054\u67e5\u8ddf\u8e2a\u53f7\u6210\u672c\u81ea\u52a8\u5377\u7b97\u62a5\u544a", (String)"StdCostServiceImpl_12", (String)"macc-cad-mservice", (Object[])new Object[0]), (Long)param.getTaskId());
        }
        catch (Exception e) {
            logger.error("\u6210\u672c\u7c7b\u578b\uff1a{}\uff0c\u9500\u552e\u8ba2\u5355\u6210\u672c\u5377\u7b97\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)costTypeId, (Object)e);
            StdCalculateHelper.updateSalOrderLogs(salOrderLogEntryIds, null, (String)"03", (Boolean)true, (String)e.getMessage(), (Long)0L);
        }
        finally {
            redisBatchLock.unlock(matConfigCodeTrackNumMap.keySet());
        }
    }

    private List<String> getCalcKelcols(List<String> wizardMatScopInfos) {
        ArrayList<String> calcKeycols = new ArrayList<String>(10);
        if (CadEmptyUtils.isEmpty(wizardMatScopInfos)) {
            return calcKeycols;
        }
        for (String wizardMatScopInfo : wizardMatScopInfos) {
            String[] split = wizardMatScopInfo.split("@");
            calcKeycols.add(split[8]);
        }
        return calcKeycols;
    }

    private String getCalcLogStatus(long taskId) {
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        DynamicObjectCollection records = QueryServiceHelper.query((String)"cad_calctaskrecord", (String)"status,nextpagepara", (QFilter[])new QFilter[]{filter});
        for (DynamicObject record : records) {
            JSONObject jsonObject;
            String successCount;
            String status = record.getString("status");
            if ("1".equals(status)) {
                return "01";
            }
            if ("2".equals(status)) {
                return "03";
            }
            String nextPagePara = record.getString("nextpagepara");
            if (CadEmptyUtils.isEmpty((String)nextPagePara) || !CadEmptyUtils.isEmpty((String)(successCount = (jsonObject = JSONObject.fromObject((Object)nextPagePara)).getString("successCount")))) continue;
            return "03";
        }
        return "02";
    }

    private List<String> getExistResultKcs(Long taskId) {
        QFilter filter = new QFilter("task", "=", (Object)taskId);
        filter.and(new QFilter("entryentity.id", ">", (Object)0L));
        DynamicObjectCollection results = QueryServiceHelper.query((String)"cad_trackstdcalcresult", (String)"id,material,auxproperty,configuredcode,tracknumber", (QFilter[])new QFilter[]{filter});
        ArrayList<String> existResultMats = new ArrayList<String>(10);
        for (DynamicObject result : results) {
            String material = result.getString("material");
            String auxproperty = result.getString("auxproperty");
            String configuredcode = result.getString("configuredcode");
            String tracknumber = result.getString("tracknumber");
            String key = material + "@" + auxproperty + "@" + configuredcode + "@" + tracknumber;
            if (existResultMats.contains(key)) continue;
            existResultMats.add(key);
        }
        return existResultMats;
    }

    private QFilter getQFilter(Set<Long> orgs, Set<Long> manuOrgs) {
        Date minMonth = TimeUtils.getTime((String)"month", (LocalTime)LocalTime.MIN);
        Date maxMonth = TimeUtils.getTime((String)"month", (LocalTime)LocalTime.MAX);
        QFilter filter = new QFilter("syncdate", ">=", (Object)minMonth);
        filter.and("syncdate", "<=", (Object)maxMonth);
        String getTrackCalcLogByTransTime = CadBgParamUtils.getCadBgParamForString((String)"getTrackCalcLogByTransTime", (String)"0");
        if ("1".equals(getTrackCalcLogByTransTime)) {
            filter = new QFilter("transmittime", ">=", (Object)minMonth);
            filter.and("transmittime", "<=", (Object)maxMonth);
        }
        filter.and("status", "in", (Object)new String[]{"00", "03", "04"});
        filter.and("trytimes", "<", (Object)3);
        filter.and("org", "in", orgs);
        if (this.SALORDERLOG_REFRESHTRANSMITTIME.booleanValue()) {
            filter.and("transmittime", "is not null", null);
        }
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            filter.and("manuorg", "in", manuOrgs);
        }
        return filter;
    }

    private List<QFilter> getQFilterForUpdate(Set<Long> orgs, Set<Long> manuOrgs, boolean isNoTimes) {
        ArrayList result = Lists.newArrayList();
        Date minMonth = TimeUtils.getTime((String)"month", (LocalTime)LocalTime.MIN);
        Date maxMonth = TimeUtils.getTime((String)"month", (LocalTime)LocalTime.MAX);
        QFilter filter = new QFilter("syncdate", ">=", (Object)minMonth);
        filter.and("syncdate", "<=", (Object)maxMonth);
        String getTrackCalcLogByTransTime = CadBgParamUtils.getCadBgParamForString((String)"getTrackCalcLogByTransTime", (String)"0");
        if ("1".equals(getTrackCalcLogByTransTime)) {
            filter = new QFilter("transmittime", ">=", (Object)minMonth);
            filter.and("transmittime", "<=", (Object)maxMonth);
        }
        filter.and("org", "in", orgs);
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            filter.and("manuorg", "in", manuOrgs);
        }
        if (!isNoTimes) {
            filter.and("trytimes", "<", (Object)5);
        } else {
            filter.and("trytimes", "<", (Object)10);
        }
        QFilter qf1 = filter.copy();
        QFilter calcQF = new QFilter("status", "=", (Object)"02");
        calcQF.and("operationtype", "=", (Object)"1");
        qf1.and(calcQF);
        result.add(qf1);
        QFilter qf2 = filter.copy();
        QFilter updateQF = new QFilter("updatestatu", "=", (Object)"F");
        updateQF.and("operationtype", "=", (Object)"2");
        qf2.and(updateQF);
        result.add(qf2);
        logger.info(String.format("\u8ddf\u8e2a\u53f7\u5377\u7b97\u81ea\u52a8\u66f4\u65b0\u6761\u4ef61:%s", qf1));
        logger.info(String.format("\u8ddf\u8e2a\u53f7\u5377\u7b97\u81ea\u52a8\u66f4\u65b0\u6761\u4ef62:%s", qf2));
        return result;
    }

    private void initStdCalcBatch() {
        QFilter filter = new QFilter("key", "in", (Object)new String[]{"stdCalcBatch_billCount", "stdCalcBatch_configCode", "log_refreshTransmitTime"});
        try {
            Map params = BusinessDataServiceHelper.loadFromCache((String)"cad_bgparam", (String)"key,value", (QFilter[])new QFilter[]{filter});
            for (Map.Entry entry : params.entrySet()) {
                DynamicObject obj = (DynamicObject)entry.getValue();
                String key = obj.getString("key");
                String value = obj.getString("value");
                if ("stdCalcBatch_billCount".equals(key)) {
                    this.STDCALCBATCH_BILLCOUNT = Integer.parseInt(value);
                }
                if ("stdCalcBatch_configCode".equals(key)) {
                    this.STDCALCBATCH_CONFIGCODE = Integer.parseInt(value);
                }
                if (!"log_refreshTransmitTime".equals(key)) continue;
                this.SALORDERLOG_REFRESHTRANSMITTIME = Integer.parseInt(value) == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6279\u6b21\u5931\u8d25\u3002", (Throwable)e);
        }
    }

    private void refreshProgress(String opContent, int nowComplete, int total, Boolean isAddNum, String progressId) {
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        if (isAddNum.booleanValue()) {
            Integer complete = paramDto.getComplete();
            paramDto.setComplete(Integer.valueOf(complete + nowComplete));
            paramDto.setTotal(Integer.valueOf(paramDto.getTotal() + nowComplete));
        } else {
            paramDto.setComplete(Integer.valueOf(nowComplete));
        }
        if (!CadEmptyUtils.isEmpty((Integer)total)) {
            paramDto.setTotal(Integer.valueOf(total));
        }
        paramDto.setUnit(ResManager.loadKDString((String)"\u6b65", (String)"StdCostServiceImpl_13", (String)"macc-cad-mservice", (Object[])new Object[0]));
        paramDto.setDurationTimes(Integer.valueOf(0));
        if (nowComplete == -1) {
            paramDto.setComplete(paramDto.getTotal());
        }
        ProgressHelper.setProgressParam((String)progressId, (ProgressParamDto)paramDto);
    }
}

