/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.olap.util.Pair;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.constants.ElementConstant;
import kd.macc.cad.common.dto.SubElementAndMatReturnDataParam;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.api.SubElementAndMatService;

public class SubElementAndMatServiceImpl
implements SubElementAndMatService {
    private static final Log logger = LogFactory.getLog(SubElementAndMatServiceImpl.class);
    private static final int CACHE_EXPIRE_MINUTE = 30;
    private static Map<Long, Tuple2<Long, Tuple2<Boolean, Long[]>>> orgHasConfigSubElementMap = Maps.newConcurrentMap();

    public Map<String, Pair<Long, Long>> getAcaSubElementByOrg(Long orgId, Set<Tuple<FourTuple<Long, Long, Long, Long>, Date>> materialToDateThreeTuple) {
        HashMap<String, Pair<Long, Long>> matIdToPairMap = new HashMap<String, Pair<Long, Long>>(materialToDateThreeTuple.size());
        if (orgId == null || materialToDateThreeTuple == null) {
            logger.error("getAcaSubElementByOrg \u4f20\u5165\u53c2\u6570\u4e3a\u7a7a,\u8bf7\u68c0\u67e5" + (orgId == null ? "orgId is null" : "matIdToBookDatePairSet is null"));
            return matIdToPairMap;
        }
        HashSet<Long> matIdSet = new HashSet<Long>(materialToDateThreeTuple.size());
        Date startDate = null;
        Date endDate = null;
        for (Tuple<FourTuple<Long, Long, Long, Long>, Date> tuple : materialToDateThreeTuple) {
            Long materialId = (Long)((FourTuple)tuple.item1).item1;
            Date bookDate = (Date)tuple.item2;
            if (materialId == null || bookDate == null) continue;
            matIdSet.add(materialId);
            if (startDate == null) {
                startDate = bookDate;
            } else {
                Date date = startDate = startDate.compareTo(bookDate) > 0 ? bookDate : startDate;
            }
            if (endDate == null) {
                endDate = bookDate;
                continue;
            }
            endDate = endDate.compareTo(bookDate) > 0 ? endDate : bookDate;
        }
        SubElementAndMatReturnDataParam acaSubElementByOrg = ElementHelper.getAcaSubElementByOrg((Long)orgId, null, matIdSet, startDate, endDate);
        for (Tuple<FourTuple<Long, Long, Long, Long>, Date> tuple : materialToDateThreeTuple) {
            Long materialId = (Long)((FourTuple)tuple.item1).item1;
            Long matVersionId = (Long)((FourTuple)tuple.item1).item2;
            Long auxptyId = (Long)((FourTuple)tuple.item1).item3;
            Long manuorgId = (Long)((FourTuple)tuple.item1).item4;
            Date bookDate = (Date)tuple.item2;
            if (materialId == null || bookDate == null) continue;
            Pair matIdToBookDatePair = ElementHelper.matToSubEleAndEle((Long)materialId, (Long)matVersionId, (Long)auxptyId, (Long)manuorgId, (Date)bookDate, (SubElementAndMatReturnDataParam)acaSubElementByOrg);
            String strKey = ElementHelper.getStrKey((String)String.valueOf(materialId), (Long)matVersionId, (Long)auxptyId, (Long)manuorgId, (Date)bookDate);
            matIdToPairMap.put(strKey, (Pair<Long, Long>)matIdToBookDatePair);
        }
        return matIdToPairMap;
    }

    public Map<String, String> getAcaSubElementByOrg(Long orgId, Set<Tuple<FourTuple<Long, Long, Long, Long>, Date>> materialToDateThreeTuple, String keyFormat) {
        HashMap<String, String> matIdToPairMap = new HashMap<String, String>(materialToDateThreeTuple.size());
        if (orgId == null || materialToDateThreeTuple == null) {
            logger.error("getAcaSubElementByOrg \u4f20\u5165\u53c2\u6570\u4e3a\u7a7a,\u8bf7\u68c0\u67e5" + (orgId == null ? "orgId is null" : "matIdToBookDatePairSet is null"));
            return matIdToPairMap;
        }
        HashSet<Long> matIdSet = new HashSet<Long>(materialToDateThreeTuple.size());
        Date startDate = null;
        Date endDate = null;
        for (Tuple<FourTuple<Long, Long, Long, Long>, Date> tuple : materialToDateThreeTuple) {
            Long materialId = (Long)((FourTuple)tuple.item1).item1;
            Date bookDate = (Date)tuple.item2;
            if (materialId == null || bookDate == null) continue;
            matIdSet.add(materialId);
            if (startDate == null) {
                startDate = bookDate;
            } else {
                Date date = startDate = startDate.compareTo(bookDate) > 0 ? bookDate : startDate;
            }
            if (endDate == null) {
                endDate = bookDate;
                continue;
            }
            endDate = endDate.compareTo(bookDate) > 0 ? endDate : bookDate;
        }
        SubElementAndMatReturnDataParam acaSubElementByOrg = ElementHelper.getAcaSubElementByOrg((Long)orgId, null, matIdSet, startDate, endDate);
        for (Tuple<FourTuple<Long, Long, Long, Long>, Date> tuple : materialToDateThreeTuple) {
            String strKey;
            Long materialId = (Long)((FourTuple)tuple.item1).item1;
            Long matVersionId = (Long)((FourTuple)tuple.item1).item2;
            Long auxptyId = (Long)((FourTuple)tuple.item1).item3;
            Long manuorgId = (Long)((FourTuple)tuple.item1).item4;
            Date bookDate = (Date)tuple.item2;
            if (materialId == null || bookDate == null) continue;
            Pair matIdToBookDatePair = ElementHelper.matToSubEleAndEle((Long)materialId, (Long)matVersionId, (Long)auxptyId, (Long)manuorgId, (Date)bookDate, (SubElementAndMatReturnDataParam)acaSubElementByOrg);
            if (StringUtils.isEmpty((String)keyFormat)) {
                strKey = ElementHelper.getStrKey((String)String.valueOf(materialId), (Long)matVersionId, (Long)auxptyId, (Long)manuorgId, (Date)bookDate);
            } else {
                switch (keyFormat) {
                    case "0": {
                        strKey = ElementHelper.getStrKey((String)String.valueOf(materialId), (Long)matVersionId, (Long)auxptyId, (Long)manuorgId, null);
                        strKey = orgId + "@" + strKey;
                        break;
                    }
                    default: {
                        strKey = ElementHelper.getStrKey((String)String.valueOf(materialId), (Long)matVersionId, (Long)auxptyId, (Long)manuorgId, (Date)bookDate);
                    }
                }
            }
            if (matIdToBookDatePair == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6210\u672c\u8981\u7d20\u6210\u672c\u5b50\u8981\u7d20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SubElementAndMatServiceImpl_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
            }
            matIdToPairMap.put(strKey, matIdToBookDatePair.getValue0() + "@" + matIdToBookDatePair.getValue1());
        }
        return matIdToPairMap;
    }

    public Map<Long, Long[]> getSubElementByOrg(Long orgId, Set<Long> materialKeys, Date effectDate) {
        return this.getSubElementByOrg(orgId, materialKeys, effectDate, true);
    }

    public void clearSubElementConfigCache(Long orgId) {
        logger.info("subElementCacheMap:{}", orgHasConfigSubElementMap);
        if (orgId == null) {
            orgHasConfigSubElementMap.clear();
        } else {
            orgHasConfigSubElementMap.remove(orgId);
        }
    }

    private Tuple2<Long, Tuple2<Boolean, Long[]>> getCacheConfig(Long orgId) {
        Tuple2<Long, Tuple2<Boolean, Long[]>> configSubElementValue = orgHasConfigSubElementMap.get(orgId);
        if (configSubElementValue == null) {
            return null;
        }
        if ((Long)configSubElementValue.t1 + 1800000L < System.currentTimeMillis()) {
            return null;
        }
        return configSubElementValue;
    }

    public Map<Long, Long[]> getSubElementByOrg(Long orgId, Set<Long> materialKeys, Date effectDate, boolean isGetDefSubElement) {
        logger.info("getSubElementByOrg-\u670d\u52a1\u8c03\u7528:{}", materialKeys);
        HashSet<Long> newMaterialKeys = new HashSet<Long>(materialKeys);
        HashMap subElementMap = Maps.newHashMapWithExpectedSize((int)10);
        if (newMaterialKeys.isEmpty()) {
            return subElementMap;
        }
        HashMap matSubEleMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap groupSubEleMap = Maps.newHashMapWithExpectedSize((int)10);
        HashSet groupstandards = Sets.newHashSetWithExpectedSize((int)10);
        Tuple2<Long, Tuple2<Boolean, Long[]>> configSubElementValue = this.getCacheConfig(orgId);
        if (configSubElementValue == null || ((Boolean)((Tuple2)configSubElementValue.t2).t1).booleanValue()) {
            this.queryEffectMatSubEleMap(orgId, effectDate, matSubEleMap, groupSubEleMap, groupstandards);
        }
        for (Long key : newMaterialKeys) {
            if (!matSubEleMap.containsKey(key)) continue;
            subElementMap.put(key, matSubEleMap.get(key));
        }
        newMaterialKeys.removeAll(subElementMap.keySet());
        if (!newMaterialKeys.isEmpty() && !groupSubEleMap.isEmpty()) {
            Map<String, String> matGroupNumMap = this.queryMaterialGroupNumber(newMaterialKeys, groupstandards);
            HashMap groupToSubEMap = Maps.newHashMapWithExpectedSize((int)10);
            String longNumberDLM = this.getMaterialGroupDlm();
            for (Map.Entry<String, String> entry : matGroupNumMap.entrySet()) {
                Long[] elementArr;
                Long materialId = Long.valueOf(entry.getKey().split("@")[0]);
                String groupNumber = entry.getValue();
                if (!StringUtils.isEmpty((String)groupNumber) && !groupToSubEMap.containsKey(groupNumber)) {
                    String selectGroup = null;
                    Long[] elementArr2 = null;
                    for (Map.Entry groupEntry : groupSubEleMap.entrySet()) {
                        boolean flag = groupNumber.startsWith((String)groupEntry.getKey() + longNumberDLM) || groupNumber.equals(groupEntry.getKey());
                        if (!flag || selectGroup != null && selectGroup.length() >= ((String)groupEntry.getKey()).length()) continue;
                        selectGroup = (String)groupEntry.getKey();
                        elementArr2 = (Long[])groupEntry.getValue();
                    }
                    groupToSubEMap.put(groupNumber, elementArr2);
                }
                if ((elementArr = (Long[])groupToSubEMap.get(groupNumber)) == null) continue;
                subElementMap.put(materialId, elementArr);
            }
            newMaterialKeys.removeAll(subElementMap.keySet());
        }
        Long[] defaultSubE = null;
        defaultSubE = configSubElementValue != null ? (Long[])((Tuple2)configSubElementValue.t2).t2 : this.getDefaultSubelement();
        if (isGetDefSubElement && !newMaterialKeys.isEmpty()) {
            for (Long key : newMaterialKeys) {
                subElementMap.put(key, defaultSubE);
            }
        }
        if (configSubElementValue == null) {
            boolean isNeedQuery = !matSubEleMap.isEmpty() || !groupSubEleMap.isEmpty();
            orgHasConfigSubElementMap.put(orgId, (Tuple2<Long, Tuple2<Boolean, Long[]>>)new Tuple2((Object)System.currentTimeMillis(), (Object)new Tuple2((Object)isNeedQuery, (Object)defaultSubE)));
        }
        return subElementMap;
    }

    private String getMaterialGroupDlm() {
        DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"bd_materialgroup").getProperty("parent");
        GroupProp group = (GroupProp)property;
        String longNumberDLM = "";
        if (group instanceof ParentBasedataProp) {
            longNumberDLM = ((ParentBasedataProp)group).getLongNumberDLM();
        }
        return longNumberDLM;
    }

    private void queryEffectMatSubEleMap(Long orgId, Date effectDate, Map<Long, Long[]> matSubEleMap, Map<String, Long[]> groupSubEleMap, Set<Long> groupstandards) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("expdate", ">=", (Object)effectDate);
        filter.and("effectdate", "<=", (Object)effectDate);
        filter.and("status", "=", (Object)"C");
        Map matSubEleInfo = BusinessDataServiceHelper.loadFromCache((String)"aca_subelementandmat", (QFilter[])filter.toArray());
        HashSet subelementIds = Sets.newHashSetWithExpectedSize((int)10);
        for (DynamicObject bill : matSubEleInfo.values()) {
            Long l = bill.getLong("subelement.id");
            if (CadEmptyUtils.isEmpty((Long)l)) continue;
            subelementIds.add(l);
            Long groupstandardId = bill.getLong("groupstandard.id");
            if (CadEmptyUtils.isEmpty((Long)groupstandardId)) {
                groupstandardId = 730148448254487552L;
            }
            groupstandards.add(groupstandardId);
            DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyn : entryentity) {
                Long materialId = dyn.getLong("material.id");
                Long materialgroupId = dyn.getLong("materialgroup.id");
                String groupNumber = dyn.getString("materialgroup.longnumber");
                if (!CadEmptyUtils.isEmpty((Long)materialId)) {
                    matSubEleMap.put(materialId, new Long[]{0L, l});
                    continue;
                }
                if (CadEmptyUtils.isEmpty((Long)materialgroupId)) continue;
                groupSubEleMap.put(groupNumber, new Long[]{0L, l});
            }
        }
        if (!subelementIds.isEmpty()) {
            Long elementId;
            Map<Long, Long> subelementMap = this.getSubelementInfo(subelementIds);
            for (Map.Entry<Long, Long[]> entry : matSubEleMap.entrySet()) {
                entry.getValue()[0] = elementId = subelementMap.get(entry.getValue()[1]);
            }
            for (Map.Entry<Object, Long[]> entry : groupSubEleMap.entrySet()) {
                entry.getValue()[0] = elementId = subelementMap.get(entry.getValue()[1]);
            }
        }
    }

    private Long[] getDefaultSubelement() {
        QFilter defSubEleQf = new QFilter("element", "=", (Object)ElementConstant.MATERIAL_ID);
        defSubEleQf.and(new QFilter("subelement.defaultvalue", "=", (Object)true));
        DynamicObjectCollection subEleRels = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element, subelement", (QFilter[])new QFilter[]{defSubEleQf});
        if (!subEleRels.isEmpty()) {
            DynamicObject subEleRel = (DynamicObject)subEleRels.get(0);
            return new Long[]{subEleRel.getLong("element"), subEleRel.getLong("subelement")};
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6210\u672c\u8981\u7d20\u201c\u7269\u6599\u201d\u9ed8\u8ba4\u7684\u6210\u672c\u5b50\u8981\u7d20\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SubElementAndMatServiceImpl_1", (String)"macc-cad-mservice", (Object[])new Object[0]));
    }

    private Map<Long, Long> getSubelementInfo(Set<Long> subElementSetIds) {
        HashMap<Long, Long> subEleToEleMap = new HashMap<Long, Long>(10);
        QFilter subQf = new QFilter("subelement", "in", subElementSetIds);
        if (!subElementSetIds.isEmpty()) {
            DynamicObjectCollection subEleRels = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element, subelement", (QFilter[])new QFilter[]{subQf});
            subEleRels.forEach(s -> subEleToEleMap.put(s.getLong("subelement"), s.getLong("element")));
        }
        return subEleToEleMap;
    }

    private Map<String, String> queryMaterialGroupNumber(Set<Long> materialIds, Set<Long> materialgroupIds) {
        QFilter filter = new QFilter("material", "in", materialIds);
        filter.and("standard", "in", materialgroupIds);
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"group.number as groupnumber,group.longnumber longnumber,material,standard", (QFilter[])filter.toArray(), (String)"group desc");
        HashMap matGroupNumMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Row row : materialDataSet) {
            matGroupNumMap.put(String.format("%s@%s", row.getLong("material"), row.getLong("standard")), row.getString("longnumber"));
        }
        return matGroupNumMap;
    }
}

