/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.business.bom.SyncBomHandle;

public class SyncCostBomService {
    private static final Log logger = LogFactory.getLog(SyncCostBomService.class);

    public String syncCostBom(String params) {
        logger.info("\u8fdb\u5165\u540c\u6b65\u65b9\u6cd5syncCostBom\uff0c\u53c2\u6570\uff1a{}", (Object)params);
        JSONObject param = JSON.parseObject((String)params);
        String entity = param.getString("entity");
        JSONArray bomIds = param.getJSONArray("bomIds");
        if (bomIds == null || bomIds.isEmpty()) {
            return ResManager.loadKDString((String)"bomIds\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u540c\u6b65\u3002", (String)"SyncCostBomService_1", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        try {
            SyncBomHandle.syncBom((String)entity, (List)bomIds);
            logger.info("\u540c\u6b65\u6210\u529f");
            return ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"SyncCostBomService_2", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        catch (Exception e) {
            logger.info("\u540c\u6b65\u5931\u8d25\uff0c\u5f00\u59cb\u8bb0\u5f55\u540c\u6b65\u65e5\u5fd7");
            this.addSyncLog((List<Object>)bomIds, this.parseMsg(e, 2000));
            logger.info("\u540c\u6b65\u5931\u8d25\uff0c\u8bb0\u5f55\u540c\u6b65\u65e5\u5fd7\u6210\u529f");
            return ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u6210\u672cBOM\u540c\u6b65\u5931\u8d25\u65e5\u5fd7\u3002", (String)"SyncCostBomService_5", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
    }

    private String parseMsg(Exception e, int size) {
        return this.parseMsg(e, size, e.getMessage());
    }

    private String parseMsg(Exception e, int size, String shotMsg) {
        if (shotMsg == null) {
            shotMsg = e.getMessage();
        }
        StringBuilder msgStr = new StringBuilder();
        msgStr.append(shotMsg);
        StackTraceElement[] stackTrace = e.getStackTrace();
        int len = stackTrace.length;
        for (int i = 0; i < len; ++i) {
            if (msgStr.length() > size) {
                msgStr.setLength(size);
                break;
            }
            msgStr.append("\r\n at ").append(stackTrace[i]);
        }
        return msgStr.toString();
    }

    private void addSyncLog(List<Object> productBomIds, String msg) {
        Date now = TimeServiceHelper.now();
        Long user = Long.valueOf(RequestContext.getOrCreate().getUserId());
        DynamicObject[] logs = new DynamicObject[productBomIds.size()];
        int i = 0;
        for (Object bomId : productBomIds) {
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"cad_syncbom_log");
            logs[i++] = log;
            log.set("creater", (Object)user);
            log.set("msg", (Object)msg);
            log.set("synctime", (Object)now);
            log.set("productbom", bomId);
        }
        try (TXHandle tx = TX.requiresNew((String)"kd.macc.cad.mservice.SyncCostBomService.addSyncLog");){
            SaveServiceHelper.save((DynamicObject[])logs);
        }
    }
}

