/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SyncCostBomServiceHelper {
    private static final Log logger = LogFactory.getLog(SyncCostBomServiceHelper.class);

    public static void syncCostBom(String entity, List<Object> productBomIds) {
        logger.info("\u5f00\u59cb\u8c03\u7528\u540c\u6b65\u6210\u672cBOM\u670d\u52a1");
        try {
            String param = SyncCostBomServiceHelper.packageParam(entity, productBomIds);
            Object msg = DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"syncCostBomService", (String)"syncCostBom", (Object[])new Object[]{param});
            logger.info("\u540c\u6b65\u6210\u672cBOM\u670d\u52a1\u6210\u529f,\u8fd4\u56de\u7ed3\u679c\uff1a{}", msg);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u6210\u672cBOM\u670d\u52a1\u5931\u8d25\uff1a", (Throwable)e);
            logger.error("\u5f00\u59cb\u8bb0\u5f55\u5931\u8d25\u65e5\u5fd7");
            SyncCostBomServiceHelper.addSyncLog(productBomIds, SyncCostBomServiceHelper.parseMsg(e, 2000));
            logger.error("\u6210\u529f\u8bb0\u5f55\u5931\u8d25\u65e5\u5fd7");
        }
    }

    private static String packageParam(String entity, List<Object> productBomIds) {
        JSONObject param = new JSONObject();
        param.put("bomIds", productBomIds);
        param.put("entity", (Object)entity);
        return param.toJSONString();
    }

    private static String parseMsg(Exception e, int size) {
        return SyncCostBomServiceHelper.parseMsg(e, size, e.getMessage());
    }

    private static String parseMsg(Exception e, int size, String shotMsg) {
        if (shotMsg == null) {
            shotMsg = e.getMessage();
        }
        StringBuilder msgStr = new StringBuilder();
        msgStr.append(shotMsg);
        StackTraceElement[] stackTrace = e.getStackTrace();
        int len = stackTrace.length;
        for (int i = 0; i < len; ++i) {
            if (msgStr.length() > size) {
                msgStr.setLength(size);
                break;
            }
            msgStr.append("\r\n at ").append(stackTrace[i]);
        }
        return msgStr.toString();
    }

    private static void addSyncLog(List<Object> productBomIds, String msg) {
        Date now = TimeServiceHelper.now();
        Long user = Long.valueOf(RequestContext.getOrCreate().getUserId());
        DynamicObject[] logs = new DynamicObject[productBomIds.size()];
        int i = 0;
        for (Object bomId : productBomIds) {
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"cad_syncbom_log");
            logs[i++] = log;
            log.set("creater", (Object)user);
            log.set("msg", (Object)msg);
            log.set("synctime", (Object)now);
            log.set("productbom", bomId);
        }
        try (TXHandle tx = TX.requiresNew((String)"kd.macc.cad.mservice.SyncCostBomService.addSyncLog");){
            SaveServiceHelper.save((DynamicObject[])logs);
        }
    }
}

