/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.business.router.SyncRouterHandle;

public class SyncCostRouterService {
    private static final Log logger = LogFactory.getLog(SyncCostRouterService.class);

    public String syncCostRouter(String params) {
        logger.info("\u8fdb\u5165\u540c\u6b65\u65b9\u6cd5syncCostRouter\uff0c\u53c2\u6570" + params);
        JSONObject param = JSON.parseObject((String)params);
        String entity = param.getString("entity");
        JSONArray routerIds = param.getJSONArray("routerIds");
        if (routerIds == null || routerIds.isEmpty()) {
            return ResManager.loadKDString((String)"routerIds\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u540c\u6b65\u3002", (String)"SyncCostRouterService_0", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        try {
            SyncRouterHandle.syncRouter((String)entity, (List)routerIds);
            logger.info("\u540c\u6b65\u6210\u529f");
            return ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"SyncCostRouterService_1", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        catch (Exception e) {
            logger.info("\u540c\u6b65\u5931\u8d25\uff0c\u5f00\u59cb\u8bb0\u5f55\u540c\u6b65\u65e5\u5fd7");
            this.addSyncLog((List<Object>)routerIds, this.parseMsg(e, 2000));
            logger.info("\u540c\u6b65\u5931\u8d25\uff0c\u8bb0\u5f55\u540c\u6b65\u65e5\u5fd7\u6210\u529f");
            return ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u6210\u672c\u5de5\u827a\u8def\u7ebf\u540c\u6b65\u5931\u8d25\u65e5\u5fd7\u3002", (String)"SyncCostRouterService_2", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
    }

    private String parseMsg(Exception e, int size) {
        return this.parseMsg(e, size, e.getMessage());
    }

    private String parseMsg(Exception e, int size, String message) {
        if (message == null) {
            message = e.getMessage();
        }
        StringBuilder msgStr = new StringBuilder();
        msgStr.append(message);
        StackTraceElement[] stackTrace = e.getStackTrace();
        int len = stackTrace.length;
        for (int i = 0; i < len; ++i) {
            if (msgStr.length() > size) {
                msgStr.setLength(size);
                break;
            }
            msgStr.append("\r\n at").append(stackTrace[i]);
        }
        return msgStr.toString();
    }

    private void addSyncLog(List<Object> productRouterIds, String msg) {
        Date now = TimeServiceHelper.now();
        Long user = Long.valueOf(RequestContext.getOrCreate().getUserId());
        DynamicObject[] logs = new DynamicObject[productRouterIds.size()];
        int i = 0;
        for (Object routerId : productRouterIds) {
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"cad_syncrouter_log");
            logs[i++] = log;
            log.set("creater", (Object)user);
            log.set("msg", (Object)msg);
            log.set("synctime", (Object)now);
            log.set("productrouter", routerId);
        }
        try (TXHandle txHandle = TX.requiresNew((String)"kd.macc.cad.mservice.SyncCostRouterService.addSyncLog");){
            SaveServiceHelper.save((DynamicObject[])logs);
        }
    }
}

