/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SyncCostRouterServiceHelper {
    private static final Log logger = LogFactory.getLog(SyncCostRouterServiceHelper.class);

    public static void syncCostRouter(String entity, List<Object> productRouterIds) {
        logger.info("\u5f00\u59cb\u8c03\u7528\u540c\u6b65\u6210\u672c\u5de5\u827a\u8def\u7ebf\u670d\u52a1");
        try {
            String param = SyncCostRouterServiceHelper.packageParam(entity, productRouterIds);
            Object msg = DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"syncCostRouterService", (String)"syncCostRouter", (Object[])new Object[]{param});
            logger.info("\u540c\u6b65\u6210\u672c\u5de5\u827a\u8def\u7ebf\u670d\u52a1\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a" + msg);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u6210\u672c\u5de5\u827a\u8def\u7ebf\u670d\u52a1\u5931\u8d25\uff1a", (Throwable)e);
            logger.error("\u5f00\u59cb\u8bb0\u5f55\u5931\u8d25\u65e5\u5fd7");
            SyncCostRouterServiceHelper.addSyncLog(productRouterIds, SyncCostRouterServiceHelper.parseMsg(e, 2000));
            logger.error("\u6210\u529f\u8bb0\u5f55\u5931\u8d25\u65e5\u5fd7");
        }
    }

    private static String packageParam(String entity, List<Object> productRouterIds) {
        JSONObject param = new JSONObject();
        param.put("routerIds", productRouterIds);
        param.put("entity", (Object)entity);
        return param.toJSONString();
    }

    private static String parseMsg(Exception e, int size) {
        return SyncCostRouterServiceHelper.parseMsg(e, size, e.getMessage());
    }

    private static String parseMsg(Exception e, int size, String message) {
        if (message == null) {
            message = e.getMessage();
        }
        StringBuilder msgStr = new StringBuilder();
        msgStr.append(message);
        StackTraceElement[] stackTrace = e.getStackTrace();
        int len = stackTrace.length;
        for (int i = 0; i < len; ++i) {
            if (msgStr.length() > size) {
                msgStr.setLength(size);
                break;
            }
            msgStr.append("\r\n at").append(stackTrace[i]);
        }
        return msgStr.toString();
    }

    private static void addSyncLog(List<Object> productRouterIds, String msg) {
        Date now = TimeServiceHelper.now();
        Long user = Long.valueOf(RequestContext.getOrCreate().getUserId());
        DynamicObject[] logs = new DynamicObject[productRouterIds.size()];
        int i = 0;
        for (Object routerId : productRouterIds) {
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"cad_syncrouter_log");
            logs[i++] = log;
            log.set("creater", (Object)user);
            log.set("msg", (Object)msg);
            log.set("synctime", (Object)now);
            log.set("productrouter", routerId);
        }
        try (TXHandle txHandle = TX.requiresNew((String)"kd.macc.cad.mservice.SyncCostRouterService.addSyncLog");){
            SaveServiceHelper.save((DynamicObject[])logs);
        }
    }
}

