/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.macc.cad.algox.function.TimeUtils;

public class TimelineUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(TimelineUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            String inTypeSql = "select fid,feffectdate,fexpdate from t_cad_bomsetting  where fnumber in ( select max(fnumber) from t_cad_bomsetting group by fcosttypeid,fmaterialid)";
            this.update("t_cad_bomsetting", "cad_bomsetting", inTypeSql);
            inTypeSql = "select fid,feffectdate,fexpdate from t_cad_resourcerate  where fbillno in ( select max(fbillno) from t_cad_resourcerate group by fcosttypeid,fresourceid)";
            this.update("t_cad_resourcerate", "cad_resourcerate", inTypeSql);
            inTypeSql = "select fid,feffectdate,fexpdate from t_cad_outsourceprice  where fbillno in ( select max(fbillno) from t_cad_outsourceprice group by fcosttypeid,fmaterialid)";
            this.update("t_cad_outsourceprice", "cad_outsourceprice", inTypeSql);
            inTypeSql = "select fid,feffectdate,fexpdate from t_cad_routersetting where fnumber in ( select max(fnumber) from t_cad_routersetting group by fcosttypeid,frouterid)";
            this.update("t_cad_routersetting", "cad_routersetting", inTypeSql);
            inTypeSql = "select fid,feffectdate,fexpdate from t_cad_purprices  where fbillno in ( select max(fbillno) from t_cad_purprices group by fcosttypeid,fmaterialid)";
            this.update("t_cad_purprices", "cad_purprices", inTypeSql);
            logger.info("\u6240\u6709\u6570\u636e\u5347\u7ea7\u6210\u529f");
            result.setLog(ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u5347\u7ea7\u5347\u7ea7\u6210\u529f\u3002", (String)"TimelineUpgradeService_1", (String)"macc-cad-mservice", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
            result.setSuccess(false);
            result.setErrorInfo(e.getMessage());
        }
        return result;
    }

    private void update(String table, String entity, String inTypeSql) {
        try (TXHandle tx = TX.requiresNew((String)"kd.macc.cad.mservice.TimelineUpgradeService");){
            try {
                MainEntityType inTypeDt = EntityMetadataCache.getDataEntityType((String)entity);
                DBRoute dBRoute = DBRoute.of((String)inTypeDt.getDBRouteKey());
                DataSet inTypeData = DB.queryDataSet((String)this.getAlgoKey(entity), (DBRoute)dBRoute, (String)inTypeSql).filter("feffectdate is null or fexpdate is null");
                StringBuilder strBuild = new StringBuilder();
                int num = 0;
                while (inTypeData.hasNext()) {
                    Row next = inTypeData.next();
                    strBuild.append(next.getLong("fid")).append(",");
                    if (num++ < 998) continue;
                    num = 0;
                    this.updateBillData(strBuild.toString(), dBRoute, table);
                    strBuild.delete(0, strBuild.toString().length());
                }
                if (num > 0) {
                    this.updateBillData(strBuild.toString(), dBRoute, table);
                }
            }
            catch (Exception e) {
                logger.error(entity + "\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
                tx.markRollback();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u5347\u7ea7\u5931\u8d25\u3002", (String)"TimelineUpgradeService_3", (String)"macc-cad-mservice", (Object[])new Object[0]), entity));
            }
        }
    }

    private void updateBillData(String idString, DBRoute dBRoute, String tableName) {
        idString = idString.length() > 0 ? idString.substring(0, idString.length() - 1) : idString;
        String updateSql = "update " + tableName + " set feffectdate =  ?, fexpdate = ? where fid in (" + idString + ")";
        DB.execute((DBRoute)dBRoute, (String)updateSql, (Object[])new Object[]{TimeUtils.getDefaultEffectDate(), TimeUtils.getDeFaultExpDate()});
    }

    private String getAlgoKey(String methodName) {
        return this.getClass().getName() + "." + methodName;
    }
}

