/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.calcdatachange;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.mservice.calcdatachange.BaseCalcDataChangeService;

public abstract class AbstractBaseCalcDataChangeService
implements BaseCalcDataChangeService {
    private final List<String> opKeyList = new ArrayList<String>(Arrays.asList("audit", "unaudit", "enable", "disable", "doprice", "refreshdata", "stdratesetting", "sync"));
    private final List<String> validEntityList = new ArrayList<String>(Arrays.asList("cad_bomsetting", "cad_routersetting", "cad_purprices", "cad_outsourceprice", "cad_resourcerate"));

    public boolean checkDataValid(String entityName, String opKey) {
        if (StringUtils.isNotBlank((CharSequence)entityName) && StringUtils.isNotBlank((CharSequence)opKey)) {
            return this.opKeyList.contains(opKey) && this.validEntityList.contains(entityName);
        }
        return false;
    }

    protected DynamicObject[] getDynamicObjectsByPks(String entityName, List<Object> pks) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", pks)};
        return BusinessDataServiceHelper.load((String)entityName, (String)String.join((CharSequence)",", this.getPropertiesByEntity(entityName)), (QFilter[])filters);
    }

    protected DynamicObject createNewChangedData(DynamicObject data, String opKey, Date time, Long userId, Long matId) {
        DynamicObject calcChangeData = BusinessDataServiceHelper.newDynamicObject((String)"cad_calchangerecord");
        calcChangeData.set("material_id", (Object)matId);
        this.setCommonValues(data.getDynamicObjectType().getName(), opKey, time, userId, data.getLong("costtype.id"), calcChangeData);
        this.handleDiffValues(data, calcChangeData);
        return calcChangeData;
    }

    private void setCommonValues(String entityName, String opKey, Date time, Long userId, Long costTypeId, DynamicObject calcChangeData) {
        calcChangeData.set("billno", (Object)("NO." + System.currentTimeMillis()));
        calcChangeData.set("costtype_id", (Object)costTypeId);
        calcChangeData.set("businessbill", (Object)entityName);
        calcChangeData.set("changeop", (Object)opKey);
        calcChangeData.set("status", (Object)"A");
        calcChangeData.set("billstatus", (Object)"C");
        calcChangeData.set("createtime", (Object)time);
        calcChangeData.set("modifytime", (Object)time);
        calcChangeData.set("auditdate", (Object)time);
        calcChangeData.set("creator_id", (Object)userId);
        calcChangeData.set("modifier_id", (Object)userId);
        calcChangeData.set("auditor_id", (Object)userId);
    }

    public abstract void handleDiffValues(DynamicObject var1, DynamicObject var2);
}

