/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.calcdatachange.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.calcdatachange.AbstractBaseCalcDataChangeService;

public class OutSourcePriceDataChangeServiceImpl
extends AbstractBaseCalcDataChangeService {
    @Override
    public List<String> getPropertiesByEntity(String entityName) {
        List<String> propertyList = super.getPropertiesByEntity(entityName);
        propertyList.add("billno");
        propertyList.add("material");
        propertyList.add("matversion");
        propertyList.add("auxpty");
        propertyList.add("keycol");
        propertyList.add("keycolid");
        return propertyList;
    }

    @Override
    public int saveChangedDatasBySource(String entityName, List<Object> pks, String opKey) {
        if (!this.checkDataValid(entityName, opKey)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u201c%1$s\u201d\u6216\u64cd\u4f5c\u201c%2$s\u201d\u4e0d\u5c5e\u4e8e\u5377\u7b97\u53d8\u66f4\u8bb0\u5f55\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OutSourcePriceDataChangeServiceImpl_1", (String)"macc-cad-mservice", (Object[])new Object[0]), entityName, opKey));
        }
        DynamicObject[] datas = this.getDynamicObjectsByPks(entityName, pks);
        ArrayList<DynamicObject> calcChangedDatas = new ArrayList<DynamicObject>(datas.length);
        Date time = TimeServiceHelper.now();
        Long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject data : datas) {
            calcChangedDatas.add(this.createNewChangedData(data, opKey, time, userId, data.getLong("material.masterid")));
        }
        if (!CadEmptyUtils.isEmpty(calcChangedDatas)) {
            return SaveServiceHelper.save((DynamicObject[])calcChangedDatas.toArray(new DynamicObject[0])).length;
        }
        return 0;
    }

    @Override
    public void handleDiffValues(DynamicObject source, DynamicObject target) {
        target.set("srcbillno", (Object)source.getString("billno"));
        if (null != source.get("matversion")) {
            target.set("matvers_id", (Object)source.getLong("matversion.id"));
        } else {
            target.set("matvers_id", (Object)0L);
        }
        if (null != source.get("auxpty")) {
            target.set("auxproperty_id", (Object)source.getLong("auxpty.id"));
        } else {
            target.set("auxproperty_id", (Object)0L);
        }
        target.set("keycol", (Object)source.getString("keycol"));
        target.set("keycolid_id", (Object)source.getLong("keycolid.id"));
    }
}

