/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.calcdatachange.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.calcdatachange.AbstractBaseCalcDataChangeService;

public class ResourceRateDataChangeServiceImpl
extends AbstractBaseCalcDataChangeService {
    private static final Log logger = LogFactory.getLog(ResourceRateDataChangeServiceImpl.class);

    @Override
    public List<String> getPropertiesByEntity(String entityName) {
        List<String> propertyList = super.getPropertiesByEntity(entityName);
        propertyList.add("billno");
        propertyList.add("material");
        return propertyList;
    }

    @Override
    public int saveChangedDatasBySource(String entityName, List<Object> pks, String opKey) {
        if (!this.checkDataValid(entityName, opKey)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u201c%1$s\u201d\u6216\u64cd\u4f5c\u201c%2$s\u201d\u4e0d\u5c5e\u4e8e\u5377\u7b97\u53d8\u66f4\u8bb0\u5f55\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ResourceRateDataChangeServiceImpl_1", (String)"macc-cad-mservice", (Object[])new Object[0]), entityName, opKey));
        }
        DynamicObject[] datas = this.getDynamicObjectsByPks(entityName, pks);
        ArrayList<DynamicObject> calcChangedDatas = new ArrayList<DynamicObject>(datas.length);
        Date time = TimeServiceHelper.now();
        Long userId = RequestContext.get().getCurrUserId();
        HashSet<Object> ids = new HashSet<Object>(datas.length);
        for (DynamicObject data : datas) {
            ids.add(data.getLong("id"));
        }
        Map<String, Set<Long>> resMatMap = this.getResourceRelatedMatIds(ids, datas[0].getLong("costtype.id"));
        for (DynamicObject data : datas) {
            String billNo = data.getString("billno");
            if (!resMatMap.containsKey(billNo)) continue;
            for (Long matId : resMatMap.get(billNo)) {
                calcChangedDatas.add(this.createNewChangedData(data, opKey, time, userId, matId));
            }
        }
        if (!CadEmptyUtils.isEmpty(calcChangedDatas)) {
            // empty if block
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<Long>> getResourceRelatedMatIds(Set<Object> ids, Long costTypeId) {
        HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>(16);
        QFilter costTypeFilter = new QFilter("costtype", "=", (Object)costTypeId);
        if (null != ids && ids.size() > 0) {
            QFilter idFilter = new QFilter("id", "in", ids);
            DataSet resRates = null;
            DataSet routers = null;
            DataSet routerSettings = null;
            DataSet materialsByNotUseAuxpty = null;
            try {
                resRates = QueryServiceHelper.queryDataSet((String)"BaseCalcDataChangedHelper#cad_resourcerate", (String)"cad_resourcerate", (String)"billno,resource", (QFilter[])new QFilter[]{costTypeFilter, idFilter}, null);
                QFilter routerFilter = new QFilter("processentry.actentryentity.actresource", "in", this.getListByKey(resRates, "resource"));
                routers = QueryServiceHelper.queryDataSet((String)"BaseCalcDataChangedHelper#cad_router", (String)"cad_router", (String)"id as routerid,processentry.actentryentity.actresource as resource", (QFilter[])new QFilter[]{routerFilter}, null);
                QFilter typeFilter = new QFilter("routertype", "=", (Object)"A");
                routerSettings = QueryServiceHelper.queryDataSet((String)"BaseCalcDataChangedHelper#cad_routersetting", (String)"cad_routersetting", (String)"router,materialentry.material as material", (QFilter[])new QFilter[]{costTypeFilter, typeFilter}, null);
                QFilter mauxptyFilter = new QFilter("isuseauxpty", "=", (Object)"0");
                materialsByNotUseAuxpty = QueryServiceHelper.queryDataSet((String)"BaseCalcDataChangedHelper#bd_material", (String)"bd_material", (String)"masterid as materialid", (QFilter[])new QFilter[]{mauxptyFilter}, null);
                resRates = resRates.join(routers, JoinType.INNER).on("resource", "resource").select(new String[]{"billno", "routerid"}).finish().join(routerSettings, JoinType.LEFT).on("routerid", "router").select(new String[]{"billno", "material"}).finish().filter("material<>0 and material is not null").join(materialsByNotUseAuxpty, JoinType.INNER).on("material", "materialid").select(new String[]{"billno", "material"}).finish();
                while (resRates.hasNext()) {
                    Row row = resRates.next();
                    Set matIds = resultMap.computeIfAbsent(row.getString("billno"), s -> new HashSet());
                    if (null == row.getLong("material")) continue;
                    matIds.add(row.getLong("material"));
                }
                logger.info("\u8d44\u6e90\u5173\u8054\u7684\u7269\u6599\uff1a" + resultMap);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u8d44\u6e90\u5173\u8054\u7684\u7269\u6599\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            }
            finally {
                if (null != resRates) {
                    resRates.close();
                }
                if (null != routers) {
                    routers.close();
                }
                if (null != routerSettings) {
                    routerSettings.close();
                }
                if (null != materialsByNotUseAuxpty) {
                    materialsByNotUseAuxpty.close();
                }
            }
        }
        return resultMap;
    }

    private List<Object> getListByKey(DataSet ds, String keyName) {
        ArrayList<Object> result = new ArrayList<Object>(16);
        try (DataSet temp = ds.copy();){
            while (temp.hasNext()) {
                Row row = temp.next();
                result.add(row.get(keyName));
            }
        }
        return result;
    }

    @Override
    public void handleDiffValues(DynamicObject source, DynamicObject target) {
        target.set("srcbillno", (Object)source.getString("billno"));
    }
}

