/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.costobject;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.dto.ProgressParamDto;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.costobject.CostObjectContext;
import kd.macc.cad.mservice.costobject.ICostObjectAction;

public abstract class AbstractCostObjectAction
implements ICostObjectAction {
    private CostObjectContext costObjectContext;

    @Override
    public void execute() {
        if (this.costObjectContext.isContinueExecute()) {
            this.doExecute();
        }
    }

    protected abstract void doExecute();

    public CostObjectContext getCostObjectContext() {
        return this.costObjectContext;
    }

    @Override
    public void setContext(CostObjectContext costObjectContext) {
        this.costObjectContext = costObjectContext;
    }

    protected void refreshProgress(String opContent, int nowComplete, int total, Boolean isAddNum) {
        CostObjectContext costObjectContext = this.getCostObjectContext();
        String progressId = costObjectContext.getCostObjectArgs().getProgressId();
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        if (isAddNum.booleanValue()) {
            Integer complete = paramDto.getComplete();
            paramDto.setComplete(Integer.valueOf(complete + nowComplete));
        } else {
            paramDto.setComplete(Integer.valueOf(nowComplete));
        }
        if (!CadEmptyUtils.isEmpty((Integer)total)) {
            paramDto.setTotal(Integer.valueOf(total));
        }
        paramDto.setUnit(ResManager.loadKDString((String)"\u6b65", (String)"AbstractCostObjectAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
        paramDto.setDurationTimes(Integer.valueOf(0));
        if (nowComplete == -1) {
            paramDto.setComplete(paramDto.getTotal());
        }
        ProgressHelper.setProgressParam((String)progressId, (ProgressParamDto)paramDto);
        this.setReportPressAndDur(progressId);
    }

    private void setReportPressAndDur(String progressId) {
        Date coldate;
        int progress = this.getProgress(progressId);
        Long id = this.getCostObjectContext().getCollectReport().getId();
        String duration = "";
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_colreport", (String)"coldate", (QFilter[])qFilter.toArray());
        if (dynamicObject != null && (coldate = dynamicObject.getDate("coldate")) != null) {
            double time = (double)(System.currentTimeMillis() - coldate.getTime()) / 1000.0;
            if (0.0 < time && time < 1.0) {
                time = 1.0;
            }
            duration = String.valueOf((int)time);
        }
        try (TXHandle handle = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cad_colreport set fprogress=" + progress + ",fduration=" + duration + " where fid =" + id));
        }
    }

    public int getProgress(String progressId) {
        if (StringUtils.isEmpty((CharSequence)progressId)) {
            return 0;
        }
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return 0;
        }
        if (CadEmptyUtils.isEmpty((Integer)paramDto.getTotal()) || CadEmptyUtils.isEmpty((Integer)paramDto.getComplete())) {
            return 0;
        }
        return (int)((double)paramDto.getComplete().intValue() / (double)paramDto.getTotal().intValue() * 100.0);
    }
}

