/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.costobject;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.CostObjectProductGroupHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.costobject.BaseImportDataAction;
import kd.macc.cad.mservice.costobject.CostObjectArgs;

public class AcaCostObjectImportDataAction
extends BaseImportDataAction {
    private Log logger = LogFactory.getLog(AcaCostObjectImportDataAction.class);

    @Override
    protected void doExecute() {
        super.doExecute();
        CostObjectArgs collectionArgs = this.getCostObjectContext().getCostObjectArgs();
        Map<Long, List<Long>> acctOrgCostCentersMap = collectionArgs.getAcctOrgCostCentersMap();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getCostObjectContext().getConfigSrcAndTargetBillsMap();
        acctOrgCostCentersMap.forEach((acctOrgId, costCenters) -> {
            Map<String, DynamicObject> objRules = this.getCostObjectContext().getAcctOrgObjRules();
            List<Long> reProduceCostCenters = this.getCostObjectContext().getAcctOrgCalmethodCostCenters().get(acctOrgId + CostObjectEnum.BIZTYPE_RO.getValue());
            if (CadEmptyUtils.isEmpty(reProduceCostCenters)) {
                this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u5de5\u5355\u6210\u672c\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f15\u5165\u7ed3\u675f\uff01", acctOrgId);
                return;
            }
            this.getCostObjectContext().getCollectReport().setReProCostCenters(reProduceCostCenters);
            for (Map.Entry configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
                DynamicObject config = (DynamicObject)configSrcAndTargetBill.getKey();
                String sourcebill = config.getString("sourcebill.id");
                String sourcebillName = config.getString("sourcebill.name");
                if (!CostObjectEnum.BIZTYPE_RO.getValue().equals(config.getString("calmethod")) || !"pom_mftorder".equals(sourcebill) && !"om_mftorder".equals(sourcebill)) continue;
                Map srcAndTargetBillsMap = (Map)configSrcAndTargetBill.getValue();
                ArrayList<DynamicObject> proBills = new ArrayList<DynamicObject>(srcAndTargetBillsMap.keySet());
                this.getCostObjectContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u67e5\u8be2%s", (String)"AcaCostObjectImportDataAction_17", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName));
                this.getCostObjectContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u201c%1$s\u201d%2$s\u6761\u6570\u636e\u3002", (String)"AcaCostObjectImportDataAction_18", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName, proBills.size()));
                if (CadEmptyUtils.isEmpty(proBills)) {
                    this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u5f52\u96c6\u914d\u7f6e\u65b9\u6848:{},\u672a\u83b7\u53d6\u5230\u6e90\u5355\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f15\u5165\u7ed3\u675f!", acctOrgId, (Object)config.getString("number"));
                    continue;
                }
                this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u5f52\u96c6\u914d\u7f6e\u65b9\u6848:{},\u83b7\u53d6\u5230\u7684\u6e90\u5355\u6761\u6570:{}", new Object[]{acctOrgId, config.getString("number"), proBills.size()});
                ArrayList<Long> probillIds = new ArrayList<Long>(10);
                ArrayList<Long> entryIds = new ArrayList<Long>(proBills.size());
                for (DynamicObject proBill : proBills) {
                    probillIds.add(proBill.getLong("entryId"));
                    entryIds.add(proBill.getLong("entryId"));
                }
                Map existEntryIdMainObjMap = CostObjectProductGroupHelper.getExistEntryIdMainObjMap((Long)acctOrgId, (List)costCenters, entryIds);
                HashMap probillCostcenterMap = Maps.newHashMapWithExpectedSize((int)10);
                Map existCostObjectManuEntryIdsMap = CostObjectHelper.getExistCostObjectManuEntryIdsMap((Long)acctOrgId, (List)costCenters, probillIds, (Map)probillCostcenterMap);
                this.getCostObjectContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61/\u4ea7\u54c1\u7ec4\u3002", (String)"AcaCostObjectImportDataAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                this.generateObjAndGroup(String.valueOf(acctOrgId), reProduceCostCenters, srcAndTargetBillsMap, proBills, config, objRules, this.getCostObjectContext().getCostObjectBills(), this.getCostObjectContext().getUpdateCostObjectBills(), this.getCostObjectContext().getProductGroups(), this.getCostObjectContext().getPgMainMap(), this.getCostObjectContext().getEntryIdMainObjMap(), existEntryIdMainObjMap, existCostObjectManuEntryIdsMap, this.getCostObjectContext(), probillCostcenterMap);
                this.getCostObjectContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%1$s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61%2$s\u4e2a\u3002", (String)"AcaCostObjectImportDataAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number"), this.getCostObjectContext().getCostObjectBills().size()));
            }
        });
    }
}

