/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.costobject;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.costobject.BaseImportDataAction;
import kd.macc.cad.mservice.costobject.CostObjectArgs;

public class AcaCostObjectImportForPZAction
extends BaseImportDataAction {
    private Log logger = LogFactory.getLog(AcaCostObjectImportForPZAction.class);

    @Override
    protected void doExecute() {
        CostObjectArgs collectionArgs = this.getCostObjectContext().getCostObjectArgs();
        Map<Long, List<Long>> acctOrgCostCentersMap = collectionArgs.getAcctOrgCostCentersMap();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getCostObjectContext().getConfigSrcAndTargetBillsMap();
        ArrayList costObjectItems = new ArrayList(1000);
        acctOrgCostCentersMap.forEach((acctOrgId, costCenters) -> {
            Map<String, DynamicObject> objRules = this.getCostObjectContext().getAcctOrgObjRules();
            List<Long> acctOrgPZCostCenters = this.getCostObjectContext().getAcctOrgCalmethodCostCenters().get(acctOrgId + CostObjectEnum.BIZTYPE_PZ.getValue());
            if (CadEmptyUtils.isEmpty(acctOrgPZCostCenters)) {
                this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u54c1\u79cd\u6cd5\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f15\u5165\u7ed3\u675f\uff01", acctOrgId);
                return;
            }
            this.getCostObjectContext().getCollectReport().setPzCostCenters(acctOrgPZCostCenters);
            Map existCostObjectMaterialIdsMap = CostObjectHelper.getExistCostObjectMaterialMap((Long)acctOrgId, acctOrgPZCostCenters, (Boolean)false);
            for (Map.Entry configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
                DynamicObject config = (DynamicObject)configSrcAndTargetBill.getKey();
                String sourcebill = config.getString("sourcebill.id");
                if (!CostObjectEnum.BIZTYPE_PZ.getValue().equals(config.getString("calmethod"))) continue;
                this.getCostObjectContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"AcaCostObjectImportForPZAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                Map srcAndTargetBillsMap = (Map)configSrcAndTargetBill.getValue();
                ArrayList srcBills = new ArrayList(srcAndTargetBillsMap.keySet());
                int count = 0;
                HashSet<Long> allMatIds = new HashSet<Long>();
                for (DynamicObject srcBill : srcBills) {
                    long auxpty;
                    DynamicObject targetBillColl = (DynamicObject)srcAndTargetBillsMap.get(srcBill);
                    if (targetBillColl == null) continue;
                    long material = targetBillColl.getLong("material.id");
                    long l = auxpty = targetBillColl.get("auxpty") == null ? 0L : targetBillColl.getLong("auxpty");
                    if (CadEmptyUtils.isEmpty((Long)material) || !CadEmptyUtils.isEmpty((Long)auxpty)) continue;
                    allMatIds.add(targetBillColl.getLong("material.id"));
                }
                Set auxptyAffectPriceIds = CostObjectHelper.getAffectPriceDs(allMatIds);
                for (DynamicObject srcBill : srcBills) {
                    DynamicObject targetBillColl = (DynamicObject)srcAndTargetBillsMap.get(srcBill);
                    if (targetBillColl == null) {
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5355\u636e\u3002", (String)"AcaCostObjectImportForPZAction_12", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    Long costCenterId = targetBillColl.getLong("costcenter.id");
                    if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"AcaCostObjectImportForPZAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    if (!acctOrgPZCostCenters.contains(costCenterId)) continue;
                    long material = targetBillColl.getLong("material.id");
                    if (CadEmptyUtils.isEmpty((Long)material)) {
                        if ("im_materialreqoutbill".equals(sourcebill)) {
                            this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u7ef4\u62a4\u4ea7\u54c1\u3002", (String)"AcaCostObjectImportForPZAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                            continue;
                        }
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u7ef4\u62a4\u7269\u6599\u3002", (String)"AcaCostObjectImportForPZAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    long bomversion = targetBillColl.get("bomversion") == null ? 0L : targetBillColl.getLong("bomversion");
                    long auxpty = targetBillColl.get("auxpty") == null ? 0L : targetBillColl.getLong("auxpty");
                    String mat = String.valueOf(material).concat("@").concat(String.valueOf(bomversion)).concat("@").concat(String.valueOf(auxpty));
                    List matInfoList = (List)existCostObjectMaterialIdsMap.get(String.valueOf(acctOrgId).concat(String.valueOf(costCenterId)));
                    if (matInfoList != null && matInfoList.contains(mat)) {
                        this.getCostObjectContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"AcaCostObjectImportForPZAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"AcaCostObjectImportForPZAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    String key = String.valueOf(acctOrgId).concat("@").concat(String.valueOf(costCenterId)).concat("@").concat(config.getString("calmethod")).concat("@").concat(config.getString("costcalcdimension.id"));
                    DynamicObject rule = objRules.get(key);
                    if (rule == null) {
                        key = String.valueOf(acctOrgId).concat("@").concat(config.getString("calmethod")).concat("@").concat(config.getString("costcalcdimension.id"));
                        rule = objRules.get(key);
                    }
                    if (rule == null) {
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"AcaCostObjectImportForPZAction_17", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    DynamicObject costObject = this.generateMeterialCostObjectBySrcBill((Long)acctOrgId, targetBillColl, rule);
                    if (costObject == null) {
                        this.getCostObjectContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"AcaCostObjectImportForPZAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5931\u8d25\u3002", (String)"AcaCostObjectImportForPZAction_18", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6210\u672c\u4e2d\u5fc3:{},\u7269\u6599:{}\uff0c\u89c4\u5219:{}\u672a\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61,\u6839\u636e\u7269\u6599\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ed3\u675f!", new Object[]{acctOrgId, costCenterId, material, rule.getLong("id")});
                        continue;
                    }
                    ++count;
                    existCostObjectMaterialIdsMap.computeIfAbsent(String.valueOf(acctOrgId).concat(String.valueOf(costCenterId)), p -> new ArrayList()).add(mat);
                    costObjectItems.add(costObject);
                    if (!auxptyAffectPriceIds.contains(material) || !CadEmptyUtils.isEmpty((Long)auxpty)) continue;
                    costObject.set("billstatus", (Object)"A");
                    this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u3010%1$s\u3011\u884c\u53f7\u3010%2$s\u3011\u4ea7\u54c1\u542f\u7528\u8f85\u52a9\u5c5e\u6027\u5e76\u5f71\u54cd\u6210\u672c\uff0c\u8f85\u52a9\u5c5e\u6027\u4e3a\u7a7a\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u72b6\u6001\u4e3a\u6682\u5b58\u3002", (String)"AcaCostObjectImportForPZAction_21", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                }
                this.getCostObjectContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%1$s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%2$s\u201d\u4e2a\u3002", (String)"AcaCostObjectImportForPZAction_19", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number"), count));
            }
        });
        this.getCostObjectContext().getCostObjectBills().addAll(costObjectItems);
    }
}

