/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.costobject;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.CadLangHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.mservice.costobject.AbstractCostObjectAction;
import kd.macc.cad.mservice.costobject.CostObjectArgs;
import kd.macc.cad.mservice.costobject.CostObjectContext;

public class CostObjectBuildConditionAction
extends AbstractCostObjectAction {
    private static final Log logger = LogFactory.getLog(CostObjectBuildConditionAction.class);

    @Override
    protected void doExecute() {
        CostObjectContext costObjectContext = this.getCostObjectContext();
        CostObjectArgs collectionArgs = costObjectContext.getCostObjectArgs();
        Map<String, String> responseInfo = costObjectContext.getResponseInfo();
        String appNum = collectionArgs.getAppNum();
        Map<Long, List<Long>> acctOrgCostCentersMap = collectionArgs.getAcctOrgCostCentersMap();
        HashMap acctOrgRulesMap = new HashMap(16);
        HashMap acctOrgCalmethodCostCentersMap = new HashMap(16);
        HashMap costCenterAndManuOrgMap = new HashMap(128);
        costObjectContext.getResponseInfo().put("successQty", "0");
        int totalNum = "aca".equals(appNum) ? 5 : 8;
        this.refreshProgress(ResManager.loadKDString((String)"\u5df2\u6784\u5efa\u6761\u4ef6\uff0c\u5f00\u59cb\u5f52\u96c6\u3002", (String)"CostObjectBuildConditionAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), 1, totalNum, false);
        acctOrgCostCentersMap.forEach((acctOrgId, costCenterIds) -> {
            if (CadEmptyUtils.isEmpty((Long)acctOrgId) || CadEmptyUtils.isEmpty((List)costCenterIds)) {
                MsgUtils.putMsg2Map((String)"tip", (String)CadLangHelper.getListCheckCostCenterEmpty(), (Map)responseInfo);
                return;
            }
            List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)Long.parseLong(RequestContext.get().getUserId()), Collections.singletonList(acctOrgId), (Set)Sets.newHashSet((Iterable)costCenterIds), (String)"cad_costobject", (String)appNum);
            if (CadEmptyUtils.isEmpty((List)enableCostCenters)) {
                return;
            }
            Map objRules = CostObjectHelper.getCostObjectRulesMap((Long)acctOrgId, (List)enableCostCenters);
            acctOrgRulesMap.putAll(objRules);
            Map orgCalmethodCostCentersMap = CostObjectHelper.groupCostCenterByRules((List)enableCostCenters, (Map)objRules);
            acctOrgCalmethodCostCentersMap.putAll(orgCalmethodCostCentersMap);
            Map costCenterAndManuOrg = OrgHelper.getCostCenterAndManuOrgMap((List)enableCostCenters, (String)this.getCostObjectContext().getCostObjectArgs().getAppNum());
            costCenterAndManuOrgMap.putAll(costCenterAndManuOrg);
            List importScopeDate = SysParamHelper.getImportScopeDate((Long)acctOrgId, (String)appNum);
            CostCenterHelper.getWorkCenter((Collection)costCenterIds, (List)importScopeDate, (CollectReport)costObjectContext.getCollectReport());
            CostCenterHelper.getAdminOrg((Collection)costCenterIds, (List)importScopeDate, (CollectReport)costObjectContext.getCollectReport());
            CostCenterHelper.getBosOrgs((Collection)costCenterIds, (List)importScopeDate, (CollectReport)costObjectContext.getCollectReport());
        });
        if (!CollectionUtils.isEmpty(acctOrgCostCentersMap)) {
            this.getCostObjectContext().getAcctOrgObjRules().putAll(acctOrgRulesMap);
        } else {
            this.getCostObjectContext().setContinueExecute(false);
        }
        if (CollectionUtils.isEmpty(acctOrgCalmethodCostCentersMap)) {
            this.getCostObjectContext().setContinueExecute(false);
        }
        if (!CollectionUtils.isEmpty(acctOrgCalmethodCostCentersMap)) {
            logger.info("\u6838\u7b97\u7ec4\u7ec7->\u6210\u672c\u4e2d\u5fc3size:{}", (Object)acctOrgCalmethodCostCentersMap.size());
            this.getCostObjectContext().getAcctOrgCalmethodCostCenters().putAll(acctOrgCalmethodCostCentersMap);
        }
    }
}

