/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.costobject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.costobject.AcaCostObjectImportDataAction;
import kd.macc.cad.mservice.costobject.BaseImportDataAction;
import kd.macc.cad.mservice.costobject.CostObjectArgs;

public class CostObjectImportDataOtherAction
extends BaseImportDataAction {
    private Log logger = LogFactory.getLog(AcaCostObjectImportDataAction.class);

    @Override
    protected void doExecute() {
        super.doExecute();
        CostObjectArgs collectionArgs = this.getCostObjectContext().getCostObjectArgs();
        Map<Long, List<Long>> acctOrgCostCentersMap = collectionArgs.getAcctOrgCostCentersMap();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getCostObjectContext().getConfigSrcAndTargetBillsMap();
        acctOrgCostCentersMap.forEach((acctOrgId, costCenters) -> {
            Map<String, DynamicObject> objRules = this.getCostObjectContext().getAcctOrgObjRules();
            List<Long> reProduceCostCenters = this.getCostObjectContext().getAcctOrgCalmethodCostCenters().get(acctOrgId + CostObjectEnum.BIZTYPE_RO.getValue());
            if (CadEmptyUtils.isEmpty(reProduceCostCenters)) {
                this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u5de5\u5355\u6210\u672c\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f15\u5165\u7ed3\u675f\uff01", acctOrgId);
                return;
            }
            for (Map.Entry configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
                DynamicObject config = (DynamicObject)configSrcAndTargetBill.getKey();
                String sourcebill = config.getString("sourcebill.id");
                String sourcebillName = config.getString("sourcebill.name");
                if (!CostObjectEnum.BIZTYPE_RO.getValue().equals(config.getString("calmethod")) || "pom_mftorder".equals(sourcebill) || "om_mftorder".equals(sourcebill)) continue;
                Map srcAndTargetBillsMap = (Map)configSrcAndTargetBill.getValue();
                ArrayList srcBills = new ArrayList(srcAndTargetBillsMap.keySet());
                this.getCostObjectContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u67e5\u8be2%s", (String)"CostObjectImportDataOtherAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName));
                this.getCostObjectContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u201c%1$s\u201d%2$s\u6761\u6570\u636e\u3002", (String)"CostObjectImportDataOtherAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName, srcBills.size()));
                if (CadEmptyUtils.isEmpty(srcBills)) {
                    this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u5f52\u96c6\u914d\u7f6e\u65b9\u6848:{},\u672a\u83b7\u53d6\u5230\u6e90\u5355\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f15\u5165\u7ed3\u675f!", acctOrgId, (Object)config.getString("number"));
                    continue;
                }
                this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u5f52\u96c6\u914d\u7f6e\u65b9\u6848:{},\u83b7\u53d6\u5230\u7684\u6e90\u5355\u6761\u6570:{}", new Object[]{acctOrgId, config.getString("number"), srcBills.size()});
                this.getCostObjectContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"CostObjectImportDataOtherAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                ArrayList<Long> probillIds = new ArrayList<Long>(10);
                for (DynamicObject srcBill : srcBills) {
                    probillIds.add(srcBill.getLong("entryId"));
                }
                Map existCostObjectManuEntryIdsMap = CostObjectHelper.getExistCostObjectManuEntryIdsMap((Long)acctOrgId, (List)costCenters, probillIds);
                ArrayList<DynamicObject> costObjectItems = new ArrayList<DynamicObject>(10);
                int count = 0;
                for (DynamicObject srcBill : srcBills) {
                    DynamicObject targetBill = (DynamicObject)srcAndTargetBillsMap.get(srcBill);
                    if (targetBill == null) {
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5355\u636e\u3002", (String)"CostObjectImportDataOtherAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    Long costCenterId = targetBill.getLong("costcenter.id");
                    if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"CostObjectImportDataOtherAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    if (!reProduceCostCenters.contains(costCenterId)) continue;
                    Set existCostObjectManuEntryIds = (Set)existCostObjectManuEntryIdsMap.get(String.valueOf(acctOrgId));
                    if (!CadEmptyUtils.isEmpty((Set)existCostObjectManuEntryIds) && existCostObjectManuEntryIds.contains(srcBill.getLong("entryId"))) {
                        this.getCostObjectContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"CostObjectImportDataOtherAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"CostObjectImportDataOtherAction_17", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    String key = String.valueOf(acctOrgId).concat("@").concat(String.valueOf(costCenterId)).concat("@").concat(config.getString("calmethod")).concat("@").concat(config.getString("costcalcdimension.id"));
                    DynamicObject rule = objRules.get(key);
                    if (rule == null) {
                        key = String.valueOf(acctOrgId).concat("@").concat(config.getString("calmethod")).concat("@").concat(config.getString("costcalcdimension.id"));
                        rule = objRules.get(key);
                    }
                    if (rule == null) {
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"CostObjectImportDataOtherAction_18", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    DynamicObject costObject = this.generateCostObjectBySrcBill((Long)acctOrgId, srcBill, targetBill, rule);
                    if (costObject == null) {
                        this.getCostObjectContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"CostObjectImportDataOtherAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5931\u8d25\u3002", (String)"CostObjectImportDataOtherAction_19", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    ++count;
                    existCostObjectManuEntryIdsMap.computeIfAbsent(String.valueOf(acctOrgId).concat(String.valueOf(costCenterId)), p -> new HashSet(10)).add(costObject.getLong("probill"));
                    costObjectItems.add(costObject);
                }
                this.getCostObjectContext().getCostObjectBills().addAll(costObjectItems);
                this.getCostObjectContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%1$s\u201d,\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61%2$s\u4e2a\u3002", (String)"CostObjectImportDataOtherAction_20", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number"), count));
            }
        });
    }

    @Override
    public DynamicObject generateCostObjectBySrcBill(Long acctOrgId, DynamicObject srcBill, DynamicObject costObject, DynamicObject rule) {
        if (costObject == null || rule == null) {
            return null;
        }
        DynamicObject costCenter = costObject.getDynamicObject("costcenter");
        String ruleAss = rule.getString("objruleass");
        String ccNumber = costCenter.getString("number") + "-";
        ruleAss = StringUtils.isEmpty((String)ruleAss) ? ccNumber : ruleAss + "-" + ccNumber;
        String ruleNameAss = rule.getString("objrulenameass");
        String ccName = costCenter.getLocaleString("name").getLocaleValue() + "-";
        ruleNameAss = StringUtils.isEmpty((String)ruleNameAss) ? ccName : ruleNameAss + "-" + ccName;
        String[] ruleNumberExt = rule.getString("rulenumberext").split(",");
        String[] ruleNameExt = rule.getString("rulenameext").split(",");
        String srcNum = srcBill.getString("billno");
        String srcRow = srcBill.getString("entryseq");
        DynamicObject material = costObject.getDynamicObject("material");
        costObject.set("material", (Object)material.getLong("id"));
        String materialNumber = material.getString("number");
        String materialName = material.getString("name");
        String materialModelnum = material.getString("modelnum");
        String billNo = ruleAss + srcNum + "-" + srcRow;
        if (Arrays.asList(ruleNumberExt).contains("CR_CPBM") && !CadEmptyUtils.isEmpty((String)materialNumber)) {
            billNo = billNo + "-" + materialNumber;
        }
        if (Arrays.asList(ruleNumberExt).contains("CR_GGXH") && !CadEmptyUtils.isEmpty((String)materialModelnum)) {
            billNo = billNo + "-" + materialModelnum;
        }
        costObject.set("costobjectrule", rule.get("id"));
        costObject.set("org", (Object)acctOrgId);
        costObject.set("bizstatus", (Object)CostObjectEnum.BIZSTATUS_UNSETTLE.getValue());
        costObject.set("sotype", (Object)rule.getString("sotype"));
        costObject.set("rule", (Object)rule.getString("rule"));
        costObject.set("originype", (Object)CostObjectEnum.ORIGINYPE_CONFIG.getValue());
        costObject.set("biztype", (Object)rule.getString("biztype"));
        costObject.set("weight", (Object)1);
        if (billNo.length() > 255) {
            billNo = billNo.substring(0, 255);
        }
        costObject.set("billno", (Object)billNo);
        String billName = ruleNameAss + srcNum + "-" + srcRow;
        if (Arrays.asList(ruleNameExt).contains("CRN_CPMC") && !CadEmptyUtils.isEmpty((String)materialName)) {
            billName = billName + "-" + materialName;
        }
        if (Arrays.asList(ruleNameExt).contains("CRN_GGXH") && !CadEmptyUtils.isEmpty((String)materialModelnum)) {
            billName = billName + "-" + materialModelnum;
        }
        if (billName.length() > 255) {
            billName = billName.substring(0, 255);
        }
        costObject.set("name", (Object)billName);
        costObject.set("creator", (Object)RequestContext.get().getUserId());
        costObject.set("createtime", (Object)new Date());
        if ("C".equals(costObject.getString("billstatus"))) {
            costObject.set("auditor", (Object)RequestContext.get().getUserId());
            costObject.set("auditdate", (Object)new Date());
        }
        return costObject;
    }
}

