/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.costobject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.costobject.BaseImportDataAction;
import kd.macc.cad.mservice.costobject.CostObjectArgs;

public class CostObjectImportForCUAction
extends BaseImportDataAction {
    private Log logger = LogFactory.getLog(CostObjectImportForCUAction.class);

    @Override
    protected void doExecute() {
        CostObjectArgs collectionArgs = this.getCostObjectContext().getCostObjectArgs();
        Map<Long, List<Long>> acctOrgCostCentersMap = collectionArgs.getAcctOrgCostCentersMap();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getCostObjectContext().getConfigSrcAndTargetBillsMap();
        Map<Long, Map<String, String>> collConfigMappingMap = this.getCostObjectContext().getCollConfigMappingMap();
        ArrayList costObjectItems = new ArrayList(1000);
        acctOrgCostCentersMap.forEach((acctOrgId, costCenters) -> {
            Map<String, DynamicObject> objRules = this.getCostObjectContext().getAcctOrgObjRules();
            List<Long> acctOrgCUCostCenters = this.getCostObjectContext().getAcctOrgCalmethodCostCenters().get(acctOrgId + CostObjectEnum.BIZTYPE_CU.getValue());
            if (CadEmptyUtils.isEmpty(acctOrgCUCostCenters)) {
                this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u5176\u4ed6\u6cd5\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f15\u5165\u7ed3\u675f\uff01", acctOrgId);
                return;
            }
            this.getCostObjectContext().getCollectReport().setCuCostCenters(acctOrgCUCostCenters);
            HashMap<String, Map> existCostObjectMaterialIdsMap = new HashMap<String, Map>(16);
            for (Map.Entry configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
                DynamicObject config = (DynamicObject)configSrcAndTargetBill.getKey();
                String sourceBill = config.getString("sourcebill.id");
                if (!CostObjectEnum.BIZTYPE_CU.getValue().equals(config.getString("calmethod"))) continue;
                this.getCostObjectContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"CostObjectImportForCUAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                Map srcAndTargetBillsMap = (Map)configSrcAndTargetBill.getValue();
                ArrayList srcBills = new ArrayList(srcAndTargetBillsMap.keySet());
                DynamicObject costCalcDimension = config.getDynamicObject("costcalcdimension");
                String dimension = costCalcDimension.getString("calcrule");
                DynamicObjectCollection entryentity = costCalcDimension.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    dimension = dimension.concat(entry.getString("field")).concat(",");
                }
                if (CadEmptyUtils.isEmpty((String)dimension)) {
                    this.getCostObjectContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"CostObjectImportForCUAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u6ca1\u6709\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ef4\u5ea6\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"CostObjectImportForCUAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                    continue;
                }
                Map configMappingMap = (Map)collConfigMappingMap.get(config.getLong("id"));
                TreeSet<String> costObjectFieldSet = new TreeSet<String>(CostObjectHelper.getCostObjectFields((String)dimension));
                String costObjectFields = String.join((CharSequence)",", costObjectFieldSet);
                Map<String, Map<String, String>> baseDataInfoMap = this.getBaseDataInfoMap(srcAndTargetBillsMap, configMappingMap, sourceBill);
                existCostObjectMaterialIdsMap.putAll(CostObjectHelper.getExistCostObjectMap((Long)acctOrgId, acctOrgCUCostCenters, (String)costObjectFields, (String)collectionArgs.getAppNum()));
                int count = 0;
                for (DynamicObject srcBill : srcBills) {
                    DynamicObject targetBillColl = (DynamicObject)srcAndTargetBillsMap.get(srcBill);
                    if (targetBillColl == null) {
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5355\u636e\u3002", (String)"CostObjectImportForCUAction_12", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    Long costCenterId = targetBillColl.getLong("costcenter.id");
                    if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"CostObjectImportForCUAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    if (!acctOrgCUCostCenters.contains(costCenterId)) continue;
                    String srcStr = CostObjectHelper.getCostObjectStr((DynamicObject)targetBillColl, (String)costObjectFields, (String)",");
                    Map matInfoList = (Map)existCostObjectMaterialIdsMap.get(String.valueOf(acctOrgId).concat(String.valueOf(costCenterId)));
                    if (!CadEmptyUtils.isEmpty((Map)matInfoList) && matInfoList.containsKey(srcStr)) {
                        this.getCostObjectContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"CostObjectImportForCUAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"CostObjectImportForCUAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    String key = String.valueOf(acctOrgId).concat("@").concat(String.valueOf(costCenterId)).concat("@").concat(config.getString("calmethod")).concat("@").concat(config.getString("costcalcdimension.id"));
                    DynamicObject rule = objRules.get(key);
                    if (rule == null) {
                        key = String.valueOf(acctOrgId).concat("@").concat(config.getString("calmethod")).concat("@").concat(config.getString("costcalcdimension.id"));
                        rule = objRules.get(key);
                    }
                    if (rule == null) {
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"CostObjectImportForCUAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    DynamicObject costObject = this.generateDimensionCostObjectBySrcBill((Long)acctOrgId, srcBill, targetBillColl, rule, baseDataInfoMap);
                    if (costObject == null) {
                        this.getCostObjectContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"CostObjectImportForCUAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5931\u8d25\u3002", (String)"CostObjectImportForCUAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6210\u672c\u4e2d\u5fc3:{},\u89c4\u5219:{}\u672a\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61,\u6839\u636e\u7269\u6599\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ed3\u675f!", new Object[]{acctOrgId, costCenterId, rule.getLong("id")});
                        continue;
                    }
                    String mulInputField = this.checkMulInputField(costObjectFieldSet, costObject);
                    if (!CadEmptyUtils.isEmpty((String)mulInputField)) {
                        this.getCostObjectContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"CostObjectImportForCUAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5931\u8d25,\u201c%3$s\u201d\u4e3a\u7a7a\u3002", (String)"CostObjectImportForCUAction_19", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq"), CadEmptyUtils.isEmpty((String)this.getDimensionName(mulInputField)) ? mulInputField : this.getDimensionName(mulInputField)));
                        this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6210\u672c\u4e2d\u5fc3:{},\u89c4\u5219:{}\u672a\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61,\u6838\u7b97\u7ef4\u5ea6\u5b57\u6bb5:{}\u4e3a\u7a7a!", new Object[]{acctOrgId, costCenterId, rule.getLong("id"), mulInputField});
                        continue;
                    }
                    ++count;
                    existCostObjectMaterialIdsMap.computeIfAbsent(String.valueOf(acctOrgId).concat(String.valueOf(costCenterId)), p -> new HashMap()).put(srcStr, costObject);
                    costObjectItems.add(costObject);
                }
                this.getCostObjectContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%1$s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%2$s\u201d\u4e2a\u3002", (String)"CostObjectImportForCUAction_18", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number"), count));
            }
        });
        this.getCostObjectContext().getCostObjectBills().addAll(costObjectItems);
    }

    private String checkMulInputField(Set<String> costObjectFieldSet, DynamicObject costObject) {
        String mulInputField = null;
        for (String costObjectField : costObjectFieldSet) {
            if ("bomversion".equals(costObjectField) || "auxpty".equals(costObjectField)) continue;
            Object costObjectValue = costObject.get(costObjectField);
            if (costObjectValue == null) {
                mulInputField = costObjectField;
                break;
            }
            if (costObjectValue instanceof DynamicObject && CadEmptyUtils.isEmpty((DynamicObject)((DynamicObject)costObjectValue))) {
                mulInputField = costObjectField;
                break;
            }
            if (costObjectValue instanceof Long && CadEmptyUtils.isEmpty((Long)((Long)costObjectValue))) {
                mulInputField = costObjectField;
                break;
            }
            if (costObjectValue instanceof Integer && CadEmptyUtils.isEmpty((Integer)((Integer)costObjectValue))) {
                mulInputField = costObjectField;
                break;
            }
            if (!(costObjectValue instanceof String) || !CadEmptyUtils.isEmpty((String)((String)costObjectValue))) continue;
            mulInputField = costObjectField;
            break;
        }
        return mulInputField;
    }

    private String getDimensionName(String costObjectField) {
        String dimensionName = "";
        if (CadEmptyUtils.isEmpty((String)costObjectField)) {
            return dimensionName;
        }
        switch (costObjectField) {
            case "srcbillnumber": {
                dimensionName = CostObjectEnum.COST_BOJ_RULE_YDDH.getName();
                break;
            }
            case "YDHH": {
                dimensionName = CostObjectEnum.COST_BOJ_RULE_YDHH.getName();
                break;
            }
            case "CP": {
                dimensionName = CostObjectEnum.COST_BOJ_RULE_CP.getName();
                break;
            }
            case "XMH": {
                dimensionName = CostObjectEnum.COST_BOJ_RULE_XMH.getName();
                break;
            }
            case "GZH": {
                dimensionName = CostObjectEnum.COST_BOJ_RULE_GZH.getName();
                break;
            }
            case "PZH": {
                dimensionName = CostObjectEnum.COST_BOJ_RULE_PZH.getName();
                break;
            }
            case "SCBH": {
                dimensionName = CostObjectEnum.COST_BOJ_RULE_SCBH.getName();
                break;
            }
            case "PH": {
                dimensionName = CostObjectEnum.COST_BOJ_RULE_PH.getName();
                break;
            }
        }
        return dimensionName;
    }
}

