/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.costobject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.business.config.service.CostObjectService;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.costobject.BaseImportDataAction;
import kd.macc.cad.mservice.costobject.CostObjectArgs;

public class EcaCostObjectImportForSPAction
extends BaseImportDataAction {
    private static final Log logger = LogFactory.getLog(EcaCostObjectImportForSPAction.class);

    @Override
    protected void doExecute() {
        CostObjectArgs collectionArgs = this.getCostObjectContext().getCostObjectArgs();
        Map<Long, List<Long>> acctOrgCostCentersMap = collectionArgs.getAcctOrgCostCentersMap();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getCostObjectContext().getConfigSrcAndTargetBillsMap();
        ArrayList costObjectItems = new ArrayList(1000);
        Map dimensionAndRuleMap = CostObjectService.getDimensionAndRuleMap();
        acctOrgCostCentersMap.forEach((acctOrgId, costCenters) -> {
            Map<String, DynamicObject> objRules = this.getCostObjectContext().getAcctOrgObjRules();
            List<Long> acctOrgSPCostCenters = this.getCostObjectContext().getAcctOrgCalmethodCostCenters().get(acctOrgId + CostObjectEnum.BIZTYPE_SP.getValue());
            if (CadEmptyUtils.isEmpty(acctOrgSPCostCenters)) {
                logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u5176\u4ed6\u6cd5\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f15\u5165\u7ed3\u675f\uff01", acctOrgId);
                return;
            }
            this.getCostObjectContext().getCollectReport().setSpCostCenters(acctOrgSPCostCenters);
            for (Map.Entry configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
                DynamicObject config = (DynamicObject)configSrcAndTargetBill.getKey();
                if (!CostObjectEnum.BIZTYPE_SP.getValue().equals(config.getString("calmethod"))) continue;
                this.getCostObjectContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"EcaCostObjectImportForSPAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                Map srcAndTargetBillsMap = (Map)configSrcAndTargetBill.getValue();
                ArrayList srcBills = new ArrayList(srcAndTargetBillsMap.keySet());
                long costcalcdimension = config.getLong("costcalcdimension.id");
                String dimension = (String)dimensionAndRuleMap.get(costcalcdimension);
                if (CadEmptyUtils.isEmpty((String)dimension)) {
                    this.getCostObjectContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"EcaCostObjectImportForSPAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u6ca1\u6709\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ef4\u5ea6\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"EcaCostObjectImportForSPAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                    continue;
                }
                TreeSet<String> costObjectFieldSet = new TreeSet<String>(CostObjectHelper.getCostObjectFields((String)dimension));
                String costObjectFields = String.join((CharSequence)",", costObjectFieldSet);
                Map<String, Map<String, String>> baseDataInfoMap = this.getBaseDataInfoMap(new ArrayList<DynamicObject>(srcAndTargetBillsMap.values()), costObjectFieldSet);
                Map existCostObjectMaterialIdsMap = CostObjectHelper.getExistCostObjectMap((Long)acctOrgId, acctOrgSPCostCenters, (String)costObjectFields, (String)collectionArgs.getAppNum());
                int count = 0;
                for (DynamicObject srcBill : srcBills) {
                    DynamicObject targetBillColl = (DynamicObject)srcAndTargetBillsMap.get(srcBill);
                    if (targetBillColl == null) {
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5355\u636e\u3002", (String)"EcaCostObjectImportForSPAction_11", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    Long costCenterId = targetBillColl.getLong("costcenter.id");
                    if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"EcaCostObjectImportForSPAction_12", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    if (!acctOrgSPCostCenters.contains(costCenterId)) continue;
                    String str = CostObjectHelper.getCostObjectStr((DynamicObject)targetBillColl, (String)costObjectFields, (String)",");
                    Map matInfoList = (Map)existCostObjectMaterialIdsMap.get(String.valueOf(acctOrgId).concat(String.valueOf(costCenterId)));
                    if (!CadEmptyUtils.isEmpty((Map)matInfoList) && matInfoList.containsKey(str)) {
                        this.getCostObjectContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"EcaCostObjectImportForSPAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"EcaCostObjectImportForSPAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    String key = String.valueOf(acctOrgId).concat("@").concat(String.valueOf(costCenterId)).concat("@").concat(config.getString("calmethod")).concat("@").concat(config.getString("costcalcdimension.id"));
                    DynamicObject rule = objRules.get(key);
                    if (rule == null) {
                        key = String.valueOf(acctOrgId).concat("@").concat(config.getString("calmethod")).concat("@").concat(config.getString("costcalcdimension.id"));
                        rule = objRules.get(key);
                    }
                    if (rule == null) {
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"EcaCostObjectImportForSPAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    DynamicObject costObject = this.generateCostObjectBySrcBill((Long)acctOrgId, srcBill, targetBillColl, rule, baseDataInfoMap);
                    if (costObject == null) {
                        this.getCostObjectContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"EcaCostObjectImportForSPAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5931\u8d25\u3002", (String)"EcaCostObjectImportForSPAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6210\u672c\u4e2d\u5fc3:{},\u89c4\u5219:{}\u672a\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61,\u6839\u636e\u7269\u6599\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ed3\u675f\u3002", new Object[]{acctOrgId, costCenterId, rule.getLong("id")});
                        continue;
                    }
                    ++count;
                    existCostObjectMaterialIdsMap.computeIfAbsent(String.valueOf(acctOrgId).concat(String.valueOf(costCenterId)), p -> new HashMap()).put(str, costObject);
                    costObjectItems.add(costObject);
                }
                this.getCostObjectContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%1$s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%2$s\u201d\u4e2a\u3002", (String)"EcaCostObjectImportForSPAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number"), count));
            }
        });
        this.getCostObjectContext().getCostObjectBills().addAll(costObjectItems);
    }
}

