/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.costobject;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.CostObjectProductGroupHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.costobject.BaseImportDataAction;
import kd.macc.cad.mservice.costobject.CostObjectArgs;

public class ScaCostObjectImportDataAction
extends BaseImportDataAction {
    private Log logger = LogFactory.getLog(ScaCostObjectImportDataAction.class);

    @Override
    protected void doExecute() {
        super.doExecute();
        CostObjectArgs collectionArgs = this.getCostObjectContext().getCostObjectArgs();
        Map<Long, List<Long>> acctOrgCostCentersMap = collectionArgs.getAcctOrgCostCentersMap();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getCostObjectContext().getConfigSrcAndTargetBillsMap();
        HashSet createdBIllEntryIds = new HashSet(200);
        acctOrgCostCentersMap.forEach((acctOrgId, costCenters) -> {
            Map<String, DynamicObject> objRules = this.getCostObjectContext().getAcctOrgObjRules();
            List<Long> reProduceCostCenters = this.getCostObjectContext().getAcctOrgCalmethodCostCenters().get(acctOrgId + CostObjectEnum.BIZTYPE_RO.getValue());
            if (CadEmptyUtils.isEmpty(reProduceCostCenters)) {
                this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u5de5\u5355\u6210\u672c\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f15\u5165\u7ed3\u675f\uff01", acctOrgId);
                return;
            }
            this.getCostObjectContext().getCollectReport().setReProCostCenters(reProduceCostCenters);
            for (Map.Entry configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
                DynamicObjectCollection allCostObjectBills;
                List<DynamicObject> costObjectList;
                DynamicObject config = (DynamicObject)configSrcAndTargetBill.getKey();
                String sourcebill = config.getString("sourcebill.id");
                String sourcebillName = config.getString("sourcebill.name");
                if (!CostObjectEnum.BIZTYPE_RO.getValue().equals(config.getString("calmethod")) || !"pom_mftorder".equals(sourcebill) && !"om_mftorder".equals(sourcebill)) continue;
                Map srcAndTargetBillsMap = (Map)configSrcAndTargetBill.getValue();
                ArrayList<DynamicObject> proBills = new ArrayList<DynamicObject>(srcAndTargetBillsMap.keySet());
                this.getCostObjectContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u67e5\u8be2%s", (String)"ScaCostObjectImportDataAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName));
                this.getCostObjectContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u201c%1$s\u201d%2$s\u6761\u6570\u636e\u3002", (String)"ScaCostObjectImportDataAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]), sourcebillName, proBills.size()));
                if (CadEmptyUtils.isEmpty(proBills)) {
                    this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u5f52\u96c6\u914d\u7f6e\u65b9\u6848:{},\u672a\u83b7\u53d6\u5230\u6e90\u5355\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f15\u5165\u7ed3\u675f!", acctOrgId, (Object)config.getString("number"));
                    continue;
                }
                this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u5f52\u96c6\u914d\u7f6e\u65b9\u6848:{},\u83b7\u53d6\u5230\u7684\u6e90\u5355\u6761\u6570:{}", new Object[]{acctOrgId, config.getString("number"), proBills.size()});
                this.getCostObjectContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"ScaCostObjectImportDataAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                ArrayList<Long> probillIds = new ArrayList<Long>(10);
                ArrayList<Long> entryIds = new ArrayList<Long>(proBills.size());
                for (DynamicObject proBill : proBills) {
                    probillIds.add(proBill.getLong("entryId"));
                    entryIds.add(proBill.getLong("entryId"));
                }
                Map existEntryIdMainObjMap = CostObjectProductGroupHelper.getExistEntryIdMainObjMap((Long)acctOrgId, (List)costCenters, entryIds);
                Map existCostObjectManuEntryIdsMap = CostObjectHelper.getExistCostObjectManuEntryIdsMap((Long)acctOrgId, (List)costCenters, probillIds);
                existCostObjectManuEntryIdsMap.forEach((key, value) -> createdBIllEntryIds.addAll(value));
                DynamicObjectCollection existCostObjectProBills = new DynamicObjectCollection();
                for (DynamicObject proBill : proBills) {
                    if (createdBIllEntryIds.isEmpty() || !createdBIllEntryIds.contains(proBill.getLong("entryId"))) continue;
                    existCostObjectProBills.add((Object)proBill);
                }
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)existCostObjectProBills) && !CadEmptyUtils.isEmpty(costObjectList = this.updateCostObjectBill((Long)acctOrgId, objRules, existCostObjectProBills, allCostObjectBills = this.getAllCostObjectBills(String.valueOf(acctOrgId), createdBIllEntryIds), config, srcAndTargetBillsMap))) {
                    this.getCostObjectContext().getUpdateCostObjectBills().addAll(costObjectList);
                    this.getCostObjectContext().getCostObjectCostChangeBills().addAll(costObjectList);
                }
                this.generateObjAndGroup(String.valueOf(acctOrgId), reProduceCostCenters, srcAndTargetBillsMap, proBills, config, objRules, this.getCostObjectContext().getCostObjectBills(), this.getCostObjectContext().getUpdateGroupObjBills(), this.getCostObjectContext().getProductGroups(), this.getCostObjectContext().getPgMainMap(), this.getCostObjectContext().getEntryIdMainObjMap(), existEntryIdMainObjMap, existCostObjectManuEntryIdsMap, this.getCostObjectContext(), null);
                this.getCostObjectContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%1$s\u201d,\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61%2$s\u4e2a\u3002", (String)"ScaCostObjectImportDataAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number"), this.getCostObjectContext().getCostObjectBills().size()));
                if (CadEmptyUtils.isEmpty((Integer)this.getCostObjectContext().getCostObjectBills().size())) {
                    this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u914d\u7f6e\u65b9\u6848:{}\u672a\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f15\u5165\u7ed3\u675f!", acctOrgId, (Object)config.getString("number"));
                    continue;
                }
                this.getCostObjectContext().getCostObjectCostChangeBills().addAll(this.getCostObjectContext().getCostObjectBills());
                String checkDesc = String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%1$s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61%2$s\u4e2a\uff0c\u6210\u672c\u53d8\u66f4\u8bb0\u5f55\u4e2a\u6570%3$s\u4e2a\u3002", (String)"ScaCostObjectImportDataAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number"), this.getCostObjectContext().getCostObjectBills().size(), this.getCostObjectContext().getCostObjectCostChangeBills().size());
                this.getCostObjectContext().getCollectReport().logCheckDesc(checkDesc);
            }
        });
    }

    private DynamicObjectCollection getAllCostObjectBills(String acctOrgId, Set<Long> ids) {
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(acctOrgId));
        QFilter proFilter = InFilterHelper.getQFilterByBachSize((String)"probill", new ArrayList<Long>(ids), (String)"in", (int)20000);
        return QueryServiceHelper.query((String)"cad_costobject", (String)"id,billno,name,costcenter,costcenter.number costcenternumber,costcenter.name costcentername,probill,material,material.number materialNumber,material.name materialName,material.modelnum materialModelnum,srcbillrow,producttype,configuredcode,tracknumber", (QFilter[])new QFilter[]{orgFilter, proFilter}, (String)"createtime desc");
    }

    private List<DynamicObject> updateCostObjectBill(Long acctOrgId, Map<String, DynamicObject> objRules, DynamicObjectCollection existCostObjectProBills, DynamicObjectCollection costObjectBills, DynamicObject config, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap) {
        ArrayList<DynamicObject> costObjectList = new ArrayList<DynamicObject>(10);
        HashMap<Long, Object> existProBillMap = new HashMap<Long, Object>(16);
        for (Object existProBill : existCostObjectProBills) {
            existProBillMap.put(existProBill.getLong("entryId"), existProBill);
        }
        ArrayList<Long> changedCostObjectIds = new ArrayList<Long>(10);
        for (DynamicObject costObjectBill : costObjectBills) {
            DynamicObject targetBill;
            DynamicObject existProBill = (DynamicObject)existProBillMap.get(costObjectBill.getLong("probill"));
            if (existProBill == null || (targetBill = srcAndTargetBillsMap.get(existProBill)) == null) continue;
            try {
                if (this.equals(targetBill.get("srcbillrow"), costObjectBill.get("srcbillrow")) && this.equals(targetBill.get("material.id"), costObjectBill.get("material")) && targetBill.getLong("costcenter.id") == costObjectBill.getLong("costcenter") && targetBill.getLong("probill") == costObjectBill.getLong("probill") && targetBill.getLong("configuredcode") == costObjectBill.getLong("configuredcode") && targetBill.getLong("tracknumber") == costObjectBill.getLong("tracknumber") && existProBill.getString("producttype").equals(costObjectBill.getString("producttype"))) continue;
                changedCostObjectIds.add(costObjectBill.getLong("id"));
            }
            catch (Exception ex) {
                this.logger.error("\u83b7\u53d6\u53c2\u6570\u503c\u53d1\u751f\u9519\u8bef", (Throwable)ex);
            }
        }
        List partArrIds = Lists.partition(new ArrayList(changedCostObjectIds), (int)20000);
        for (List changedCostObjectIdList : partArrIds) {
            DynamicObject[] costObjects;
            for (DynamicObject costObject : costObjects = BusinessDataServiceHelper.load((Object[])changedCostObjectIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_costobject"))) {
                Long costCenterId = costObject.getLong("costcenter.id");
                String key = String.valueOf(acctOrgId).concat("@").concat(String.valueOf(costCenterId)).concat("@").concat(config.getString("calmethod")).concat("@").concat(config.getString("costcalcdimension.id"));
                DynamicObject rule = objRules.get(key);
                if (rule == null) {
                    key = String.valueOf(acctOrgId).concat("@").concat(config.getString("calmethod")).concat("@").concat(config.getString("costcalcdimension.id"));
                    rule = objRules.get(key);
                }
                if (rule == null) continue;
                String[] ruleNumberExt = rule.getString("rulenumberext").split(",");
                String[] ruleNameExt = rule.getString("rulenameext").split(",");
                DynamicObject existProBill = (DynamicObject)existProBillMap.get(costObject.getLong("probill"));
                DynamicObject targetBill = srcAndTargetBillsMap.get(existProBill);
                if (targetBill == null) {
                    this.logger.info("\u6839\u636e\u6e90\u5355:{}\u672a\u627e\u5230\u76ee\u6807\u5355\uff0c\u8df3\u8fc7!", (Object)SerializationUtils.toJsonString((Object)existProBill));
                    continue;
                }
                String proBillNo = existProBill.getString("billno");
                String proBillSeq = existProBill.getString("entryseq");
                String newBillno = costObject.getString("costcenter.number") + "-" + proBillNo + "-" + proBillSeq;
                if (Arrays.asList(ruleNumberExt).contains("CR_CPBM")) {
                    newBillno = newBillno + "-" + targetBill.getString("material.name");
                }
                if (Arrays.asList(ruleNumberExt).contains("CR_GGXH")) {
                    newBillno = newBillno + "-" + targetBill.getString("material.modelnum");
                }
                String newName = costObject.getString("costcenter.name") + "-" + proBillNo + "-" + proBillSeq;
                if (Arrays.asList(ruleNameExt).contains("CRN_CPMC")) {
                    newBillno = newBillno + "-" + targetBill.getString("material.name");
                }
                if (Arrays.asList(ruleNameExt).contains("CRN_GGXH")) {
                    newBillno = newBillno + "-" + targetBill.getString("material.modelnum");
                }
                costObject.set("billno", (Object)newBillno);
                costObject.set("name", (Object)newName);
                costObject.set("srcbillrow", (Object)proBillSeq);
                costObject.set("material", (Object)existProBill.getLong("material"));
                costObject.set("configuredcode", (Object)targetBill.getLong("configuredcode"));
                costObject.set("tracknumber", (Object)targetBill.getLong("tracknumber"));
                costObject.set("producttype", (Object)existProBill.getString("producttype"));
                costObjectList.add(costObject);
            }
        }
        return costObjectList;
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }
}

