/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.costobject;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.costobject.BaseImportDataAction;
import kd.macc.cad.mservice.costobject.CostObjectArgs;

public class ScaCostObjectImportForFPAction
extends BaseImportDataAction {
    private Log logger = LogFactory.getLog(ScaCostObjectImportForFPAction.class);

    @Override
    protected void doExecute() {
        CostObjectArgs collectionArgs = this.getCostObjectContext().getCostObjectArgs();
        Map<Long, List<Long>> acctOrgCostCentersMap = collectionArgs.getAcctOrgCostCentersMap();
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getCostObjectContext().getConfigSrcAndTargetBillsMap();
        ArrayList costObjectItems = new ArrayList(1000);
        acctOrgCostCentersMap.forEach((acctOrgId, costCenters) -> {
            Map<String, DynamicObject> objRules = this.getCostObjectContext().getAcctOrgObjRules();
            List<Long> acctOrgSimpleCostCenters = this.getCostObjectContext().getAcctOrgCalmethodCostCenters().get(acctOrgId + CostObjectEnum.BIZTYPE_SO.getValue());
            if (CadEmptyUtils.isEmpty(acctOrgSimpleCostCenters)) {
                this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6ca1\u6709\u5206\u6279\u6cd5\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u5206\u6279\u6cd5\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f15\u5165\u7ed3\u675f\uff01", acctOrgId);
                return;
            }
            this.getCostObjectContext().getCollectReport().setFpCostCenters(acctOrgSimpleCostCenters);
            Map existCostObjectUnSettleMaterialMap = CostObjectHelper.getExistCostObjectMaterialMapForFP((Long)acctOrgId, acctOrgSimpleCostCenters, (String)collectionArgs.getAppNum());
            for (Map.Entry configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
                DynamicObject config = (DynamicObject)configSrcAndTargetBill.getKey();
                String sourcebill = config.getString("sourcebill.id");
                if (!CostObjectEnum.BIZTYPE_SO.getValue().equals(config.getString("calmethod"))) continue;
                this.getCostObjectContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"ScaCostObjectImportForFPAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                Map srcAndTargetBillsMap = (Map)configSrcAndTargetBill.getValue();
                ArrayList srcBills = new ArrayList(srcAndTargetBillsMap.keySet());
                int count = 0;
                for (DynamicObject srcBill : srcBills) {
                    DynamicObject targetBillColl = (DynamicObject)srcAndTargetBillsMap.get(srcBill);
                    if (targetBillColl == null) {
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5355\u636e\u3002", (String)"ScaCostObjectImportForFPAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    Long costCenterId = targetBillColl.getLong("costcenter.id");
                    if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"ScaCostObjectImportForFPAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    if (!acctOrgSimpleCostCenters.contains(costCenterId)) continue;
                    long material = targetBillColl.getLong("material.id");
                    if (CadEmptyUtils.isEmpty((Long)material)) {
                        if ("im_materialreqoutbill".equals(sourcebill)) {
                            this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u7ef4\u62a4\u4ea7\u54c1\u3002", (String)"ScaCostObjectImportForFPAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                            continue;
                        }
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u7ef4\u62a4\u7269\u6599\u3002", (String)"ScaCostObjectImportForFPAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    String produceNum = targetBillColl.getString("producenum");
                    if (CadEmptyUtils.isEmpty((String)produceNum)) {
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u7ef4\u62a4\u751f\u4ea7\u7f16\u53f7\u3002", (String)"ScaCostObjectImportForFPAction_17", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    long bomversion = targetBillColl.get("bomversion") == null ? 0L : targetBillColl.getLong("bomversion");
                    long auxpty = targetBillColl.get("auxpty") == null ? 0L : targetBillColl.getLong("auxpty");
                    String mat = "";
                    mat = "sca".equals(collectionArgs.getAppNum()) ? String.valueOf(material).concat("@").concat(String.valueOf(bomversion)).concat("@").concat(String.valueOf(auxpty)).concat("@").concat(targetBillColl.getString("period")) : String.valueOf(material).concat("@").concat(String.valueOf(bomversion)).concat("@").concat(String.valueOf(auxpty)).concat("@").concat(targetBillColl.getString("producenum"));
                    List matInfoList = (List)existCostObjectUnSettleMaterialMap.get(String.valueOf(acctOrgId).concat(String.valueOf(costCenterId)));
                    if (matInfoList != null && matInfoList.contains(mat)) {
                        this.getCostObjectContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"ScaCostObjectImportForFPAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"ScaCostObjectImportForFPAction_18", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    String key = String.valueOf(acctOrgId).concat("@").concat(String.valueOf(costCenterId)).concat("@").concat(config.getString("calmethod")).concat("@").concat(config.getString("costcalcdimension.id"));
                    DynamicObject rule = objRules.get(key);
                    if (rule == null) {
                        key = String.valueOf(acctOrgId).concat("@").concat(config.getString("calmethod")).concat("@").concat(config.getString("costcalcdimension.id"));
                        rule = objRules.get(key);
                    }
                    if (rule == null) {
                        this.getCostObjectContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"ScaCostObjectImportForFPAction_19", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        continue;
                    }
                    DynamicObject costObject = this.generateMeterialCostObjectBySrcBill((Long)acctOrgId, targetBillColl, rule);
                    if (costObject == null) {
                        this.getCostObjectContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"ScaCostObjectImportForFPAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5931\u8d25\u3002", (String)"ScaCostObjectImportForFPAction_20", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                        this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6210\u672c\u4e2d\u5fc3:{},\u7269\u6599:{}\uff0c\u89c4\u5219:{}\u672a\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61,\u6839\u636e\u7269\u6599\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ed3\u675f!", new Object[]{acctOrgId, costCenterId, material, rule.getLong("id")});
                        continue;
                    }
                    ++count;
                    existCostObjectUnSettleMaterialMap.computeIfAbsent(String.valueOf(acctOrgId).concat(String.valueOf(costCenterId)), p -> new ArrayList()).add(mat);
                    costObjectItems.add(costObject);
                }
                this.getCostObjectContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u201c%1$s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61%2$s\u4e2a\u3002", (String)"ScaCostObjectImportForFPAction_21", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number"), count));
            }
        });
        this.getCostObjectContext().getCostObjectBills().addAll(costObjectItems);
    }
}

