/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.diycostdriver;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.diycostdriver.AbstractDiyCostDriverAction;
import kd.macc.cad.mservice.diycostdriver.DiyCostDriverArgs;

public class DiyCostDriverImportDataConfigAction
extends AbstractDiyCostDriverAction {
    private static final Log logger = LogFactory.getLog(DiyCostDriverImportDataConfigAction.class);
    private static final String ENTRY_QTY_FIELD = "entryqty";
    private static String selectFields = "id,org,costaccount,manuorg,costcenter,costdriver,entryentity.entryqty";

    @Override
    protected void doExecute() {
        this.refreshProgress(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u8f6c\u6362\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"DiyCostDriverImportDataConfigAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), 7, 14, false);
        DiyCostDriverArgs diyCostDriverArgs = this.getDiyCostDriverContext().getDiyCostDriverArgs();
        long orgId = diyCostDriverArgs.getAcctOrgId();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        long costAccountId = diyCostDriverArgs.getCostAccountId();
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccountId, (String)"cal_bd_costaccount");
        String appNum = diyCostDriverArgs.getAppNum();
        List<Long> costCenterIds = diyCostDriverArgs.getCostCenterIds();
        HashMap<String, List> saveDiyCostDriverBillsMap = new HashMap<String, List>(16);
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getDiyCostDriverContext().getConfigSrcAndTargetBillsMap();
        Map<Long, Map<String, String>> collConfigMappingMap = this.getDiyCostDriverContext().getCollConfigMappingMap();
        Map<Long, Map<String, String>> collConfigRuleMappingMap = this.getDiyCostDriverContext().getCollConfigRuleMappingMap();
        HashSet<String> targetFieldSet = new HashSet<String>(16);
        targetFieldSet.add("entryentity.costobject");
        HashSet<String> otherFieldSet = new HashSet<String>(16);
        for (Map<String, String> collConfigs : collConfigMappingMap.values()) {
            Set<String> collConfigKeys = collConfigs.keySet();
            for (String string : collConfigKeys) {
                targetFieldSet.add(string);
                if (selectFields.contains(string)) continue;
                otherFieldSet.add(string);
            }
        }
        if (!CadEmptyUtils.isEmpty(otherFieldSet)) {
            StringBuffer otherFields = new StringBuffer();
            otherFieldSet.forEach(s -> otherFields.append(",").append((String)s));
            selectFields = selectFields + otherFields;
        }
        QFilter qf = new QFilter("org", "=", (Object)orgId);
        qf.and("costaccount", "=", (Object)costAccountId);
        qf.and("appnum", "=", (Object)appNum);
        qf.and("costcenter", "in", costCenterIds);
        qf.and("effectstatus", "=", (Object)"E");
        DynamicObjectCollection existDiyCostDriverBills = QueryServiceHelper.query((String)"sca_diycostdriver", (String)selectFields, (QFilter[])new QFilter[]{qf});
        HashMap<String, DynamicObject> existDiyCostDriverMap = new HashMap<String, DynamicObject>(16);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)existDiyCostDriverBills)) {
            existDiyCostDriverBills.forEach(s -> {
                String dimensionBillKey = String.format("%s@%s@%s@%s@%s", orgId, costAccountId, s.get("manuorg"), s.get("costcenter"), s.get("costdriver"));
                existDiyCostDriverMap.put(dimensionBillKey, (DynamicObject)s);
            });
        }
        HashMap<String, Boolean> mergerBillSource = new HashMap<String, Boolean>(16);
        for (Map.Entry<DynamicObject, Map<DynamicObject, DynamicObject>> entry : configSrcAndTargetBillsMap.entrySet()) {
            DynamicObject config = entry.getKey();
            long configId = config.getLong("id");
            diyCostDriverArgs.getCollectConfigIds().add(configId);
            boolean isMergeSource = config.getBoolean("ismergesource");
            Map<DynamicObject, DynamicObject> srcAndTargetBillsMap = entry.getValue();
            TreeMap<String, String> configRuleMappingMap = new TreeMap<String, String>();
            if (collConfigRuleMappingMap.get(config.getLong("id")) != null) {
                configRuleMappingMap.putAll(collConfigRuleMappingMap.get(config.getLong("id")));
            }
            Map existCostObjectMap = new HashMap(16);
            if (!CadEmptyUtils.isEmpty(configRuleMappingMap)) {
                String costObjectFields = String.join((CharSequence)",", configRuleMappingMap.keySet());
                existCostObjectMap = CostObjectHelper.getExistCostObjectMap((Long)orgId, null, (String)costObjectFields, (String)appNum);
            }
            for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBills : srcAndTargetBillsMap.entrySet()) {
                DynamicObject srcBill = srcAndTargetBills.getKey();
                DynamicObject diyCostDriverBill = srcAndTargetBills.getValue();
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)diyCostDriverBill.getDynamicObjectCollection("entryentity")) && ((DynamicObject)diyCostDriverBill.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("costobject") == null) {
                    DynamicObject costObject;
                    String srcStr = CostObjectHelper.getCostObjectHashCodeBySrcBill((DynamicObject)srcBill, configRuleMappingMap);
                    Map matInfoList = (Map)existCostObjectMap.get(String.valueOf(orgId));
                    DynamicObject dynamicObject = costObject = matInfoList == null ? null : (DynamicObject)matInfoList.get(srcStr);
                    if (costObject != null) {
                        DynamicObjectCollection entryEntity = diyCostDriverBill.getDynamicObjectCollection("entryentity");
                        DynamicObject newEntity = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity) ? entryEntity.addNew() : (DynamicObject)entryEntity.get(0);
                        DynamicObject loadCostObject = BusinessDataServiceHelper.loadSingleFromCache((Object)costObject.getLong("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_costobject"));
                        newEntity.set("costobject", (Object)loadCostObject);
                        newEntity.set("costobject_id", (Object)loadCostObject.getLong("id"));
                    }
                }
                long manuOrgId = diyCostDriverBill.get("manuorg") == null ? 0L : diyCostDriverBill.getLong("manuorg.id");
                long costCenterId = diyCostDriverBill.get("costcenter") == null ? 0L : diyCostDriverBill.getLong("costcenter.id");
                long costDriverId = diyCostDriverBill.get("costdriver") == null ? 0L : diyCostDriverBill.getLong("costdriver.id");
                diyCostDriverBill.set("org", (Object)org);
                diyCostDriverBill.set("costaccount", (Object)costAccount);
                String mergeBillKey = String.format("%s@%s@%s@%s@%s", orgId, costAccountId, manuOrgId, costCenterId, costDriverId, configId);
                saveDiyCostDriverBillsMap.computeIfAbsent(mergeBillKey, s -> new ArrayList()).add(diyCostDriverBill);
                mergerBillSource.put(mergeBillKey, isMergeSource);
            }
        }
        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>();
        for (Map.Entry saveDiyCostDriverBillEntry : saveDiyCostDriverBillsMap.entrySet()) {
            String mergeKey = (String)saveDiyCostDriverBillEntry.getKey();
            List saveDiyCostDriverBills = (List)saveDiyCostDriverBillEntry.getValue();
            logger.info("\u5f00\u59cb\u5904\u7406\u5408\u5355,\u5408\u5355\u7ef4\u5ea6:{}, \u5355\u636e\u6570\u91cf:{}", (Object)mergeKey, (Object)saveDiyCostDriverBills.size());
            this.createBills(mergeKey, mergerBillSource, targetFieldSet, existDiyCostDriverMap, saveDiyCostDriverBills, arrayList);
        }
        this.getDiyCostDriverContext().getDiyCostDriverBills().addAll(arrayList);
        this.refreshProgress(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u8f6c\u6362\u5b8c\u6210\u3002", (String)"DiyCostDriverImportDataConfigAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), 9, 14, false);
    }

    private void createBills(String mergeKey, Map<String, Boolean> mergerBillSource, Set<String> targetFieldSet, Map<String, DynamicObject> existDiyCostDriverMap, List<DynamicObject> saveDiyCostDriverBills, List<DynamicObject> saveMfgFeeBillList) {
        DynamicObject diyCostDriverBill = saveDiyCostDriverBills.get(0);
        DynamicObjectCollection saveEntryEntity = diyCostDriverBill.getDynamicObjectCollection("entryentity");
        DynamicObject costDriver = diyCostDriverBill.getDynamicObject("costdriver");
        boolean isFirstRow = true;
        boolean isMergeBillSource = mergerBillSource.get(mergeKey);
        HashMap<String, DynamicObject> mergeEntryEntity = new HashMap<String, DynamicObject>(16);
        String mergeEntryKey = "";
        String allocClass = costDriver.getString("allocclass");
        for (DynamicObject saveDiyCostDriverBill : saveDiyCostDriverBills) {
            DynamicObject entry;
            DynamicObjectCollection entryEntity = saveDiyCostDriverBill.getDynamicObjectCollection("entryentity");
            DynamicObject targetEntry = null;
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
                targetEntry = (DynamicObject)entryEntity.get(0);
            }
            if (isMergeBillSource) {
                Long dimensionKey = 0L;
                if (targetEntry != null) {
                    if ("COSTOBJECT".equals(allocClass) && targetEntry.get("costobject") != null) {
                        dimensionKey = targetEntry.getLong("costobject.id");
                    } else if ("COSTCENTER".equals(allocClass) && targetEntry.get("benefcostcenter") != null) {
                        dimensionKey = targetEntry.getLong("benefcostcenter.id");
                    } else if ("MATERIAL".equals(allocClass) && targetEntry.get("matnum") != null) {
                        dimensionKey = targetEntry.getLong("matnum.id");
                    } else if ("MATERIALGROUP".equals(allocClass) && targetEntry.get("materialgroup") != null) {
                        dimensionKey = targetEntry.getLong("materialgroup.id");
                    }
                }
                mergeEntryKey = mergeKey + "@" + dimensionKey;
                if (isFirstRow) {
                    entry = (DynamicObject)saveEntryEntity.get(0);
                    this.setEntryFieldValue(entry, targetEntry, targetFieldSet);
                } else if (mergeEntryEntity.get(mergeEntryKey) != null) {
                    entry = (DynamicObject)mergeEntryEntity.get(mergeEntryKey);
                    BigDecimal entryQty = entry.getBigDecimal(ENTRY_QTY_FIELD);
                    if (targetEntry != null) {
                        entryQty = entryQty.add(targetEntry.getBigDecimal(ENTRY_QTY_FIELD));
                    }
                    entry.set(ENTRY_QTY_FIELD, (Object)entryQty);
                } else {
                    entry = saveEntryEntity.addNew();
                    this.setEntryFieldValue(entry, targetEntry, targetFieldSet);
                }
                mergeEntryEntity.put(mergeEntryKey, entry);
            } else {
                entry = isFirstRow ? (DynamicObject)saveEntryEntity.get(0) : saveEntryEntity.addNew();
                this.setEntryFieldValue(entry, targetEntry, targetFieldSet);
            }
            isFirstRow = false;
        }
        saveMfgFeeBillList.add(diyCostDriverBill);
    }

    private void setEntryFieldValue(DynamicObject entry, DynamicObject targetEntry, Set<String> targetFieldSet) {
        if (targetEntry != null && !CadEmptyUtils.isEmpty((DynamicObject)targetEntry)) {
            for (String costField : targetFieldSet) {
                if (CadEmptyUtils.isEmpty((String)costField) || !costField.contains(".")) continue;
                String entryField = costField.split("\\.")[1];
                entry.set(entryField, targetEntry.get(entryField));
            }
        }
    }
}

