/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.diycostdriver;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.common.helper.OperationResultHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.diycostdriver.AbstractDiyCostDriverAction;
import kd.macc.cad.mservice.diycostdriver.DiyCostDriverArgs;

public class DiyCostDriverSaveAction
extends AbstractDiyCostDriverAction {
    private static final Log logger = LogFactory.getLog(DiyCostDriverSaveAction.class);

    @Override
    protected void doExecute() {
        this.refreshProgress(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u5df2\u4fdd\u5b58\u5e76\u751f\u6548\u4e2d\u3002", (String)"DiyCostDriverSaveAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), 11, 14, false);
        List<DynamicObject> diyCostDriverBills = this.getDiyCostDriverContext().getDiyCostDriverBills();
        DiyCostDriverArgs diyCostDriverArgs = this.getDiyCostDriverContext().getDiyCostDriverArgs();
        Set<Long> collectConfigIds = diyCostDriverArgs.getCollectConfigIds();
        if (CadEmptyUtils.isEmpty(diyCostDriverBills)) {
            this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"DiyCostDriverSaveAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, false);
            return;
        }
        logger.info("\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u5185\u90e8\u7cfb\u7edf\u5f15\u5165-\u5f15\u5165\u7684\u5f52\u96c6\u5355\u6570\u91cf\uff1a{}", (Object)diyCostDriverBills.size());
        try (TXHandle txHandle = TX.required();){
            int batchSize;
            int saveSize;
            if (!SysParamHelper.getEnableEffectByOrg((Long)diyCostDriverArgs.getAcctOrgId(), (String)diyCostDriverArgs.getAppNum(), (String)"sca_diycostdriver").booleanValue() && !CadEmptyUtils.isEmpty(collectConfigIds)) {
                QFilter qFilter = new QFilter("org", "=", (Object)diyCostDriverArgs.getAcctOrgId());
                qFilter.and("costcenter", "in", diyCostDriverArgs.getCostCenterIds());
                qFilter.and("collconfig", "in", collectConfigIds);
                qFilter.and(SysParamHelper.getImportTimeScope((Long)diyCostDriverArgs.getAcctOrgId(), (String)"bookdate", (String)diyCostDriverArgs.getAppNum()));
                int deleteSize = DeleteServiceHelper.delete((String)"sca_diycostdriver", (QFilter[])qFilter.toArray());
                this.getDiyCostDriverContext().setDelNum(deleteSize);
            }
            if ((saveSize = diyCostDriverBills.size()) <= (batchSize = 300) * 3) {
                this.save(diyCostDriverBills);
            } else {
                int batchCount = saveSize / batchSize + 1;
                for (int i = 0; i < batchCount; ++i) {
                    int startCount = i * batchSize;
                    int endCount = (i + 1) * batchSize;
                    if (i == batchCount - 1) {
                        endCount = saveSize;
                    }
                    List<DynamicObject> batchBillList = diyCostDriverBills.subList(startCount, endCount);
                    this.save(batchBillList);
                }
            }
        }
        this.getDiyCostDriverContext().setAddNum(diyCostDriverBills.size());
        this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"DiyCostDriverSaveAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, false);
    }

    private void save(List<DynamicObject> diyCostDriverBills) {
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"sca_diycostdriver", (DynamicObject[])diyCostDriverBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!operateResult.isSuccess()) {
            String errorInfo = OperationResultHelper.errorMsgHandle((OperationResult)operateResult);
            logger.error("\u4fdd\u5b58\u5931\u8d25\u3002" + errorInfo);
            throw new KDBizException(errorInfo);
        }
        OperationResult effectResult = OperationServiceHelper.executeOperate((String)"effect", (String)"sca_diycostdriver", (DynamicObject[])diyCostDriverBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!effectResult.isSuccess()) {
            String errorInfo = OperationResultHelper.errorMsgHandle((OperationResult)effectResult);
            logger.error("\u751f\u6548\u5931\u8d25\u3002" + errorInfo);
            throw new KDBizException(errorInfo);
        }
    }
}

