/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.event;

import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.settle.CalcSettleEngine;
import kd.macc.cad.common.enums.CadCommonEventEnum;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class CadCommonBusEvent
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(CadCommonBusEvent.class);

    public Object handleEvent(KDBizEvent e) {
        String jsonSource = e.getSource();
        logger.info("\u63a5\u6536\u5de5\u5355\u5173\u95ed\u4e8b\u4ef6\u53c2\u6570\uff1a" + jsonSource);
        if (StringUtils.isEmpty((String)jsonSource)) {
            return e.getEventId();
        }
        JSONArray custparamJs = JSONArray.fromObject((Object)jsonSource);
        for (int index = 0; index < custparamJs.size(); ++index) {
            JSONObject obj = custparamJs.getJSONObject(index);
            String type = obj.getString("type");
            String json = obj.getString("json");
            JSONObject paramObj = null;
            if (!StringUtils.isEmpty((String)json)) {
                paramObj = JSONObject.fromObject((Object)json);
            }
            if (!CadCommonEventEnum.CALC_SETTLE_TASK_EXEC.getValue().equals(type)) continue;
            this.calcSettleTaskExec(paramObj);
        }
        return e.getEventId();
    }

    private void calcSettleTaskExec(JSONObject paramObj) {
        if (paramObj == null) {
            return;
        }
        try {
            Long taskId = paramObj.getLong("taskId");
            if (!CadEmptyUtils.isEmpty((Long)taskId)) {
                CalcSettleEngine.executeTask((Long)taskId);
            }
        }
        catch (Exception ex) {
            logger.error("\u6708\u7ed3\u4efb\u52a1\u6267\u884c\u62a5\u9519", (Throwable)ex);
        }
    }
}

