/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.event;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.event.AbstractOrgChangeEventServicePlugin;
import kd.bos.org.model.OrgChangeCheckReport;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class CadResertRoots
extends AbstractOrgChangeEventServicePlugin {
    private static final Log logger = LogFactory.getLog(CadResertRoots.class);

    protected OrgChangeCheckReport handleEventAndReturnCheckReport(KDBizEvent evt) {
        OrgChangeCheckReport orgChangeCheckReport = new OrgChangeCheckReport();
        try {
            String variableStr = evt.getVariables();
            logger.info("\u91cd\u7f6e\u8ddf\u7ec4\u7ec7\u8fd4\u56de\u53c2\u6570==>{}", (Object)variableStr);
            JSONObject variables = (JSONObject)SerializationUtils.fromJsonString((String)variableStr, JSONObject.class);
            Object subscriptionId = variables.get("subscription_id");
            if (Objects.nonNull(subscriptionId)) {
                orgChangeCheckReport.setEventId(Long.valueOf(subscriptionId.toString()));
            }
            JSONObject operationParams = variables.getJSONObject("base_orgchange_resetroot");
            String changeRecordId = operationParams.getString("changerecordid");
            orgChangeCheckReport.setChangeRecordId(Long.valueOf(changeRecordId));
            JSONArray synviewsJs = operationParams.getJSONArray("synviews");
            String oldrootid = "";
            String newrootid = "";
            for (int index = 0; index < synviewsJs.size(); ++index) {
                JSONObject obj = synviewsJs.getJSONObject(index);
                String viewId = obj.getString("viewid");
                if (!"10".equals(viewId)) continue;
                oldrootid = obj.getString("oldrootid");
                newrootid = obj.getString("newrootid");
            }
            logger.info("\u91cd\u7f6e\u8ddf\u7ec4\u7ec7\uff0c\u539f\u7ec4\u7ec7id==>{},\u65b0\u7ec4\u7ec7id==>{}", (Object)oldrootid, (Object)newrootid);
            if (!(CadEmptyUtils.isEmpty((String)oldrootid) || CadEmptyUtils.isEmpty((String)newrootid) || oldrootid.equals(newrootid))) {
                logger.info("\u91cd\u7f6e\u8ddf\u7ec4\u7ec7-\u6210\u672c\u5f52\u96c6\u914d\u7f6e-\u5f00\u59cb");
                String updateSql = "update t_cad_costconfigplan set forgid=%s where fpreset = '1'";
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)String.format(updateSql, Long.valueOf(newrootid)));
                logger.info("\u91cd\u7f6e\u8ddf\u7ec4\u7ec7-\u6210\u672c\u5f52\u96c6\u914d\u7f6e-\u7ed3\u675f");
            }
            String querySql = "select fid,fnumber,fname from t_org_org where fid =" + Long.valueOf(newrootid);
            HashMap numberMap = new HashMap();
            DB.query((DBRoute)DBRoute.basedata, (String)querySql, rh -> {
                while (rh.next()) {
                    numberMap.put("fid", rh.getString("fid"));
                    numberMap.put("fnumber", rh.getString("fnumber"));
                    numberMap.put("fname", rh.getString("fname"));
                }
                return null;
            });
            QFilter filter = new QFilter("parent", "=", (Object)0);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_costcenter", (String)"orgduty", (QFilter[])filter.toArray());
            if (dynamicObject != null) {
                DynamicObject[] dynamicObjects;
                DynamicObject dynamicObjectNew = BusinessDataServiceHelper.newDynamicObject((String)"bos_costcenter");
                dynamicObjectNew.set("id", (Object)Long.valueOf(newrootid));
                dynamicObjectNew.set("orgduty", (Object)dynamicObject.getLong("orgduty.masterid"));
                dynamicObjectNew.set("number", numberMap.get("fnumber"));
                dynamicObjectNew.set("name", numberMap.get("fname"));
                dynamicObjectNew.set("parent", (Object)0);
                dynamicObjectNew.set("enable", (Object)Character.valueOf('1'));
                dynamicObjectNew.set("masterid", (Object)Long.valueOf(newrootid));
                dynamicObjectNew.set("status", (Object)"C");
                dynamicObjectNew.set("longnumber", numberMap.get("fnumber"));
                dynamicObjectNew.set("isleaf", (Object)Character.valueOf('0'));
                dynamicObjectNew.set("creator", (Object)RequestContext.getOrCreate().getCurrUserId());
                dynamicObjectNew.set("modifier", (Object)RequestContext.getOrCreate().getCurrUserId());
                String updateSql = "update t_bas_costcenter set fparentid=%s,faccountorgid =%s where fparentid =0 ";
                logger.info("\u91cd\u7f6e\u8ddf\u7ec4\u7ec7-\u6210\u672c\u4e2d\u5fc3-\u66f4\u65b0\u65e7\u7ec4\u7ec7\u5f00\u59cb");
                DB.execute((DBRoute)new DBRoute("sys"), (String)String.format(updateSql, Long.valueOf(newrootid), Long.valueOf(newrootid)));
                logger.info("\u91cd\u7f6e\u8ddf\u7ec4\u7ec7-\u6210\u672c\u4e2d\u5fc3-\u66f4\u65b0\u65e7\u7ec4\u7ec7\u7ed3\u675f");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObjectNew});
                logger.info("\u91cd\u7f6e\u8ddf\u7ec4\u7ec7-\u6210\u672c\u4e2d\u5fc3-\u66f4\u65b0\u957f\u7f16\u7801\u5f00\u59cb");
                this.updateCostCenterLongNumber();
                logger.info("\u91cd\u7f6e\u8ddf\u7ec4\u7ec7-\u6210\u672c\u4e2d\u5fc3-\u66f4\u65b0\u957f\u7f16\u7801\u7ed3\u675f");
                logger.info("\u91cd\u7f6e\u8ddf\u7ec4\u7ec7-\u6210\u672c\u4e2d\u5fc3-\u66f4\u65b0\u7ea7\u6b21\u5f00\u59cb");
                for (DynamicObject object : dynamicObjects = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,level", null)) {
                    object.set("level", (Object)(object.getInt("level") + 1));
                }
                SaveServiceHelper.update((DynamicObject[])dynamicObjects);
                logger.info("\u91cd\u7f6e\u8ddf\u7ec4\u7ec7-\u6210\u672c\u4e2d\u5fc3-\u66f4\u65b0\u7ea7\u6b21\u7ed3\u675f");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return orgChangeCheckReport;
    }

    private void updateCostCenterLongNumber() {
        QFilter qFilter = new QFilter("parent", "=", (Object)0L);
        DataSet updateDataSet = QueryServiceHelper.queryDataSet((String)"queryCostCenter", (String)"bos_costcenter", (String)"id,parent,number,name", (QFilter[])qFilter.toArray(), null);
        HashMap<Long, String> longNumberMap = new HashMap<Long, String>(256);
        HashMap<Long, String> fullNameMap = new HashMap<Long, String>(256);
        HashSet<Long> rootParentIds = new HashSet<Long>(16);
        for (Row row : updateDataSet) {
            Long id = row.getLong("id");
            String number = row.getString("number");
            String name = row.getString("name");
            longNumberMap.put(id, number);
            fullNameMap.put(id, name);
            rootParentIds.add(id);
        }
        String longNumberDLM = CadResertRoots.getLongNumberDML();
        this.queryChildData(rootParentIds, longNumberMap, fullNameMap, longNumberDLM);
        if (longNumberMap.size() > 0) {
            DynamicObject[] costCenterBills;
            QFilter idQFilter = new QFilter("id", "in", longNumberMap.keySet());
            for (DynamicObject costCenter : costCenterBills = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,longnumber,fullname", (QFilter[])idQFilter.toArray())) {
                long costCenterId = costCenter.getLong("id");
                costCenter.set("longnumber", longNumberMap.get(costCenterId));
                costCenter.set("fullname", fullNameMap.get(costCenterId));
            }
            SaveServiceHelper.update((DynamicObject[])costCenterBills);
        }
    }

    public static String getLongNumberDML() {
        String longNumberDLM = ".";
        MainEntityType costCenterEntityType = EntityMetadataCache.getDataEntityType((String)"bos_costcenter");
        if (costCenterEntityType != null && costCenterEntityType.getProperties() != null) {
            for (IDataEntityProperty dymProperty : costCenterEntityType.getProperties()) {
                if (!(dymProperty instanceof ParentBasedataProp)) continue;
                longNumberDLM = ((ParentBasedataProp)dymProperty).getLongNumberDLM();
                break;
            }
        }
        return longNumberDLM;
    }

    private void queryChildData(Set<Long> parentIds, Map<Long, String> longNumberMap, Map<Long, String> fullNameMap, String longNumberDLM) {
        QFilter parentFilter = new QFilter("parent", "in", parentIds);
        DataSet levelDataSet = QueryServiceHelper.queryDataSet((String)"queryCostCenter", (String)"bos_costcenter", (String)"id,parent,number,name", (QFilter[])parentFilter.toArray(), null);
        if (levelDataSet == null || levelDataSet.isEmpty()) {
            return;
        }
        HashSet<Long> currentParentIds = new HashSet<Long>(16);
        String longNumberFormat = "%s" + longNumberDLM + "%s";
        for (Row row : levelDataSet) {
            long parentId = row.getLong("parent");
            Long id = row.getLong("id");
            String number = row.getString("number");
            String name = row.getString("name");
            String parentNumber = longNumberMap.get(parentId);
            String parentName = fullNameMap.get(parentId);
            String longNumber = String.format(longNumberFormat, parentNumber, number);
            String fullName = String.format(longNumberFormat, parentName, name);
            longNumberMap.put(id, longNumber);
            fullNameMap.put(id, fullName);
            currentParentIds.add(id);
        }
        this.queryChildData(currentParentIds, longNumberMap, fullNameMap, longNumberDLM);
    }
}

