/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.factedoutput;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.dto.OutSourcePrice;
import kd.macc.cad.common.dto.ProgressParamDto;
import kd.macc.cad.common.enums.CollectStatus;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.EntityPropertyHelper;
import kd.macc.cad.common.helper.ImportInitCostHelper;
import kd.macc.cad.common.helper.OperationResultHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.ResourceAbsorbHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.common.utils.UUIDUtils;
import kd.macc.cad.mservice.factedoutput.CompletionContext;
import kd.macc.cad.mservice.factedoutput.ICompletionAction;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractCompletionAction
implements ICompletionAction {
    private Log logger = LogFactory.getLog(AbstractCompletionAction.class);
    protected static final String SELECT_PRO = "id,billno,invscheme,billentry.Seq,billentry.id entryId,billentry.material material,billentry.productnum productnum,biztime,bookdate,billentry.baseunit baseunit,billentry.mversion mversion,billentry.auxpty auxpty,billentry.warehouse warehouse,billentry.location location,billentry.lotnumber lotnumber,billentry.baseqty baseqty,org,auditdate,bizorg";
    protected static final String LOAD_PRO = "id,billno,invscheme,invscheme.number,billentry.Seq,billentry.material,billentry.productnum,biztime,bookdate,billentry.baseunit,billentry.mversion,billentry.auxpty,billentry.warehouse,billentry.location,billentry.lotnumber,billentry.baseqty,org,auditdate,bizorg";
    private CompletionContext completionContext;

    protected abstract void doExecute();

    @Override
    public void execute() {
        if (this.completionContext.isContinueExecute()) {
            this.doExecute();
        }
    }

    @Override
    public void setContext(CompletionContext completionContext) {
        this.completionContext = completionContext;
    }

    public CompletionContext getCompletionContext() {
        return this.completionContext;
    }

    protected Map<String, List<Long>> getInnerSys(Long accountOrg, List<Long> costCenters, String appNum) {
        ArrayList costCentersCopy = Lists.newArrayList(costCenters);
        HashMap billCostCentersMap = Maps.newHashMapWithExpectedSize((int)8);
        HashMap ccRangeMap = Maps.newHashMapWithExpectedSize((int)8);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter orgQf = new QFilter("accountorg", "=", (Object)accountOrg);
        if (!CadEmptyUtils.isEmpty((Long)accountOrg)) {
            filters.add(orgQf);
        }
        if (!CadEmptyUtils.isEmpty((List)costCentersCopy)) {
            filters.add(new QFilter("costcenter", "in", (Object)costCentersCopy));
        }
        filters.add(new QFilter("appnum", "=", (Object)appNum));
        DynamicObjectCollection sysParams = QueryServiceHelper.query((String)"cad_sysparam", (String)"costcenter,completetype,billrange", (QFilter[])filters.toArray(new QFilter[0]));
        filters.clear();
        filters.add(orgQf);
        filters.add(new QFilter("appnum", "=", (Object)appNum));
        filters.add(new QFilter("costcenter", "=", (Object)0L));
        DynamicObject orgSysParam = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"costcenter,completetype,billrange", (QFilter[])filters.toArray(new QFilter[0]));
        if (sysParams != null && sysParams.size() > 0) {
            for (DynamicObject sysParam : sysParams) {
                String[] completeCollectRange = sysParam.getString("billrange");
                long costCenter = sysParam.getLong("costcenter");
                if (kd.bos.login.utils.StringUtils.isNotBlank((String)completeCollectRange)) {
                    String[] ranges;
                    ccRangeMap.put(costCenter, completeCollectRange);
                    for (String range : ranges = completeCollectRange.split(",")) {
                        billCostCentersMap.computeIfAbsent(range, cc -> new ArrayList()).add(costCenter);
                    }
                    costCentersCopy.remove(costCenter);
                    continue;
                }
                ccRangeMap.put(costCenter, completeCollectRange);
                billCostCentersMap.computeIfAbsent(completeCollectRange, cc -> new ArrayList()).add(costCenter);
                costCentersCopy.remove(costCenter);
            }
            if (!costCentersCopy.isEmpty() && orgSysParam != null) {
                String completeCollectRange = orgSysParam.getString("billrange");
                if (kd.bos.login.utils.StringUtils.isNotBlank((String)completeCollectRange)) {
                    String[] ranges = completeCollectRange.split(",");
                    for (String range : ranges) {
                        billCostCentersMap.computeIfAbsent(range, cc -> new ArrayList()).addAll(costCentersCopy);
                    }
                    for (Long costCenter : costCentersCopy) {
                        ccRangeMap.put(costCenter, completeCollectRange);
                    }
                } else {
                    for (Long costCenter : costCentersCopy) {
                        ccRangeMap.put(costCenter, completeCollectRange);
                    }
                }
            }
        } else if (!costCentersCopy.isEmpty() && orgSysParam != null) {
            String completeCollectRange = orgSysParam.getString("billrange");
            if (kd.bos.login.utils.StringUtils.isNotBlank((String)completeCollectRange)) {
                String[] ranges = completeCollectRange.split(",");
                for (String range : ranges) {
                    billCostCentersMap.computeIfAbsent(range, cc -> new ArrayList()).addAll(costCentersCopy);
                }
                for (Long costCenter : costCentersCopy) {
                    ccRangeMap.put(costCenter, completeCollectRange);
                }
            } else {
                billCostCentersMap.computeIfAbsent(completeCollectRange, cc -> new ArrayList()).addAll(costCentersCopy);
                for (Long costCenter : costCentersCopy) {
                    ccRangeMap.put(costCenter, completeCollectRange);
                }
            }
        }
        this.getCompletionContext().getCollectReport().getCcRangeMap().putAll(ccRangeMap);
        return billCostCentersMap;
    }

    protected Map<Long, String> getOutSourcePrice(long accountOrg, String appNum) {
        return null;
    }

    protected Map<String, Map<Long, Set<Long>>> getManuBill(String entityName, Long org, List<Long> costCenterId, List<Long> manuOrgs, List<Long> mftorderentryids, String appNum, Map<String, Object> collectParamMap) {
        QFilter manuOrgsQf;
        String entityDesc = "";
        if ("im_mdc_mftmanuinbill".equals(entityName)) {
            entityDesc = ResManager.loadKDString((String)"\u5b8c\u5de5\u5165/\u9000\u5e93\u5355", (String)"AbstractCompletionAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]);
        } else if ("im_mdc_omcmplinbill".equals(entityName)) {
            entityDesc = ResManager.loadKDString((String)"\u59d4\u5916\u5b8c\u5de5\u5165/\u9000\u5e93\u5355", (String)"AbstractCompletionAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        this.getCompletionContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5de5\u5355\u6cd5-\u83b7\u53d6%s", (String)"AbstractCompletionAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), entityDesc));
        HashMap<String, Map<Long, Set<Long>>> resultBillMap = new HashMap<String, Map<Long, Set<Long>>>(16);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List<Map<String, Date>> importScopeDate = this.getCompletionContext().getOrgImportScopeDate().get(org);
        List workCenter = CostCenterHelper.getWorkCenter(costCenterId, importScopeDate, (CollectReport)this.getCompletionContext().getCollectReport());
        List dataId = CostCenterHelper.getBosOrgs(costCenterId, importScopeDate, (CollectReport)this.getCompletionContext().getCollectReport());
        List adminOrgIds = CostCenterHelper.getAdminOrg(costCenterId, importScopeDate, (CollectReport)this.getCompletionContext().getCollectReport());
        QFilter wcOrOrgOrAoQF = this.getWcOrOrgOrAoQFByWay(workCenter, dataId, adminOrgIds, entityName);
        if (wcOrOrgOrAoQF == null) {
            this.getCompletionContext().getCollectReport().logStatusChange(CollectStatus.REMIND, String.format(ResManager.loadKDString((String)"\u5de5\u5355\u6210\u672c\u6cd5\u6210\u672c\u4e2d\u5fc3\u672a\u8bbe\u7f6e\u6765\u6e90\uff0c\u5de5\u5355\u6210\u672c\u6cd5\u83b7\u53d6%s\u7ed3\u675f\u3002", (String)"AbstractCompletionAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), entityDesc));
            this.logger.info("\u6210\u672c\u4e2d\u5fc3:{}\u672a\u8bbe\u7f6e\u6765\u6e90\uff0c\u6b64\u6210\u672c\u4e2d\u5fc3\u5f15\u5165\u7ed3\u675f!", costCenterId);
            return resultBillMap;
        }
        filters.add(wcOrOrgOrAoQF);
        QFilter billQf = new QFilter("billtype.billformid.number", "=", (Object)"im_mdc_mftmanuinbill");
        QFilter wgtkQf = new QFilter("billtype.billformid.number", "=", (Object)"im_mdc_mftreturnbill");
        if ("im_mdc_mftmanuinbill".equals(entityName)) {
            if (!CadEmptyUtils.isEmpty(mftorderentryids)) {
                filters.add(new QFilter("billentry.manuentryid", "in", mftorderentryids));
            }
            if (!CadEmptyUtils.isEmpty(manuOrgs)) {
                manuOrgsQf = new QFilter("productionorg", "in", manuOrgs);
                filters.add(manuOrgsQf);
            }
        }
        if ("im_mdc_omcmplinbill".equals(entityName)) {
            if (!CadEmptyUtils.isEmpty(mftorderentryids)) {
                filters.add(new QFilter("billentry.manuentryid", "in", mftorderentryids));
            }
            if (!CadEmptyUtils.isEmpty(manuOrgs)) {
                manuOrgsQf = new QFilter("billentry.entryreqorg", "in", manuOrgs);
                filters.add(manuOrgsQf);
            }
            billQf = new QFilter("billtype.billformid.number", "=", (Object)"im_mdc_omcmplinbill");
        }
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        Map notNeedCollectBillBizIdsMap = SysParamHelper.getNotNeedCollectBillBizIdsMap((Long)org, (String)"cad_factnedoutputbill", (String)entityName, (String)"bizsettingentry.biztype.fbasedataid.id,bizsettingentry.invscheme.fbasedataid.id", (String)appNum);
        Set bizTypeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.biztype.fbasedataid.id");
        Set invSchemeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.invscheme.fbasedataid.id");
        if (!CadEmptyUtils.isEmpty((Set)bizTypeIds)) {
            this.getCompletionContext().getCollectReport().setBizTypeIds(bizTypeIds);
            billQf.and(new QFilter("biztype", "not in", (Object)bizTypeIds));
        }
        if (!CadEmptyUtils.isEmpty((Set)invSchemeIds)) {
            this.getCompletionContext().getCollectReport().setInvSchemeIds(invSchemeIds);
            billQf.and(new QFilter("invscheme", "not in", (Object)invSchemeIds));
        }
        if ("im_mdc_mftmanuinbill".equals(entityName)) {
            notNeedCollectBillBizIdsMap = SysParamHelper.getNotNeedCollectBillBizIdsMap((Long)org, (String)"cad_factnedoutputbill", (String)"im_mdc_mftreturnbill", (String)"bizsettingentry.biztype.fbasedataid.id,bizsettingentry.invscheme.fbasedataid.id", (String)appNum);
            bizTypeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.biztype.fbasedataid.id");
            invSchemeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.invscheme.fbasedataid.id");
            if (!CadEmptyUtils.isEmpty((Set)bizTypeIds)) {
                wgtkQf.and(new QFilter("biztype", "not in", (Object)bizTypeIds));
            }
            if (!CadEmptyUtils.isEmpty((Set)invSchemeIds)) {
                wgtkQf.and(new QFilter("invscheme", "not in", (Object)invSchemeIds));
            }
        }
        QFilter billTypeQf = billQf.or(wgtkQf);
        filters.add(billTypeQf);
        QFilter timeQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum, (CollectReport)this.getCompletionContext().getCollectReport());
        if (!CadEmptyUtils.isEmpty(collectParamMap) && collectParamMap.get("startDate") != null && collectParamMap.get("endDate") != null) {
            QFilter collectTimeQFilter = new QFilter("bookdate", ">=", collectParamMap.get("startDate"));
            collectTimeQFilter.and(new QFilter("bookdate", "<=", collectParamMap.get("endDate")));
            timeQf.and(collectTimeQFilter);
        }
        filters.add(timeQf);
        this.getCompletionContext().getCollectReport().setTimeQf(timeQf);
        DynamicObjectCollection bills = null;
        bills = "im_mdc_mftmanuinbill".equals(entityName) ? QueryServiceHelper.query((String)entityName, (String)"id,invscheme.billform.number invscheme,productionorg", (QFilter[])filters.toArray(new QFilter[0])) : QueryServiceHelper.query((String)entityName, (String)"id,invscheme.billform.number invscheme,billentry.entryreqorg productionorg", (QFilter[])filters.toArray(new QFilter[0]));
        if (bills == null) {
            this.getCompletionContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5de5\u5355\u6cd5-\u83b7\u53d6\u5230%s\u6570\u636e0\u6761\u3002", (String)"AbstractCompletionAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), entityDesc));
            return resultBillMap;
        }
        this.getCompletionContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5de5\u5355\u6cd5\u83b7\u53d6\u5230\u201c%1$s\u201d\u6570\u636e%2$s\u6761\u3002", (String)"AbstractCompletionAction_17", (String)"macc-cad-mservice", (Object[])new Object[0]), entityDesc, bills.size()));
        for (DynamicObject bill : bills) {
            Map sourceBillMap = resultBillMap.computeIfAbsent(bill.getString("invscheme"), p -> new HashMap(16));
            sourceBillMap.computeIfAbsent(bill.getLong("productionorg"), p -> new HashSet(200)).add(bill.getLong("id"));
        }
        HashMap emptyMap = Maps.newHashMapWithExpectedSize((int)1);
        emptyMap.put(0L, Sets.newHashSetWithExpectedSize((int)0));
        if ("im_mdc_mftmanuinbill".equals(entityName)) {
            if (!resultBillMap.containsKey("im_mdc_mftmanuinbill")) {
                resultBillMap.put("im_mdc_mftmanuinbill", emptyMap);
            }
            if (!resultBillMap.containsKey("im_mdc_mftreturnbill")) {
                resultBillMap.put("im_mdc_mftreturnbill", emptyMap);
            }
        } else if (!resultBillMap.containsKey("im_mdc_omcmplinbill")) {
            resultBillMap.put("im_mdc_omcmplinbill", emptyMap);
        }
        return resultBillMap;
    }

    protected Object getBizDate(Date date) {
        if (date == null) {
            return TimeServiceHelper.now();
        }
        Calendar now = Calendar.getInstance();
        now.setTime(TimeServiceHelper.now());
        Calendar bizTime = Calendar.getInstance();
        bizTime.setTime(date);
        bizTime.set(11, now.get(11));
        bizTime.set(12, now.get(12));
        bizTime.set(13, now.get(13));
        return bizTime;
    }

    protected void doDiff(BigDecimal completeqty, DynamicObjectCollection entryentity, Boolean notBack) {
        if (entryentity.size() == 0) {
            return;
        }
        BigDecimal maxVal = BigDecimal.ZERO;
        BigDecimal sumVal = BigDecimal.ZERO;
        BigDecimal curVal = BigDecimal.ZERO;
        int index = 0;
        for (int i = 0; i < entryentity.size(); ++i) {
            curVal = ((DynamicObject)entryentity.get(i)).getBigDecimal("qty");
            sumVal = sumVal.add(curVal);
            if (!notBack.booleanValue() && i == 0) {
                maxVal = curVal;
            }
            if (maxVal.compareTo(curVal) >= 0) continue;
            maxVal = curVal;
            index = i;
        }
        ((DynamicObject)entryentity.get(index)).set("qty", (Object)maxVal.add(completeqty.subtract(sumVal)));
    }

    protected DynamicObject[] getTypeCostObject(Long org, List<Long> typeCostCenters) {
        QFilter orgQf = new QFilter("org", "=", (Object)org);
        QFilter costCenterQf = new QFilter("costcenter", "in", typeCostCenters);
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        return BusinessDataServiceHelper.load((String)"cad_costobject", (String)"id,material,srcbillnumber,producenum,costcenter", (QFilter[])new QFilter[]{orgQf, costCenterQf, billStatus});
    }

    protected List<Long> getExistsCompletion(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, String[] completetypes, String appNum) {
        QFilter orgQf = new QFilter("org", "in", (Object)org);
        QFilter costObjectQf = new QFilter("costcenter", "in", methodCostCenters);
        QFilter AppnumQf = new QFilter("appnum", "=", (Object)appNum);
        if (!CadEmptyUtils.isEmpty((Object[])completetypes)) {
            orgQf.and(new QFilter("completetype", "in", (Object)completetypes));
        }
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            orgQf.and(new QFilter("manuorg", "in", manuOrgs));
        }
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum);
        DynamicObjectCollection completionList = QueryServiceHelper.query((String)"cad_factnedoutputbill", (String)"id", (QFilter[])new QFilter[]{orgQf, costObjectQf, bookDateQf, AppnumQf});
        if (CadEmptyUtils.isEmpty((List)completionList)) {
            return null;
        }
        return completionList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    protected DataSet getExistsCompletBill(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, String srcBillType, String appNum, Map<String, Object> collectParamMap, long configId, Set<Long> allCollconfigIds) {
        QFilter orgQf = new QFilter("org", "in", (Object)org);
        if (allCollconfigIds != null) {
            orgQf.and(new QFilter("collconfig", "not in", allCollconfigIds));
        } else {
            orgQf.and(new QFilter("srcbilltype", "=", (Object)srcBillType));
            if (!CadEmptyUtils.isEmpty((Long)configId)) {
                orgQf.and(new QFilter("collconfig", "=", (Object)configId));
            }
        }
        QFilter costObjectQf = new QFilter("costcenter", "in", methodCostCenters);
        QFilter appnumQf = new QFilter("appnum", "=", (Object)appNum);
        QFilter voucherTypeQf = new QFilter("vouchertype", "=", (Object)" ");
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            orgQf.and(new QFilter("manuorg", "in", manuOrgs));
        }
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum);
        if (!CadEmptyUtils.isEmpty(collectParamMap) && collectParamMap.get("startDate") != null && collectParamMap.get("endDate") != null) {
            QFilter collectTimeQFilter = new QFilter("bookdate", ">=", collectParamMap.get("startDate"));
            collectTimeQFilter.and(new QFilter("bookdate", "<=", collectParamMap.get("endDate")));
            bookDateQf.and(collectTimeQFilter);
        }
        this.logger.info("\u67e5\u8be2\u5df2\u5b58\u5728\u7684\u5355\u636e\u6761\u4ef6\uff1a{},{}.{}.{},{}", new Object[]{orgQf, costObjectQf, bookDateQf, voucherTypeQf, appnumQf});
        return QueryServiceHelper.queryDataSet((String)"factnedoutputbill", (String)"cad_factnedoutputbill", (String)"id,sourcebillentry sourcebillentryid,nsrcauditdate", (QFilter[])new QFilter[]{orgQf, costObjectQf, bookDateQf, appnumQf, voucherTypeQf}, null);
    }

    protected List<Long> getExistsCompletBillIds(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, List<Long> mftOrderEntryIds, Map<String, String> configRuleMappingMap, String srcBillType, String appNum, Map<String, Object> collectParamMap, long configId, Set<Long> allCollconfigIds) {
        DataSet resultDs = this.getExistsCompletBill(org, methodCostCenters, manuOrgs, mftOrderEntryIds, configRuleMappingMap, srcBillType, appNum, collectParamMap, configId, allCollconfigIds);
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (Row row : resultDs) {
            ids.add(row.getLong("id"));
        }
        return ids;
    }

    protected List<Long> getExistsCompletBillIds(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, String srcBillType, String appNum, Map<String, Object> collectParamMap, long configId, Set<Long> allCollconfigIds) {
        DataSet resultDs = this.getExistsCompletBill(org, methodCostCenters, manuOrgs, srcBillType, appNum, collectParamMap, configId, allCollconfigIds);
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (Row row : resultDs) {
            ids.add(row.getLong("id"));
        }
        return ids;
    }

    protected DataSet getExistsCompletBill(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, List<Long> mftOrderEntryIds, Map<String, String> configRuleMappingMap, String srcBillType, String appNum, Map<String, Object> collectParamMap, long configId, Set<Long> allCollconfigIds) {
        if (CadEmptyUtils.isEmpty(mftOrderEntryIds) && CadEmptyUtils.isEmpty(collectParamMap)) {
            return this.getExistsCompletBill(org, methodCostCenters, manuOrgs, srcBillType, appNum, collectParamMap, configId, allCollconfigIds);
        }
        if (CadEmptyUtils.isEmpty((String)configRuleMappingMap.get("probill"))) {
            return null;
        }
        QFilter orgQf = new QFilter("org", "in", (Object)org);
        if (allCollconfigIds != null) {
            orgQf.and(new QFilter("collconfig", "not in", allCollconfigIds));
        } else {
            orgQf.and(new QFilter("srcbilltype", "=", (Object)srcBillType));
            if (!CadEmptyUtils.isEmpty((Long)configId)) {
                orgQf.and(new QFilter("collconfig", "=", (Object)configId));
            }
        }
        QFilter costObjectQf = new QFilter("costcenter", "in", methodCostCenters);
        QFilter voucherTypeQf = new QFilter("vouchertype", "=", (Object)" ");
        QFilter appnumQf = new QFilter("appnum", "=", (Object)appNum);
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum);
        if (!CadEmptyUtils.isEmpty(collectParamMap) && collectParamMap.get("startDate") != null && collectParamMap.get("endDate") != null) {
            QFilter collectTimeQFilter = new QFilter("bookdate", ">=", collectParamMap.get("startDate"));
            collectTimeQFilter.and(new QFilter("bookdate", "<=", collectParamMap.get("endDate")));
            bookDateQf.and(collectTimeQFilter);
        }
        if (!CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            QFilter sourceBillQf = new QFilter("entryentity.costobject.probill", "in", mftOrderEntryIds);
            bookDateQf.and(sourceBillQf);
        }
        this.logger.info("\u67e5\u8be2\u5df2\u5b58\u5728\u7684\u5355\u636e\u6761\u4ef6\uff1a{},{}.{}.{},{}", new Object[]{orgQf, costObjectQf, bookDateQf, voucherTypeQf, appnumQf});
        return QueryServiceHelper.queryDataSet((String)"factnedoutputbill", (String)"cad_factnedoutputbill", (String)"id,sourcebillentry sourcebillentryid,nsrcauditdate", (QFilter[])new QFilter[]{orgQf, costObjectQf, bookDateQf, appnumQf, voucherTypeQf}, null);
    }

    protected Map<String, DynamicObject> groupEntryIdCompleteMap(List<Long> sourceBillIds, Set<String> existBillNos, Set<String> srcFields) {
        HashMap idEntryIdCompleteMap = Maps.newHashMapWithExpectedSize((int)1024);
        if (CadEmptyUtils.isEmpty(sourceBillIds)) {
            return idEntryIdCompleteMap;
        }
        HashSet<String> selectFieldSet = new HashSet<String>(10);
        if (srcFields != null) {
            selectFieldSet.addAll(srcFields);
        }
        HashSet fields = Sets.newHashSet((Object[])new String[]{"id", "billno", "org", "costcenter", "material", "sourcebill", "sourcebillentry", "srcauditdate", "nsrcauditdate", "auditor", "auditdate", "appnum", "entryentity.costobject", "entryentity.plannedoutput"});
        selectFieldSet.addAll(fields);
        String selectFields = String.join((CharSequence)",", selectFieldSet);
        Object[] completionList = BusinessDataServiceHelper.load((String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIds)});
        if (CadEmptyUtils.isEmpty((Object[])completionList)) {
            return idEntryIdCompleteMap;
        }
        for (Object complet : completionList) {
            if (existBillNos != null) {
                existBillNos.add(complet.getString("billno"));
            }
            if (CadEmptyUtils.isEmpty((Long)complet.getLong("sourcebill"))) continue;
            idEntryIdCompleteMap.put(complet.getLong("sourcebill") + "-" + complet.get("sourcebillentry"), complet);
        }
        return idEntryIdCompleteMap;
    }

    @Deprecated
    protected Map<String, List<DynamicObject>> getTypeSourceBillsCompletionMap(List<Long> existsCompletionIds) {
        HashMap typeSourceBills = Maps.newHashMapWithExpectedSize((int)512);
        if (!CadEmptyUtils.isEmpty(existsCompletionIds)) {
            Object[] completionList = BusinessDataServiceHelper.load((Object[])existsCompletionIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_factnedoutputbill"));
            if (CadEmptyUtils.isEmpty((Object[])completionList)) {
                return null;
            }
            for (Object dynamicObject : completionList) {
                typeSourceBills.computeIfAbsent(dynamicObject.getString("completetype"), key -> new ArrayList()).add(dynamicObject);
            }
        }
        return typeSourceBills;
    }

    protected Map<Long, DynamicObject> getExistCostObjectByFactnedBills(Long accountOrg, List<Long> costCenters, DynamicObject[] sourceBills) {
        HashMap<Long, DynamicObject> costObjectMap = new HashMap<Long, DynamicObject>(200);
        HashSet manuEntryIds = new HashSet(200);
        for (DynamicObject sourceBill : sourceBills) {
            DynamicObjectCollection billentry = sourceBill.getDynamicObjectCollection("billentry");
            billentry.forEach(entry -> manuEntryIds.add(entry.getLong("manuentryid")));
        }
        this.logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6-\u5b8c\u5de5\u5165/\u9000\u5e93\u5355\u5bf9\u5e94\u7684\u5de5\u5355\u5206\u5f55id\uff1a{}", manuEntryIds);
        QFilter orgFilter = new QFilter("org", "=", (Object)accountOrg);
        QFilter srcBillIdFilter = new QFilter("probill", "in", manuEntryIds);
        QFilter statusFilter = new QFilter("billstatus", "in", (Object)"C");
        DynamicObjectCollection costObjects = QueryServiceHelper.query((String)"cad_costobject", (String)"id,costcenter,probill,bomversion,auxpty", (QFilter[])new QFilter[]{orgFilter, srcBillIdFilter, statusFilter});
        for (DynamicObject costObject : costObjects) {
            costObjectMap.put(costObject.getLong("probill"), costObject);
        }
        return costObjectMap;
    }

    protected Map<String, DynamicObject> getCostObjectMapBySrcMaterial(Long org, List<Long> costCenters, DynamicObject[] srcBills, Boolean isFP) {
        HashMap<String, DynamicObject> costObjectMap = new HashMap<String, DynamicObject>();
        HashSet materialId = new HashSet(1000);
        for (DynamicObject srcBill : srcBills) {
            DynamicObjectCollection billentry = srcBill.getDynamicObjectCollection("billentry");
            billentry.forEach(p -> materialId.add(p.getLong("material.masterid.masterid")));
        }
        if (CadEmptyUtils.isEmpty(materialId)) {
            this.logger.info("\u83b7\u53d6\u6210\u672c\u6838\u7b97\u5bf9\u8c61-\u7269\u6599\u96c6\u5408\u5927\u5c0f\uff1a{}", (Object)materialId.size());
            return costObjectMap;
        }
        QFilter qfMat = new QFilter("material", "in", (Object)materialId.toArray());
        QFilter qfOrg = new QFilter("org", "=", (Object)org);
        QFilter qfCostenters = new QFilter("costcenter", "in", costCenters);
        QFilter qfBillStatus = new QFilter("billstatus", "=", (Object)"C");
        DynamicObjectCollection dyCostObject = QueryServiceHelper.query((String)"cad_costobject", (String)"id,srcbillnumber,producenum,srcbillrow,org,costcenter,material,bomversion,auxpty,producttype", (QFilter[])new QFilter[]{qfMat, qfOrg, qfCostenters, qfBillStatus});
        for (DynamicObject cost : dyCostObject) {
            String key = cost.getLong("org") + "@" + cost.getLong("costcenter") + "@" + cost.getLong("material") + "@" + cost.getLong("bomversion") + "@" + cost.getLong("auxpty");
            if (isFP.booleanValue()) {
                key = key + "@" + cost.getString("producenum");
            }
            costObjectMap.put(key, cost);
        }
        return costObjectMap;
    }

    protected DynamicObject[] getMethodPlanned(Set<Long> methodCostObjectIds, String appNum) {
        QFilter costObjectQf = new QFilter("costobject", "in", methodCostObjectIds);
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter appNumQf = new QFilter("appnum", "=", (Object)appNum);
        return BusinessDataServiceHelper.load((String)"cad_plannedoutputbill", (String)"id,costobject,material,qty,wipqty,totalinqty,auditdate", (QFilter[])new QFilter[]{costObjectQf, billStatus, appNumQf}, (String)"auditdate desc");
    }

    protected QFilter getCostCenterSourceQf(Long acctOrg, List<Long> costCenters, String entityName, String appNum) {
        List<Map<String, Date>> importScopeDate = this.getCompletionContext().getOrgImportScopeDate().get(acctOrg);
        List workCenter = CostCenterHelper.getWorkCenter(costCenters, importScopeDate, (CollectReport)this.getCompletionContext().getCollectReport());
        List dataId = CostCenterHelper.getBosOrgs(costCenters, importScopeDate, (CollectReport)this.getCompletionContext().getCollectReport());
        List adminOrgIds = CostCenterHelper.getAdminOrg(costCenters, importScopeDate, (CollectReport)this.getCompletionContext().getCollectReport());
        return this.getWcOrOrgOrAoQFByWay(workCenter, dataId, adminOrgIds, entityName);
    }

    protected QFilter getWcOrOrgOrAoQFByWay(List<Long> workCenter, List<Long> dataId, List<Long> adminOrgIds, String entityName) {
        QFilter wcOrOrgOrAoQF = null;
        if ("im_mdc_mftmanuinbill".equals(entityName)) {
            if (!CadEmptyUtils.isEmpty(workCenter)) {
                wcOrOrgOrAoQF = new QFilter("billentry.workcenterid", "in", workCenter);
            }
            if (!CollectionUtils.isEmpty(dataId)) {
                wcOrOrgOrAoQF = wcOrOrgOrAoQF == null ? new QFilter("productionorg", "in", (Object)dataId.toArray()) : wcOrOrgOrAoQF.or(new QFilter("productionorg", "in", (Object)dataId.toArray()));
            }
            if (!CollectionUtils.isEmpty(adminOrgIds)) {
                Set billentrySet = EntityPropertyHelper.getEntryPropertys((String)entityName, (String)"billentry");
                if (wcOrOrgOrAoQF == null) {
                    if (billentrySet.contains("producedept")) {
                        wcOrOrgOrAoQF = new QFilter("billentry.producedept", "in", adminOrgIds);
                        wcOrOrgOrAoQF.or("bizdept", "in", adminOrgIds);
                    } else {
                        wcOrOrgOrAoQF = new QFilter("bizdept", "in", adminOrgIds);
                    }
                } else {
                    if (billentrySet.contains("producedept")) {
                        wcOrOrgOrAoQF = wcOrOrgOrAoQF.or(new QFilter("billentry.producedept", "in", adminOrgIds));
                    }
                    wcOrOrgOrAoQF.or("bizdept", "in", adminOrgIds);
                }
            }
            return wcOrOrgOrAoQF;
        }
        if ("im_productinbill".equals(entityName)) {
            if (CollectionUtils.isNotEmpty(dataId)) {
                wcOrOrgOrAoQF = new QFilter("bizorg", "in", (Object)dataId.toArray());
            }
            if (!CollectionUtils.isEmpty(adminOrgIds)) {
                if (wcOrOrgOrAoQF == null) {
                    wcOrOrgOrAoQF = new QFilter("bizdept", "in", adminOrgIds);
                } else {
                    wcOrOrgOrAoQF.or(new QFilter("bizdept", "in", adminOrgIds));
                }
            }
            return wcOrOrgOrAoQF;
        }
        if ("im_mdc_omcmplinbill".equals(entityName)) {
            if (!CadEmptyUtils.isEmpty(workCenter)) {
                wcOrOrgOrAoQF = new QFilter("billentry.workcenter", "in", workCenter);
            }
            if (!CollectionUtils.isEmpty(dataId)) {
                wcOrOrgOrAoQF = wcOrOrgOrAoQF == null ? new QFilter("billentry.entryreqorg", "in", (Object)dataId.toArray()) : wcOrOrgOrAoQF.or(new QFilter("billentry.entryreqorg", "in", (Object)dataId.toArray()));
            }
            if (!CollectionUtils.isEmpty(adminOrgIds)) {
                wcOrOrgOrAoQF = wcOrOrgOrAoQF == null ? new QFilter("billentry.producedept", "in", adminOrgIds) : wcOrOrgOrAoQF.or(new QFilter("billentry.producedept", "in", adminOrgIds));
            }
        }
        return wcOrOrgOrAoQF;
    }

    protected Map<String, List<DynamicObject>> getCenterByBill(String entityName, DynamicObject[] bill, List<Long> costCenters, List<Map<String, Date>> importScopeDate) {
        DynamicObjectCollection billentrys;
        HashMap<String, List<DynamicObject>> costCenterSourceDataListMap = new HashMap<String, List<DynamicObject>>(16);
        HashSet<Long> org = new HashSet<Long>();
        HashSet<Long> workCenters = new HashSet<Long>();
        HashSet<Long> adminOrgs = new HashSet<Long>();
        Set billentrySet = EntityPropertyHelper.getEntryPropertys((String)entityName, (String)"billentry");
        if ("im_mdc_mftmanuinbill".equals(entityName)) {
            for (DynamicObject manu : bill) {
                if (manu.getLong("productionorg.id") != 0L) {
                    org.add(manu.getLong("productionorg.id"));
                }
                billentrys = manu.getDynamicObjectCollection("billentry");
                for (DynamicObject billentry : billentrys) {
                    DynamicObject workcenter = billentry.getDynamicObject("workcenterid");
                    if (workcenter == null) continue;
                    workCenters.add(billentry.getLong("workcenterid.id"));
                }
                if (billentrySet.contains("producedept")) {
                    for (DynamicObject billentry : billentrys) {
                        if (!CadEmptyUtils.isEmpty((Long)billentry.getLong("producedept.id"))) {
                            adminOrgs.add(billentry.getLong("producedept.id"));
                            continue;
                        }
                        DynamicObject bizDept = manu.getDynamicObject("bizdept");
                        if (bizDept == null) continue;
                        adminOrgs.add(bizDept.getLong("id"));
                    }
                    continue;
                }
                DynamicObject bizDept = manu.getDynamicObject("bizdept");
                if (bizDept == null) continue;
                adminOrgs.add(bizDept.getLong("id"));
            }
        }
        if ("im_productinbill".equals(entityName)) {
            for (DynamicObject manu : bill) {
                Object bizdept;
                DynamicObject manuOrg = manu.getDynamicObject("bizorg");
                if (manuOrg != null) {
                    org.add(manu.getLong("bizorg.id"));
                }
                if ((bizdept = manu.getDynamicObject("bizdept")) == null) continue;
                adminOrgs.add(manu.getDynamicObject("bizdept").getLong("id"));
            }
        }
        if ("im_mdc_omcmplinbill".equals(entityName)) {
            for (DynamicObject manu : bill) {
                billentrys = manu.getDynamicObjectCollection("billentry");
                for (DynamicObject billentry : billentrys) {
                    if (!CadEmptyUtils.isEmpty((Long)billentry.getLong("entryreqorg.id"))) {
                        org.add(billentry.getLong("entryreqorg.id"));
                    }
                    if (!CadEmptyUtils.isEmpty((Long)billentry.getLong("producedept.id"))) {
                        adminOrgs.add(billentry.getLong("producedept.id"));
                    }
                    if (CadEmptyUtils.isEmpty((DynamicObject)billentry.getDynamicObject("workcenter"))) continue;
                    workCenters.add(billentry.getLong("workcenter.id"));
                }
            }
        }
        if (CadEmptyUtils.isEmpty(org) && CadEmptyUtils.isEmpty(workCenters) && CadEmptyUtils.isEmpty(adminOrgs)) {
            return costCenterSourceDataListMap;
        }
        QFilter qfDataId = new QFilter("entryentity.sourcedata", "in", (Object)org.toArray());
        qfDataId.and("entryentity.sourcetype", "=", (Object)"bos_org");
        if (CollectionUtils.isNotEmpty(workCenters)) {
            QFilter qfWorkCenter = new QFilter("entryentity.sourcedata", "in", (Object)workCenters.toArray());
            qfWorkCenter.and("entryentity.sourcetype", "=", (Object)"mpdm_workcentre");
            qfDataId.or(qfWorkCenter);
        }
        if (CollectionUtils.isNotEmpty(adminOrgs)) {
            QFilter qfAdminOrg = new QFilter("entryentity.sourcedata", "in", (Object)adminOrgs.toArray());
            qfAdminOrg.and("entryentity.sourcetype", "=", (Object)"bos_adminorg");
            qfDataId.or(qfAdminOrg);
        }
        QFilter ccFilter = new QFilter("costcenter", "in", costCenters);
        QFilter enableFilter = new QFilter("costcenter.enable", "=", (Object)Boolean.TRUE);
        QFilter qfOrgduty = new QFilter("costcenter.orgduty", "=", (Object)4L);
        if (!CadEmptyUtils.isEmpty(importScopeDate)) {
            DynamicObjectCollection centerSourceMap;
            Date startDate = importScopeDate.get(0).get("start");
            Date endDate = importScopeDate.get(0).get("end");
            QFilter dateFilter = new QFilter("effectdate", "<", (Object)endDate).and(new QFilter("expdate", ">", (Object)startDate));
            if (importScopeDate.size() > 1) {
                Date nextStartDate = importScopeDate.get(1).get("start");
                Date nextEndDate = importScopeDate.get(1).get("end");
                QFilter nextDateFilter = new QFilter("effectdate", "<", (Object)nextEndDate).and(new QFilter("expdate", ">", (Object)nextStartDate));
                dateFilter = dateFilter.or(nextDateFilter);
            }
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)(centerSourceMap = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"costcenter as id,costcenter.accountorg orgid,effectdate,expdate,entryentity,entryentity.sourcetype,entryentity.sourcedata", (QFilter[])new QFilter[]{qfDataId, ccFilter, enableFilter, qfOrgduty, dateFilter})))) {
                return costCenterSourceDataListMap;
            }
            for (DynamicObject sourceMap : centerSourceMap) {
                String mapKey = sourceMap.getLong("entryentity.sourcedata") + "@" + sourceMap.getString("entryentity.sourcetype");
                costCenterSourceDataListMap.computeIfAbsent(mapKey, s -> new ArrayList()).add(sourceMap);
            }
        }
        return costCenterSourceDataListMap;
    }

    protected void generateScrkCompletion(Long org, List<Long> batchCostCenters, DynamicObject[] sourceBills, Map<String, DynamicObject> idEntryIdCompleteMap, String appNum, Boolean isFP) {
        if (CadEmptyUtils.isEmpty((Object[])sourceBills)) {
            this.logger.info("\u6838\u7b97\u7ec4\u7ec7{}\uff0c\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3{}\uff0c\u627e\u4e0d\u5230\u6e90\u5355\uff0c\u5f52\u96c6\u7ed3\u675f", (Object)org, batchCostCenters);
            return;
        }
        this.getCompletionContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u6839\u636e\u6e90\u5355\u751f\u6210\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6", (String)"AbstractCompletionAction_8", (String)"macc-cad-mservice", (Object[])new Object[0]));
        Map costSyncInfoMap = ImportInitCostHelper.getCostRecordMap((DynamicObject[])sourceBills);
        List<Map<String, Date>> importScopeDate = this.getCompletionContext().getOrgImportScopeDate().get(org);
        Map<String, List<DynamicObject>> costInfo = this.getCenterByBill("im_productinbill", sourceBills, batchCostCenters, importScopeDate);
        Map<String, DynamicObject> existCostObjectByInvBills = this.getCostObjectMapBySrcMaterial(org, batchCostCenters, sourceBills, isFP);
        if (CadEmptyUtils.isEmpty(existCostObjectByInvBills)) {
            this.getCompletionContext().getCollectReport().logStatusChange(CollectStatus.REMIND, ResManager.loadKDString((String)"\u6839\u636e\u6e90\u5355\u751f\u6210\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6,\u672a\u627e\u5230\u7269\u6599\u548c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5bf9\u5e94\u5173\u7cfb\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"AbstractCompletionAction_9", (String)"macc-cad-mservice", (Object[])new Object[0]));
            this.logger.info("\u672a\u627e\u5230\u7269\u6599\u548c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5bf9\u5e94\u5173\u7cfb\uff0c\u751f\u4ea7\u5165/\u9000\u5e93\u5355\u5f52\u96c6\u7ed3\u675f");
            for (DynamicObject sourceBill : sourceBills) {
                String billNo = sourceBill.getString("billno");
                DynamicObjectCollection billentry = sourceBill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : billentry) {
                    String key = billNo.concat("@").concat(entry.getString("seq"));
                    Map errorInfMap = this.getCompletionContext().getErrorInfMap();
                    if (errorInfMap.containsKey(key)) continue;
                    this.getCompletionContext().logErrorMsg(key, ResManager.loadKDString((String)"\u672a\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"AbstractCompletionAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]));
                }
            }
            return;
        }
        List<DynamicObject> factnedBills = this.getCompletionContext().getFactnedBills();
        Set willSaveBillNoSet = factnedBills.stream().map(o -> o.getString("billno")).collect(Collectors.toSet());
        Long userId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        ArrayList<DynamicObject> factnedBill = new ArrayList<DynamicObject>();
        int updNum = 0;
        int addNum = 0;
        HashSet<Long> materialSet = new HashSet<Long>();
        for (DynamicObject sourceBill : sourceBills) {
            List costSyncInfos = (List)costSyncInfoMap.get(sourceBill.getLong("entryId"));
            if (CollectionUtils.isEmpty((Collection)costSyncInfos)) {
                this.logger.info("\u4ece\u751f\u4ea7\u5165/\u9000\u5e93\u5355\u5f15\u5165\uff0c\u672a\u83b7\u53d6\u5230\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002\u5f53\u524d\u751f\u6210\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u7ed3\u675f,\u6e90\u5355\u5206\u5f55id{}", (Object)sourceBill.getLong("entryId"));
                continue;
            }
            long sourceBillId = sourceBill.getLong("id");
            Date auditDate = sourceBill.getDate("auditdate");
            Date bookDate = sourceBill.getDate("bookdate");
            String sourceBillNo = sourceBill.getString("billno");
            boolean notBack = "330".equals(sourceBill.getString("invscheme.number"));
            DynamicObjectCollection billEntries = sourceBill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntries) {
                DynamicObject costObject;
                Long entryId = entry.getLong("id");
                String key = sourceBillId + "-" + entryId;
                DynamicObject factned = null;
                String billNo = sourceBill.getString("billno") + "-" + entry.getString("Seq") + "-" + UUIDUtils.getUUIDN((int)5).toUpperCase();
                if (willSaveBillNoSet.contains(billNo)) {
                    this.logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6-\u6e90\u5355{}\u884c\u53f7{}\u5df2\u5728\u5176\u4ed6\u6210\u672c\u4e2d\u5fc3\u4e0b\u5f15\u5165\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)sourceBill.getString("billno"), (Object)entry.getString("Seq"));
                    continue;
                }
                DynamicObject centerInfo = CostObjectHelper.getCostCenterBySrcBillDate((Date)bookDate, costInfo.get(sourceBill.getLong("bizorg.id") + "@" + "bos_org"));
                if (centerInfo == null && sourceBill.getDynamicObject("bizdept") != null) {
                    centerInfo = CostObjectHelper.getCostCenterBySrcBillDate((Date)bookDate, costInfo.get(sourceBill.getDynamicObject("bizdept").getLong("id") + "@" + "bos_adminorg"));
                }
                Long acOrg = centerInfo == null ? 0L : centerInfo.getLong("orgid");
                Long csCen = centerInfo == null ? 0L : centerInfo.getLong("id");
                String proNo = entry.getString("productnum");
                Long version = 0L;
                if (entry.getBoolean("material.masterid.isenablematerialversion")) {
                    version = entry.getLong("mversion.id");
                }
                Long material = entry.getLong("material.masterid.masterid");
                DynamicObject srcAuxpty = entry.getDynamicObject("auxpty");
                DynamicObject mat = CostObjectHelper.getMaterialById((Long)material);
                Long auxpty = 0L;
                if (srcAuxpty != null && mat != null) {
                    auxpty = srcAuxpty.getLong("id");
                }
                String matKey = acOrg + "@" + csCen + "@" + material + "@" + version + "@" + auxpty;
                if (isFP.booleanValue()) {
                    matKey = matKey + "@" + proNo;
                }
                if ((costObject = existCostObjectByInvBills.get(matKey)) == null) {
                    this.getCompletionContext().logErrorMsg(sourceBill.getString("billno").concat("@").concat(entry.getString("seq")), ResManager.loadKDString((String)"\u672a\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"AbstractCompletionAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    this.logger.info("\u6839\u636e\u6e90\u5355:{}\u83b7\u53d6\u7684key{}\u672a\u627e\u5230\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u751f\u6210\u5b8c\u5de5\u5165\u5e93\u5355\u7ed3\u675f\uff01", (Object)sourceBill.getString("billno"), (Object)matKey);
                    continue;
                }
                if (idEntryIdCompleteMap.containsKey(key)) {
                    this.logger.info("\u6e90\u5355\u5206\u5f55\u5df2\u5f52\u96c6\uff0c\u6821\u9a8c\u662f\u5426\u9700\u8981\u4fee\u6539");
                    factned = idEntryIdCompleteMap.remove(key);
                    Date srcAuditDate = factned.getDate("nsrcauditdate");
                    if (srcAuditDate.compareTo(auditDate) == 0) {
                        this.logger.info("\u6e90\u5355{}\u672a\u6539\u53d8\uff0c\u8df3\u8fc7", (Object)sourceBillNo);
                        continue;
                    }
                    ++updNum;
                } else {
                    factned = BusinessDataServiceHelper.newDynamicObject((String)"cad_factnedoutputbill");
                    ++addNum;
                }
                this.logger.info("\u4ece\u751f\u4ea7\u5165/\u9000\u5e93\u5355\u5f15\u5165\uff0c\u5f00\u59cb\u521b\u5efa\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u6e90\u5355\u7f16\u53f7:{}", (Object)billNo);
                factned.set("billno", (Object)billNo);
                factned.set("bizdate", this.getBizDate(sourceBill.getDate("biztime")));
                factned.set("bookdate", this.getBizDate(sourceBill.getDate("bookdate")));
                factned.set("appnum", (Object)appNum);
                long masterId = entry.getLong("material.masterid.masterid");
                factned.set("material_id", (Object)masterId);
                factned.set("material", (Object)masterId);
                materialSet.add(masterId);
                factned.set("baseunit", (Object)entry.getLong("baseunit.id"));
                BigDecimal completeqty = entry.getBigDecimal("baseqty");
                factned.set("completeqty", (Object)completeqty);
                factned.set("warehouse", (Object)entry.getLong("warehouse.id"));
                factned.set("location", (Object)entry.getLong("location.id"));
                factned.set("batch", (Object)entry.getString("lotnumber"));
                factned.set("wareinorg", (Object)sourceBill.getLong("org.id"));
                factned.set("completetype", (Object)(notBack ? "PRODUCTCOMPELETE" : "PRODUCTCOMPELETEBACK"));
                factned.set("billstatus", (Object)"C");
                factned.set("auditor", (Object)userId);
                factned.set("auditor_id", (Object)userId);
                factned.set("auditdate", (Object)now);
                factned.set("invtype", (Object)entry.getLong("invtype.id"));
                factned.set("srcauditdate", (Object)DateUtils.getPriceDate((Date)sourceBill.getDate("auditdate"), (Date)sourceBill.getDate("bookdate")));
                factned.set("nsrcauditdate", (Object)sourceBill.getDate("auditdate"));
                factned.set("org_id", (Object)org);
                factned.set("org", (Object)org);
                factned.set("costcenter_id", (Object)csCen);
                factned.set("costcenter", (Object)csCen);
                factned.set("manuorg_id", (Object)sourceBill.getDynamicObject("bizorg").getLong("id"));
                factned.set("manuorg", (Object)sourceBill.getDynamicObject("bizorg").getLong("id"));
                factned.set("producttype", (Object)costObject.getString("producttype"));
                factned.set("qualitystatus", (Object)"A");
                factned.set("sourcebill", sourceBill.getPkValue());
                factned.set("sourcebillentry", entry.getPkValue());
                factned.set("sourcebiztime", (Object)sourceBill.getDate("biztime"));
                if (!idEntryIdCompleteMap.containsKey(key)) {
                    factned.set("creator", (Object)userId);
                    factned.set("createtime", (Object)now);
                }
                factned.set("srcbilltype", (Object)"im_productinbill");
                DynamicObjectCollection entryentity = factned.getDynamicObjectCollection("entryentity");
                entryentity.clear();
                DynamicObject completionEntry = entryentity.addNew();
                completionEntry.set("costobject", (Object)costObject.getLong("id"));
                completionEntry.set("qty", (Object)entry.getBigDecimal("baseqty"));
                factned.set("version", (Object)costObject.getLong("bomversion"));
                factned.set("auxpty", (Object)costObject.getLong("auxpty"));
                factnedBill.add(factned);
                this.logger.info("\u4ece\u751f\u4ea7\u5165/\u9000\u5e93\u5355\u5f15\u5165\uff0c\u5b8c\u5de5\u5165\u5e93\u5355\u521b\u5efa\u5b8c\u6210\uff0c\u6e90\u5355\u7f16\u53f7:{}", (Object)billNo);
            }
        }
        if (CadEmptyUtils.isEmpty(factnedBill)) {
            this.getCompletionContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6e90\u5355\u751f\u6210\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\uff0c\u65b0\u589e%1$s\u6761\uff0c\u66f4\u65b0%2$s\u6761\u3002", (String)"AbstractCompletionAction_18", (String)"macc-cad-mservice", (Object[])new Object[0]), addNum, updNum));
            this.logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6->\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u751f\u4ea7\u5165\u5e93\u3001\u751f\u4ea7\u9000\u5e93\u5355");
            return;
        }
        if (!materialSet.isEmpty()) {
            this.setGradeProdGroup(materialSet, factnedBill);
        }
        this.getCompletionContext().setAddNum(this.getCompletionContext().getAddNum() + addNum);
        this.getCompletionContext().setUpdateNum(this.getCompletionContext().getUpdateNum() + updNum);
        this.getCompletionContext().getFactnedBills().addAll(factnedBill);
        this.getCompletionContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6e90\u5355\u751f\u6210\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\uff0c\u65b0\u589e%1$s\u6761\uff0c\u66f4\u65b0%2$s\u6761\u3002", (String)"AbstractCompletionAction_18", (String)"macc-cad-mservice", (Object[])new Object[0]), addNum, updNum));
    }

    protected Long getEffectCostAuxpty(DynamicObject mat, DynamicObject sourceBill) {
        DynamicObject[] auxproperty;
        HashSet<Long> auxptyIdSet = new HashSet<Long>(16);
        DynamicObject auxpty = (DynamicObject)sourceBill.get("auxpty");
        if (auxpty == null) {
            return 0L;
        }
        DynamicObjectCollection isaffectprices = mat.getDynamicObjectCollection("auxptyentry");
        for (DynamicObject price : isaffectprices) {
            Long auxptyId = price.getLong("auxpty.id");
            if (price.getBoolean("isaffectprice")) continue;
            auxptyIdSet.add(auxptyId);
        }
        if (CadEmptyUtils.isEmpty(auxptyIdSet)) {
            return 0L;
        }
        String auxStr = (String)auxpty.get(1);
        JSONObject auxptyJsonObject = (JSONObject)JSON.parse((String)auxStr);
        for (DynamicObject aux : auxproperty = BusinessDataServiceHelper.load((String)"bd_auxproperty", (String)"flexfield", (QFilter[])new QFilter[]{new QFilter("id", "in", auxptyIdSet)})) {
            auxptyJsonObject.remove((Object)aux.getString("flexfield"));
        }
        String jsonString = auxptyJsonObject.toJSONString();
        auxpty.set("value", (Object)jsonString);
        return auxpty.getLong("id");
    }

    protected int deleteFactnedBillForNoSrource(Map<String, DynamicObject> idEntryIdCompleteMap) {
        if (CadEmptyUtils.isEmpty(idEntryIdCompleteMap)) {
            return 0;
        }
        Collection<DynamicObject> completeCollection = idEntryIdCompleteMap.values();
        Map<Long, DynamicObject> idCompleteCollectMap = completeCollection.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject));
        Set delResourceIds = ResourceAbsorbHelper.delOrRevertEntity(idCompleteCollectMap.keySet(), (String)"cad_factnedoutputbill", (String)this.getCompletionContext().getCompletionArgs().getAppNum(), (Set)Sets.newHashSet((Object[])new String[]{"completeqty"}), (Set)Sets.newHashSet((Object[])new String[]{"qty"}));
        for (Long delResourceId : delResourceIds) {
            idCompleteCollectMap.remove(delResourceId);
        }
        Collection<DynamicObject> delDynamicObjs = idCompleteCollectMap.values();
        this.getCompletionContext().setDelNum(this.getCompletionContext().getDelNum() + delResourceIds.size());
        this.getCompletionContext().getDelFactnedBills().addAll(delDynamicObjs);
        HashSet<Long> deleteSrcData = new HashSet<Long>(10);
        delDynamicObjs.forEach(p -> deleteSrcData.add(p.getLong("sourcebill")));
        this.delChangeRecord(deleteSrcData);
        return delResourceIds.size();
    }

    protected DynamicObject[] getWwWgrkSourceBill(Long org, List<Long> costCenters, List<Long> manuOrgs, String appNum) {
        String selectProperties = "id,billno,invscheme,invscheme.billform.number,billentry.Seq,billentry.material,biztime,bookdate,billentry.baseunit,billentry.mversion,billentry.auxpty,billentry.warehouse,billentry.location,billentry.lotnumber,billentry.baseqty,billentry.producttype,billentry.qualitystatus,billentry.baseunit,billentry.owner,org,auditdate,bizorg,billentry.entryreqorg,billentry.producedept,billentry.invtype";
        QFilter costCenterSourceQf = this.getCostCenterSourceQf(org, costCenters, "im_mdc_omcmplinbill", appNum);
        if (costCenterSourceQf == null) {
            this.getCompletionContext().getCollectReport().logStatusChange(CollectStatus.REMIND, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u672a\u914d\u7f6e\u6765\u6e90\uff0c\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u7ed3\u675f\u3002", (String)"AbstractCompletionAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]));
            this.logger.info("\u6210\u672c\u4e2d\u5fc3:{}\u672a\u8bbe\u7f6e\u6765\u6e90\uff0c\u6b64\u6210\u672c\u4e2d\u5fc3\u5f15\u5165\u7ed3\u675f!", costCenters);
            return null;
        }
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            costCenterSourceQf.and(new QFilter("billentry.entryreqorg", "in", manuOrgs));
        }
        Set notNeedCollectBillBizIds = SysParamHelper.getNotNeedCollectBillBizIds((Long)org, (String)"cad_factnedoutputbill", (String)"im_mdc_omcmplinbill", (String)"bizsettingentry.invscheme.fbasedataid.id", (String)appNum);
        QFilter bizQf = null;
        if (!CadEmptyUtils.isEmpty((Set)notNeedCollectBillBizIds)) {
            bizQf = new QFilter("invscheme", "not in", (Object)notNeedCollectBillBizIds);
        }
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum);
        return BusinessDataServiceHelper.load((String)"im_mdc_omcmplinbill", (String)selectProperties, (QFilter[])new QFilter[]{costCenterSourceQf, billStatusQf, bookDateQf, bizQf});
    }

    protected DynamicObject[] getScrkSourceBill(Long org, List<Long> costCenters, List<Long> manuOrgs, String appNum) {
        String selectProperties = "id,billno,invscheme,invscheme.number,billentry.Seq,billentry.material,billentry.productnum,biztime,bookdate,billentry.baseunit,billentry.mversion,billentry.auxpty,billentry.warehouse,billentry.location,billentry.lotnumber,billentry.baseqty,billentry.invtype,org,auditdate,bizorg,bizdept";
        QFilter costCenterSourceQf = this.getCostCenterSourceQf(org, costCenters, "im_productinbill", appNum);
        if (costCenterSourceQf == null) {
            this.getCompletionContext().getCollectReport().logStatusChange(CollectStatus.REMIND, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u672a\u914d\u7f6e\u6765\u6e90\uff0c\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u7ed3\u675f\u3002", (String)"AbstractCompletionAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]));
            this.logger.info("\u6210\u672c\u4e2d\u5fc3:{}\u672a\u8bbe\u7f6e\u6765\u6e90\uff0c\u6b64\u6210\u672c\u4e2d\u5fc3\u5f15\u5165\u7ed3\u675f!", costCenters);
            return null;
        }
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            costCenterSourceQf.and(new QFilter("bizorg", "in", manuOrgs));
        }
        Map notNeedCollectBillBizIdsMap = SysParamHelper.getNotNeedCollectBillBizIdsMap((Long)org, (String)"cad_factnedoutputbill", (String)"im_productinbill", (String)"bizsettingentry.biztype.fbasedataid.id,bizsettingentry.invscheme.fbasedataid.id", (String)appNum);
        Set bizTypeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.biztype.fbasedataid.id");
        Set invSchemeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.invscheme.fbasedataid.id");
        QFilter bizQf = null;
        if (!CadEmptyUtils.isEmpty((Set)bizTypeIds)) {
            bizQf = new QFilter("biztype", "not in", (Object)bizTypeIds);
        }
        if (!CadEmptyUtils.isEmpty((Set)invSchemeIds)) {
            this.getCompletionContext().getCollectReport().getInvSchemeIds().addAll(invSchemeIds);
            if (bizQf == null) {
                bizQf = new QFilter("invscheme", "not in", (Object)invSchemeIds);
            } else {
                bizQf.and(new QFilter("invscheme", "not in", (Object)invSchemeIds));
            }
        }
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum);
        return BusinessDataServiceHelper.load((String)"im_productinbill", (String)selectProperties, (QFilter[])new QFilter[]{costCenterSourceQf, billStatusQf, bookDateQf, bizQf});
    }

    protected DynamicObject[] getWgrkSourceBill(Long org, List<Long> costCenters, List<Long> manuOrgs, String appNum) {
        QFilter costCenterSourceQf;
        String selectProperties = "id,billno,invscheme,invscheme.billform.number,billentry.Seq,billentry.material,biztime,bookdate,billentry.baseunit,billentry.mversion,billentry.auxpty,billentry.warehouse,billentry.location,billentry.lotnumber,billentry.baseqty,billentry.producttype,billentry.qualitystatus,billentry.baseunit,billentry.owner,billentry.workcenterid,productionorg,bizdept,org,auditdate,bizorg,billentry.manuentryid,billentry.invtype";
        Set billentrySet = EntityPropertyHelper.getEntryPropertys((String)"im_mdc_mftmanuinbill", (String)"billentry");
        if (billentrySet.contains("producedept")) {
            selectProperties = selectProperties + ",billentry.producedept";
        }
        if ((costCenterSourceQf = this.getCostCenterSourceQf(org, costCenters, "im_mdc_mftmanuinbill", appNum)) == null) {
            this.getCompletionContext().getCollectReport().logStatusChange(CollectStatus.REMIND, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u672a\u8bbe\u7f6e\u6765\u6e90\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"AbstractCompletionAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]));
            this.logger.info("\u6210\u672c\u4e2d\u5fc3:{}\u672a\u8bbe\u7f6e\u6765\u6e90\uff0c\u6b64\u6210\u672c\u4e2d\u5fc3\u5f15\u5165\u7ed3\u675f!", costCenters);
            return null;
        }
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            costCenterSourceQf.and(new QFilter("productionorg", "in", manuOrgs));
        }
        QFilter wgrkQf = new QFilter("billtype.billformid.number", "=", (Object)"im_mdc_mftmanuinbill");
        QFilter wgtkQf = new QFilter("billtype.billformid.number", "=", (Object)"im_mdc_mftreturnbill");
        Map notNeedCollectBillBizIdsMap = SysParamHelper.getNotNeedCollectBillBizIdsMap((Long)org, (String)"cad_factnedoutputbill", (String)"im_mdc_mftmanuinbill", (String)"bizsettingentry.biztype.fbasedataid.id,bizsettingentry.invscheme.fbasedataid.id", (String)appNum);
        Set bizTypeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.biztype.fbasedataid.id");
        Set invSchemeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.invscheme.fbasedataid.id");
        if (!CadEmptyUtils.isEmpty((Set)bizTypeIds)) {
            wgrkQf.and(new QFilter("biztype", "not in", (Object)bizTypeIds));
        }
        if (!CadEmptyUtils.isEmpty((Set)invSchemeIds)) {
            wgrkQf.and(new QFilter("invscheme", "not in", (Object)invSchemeIds));
        }
        notNeedCollectBillBizIdsMap = SysParamHelper.getNotNeedCollectBillBizIdsMap((Long)org, (String)"cad_factnedoutputbill", (String)"im_mdc_mftreturnbill", (String)"bizsettingentry.biztype.fbasedataid.id,bizsettingentry.invscheme.fbasedataid.id", (String)appNum);
        bizTypeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.biztype.fbasedataid.id");
        invSchemeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.invscheme.fbasedataid.id");
        if (!CadEmptyUtils.isEmpty((Set)bizTypeIds)) {
            wgtkQf.and(new QFilter("biztype", "not in", (Object)bizTypeIds));
        }
        if (!CadEmptyUtils.isEmpty((Set)invSchemeIds)) {
            wgtkQf.and(new QFilter("invscheme", "not in", (Object)invSchemeIds));
        }
        QFilter billTypeQf = wgrkQf.or(wgtkQf);
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum);
        return BusinessDataServiceHelper.load((String)"im_mdc_mftmanuinbill", (String)selectProperties, (QFilter[])new QFilter[]{costCenterSourceQf, billStatusQf, bookDateQf, billTypeQf});
    }

    protected Map<String, DynamicObject> groupEntryIdCompleteMap(Map<String, List<DynamicObject>> typeSourceBillsMap, List<String> ranges) {
        Map<Object, Object> idEntryIdCompleteMap = Maps.newHashMapWithExpectedSize((int)1024);
        if (CadEmptyUtils.isEmpty(typeSourceBillsMap)) {
            return idEntryIdCompleteMap;
        }
        ArrayList sourceBills = new ArrayList(200);
        for (String range : ranges) {
            if (typeSourceBillsMap.get(range) == null) continue;
            sourceBills.addAll(typeSourceBillsMap.get(range));
        }
        if (CadEmptyUtils.isEmpty(sourceBills)) {
            return idEntryIdCompleteMap;
        }
        idEntryIdCompleteMap = sourceBills.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("sourcebill") + "-" + dynamicObject.get("sourcebillentry"), dynamicObject -> dynamicObject, (oldData, newData) -> newData));
        return idEntryIdCompleteMap;
    }

    protected DynamicObject wrapMaterialObject4Save(Long manuOrg, Long costCenterId, DynamicObject ruleItem, DynamicObject entry) {
        QFilter billNoFiler;
        if (ruleItem == null) {
            this.logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6-\u6ca1\u6709\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219,\u81ea\u52a8\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ed3\u675f\uff01");
            return null;
        }
        DynamicObject costCenter = BusinessDataServiceHelper.loadSingleFromCache((Object)costCenterId, (String)"bos_costcenter");
        String ruleAss = ruleItem.getString("objruleass");
        String ccNumber = costCenter.getString("number") + "-";
        ruleAss = kd.bos.util.StringUtils.isEmpty((String)ruleAss) ? ccNumber : ruleAss + "-" + ccNumber;
        String ruleNameAss = ruleItem.getString("objrulenameass");
        String ccName = costCenter.getLocaleString("name").getLocaleValue() + "-";
        ruleNameAss = kd.bos.util.StringUtils.isEmpty((String)ruleNameAss) ? ccName : ruleNameAss + "-" + ccName;
        DynamicObject costObject = BusinessDataServiceHelper.newDynamicObject((String)"cad_costobject");
        costObject.set("id", (Object)DB.genGlobalLongId());
        costObject.set("costobjectrule", ruleItem.get("id"));
        costObject.set("org", ruleItem.get("accountorg"));
        costObject.set("billstatus", (Object)"C");
        costObject.set("costcenter", costCenter.getPkValue());
        costObject.set("bizstatus", (Object)CostObjectEnum.BIZSTATUS_UNSETTLE.getValue());
        costObject.set("sotype", (Object)ruleItem.getString("sotype"));
        costObject.set("rule", (Object)ruleItem.getString("rule"));
        costObject.set("originype", (Object)CostObjectEnum.ORIGINYPE_RULE.getValue());
        costObject.set("biztype", (Object)ruleItem.getString("biztype"));
        costObject.set("manuorg", (Object)manuOrg);
        String srcNo = "";
        if (CostObjectEnum.BIZTYPE_SO.getValue().equals(ruleItem.getString("biztype"))) {
            costObject.set("srcbillnumber", (Object)entry.getString("productnum"));
            costObject.set("srcbillrow", (Object)1);
            srcNo = entry.getString("productnum");
        } else {
            costObject.set("srcbillnumber", null);
            costObject.set("srcbillrow", null);
        }
        costObject.set("material", (Object)entry.getLong("material.masterid.masterid"));
        String matNumber = entry.getString("material.masterid.number");
        String modelnum = entry.getString("material.masterid.modelnum");
        String[] ruleNumberExt = ruleItem.getString("rulenumberext").split(",");
        String[] ruleNameExt = ruleItem.getString("rulenameext").split(",");
        String billNo = ruleAss + matNumber;
        if (!CadEmptyUtils.isEmpty((String)srcNo)) {
            billNo = billNo + "-" + srcNo;
        }
        if (Arrays.asList(ruleNumberExt).contains("CR_GGXH") && !CadEmptyUtils.isEmpty((String)modelnum)) {
            billNo = billNo + "-" + modelnum;
        }
        if (QueryServiceHelper.exists((String)"cad_costobject", (QFilter[])new QFilter[]{billNoFiler = new QFilter("billno", "=", (Object)billNo)})) {
            return null;
        }
        if (billNo.length() > 255) {
            billNo = billNo.substring(0, 255);
        }
        costObject.set("billno", (Object)billNo);
        String matName = entry.getString("material.masterid.name");
        String billName = ruleNameAss + matName;
        if (!CadEmptyUtils.isEmpty((String)srcNo)) {
            billName = billName + "-" + srcNo;
        }
        if (Arrays.asList(ruleNameExt).contains("CRN_GGXH") && !CadEmptyUtils.isEmpty((String)modelnum)) {
            billName = billName + "-" + modelnum;
        }
        if (billName.length() > 255) {
            billName = billName.substring(0, 255);
        }
        costObject.set("name", (Object)billName);
        costObject.set("producttype", (Object)"C");
        costObject.set("weight", (Object)1);
        costObject.set("creator", (Object)RequestContext.get().getUserId());
        costObject.set("createtime", (Object)new Date());
        Long version = 0L;
        if (entry.getBoolean("material.masterid.isenablematerialversion")) {
            version = entry.getLong("mversion.id");
        }
        costObject.set("bomversion", (Object)version);
        Long auxpty = CostObjectHelper.getEffectCostAuxpty((DynamicObject)CostObjectHelper.getMaterialById((Long)entry.getLong("material.masterid.masterid")), (DynamicObject)entry.getDynamicObject("auxpty"));
        costObject.set("auxpty", (Object)auxpty);
        if (CostObjectEnum.BIZTYPE_FL.getValue().equals(ruleItem.getString("biztype"))) {
            costObject.set("billstatus", (Object)"A");
        } else {
            costObject.set("auditor", (Object)RequestContext.get().getUserId());
            costObject.set("auditdate", (Object)new Date());
        }
        return costObject;
    }

    protected int save(List<DynamicObject> factnedBills, CollectReport report) {
        if (CollectionUtils.isEmpty(factnedBills)) {
            return 0;
        }
        List billNos = factnedBills.stream().map(dynamicObject -> dynamicObject.getString("billno")).collect(Collectors.toList());
        this.logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6-\u5f15\u5165\u7684\u5f52\u96c6\u5355\u7f16\u53f7\uff1a{}", (Object)JSON.toJSONString(billNos));
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_factnedoutputbill", (DynamicObject[])factnedBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        int successQty = operateResult.getSuccessPkIds() == null ? 0 : operateResult.getSuccessPkIds().size();
        this.getCompletionContext().setSuccessNum(successQty);
        if (!operateResult.isSuccess()) {
            QFilter appNumQf;
            Set entryIds;
            QFilter entryIdQf;
            DynamicObjectCollection exists;
            String errorInfo = OperationResultHelper.errorMsgHandle((OperationResult)operateResult);
            ValidateResultCollection validateResult = operateResult.getValidateResult();
            HashSet errorDataIndexs = validateResult.getErrorDataIndexs();
            HashMap<Long, DynamicObject> entryIdErrorDynamicMap = new HashMap<Long, DynamicObject>(16);
            for (Integer errorDataIndex : errorDataIndexs) {
                long billEntryId;
                String srcBillNo;
                int i;
                DynamicObject errorDynamic = factnedBills.get(errorDataIndex);
                String billno = errorDynamic.getString("billno");
                Object srcBillTypeObj = errorDynamic.get("srcbilltype");
                String srcbilltype = "";
                srcbilltype = srcBillTypeObj instanceof DynamicObject ? ((DynamicObject)srcBillTypeObj).getString("number") : srcBillTypeObj.toString();
                if (!StringUtils.isEmpty((CharSequence)billno) && (i = billno.lastIndexOf("-")) != -1 && (srcBillNo = billno.substring(0, i)).lastIndexOf("-") != -1) {
                    int index = srcBillNo.lastIndexOf("-");
                    srcBillNo = srcBillNo.substring(0, srcBillNo.lastIndexOf("-"));
                    String seq = billno.substring(index + 1, index + 2);
                    this.getCompletionContext().logErrorMsg(srcBillNo.concat("@").concat(seq).concat("@").concat(srcbilltype), ResManager.loadKDString((String)"\u751f\u6210\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5931\u8d25\u3002", (String)"AbstractCompletionAction_41", (String)"macc-cad-mservice", (Object[])new Object[0]));
                }
                if (CadEmptyUtils.isEmpty((Long)(billEntryId = errorDynamic.getLong("sourcebillentry")))) continue;
                entryIdErrorDynamicMap.put(billEntryId, errorDynamic);
            }
            if (!entryIdErrorDynamicMap.isEmpty() && (exists = QueryServiceHelper.query((String)"cad_factnedoutputbill", (String)"bookdate,sourcebillentry", (QFilter[])new QFilter[]{entryIdQf = new QFilter("sourcebillentry", "in", entryIds = entryIdErrorDynamicMap.keySet()), appNumQf = new QFilter("appnum", "=", (Object)report.getAppNum())})) != null && !exists.isEmpty()) {
                for (DynamicObject exist : exists) {
                    long sourceBillEntry = exist.getLong("sourcebillentry");
                    DynamicObject dynamicObject2 = (DynamicObject)entryIdErrorDynamicMap.get(sourceBillEntry);
                    String billNo = dynamicObject2.getString("billno");
                    if (CadEmptyUtils.isEmpty((String)billNo) || billNo.length() <= 6) continue;
                    billNo = billNo.substring(0, billNo.length() - 6);
                    int splitIndex = billNo.lastIndexOf("-");
                    String sourceBillNo = billNo.substring(0, splitIndex);
                    String seq = billNo.substring(splitIndex + 1);
                    String srcBillType = dynamicObject2.getString("srcbilltype");
                    Date bizDate = exist.getDate("bookdate");
                    String bizDateStr = "";
                    if (bizDate != null) {
                        bizDateStr = DateUtils.formatDate((Date)bizDate, (String)"yyyy-MM-dd");
                    }
                    this.getCompletionContext().logErrorMsg(sourceBillNo.concat("@").concat(seq).concat("@").concat(srcBillType), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u5df2\u6b63\u5e38\u5f52\u96c6\uff0c\u8bb0\u8d26\u65e5\u671f\u201c%s\u201d\u3002", (String)"AbstractCompletionAction_39", (String)"macc-cad-mservice", (Object[])new Object[0]), bizDateStr));
                }
            }
            this.logger.error("\u4fdd\u5b58\u5931\u8d25\u3002" + errorInfo);
            this.getCompletionContext().setValidate(true);
            report.setError(true);
            report.logTip(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u53d1\u73b0\u5f02\u5e38\u3002", (String)"AbstractCompletionAction_40", (String)"macc-cad-mservice", (Object[])new Object[0]), errorInfo);
        }
        return successQty;
    }

    protected void refreshProgress(String opContent, int nowComplete, int total, Boolean isAddNum) {
        CompletionContext completionContext = this.getCompletionContext();
        String progressId = completionContext.getCompletionArgs().getProgressId();
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        if (isAddNum.booleanValue()) {
            Integer complete = paramDto.getComplete();
            paramDto.setComplete(Integer.valueOf(complete + nowComplete));
        } else {
            paramDto.setComplete(Integer.valueOf(nowComplete));
        }
        if (!CadEmptyUtils.isEmpty((Integer)total)) {
            paramDto.setTotal(Integer.valueOf(total));
        }
        paramDto.setUnit(ResManager.loadKDString((String)"\u6b65", (String)"AbstractCompletionAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]));
        paramDto.setDurationTimes(Integer.valueOf(0));
        if (nowComplete == -1) {
            paramDto.setComplete(paramDto.getTotal());
        }
        ProgressHelper.setProgressParam((String)progressId, (ProgressParamDto)paramDto);
        this.setReportPressAndDur(progressId);
    }

    private void setReportPressAndDur(String progressId) {
        Date coldate;
        int progress = this.getProgress(progressId);
        Long id = this.getCompletionContext().getCollectReport().getId();
        String duration = "";
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_colreport", (String)"coldate", (QFilter[])qFilter.toArray());
        if (dynamicObject != null && (coldate = dynamicObject.getDate("coldate")) != null) {
            double time = (double)(System.currentTimeMillis() - coldate.getTime()) / 1000.0;
            if (0.0 < time && time < 1.0) {
                time = 1.0;
            }
            duration = String.valueOf((int)time);
        }
        try (TXHandle handle = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cad_colreport set fprogress=" + progress + ",fduration=" + duration + " where fid =" + id));
        }
    }

    public int getProgress(String progressId) {
        if (StringUtils.isEmpty((CharSequence)progressId)) {
            return 0;
        }
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return 0;
        }
        if (CadEmptyUtils.isEmpty((Integer)paramDto.getTotal()) || CadEmptyUtils.isEmpty((Integer)paramDto.getComplete())) {
            return 0;
        }
        return (int)((double)paramDto.getComplete().intValue() / (double)paramDto.getTotal().intValue() * 100.0);
    }

    protected void setGradeProdGroup(Set<Long> materialSet, List<DynamicObject> factnedBill) {
        HashMap<Long, Long> mateGroupMap = new HashMap<Long, Long>(16);
        if (factnedBill.size() > 0) {
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            DynamicObject fact = factnedBill.get(0);
            Long orgId = 0L;
            orgId = fact.get("org") instanceof DynamicObject ? Long.valueOf(fact.getLong("org.id")) : Long.valueOf(fact.getLong("org"));
            filter.and("org", "=", (Object)orgId);
            filter.and("status", "=", (Object)"C");
            filter.and("grouptype", "=", (Object)"2");
            filter.and("entryentity.material", "in", materialSet);
            filter.and("effectdate", "<=", (Object)TimeServiceHelper.now());
            filter.and("expdate", ">", (Object)TimeServiceHelper.now());
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_productintogroup", (String)"id,entryentity.material material", (QFilter[])new QFilter[]{filter});
            for (DynamicObject dynamicObject : dynamicObjects) {
                mateGroupMap.put(dynamicObject.getLong("material"), dynamicObject.getLong("id"));
            }
            if (!mateGroupMap.isEmpty()) {
                for (DynamicObject dynamicObject : factnedBill) {
                    long material = dynamicObject.getLong("material");
                    Long groupId = (Long)mateGroupMap.get(material);
                    if (groupId == null) continue;
                    dynamicObject.set("gradeprodgroup", (Object)groupId);
                }
            }
        }
    }

    public DynamicObject[] getPlanBySourceBill(Long accountOrg, List<Long> costCenters, String appNum, List<Long> mftOrderEntryIds, Set<Long> entryIds, Map<String, Object> collectParamMap) {
        QFilter orgQf = new QFilter("accountorg", "=", (Object)accountOrg);
        QFilter costCenterQf = new QFilter("costcenter", "in", costCenters);
        QFilter qfBillStatu = new QFilter("billstatus", "=", (Object)"C");
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        if (!CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            qfAppNum.and("sourcebillentry", "in", mftOrderEntryIds);
        }
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)accountOrg, (String)"bizdate", (String)appNum);
        if (!CadEmptyUtils.isEmpty(collectParamMap) && collectParamMap.get("startDate") != null && collectParamMap.get("endDate") != null) {
            QFilter collectTimeQFilter = new QFilter("bizdate", ">=", collectParamMap.get("startDate"));
            collectTimeQFilter.and(new QFilter("bizdate", "<=", collectParamMap.get("endDate")));
            bookDateQf.and(collectTimeQFilter);
        }
        HashSet<Long> ids = new HashSet<Long>();
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"planbill", (String)"cad_plannedoutputbill", (String)"id", (QFilter[])new QFilter[]{orgQf, costCenterQf, bookDateQf, qfBillStatu, qfAppNum}, null);
        for (Row row : resultDs) {
            ids.add(row.getLong("id"));
        }
        if (!CadEmptyUtils.isEmpty(entryIds)) {
            bookDateQf = new QFilter("costobject.probill", "in", entryIds);
            resultDs = QueryServiceHelper.queryDataSet((String)"planbill", (String)"cad_plannedoutputbill", (String)"id", (QFilter[])new QFilter[]{orgQf, costCenterQf, bookDateQf, qfBillStatu, qfAppNum}, null);
            for (Row row : resultDs) {
                ids.add(row.getLong("id"));
            }
        }
        QFilter idFilter = new QFilter("id", "in", ids);
        return BusinessDataServiceHelper.load((String)"cad_plannedoutputbill", (String)"id,accountorg.id,costobject.srcbillnumber,costobject.srcbillrow,costobject.probill,material.id,costobject.id,costcenter.id,qty", (QFilter[])idFilter.toArray(), null);
    }

    protected List<DynamicObject> generateMaterialCompletion(Long org, List<Long> costCenters, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, Map<String, DynamicObject>> existCostObjectMap, TreeMap<String, String> collConfigRuleMappingMap, Map<String, String> configMappingMap, Map<String, DynamicObject> idEntryIdCompleteMap, Map<Long, String> outSourcePrice, Set<String> existBillNos, String sourceEntity, String appNum) {
        ArrayList<DynamicObject> factnedBill = new ArrayList<DynamicObject>();
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            this.logger.info("\u6838\u7b97\u7ec4\u7ec7{}\uff0c\u627e\u4e0d\u5230\u6e90\u5355\uff0c\u5f52\u96c6\u7ed3\u675f", (Object)org);
            return factnedBill;
        }
        HashMap<String, DynamicObject> changeFactMap = new HashMap<String, DynamicObject>(16);
        this.dealExitsData(idEntryIdCompleteMap, srcAndTargetBillsMap.keySet().toArray(new DynamicObject[0]), changeFactMap, appNum);
        Map costSyncInfoMap = ImportInitCostHelper.getCostRecordMap((DynamicObject[])srcAndTargetBillsMap.keySet().toArray(new DynamicObject[0]));
        int updNum = 0;
        int addNum = 0;
        List<DynamicObject> factnedBills = this.getCompletionContext().getFactnedBills();
        Set willSaveBillNoSet = factnedBills.stream().map(o -> o.getString("billno")).collect(Collectors.toSet());
        HashSet<Long> materialSet = new HashSet<Long>(200);
        Set<String> existsIds = idEntryIdCompleteMap.keySet();
        HashMap<Long, Boolean> outSourceMaterialMap = new HashMap<Long, Boolean>(16);
        HashMap orgCostaccountMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap<String, DynamicObject> needDelDynMap = new HashMap<String, DynamicObject>(10);
        HashMap<Long, Tuple2> costobjectKeyColMap = new HashMap<Long, Tuple2>(10);
        HashSet<Long> keycolfieldUpdateSet = new HashSet<Long>(10);
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBills : srcAndTargetBillsMap.entrySet()) {
            DynamicObject sourceBill = srcAndTargetBills.getKey();
            DynamicObject targetBill = srcAndTargetBills.getValue();
            if (!sourceEntity.equals(sourceBill.getString("billtype"))) continue;
            if (targetBill == null) {
                this.getCompletionContext().logErrorMsg(sourceBill.getString("billno").concat("@").concat(sourceBill.getString("entryseq")).concat("@").concat(sourceBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\u3002", (String)"AbstractCompletionAction_30", (String)"macc-cad-mservice", (Object[])new Object[0]), sourceBill.getString("billno"), sourceBill.getString("entryseq")));
                continue;
            }
            String sourceId = sourceBill.getString("id") + "-" + sourceBill.getString("entryId");
            boolean isNeedChangeData = changeFactMap.containsKey(sourceId);
            if (existsIds.contains(sourceId) && !isNeedChangeData) {
                this.getCompletionContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"AbstractCompletionAction_20", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"AbstractCompletionAction_31", (String)"macc-cad-mservice", (Object[])new Object[0]), sourceBill.getString("billno"), sourceBill.getString("entryseq")));
                this.logger.info("\u6e90\u5355{}\u5df2\u5f15\u5165\u4e14\u6ca1\u6709\u53d8\u66f4\u3002", (Object)sourceBill.getString("billno"));
                idEntryIdCompleteMap.remove(sourceId);
                continue;
            }
            String billNo = targetBill.getString("billno");
            if (willSaveBillNoSet.contains(billNo)) {
                this.getCompletionContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"AbstractCompletionAction_20", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"AbstractCompletionAction_32", (String)"macc-cad-mservice", (Object[])new Object[0]), sourceBill.getString("billno"), sourceBill.getString("entryseq")));
                this.logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6-\u6e90\u5355{}\u884c\u53f7{}\u5df2\u5728\u5176\u4ed6\u6210\u672c\u4e2d\u5fc3\u4e0b\u5f15\u5165\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)sourceBill.getString("billno"), (Object)sourceBill.getString("entryseq"));
                continue;
            }
            if (!existsIds.contains(sourceId) && existBillNos.contains(sourceBill.getString("billno") + "-" + sourceBill.getString("entryseq"))) {
                this.getCompletionContext().getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"AbstractCompletionAction_20", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"AbstractCompletionAction_32", (String)"macc-cad-mservice", (Object[])new Object[0]), sourceBill.getString("billno"), sourceBill.getString("entryseq")));
                this.logger.info("\u6e90\u5355{}\u884c\u53f7{}\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)sourceBill.getString("billno"), (Object)sourceBill.getString("entryseq"));
                continue;
            }
            List costSyncInfos = (List)costSyncInfoMap.get(sourceBill.getLong("entryId"));
            if (CollectionUtils.isEmpty((Collection)costSyncInfos)) {
                this.getCompletionContext().logErrorMsg(sourceBill.getString("billno").concat("@").concat(sourceBill.getString("entryseq")).concat("@").concat(sourceBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u751f\u6210\u6210\u672c\u6838\u7b97\u8bb0\u5f55\u3002", (String)"AbstractCompletionAction_33", (String)"macc-cad-mservice", (Object[])new Object[0]), sourceBill.getString("billno"), sourceBill.getString("entryseq")));
                this.logger.info("\u4ece\u751f\u4ea7\u5165\u5e93\u5355\u5f15\u5165\uff0c\u672a\u83b7\u53d6\u5230\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002\u5f53\u524d\u751f\u6210\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u7ed3\u675f,\u6e90\u5355\u5206\u5f55id{}", (Object)sourceBill.getLong("entryId"));
                continue;
            }
            Long costCenterId = targetBill.getLong("costcenter.id");
            if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                this.getCompletionContext().logErrorMsg(sourceBill.getString("billno").concat("@").concat(sourceBill.getString("entryseq")).concat("@").concat(sourceBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"AbstractCompletionAction_34", (String)"macc-cad-mservice", (Object[])new Object[0]), sourceBill.getString("billno"), sourceBill.getString("entryseq")));
                continue;
            }
            if (!costCenters.contains(costCenterId)) continue;
            DynamicObject costObject = null;
            if (targetBill.containsProperty("costobject") && !CadEmptyUtils.isEmpty((DynamicObjectCollection)targetBill.getDynamicObjectCollection("entryentity")) && ((DynamicObject)targetBill.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("costobject") != null) {
                costObject = ((DynamicObject)targetBill.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("costobject");
            } else {
                String srcStr = CostObjectHelper.getCostObjectHashCodeBySrcBill((DynamicObject)sourceBill, collConfigRuleMappingMap);
                Map<String, DynamicObject> matInfoList = existCostObjectMap.get(String.valueOf(org).concat(String.valueOf(costCenterId)));
                DynamicObject dynamicObject = costObject = matInfoList == null ? null : matInfoList.get(srcStr);
            }
            if (costObject == null) {
                if ("sca".equals(appNum)) {
                    this.getCompletionContext().logErrorMsg(sourceBill.getString("billno").concat("@").concat(sourceBill.getString("entryseq")).concat("@").concat(sourceBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u4e14\u672a\u7ed3\u7b97\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"AbstractCompletionAction_35", (String)"macc-cad-mservice", (Object[])new Object[0]), sourceBill.getString("billno"), sourceBill.getString("entryseq")));
                    continue;
                }
                this.getCompletionContext().logErrorMsg(sourceBill.getString("billno").concat("@").concat(sourceBill.getString("entryseq")).concat("@").concat(sourceBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"AbstractCompletionAction_36", (String)"macc-cad-mservice", (Object[])new Object[0]), sourceBill.getString("billno"), sourceBill.getString("entryseq")));
                continue;
            }
            Long keycol = costObject.getLong("calckeycol");
            String keycolfield = costObject.getString("keycolfield");
            if (CadEmptyUtils.isEmpty((Long)keycol) || kd.bos.util.StringUtils.isEmpty((String)keycolfield)) {
                if (kd.bos.util.StringUtils.isEmpty((String)keycolfield)) {
                    keycolfieldUpdateSet.add(costObject.getLong("id"));
                }
                costobjectKeyColMap.putIfAbsent(costObject.getLong("id"), new Tuple2((Object)((DynamicObject)costSyncInfos.get(0)).getString("caldimension"), (Object)((DynamicObject)costSyncInfos.get(0)).getString("noupdatecalfields")));
            }
            if (isNeedChangeData) {
                DynamicObject factned = idEntryIdCompleteMap.remove(sourceId);
                if (factned != null) {
                    needDelDynMap.put(sourceId, factned);
                }
                ++addNum;
            } else {
                ++addNum;
            }
            DynamicObjectCollection entryentity = targetBill.getDynamicObjectCollection("entryentity");
            DynamicObject newEntity = null;
            newEntity = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryentity) ? entryentity.addNew() : (DynamicObject)entryentity.get(0);
            newEntity.set("costobject", (Object)costObject.getLong("id"));
            outSourceMaterialMap.put(costObject.getLong("material.id"), costObject.getBoolean("isoutsource"));
            targetBill.set("version", (Object)costObject.getLong("bomversion"));
            targetBill.set("auxpty", (Object)costObject.getLong("auxpty"));
            targetBill.set("configuredcode", (Object)costObject.getLong("configuredcode"));
            targetBill.set("tracknumber", (Object)costObject.getLong("tracknumber"));
            targetBill.set("project", (Object)costObject.getLong("projectnumber"));
            targetBill.set("lot", (Object)costObject.getString("lot"));
            targetBill.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
            targetBill.set("createtime", (Object)TimeServiceHelper.now());
            targetBill.set("auditor", (Object)Long.valueOf(RequestContext.get().getUserId()));
            targetBill.set("auditdate", (Object)TimeServiceHelper.now());
            materialSet.add(targetBill.getLong("material"));
            if ("sca".equals(appNum)) {
                DynamicObjectCollection entryEntity = targetBill.getDynamicObjectCollection("entryentity");
                BigDecimal completeqty = targetBill.getBigDecimal("completeqty");
                for (DynamicObject entry : entryEntity) {
                    long materialId = costObject.getLong("material");
                    boolean isOutSource = costObject.getBoolean("isoutsource");
                    outSourceMaterialMap.put(materialId, isOutSource);
                    if (entry.get("qty") != null && entry.getBigDecimal("qty").compareTo(BigDecimal.ZERO) != 0) continue;
                    entry.set("qty", (Object)completeqty);
                }
                DynamicObjectCollection entryCostEntity = targetBill.getDynamicObjectCollection("entrycost");
                entryCostEntity.clear();
                ImportInitCostHelper.createEntryCost((DynamicObject)targetBill, (List)costSyncInfos, outSourcePrice, outSourceMaterialMap, (Map)orgCostaccountMap);
                DynamicObjectCollection entrycost = targetBill.getDynamicObjectCollection("entrycost");
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entrycost)) {
                    this.getCompletionContext().logErrorMsg(sourceBill.getString("billno").concat("@").concat(sourceBill.getString("entryseq")).concat("@").concat(sourceBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u672a\u627e\u5230\u6e90\u5355\u5bf9\u5e94\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\u3002", (String)"AbstractCompletionAction_37", (String)"macc-cad-mservice", (Object[])new Object[0]), sourceBill.getString("billno"), sourceBill.getString("entryseq")));
                    this.logger.info("\u672a\u627e\u5230\u6e90\u5355\u5bf9\u5e94\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\uff0c\u521b\u5efaentrycost\u5931\u8d25\uff0c\u5f15\u5165\u5931\u8d25\uff0c\u6e90\u5355:{}", (Object)sourceBill.getString("billno"));
                    continue;
                }
                factnedBills.add(targetBill);
                continue;
            }
            factnedBill.add(targetBill);
        }
        if (!needDelDynMap.isEmpty()) {
            this.deleteFactnedBillForNoSrource(needDelDynMap);
        }
        if ("aca".equals(appNum) && !materialSet.isEmpty()) {
            this.setGradeProdGroup(materialSet, factnedBill);
        }
        CalcKeycolHelper.costobjectGenKeyCol((Long)org, null, (String)appNum, costobjectKeyColMap, keycolfieldUpdateSet);
        this.getCompletionContext().setAddNum(this.getCompletionContext().getAddNum() + addNum);
        this.getCompletionContext().setUpdateNum(this.getCompletionContext().getUpdateNum() + updNum);
        this.getCompletionContext().getFactnedBills().addAll(factnedBill);
        return factnedBill;
    }

    protected void dealExitsData(Map<String, DynamicObject> idEntryIdCompleteMap, DynamicObject[] sourceBill, Map<String, DynamicObject> changeFactMap, String appNum) {
        if (CadEmptyUtils.isEmpty(idEntryIdCompleteMap) || CadEmptyUtils.isEmpty((Object[])sourceBill)) {
            return;
        }
        HashMap<Long, Date> dateMap = new HashMap<Long, Date>(16);
        for (DynamicObject manu : sourceBill) {
            dateMap.put(manu.getLong("id"), manu.getDate("auditdate"));
        }
        for (Map.Entry entry : idEntryIdCompleteMap.entrySet()) {
            String factKey = (String)entry.getKey();
            DynamicObject fact = (DynamicObject)entry.getValue();
            if (fact == null) continue;
            Long srcBillId = fact.getLong("sourcebill");
            Date nsrcAuditDate = fact.getDate("nsrcauditdate");
            if (nsrcAuditDate == null || dateMap.get(srcBillId) == null || nsrcAuditDate.compareTo((Date)dateMap.get(srcBillId)) == 0) continue;
            changeFactMap.put(factKey, fact);
        }
    }

    protected void deleteFactned(Set<Long> deleteIds) {
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cad_factnedoutputbill"), (Object[])deleteIds.toArray(new Long[0]));
    }

    protected void delChangeRecord(Set<Long> srcBillIds) {
        QFilter filter = new QFilter("sourcebill", "in", srcBillIds);
        filter.and("bizstatus", "!=", (Object)"B");
        DeleteServiceHelper.delete((String)"sca_costchangerecord", (QFilter[])new QFilter[]{filter});
    }

    protected DynamicObject buildResourceAbsorbBill(DynamicObject factned, DynamicObjectCollection entryentity, Long costaccount, Set<OutSourcePrice> outSourcePrices) {
        DynamicObject costAccountDO = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.calpolicy.currency currency,entry.calpolicy.currency.amtprecision amtprecision,entry.currentperiod currentperiod", (QFilter[])new QFilter("entry.costaccount", "=", (Object)costaccount).toArray());
        if (costAccountDO == null) {
            return null;
        }
        DynamicObject resourceAbsorb = BusinessDataServiceHelper.newDynamicObject((String)"sca_resourceabsorb");
        resourceAbsorb.set("billno", (Object)factned.getString("billno"));
        resourceAbsorb.set("org", (Object)this.getCompletionContext().getCompletionArgs().getAcctOrgId());
        resourceAbsorb.set("costaccount", (Object)costaccount);
        resourceAbsorb.set("costcenter", (Object)factned.getLong("costcenter.id"));
        resourceAbsorb.set("period", (Object)PeriodHelper.getPeriodByDate((Date)factned.getDate("bookdate"), (Long)costaccount).getLong("id"));
        resourceAbsorb.set("currency", (Object)costAccountDO.getLong("currency"));
        resourceAbsorb.set("sourcetype", (Object)"F");
        resourceAbsorb.set("outputbillno", (Object)factned.getString("billno"));
        resourceAbsorb.set("businessdate", (Object)factned.getDate("bizdate"));
        resourceAbsorb.set("bookdate", (Object)factned.getDate("bookdate"));
        resourceAbsorb.set("costobject", (Object)this.getDyLong(((DynamicObject)entryentity.get(0)).get("costobject")));
        resourceAbsorb.set("sourcebill", (Object)factned.getLong("id"));
        resourceAbsorb.set("sourcebillentry", (Object)0L);
        resourceAbsorb.set("material", (Object)this.getDyLong(factned.get("material")));
        resourceAbsorb.set("auxpty", (Object)this.getDyLong(factned.get("auxpty")));
        resourceAbsorb.set("creator", (Object)RequestContext.get().getCurrUserId());
        resourceAbsorb.set("modifier", (Object)RequestContext.get().getCurrUserId());
        resourceAbsorb.set("auditor", (Object)RequestContext.get().getCurrUserId());
        resourceAbsorb.set("createtime", (Object)TimeServiceHelper.now());
        resourceAbsorb.set("modifytime", (Object)TimeServiceHelper.now());
        resourceAbsorb.set("auditdate", (Object)TimeServiceHelper.now());
        resourceAbsorb.set("billstatus", (Object)"C");
        Date srcAuditDate = factned.getDate("srcauditdate");
        DynamicObjectCollection entryEntity = resourceAbsorb.getDynamicObjectCollection("entryentity");
        for (OutSourcePrice materialPrice : outSourcePrices) {
            if (srcAuditDate.getTime() < materialPrice.getEffectDate().getTime() || srcAuditDate.getTime() >= materialPrice.getExpDate().getTime()) continue;
            BigDecimal qty = factned.getBigDecimal("completeqty");
            BigDecimal unitPrice = materialPrice.getPrice();
            int amtprecision = costAccountDO.getInt("amtprecision");
            BigDecimal amount = unitPrice.multiply(qty).setScale(amtprecision, 4);
            long element = materialPrice.getElement();
            long subElement = materialPrice.getSubElement();
            resourceAbsorb.set("keycol", (Object)materialPrice.getKeycol());
            resourceAbsorb.set("keycolid", (Object)materialPrice.getKeycolid());
            DynamicObject raEntry = entryEntity.addNew();
            raEntry.set("element", (Object)element);
            raEntry.set("subelement", (Object)subElement);
            raEntry.set("qty", (Object)qty);
            raEntry.set("unitprice", (Object)unitPrice);
            raEntry.set("amount", (Object)amount);
            raEntry.set("baseunit", (Object)this.getDyLong(factned.get("baseunit")));
        }
        return resourceAbsorb;
    }

    protected DynamicObject buildResourceAbsorbBill(DynamicObject factned, DynamicObjectCollection entryentity, Long costaccount, OutSourcePrice materialPrice) {
        DynamicObject costAccountDO = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.calpolicy.currency currency,entry.calpolicy.currency.amtprecision amtprecision,entry.currentperiod currentperiod", (QFilter[])new QFilter("entry.costaccount", "=", (Object)costaccount).toArray());
        DynamicObject resourceAbsorb = BusinessDataServiceHelper.newDynamicObject((String)"sca_resourceabsorb");
        resourceAbsorb.set("org", (Object)this.getCompletionContext().getCompletionArgs().getAcctOrgId());
        resourceAbsorb.set("costaccount", (Object)costaccount);
        resourceAbsorb.set("costcenter", (Object)factned.getLong("costcenter.id"));
        resourceAbsorb.set("period", (Object)PeriodHelper.getPeriodByDate((Date)factned.getDate("bookdate"), (Long)costaccount).getLong("id"));
        resourceAbsorb.set("currency", (Object)costAccountDO.getLong("currency"));
        resourceAbsorb.set("sourcetype", (Object)"F");
        resourceAbsorb.set("outputbillno", (Object)factned.getString("billno"));
        resourceAbsorb.set("businessdate", (Object)factned.getDate("bizdate"));
        resourceAbsorb.set("bookdate", (Object)factned.getDate("bookdate"));
        resourceAbsorb.set("costobject", (Object)this.getDyLong(((DynamicObject)entryentity.get(0)).get("costobject")));
        resourceAbsorb.set("sourcebill", (Object)factned.getLong("id"));
        resourceAbsorb.set("sourcebillentry", (Object)0L);
        resourceAbsorb.set("material", (Object)this.getDyLong(factned.get("material")));
        resourceAbsorb.set("auxpty", (Object)this.getDyLong(factned.get("auxpty")));
        resourceAbsorb.set("creator", (Object)RequestContext.get().getCurrUserId());
        resourceAbsorb.set("modifier", (Object)RequestContext.get().getCurrUserId());
        resourceAbsorb.set("auditor", (Object)RequestContext.get().getCurrUserId());
        resourceAbsorb.set("createtime", (Object)TimeServiceHelper.now());
        resourceAbsorb.set("modifytime", (Object)TimeServiceHelper.now());
        resourceAbsorb.set("auditdate", (Object)TimeServiceHelper.now());
        resourceAbsorb.set("billstatus", (Object)"C");
        DynamicObjectCollection entryEntity = resourceAbsorb.getDynamicObjectCollection("entryentity");
        BigDecimal qty = factned.getBigDecimal("completeqty");
        BigDecimal unitPrice = materialPrice.getPrice();
        int amtprecision = costAccountDO.getInt("amtprecision");
        BigDecimal amount = unitPrice.multiply(qty).setScale(amtprecision, 4);
        long element = materialPrice.getElement();
        long subElement = materialPrice.getSubElement();
        DynamicObject raEntry = entryEntity.addNew();
        raEntry.set("element", (Object)element);
        raEntry.set("subelement", (Object)subElement);
        raEntry.set("qty", (Object)qty);
        raEntry.set("unitprice", (Object)unitPrice);
        raEntry.set("amount", (Object)amount);
        raEntry.set("baseunit", (Object)this.getDyLong(factned.get("baseunit")));
        return resourceAbsorb;
    }

    private Long getDyLong(Object obj) {
        Long id = obj instanceof DynamicObject ? Long.valueOf(((DynamicObject)obj).getLong("id")) : (Long)obj;
        return id;
    }

    protected String getResourceAbsorbBillno(String resourceBillno, String entryseq, Set<String> exitBillNo, int i) {
        String billno = resourceBillno + "-" + entryseq + "-" + i;
        if (exitBillNo.contains(billno)) {
            return this.getResourceAbsorbBillno(resourceBillno, entryseq, exitBillNo, ++i);
        }
        exitBillNo.add(billno);
        return billno;
    }
}

