/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.factedoutput;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.config.costcenter.CostCenterRelationService;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.engine.CollConifgContext;
import kd.macc.cad.business.config.engine.CollConifgParam;
import kd.macc.cad.business.config.engine.IBillTransfer;
import kd.macc.cad.business.config.engine.filter.CollConfigFilterService;
import kd.macc.cad.business.config.engine.helper.CollectEngineHelper;
import kd.macc.cad.business.config.engine.mapping.CollConfigMappingService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.BatchUtils;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MaterialPropHelper;
import kd.macc.cad.mservice.factedoutput.AbstractCompletionAction;
import kd.macc.cad.mservice.factedoutput.AcaCompletionImportDataForFLConfigAction;
import kd.macc.cad.mservice.factedoutput.AcaCompletionImportDataForPZConfigAction;
import kd.macc.cad.mservice.factedoutput.CompletionArgs;
import kd.macc.cad.mservice.factedoutput.CompletionContext;
import kd.macc.cad.mservice.factedoutput.CompletionImportDataConfigAction;
import kd.macc.cad.mservice.factedoutput.CompletionImportDataForCUConfigAction;
import kd.macc.cad.mservice.factedoutput.CompletionImportDataForFPConfigAction;
import kd.macc.cad.mservice.factedoutput.CompletionSaveAction;
import kd.macc.cad.mservice.factedoutput.ICompletionAction;
import kd.macc.cad.mservice.factedoutput.ScaCompletionWriteCostChangeConfigAction;

public class CompeletionTransferAction
extends AbstractCompletionAction {
    private static final Log logger = LogFactory.getLog(CompeletionTransferAction.class);

    @Override
    protected void doExecute() {
        CompletionContext context = this.getCompletionContext();
        Map<Long, Set<Long>> acctOrgCostCentersMap = context.getAcctOrgCostCentersMap();
        boolean disableCollectReport = CollectReportHelper.disableCollectReport();
        int batchSize = CadBgParamUtils.getCadParamForInt((String)"factnedCollBatch", (int)10000);
        logger.info("\u5dee\u91cf\u5f52\u96c6\u5224\u65ad:\u5f52\u96c6\u62a5\u544a\u5f00\u542f\u72b6\u6001{}", (Object)disableCollectReport);
        List<ICompletionAction> actions = this.initializeActions(context.getCompletionArgs().getAppNum());
        for (Map.Entry<Long, Set<Long>> entry : acctOrgCostCentersMap.entrySet()) {
            this.orgToCollect(entry.getKey(), entry.getValue(), disableCollectReport, actions, batchSize);
        }
    }

    private void orgToCollect(Long acctOrgId, Set<Long> costCenterIds, boolean disableCollectReport, List<ICompletionAction> actions, int batchSize) {
        ArrayList<Long> orgCostCenterIds = new ArrayList<Long>(costCenterIds);
        CompletionContext context = this.getCompletionContext();
        CompletionArgs collectionArgs = context.getCompletionArgs();
        CollConifgContext configContext = this.getConfigParam(context, orgCostCenterIds);
        HashSet<Long> allCollconfigIds = new HashSet<Long>(10);
        allCollconfigIds.add(0L);
        List<DynamicObject> collConfigList = this.getValidCollConfigList(context, "cad_factnedoutputbill", allCollconfigIds);
        if (CadEmptyUtils.isEmpty(collConfigList)) {
            return;
        }
        CollConfigMappingService mappingService = new CollConfigMappingService();
        Map collConfigMappingMap = mappingService.getCollConfigMappingMap(collConfigList);
        Map collSelectValueMappingMap = mappingService.getCollSelectValueMappingMap(collConfigList);
        Map collConfigRuleMappingMap = mappingService.getCollConfigRuleMappingMap(collConfigList);
        Map collConfigFilterMap = new CollConfigFilterService().getCollConfigFilterMap(collConfigList);
        boolean isOldUserForSysParamBizRange = ImportServiceHelper.isOldUserForSysParamBizRange();
        Map<String, List<Long>> billRangeMap = isOldUserForSysParamBizRange ? this.getBillRangeMap(context.getCompletionArgs().getAcctOrgId(), orgCostCenterIds, "cad_factnedoutputbill", context.getCompletionArgs().getAppNum(), context.getCollectReport()) : null;
        context.getCollConfigMappingMap().putAll(collConfigMappingMap);
        context.getCollConfigRuleMappingMap().putAll(collConfigRuleMappingMap);
        Map<String, Set<Long>> costCentersourceTypeDataMap = this.getCostCentersourceTypeDataMap(configContext);
        this.delHistoryCollConfigData(collConfigList.get(0), collectionArgs, allCollconfigIds, context.getCollConfigRuleMappingMap());
        HashMap souCollConfigsMap = Maps.newHashMapWithExpectedSize((int)10);
        for (DynamicObject config2 : collConfigList) {
            String sourcebill = config2.getString("sourcebill.id") + "@" + config2.getString("calmethod");
            souCollConfigsMap.computeIfAbsent(sourcebill, t -> new ArrayList()).add(config2);
        }
        this.addConfigEntry();
        int total = collConfigList.size() + 2;
        this.refreshProgress(ResManager.loadKDString((String)"\u914d\u7f6e\u65b9\u6848\u5f15\u5165\u5904\u7406", (String)"CompeletionTransferAction_11", (String)"macc-cad-mservice", (Object[])new Object[0]), 1, total, false);
        for (List cofigList : souCollConfigsMap.values()) {
            cofigList.forEach(config -> {
                String confignumber = config.getString("number");
                this.refreshProgress(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u914d\u7f6e\u65b9\u6848\u5f00\u59cb\u5f15\u5165\u5904\u7406", (String)"CompeletionTransferAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]), confignumber), 1, 0, true);
                context.getIdEntryIdCompleteMap().clear();
                context.getExistBillNos().clear();
                context.getDelFactnedBills().clear();
                long configId = config.getLong("id");
                String targetBillEntity = config.getString("costbill.id");
                String sourceBillEntity = config.getString("sourcebill.id");
                DataSet existsBillDs = this.getExistsCompletBill(acctOrgId, orgCostCenterIds, collectionArgs.getManuOrgs(), collectionArgs.getMftOrderEntryIds(), (Map)collConfigRuleMappingMap.get(config.getLong("id")), sourceBillEntity, collectionArgs.getAppNum(), collectionArgs.getCollectParamMap(), config.getLong("id"), null);
                Map fieldMappingMap = (Map)collConfigMappingMap.get(configId);
                String entryEntityName = this.getSrcEntryEntityName(fieldMappingMap);
                Map selectValueMappingMap = (Map)collSelectValueMappingMap.get(configId);
                Map ruleMappingMap = (Map)collConfigRuleMappingMap.get(configId);
                if (isOldUserForSysParamBizRange && billRangeMap != null && !billRangeMap.containsKey("norange")) {
                    if (!billRangeMap.containsKey(sourceBillEntity)) {
                        logger.info("\u6e90\u5355\uff1a\u3010" + sourceBillEntity + "\u3011\uff0c\u4e0d\u5728\u76ee\u6807\u5355\u3010" + targetBillEntity + "\u3011\u8bbe\u7f6e\u7684\u5f52\u96c6\u5355\u636e\u8303\u56f4\u5185");
                        return;
                    }
                    List ccsIds = (List)billRangeMap.get(sourceBillEntity);
                    if (CadEmptyUtils.isEmpty((List)ccsIds)) {
                        logger.info("\u6e90\u5355\uff1a\u3010" + sourceBillEntity + "\u3011\uff0c\u76ee\u6807\u5355\u3010" + targetBillEntity + "\u3011\uff0c\u6ca1\u6709\u9700\u8981\u5f52\u96c6\u7684\u6210\u672c\u4e2d\u5fc3");
                        return;
                    }
                    configContext.getParam().setCostCenterIds(ccsIds.toArray(new Long[0]));
                }
                List collConfigFilter = ImportServiceHelper.getSrcQFilters((Long)configContext.getParam().getCalOrgId(), (List)orgCostCenterIds, Arrays.asList(configContext.getParam().getManuOrgIds()), (DynamicObject)config, (Map)collConfigFilterMap, (Map)fieldMappingMap, (Map)selectValueMappingMap, (Map)costCentersourceTypeDataMap, collectionArgs.getMftOrderEntryIds(), collectionArgs.getCollectParamMap(), (Long)configContext.getParam().getCostAccountId(), (Long)configContext.getParam().getCurPeriodId(), (String)configContext.getParam().getAppnum(), (Map)configContext.getConfigProEntryIdWorkCenterMap(), (CollectReport)context.getCollectReport());
                String selectFields = CollectEngineHelper.getSrcSelectFields((DynamicObject)config, (Map)fieldMappingMap, (Map)ruleMappingMap);
                if (CadEmptyUtils.isEmpty((String)selectFields)) {
                    return;
                }
                logger.info("\u67e5\u8be2\u6e90\u5355\u8fc7\u6ee4\u6761\u4ef6\uff1a{}", (Object)collConfigFilter);
                StringBuilder selectFieldStr = new StringBuilder("id,auditdate");
                if (!"id".equals(entryEntityName)) {
                    selectFieldStr.append(",");
                    selectFieldStr.append(entryEntityName);
                }
                DataSet sourceBills = QueryServiceHelper.queryDataSet((String)"CompeletionTransferAction_doExecute", (String)sourceBillEntity, (String)selectFieldStr.toString(), (QFilter[])collConfigFilter.toArray(new QFilter[0]), (String)"id desc");
                if (!disableCollectReport) {
                    DataSet notChangeDs;
                    long diffTime = System.currentTimeMillis();
                    boolean isChanged = this.checkConfigChanged((DynamicObject)config, targetBillEntity);
                    logger.info("\u5dee\u91cf\u5f52\u96c6\u5224\u65ad:\u6210\u672c\u5f52\u96c6\u914d\u7f6e\u65b9\u6848:{},\u6539\u53d8\u72b6\u6001:{}", (Object)config.getString("number"), (Object)isChanged);
                    if (!(isChanged || existsBillDs == null || existsBillDs.isEmpty() || (notChangeDs = sourceBills.copy().join(existsBillDs.copy(), JoinType.INNER).on(entryEntityName, "sourcebillentryid").on("auditdate", "nsrcauditdate").select(new String[]{entryEntityName}, new String[]{"id as useId"}).finish()) == null || notChangeDs.isEmpty())) {
                        final HashSet<Long> sourceEntryIds = new HashSet<Long>(512);
                        final HashSet<Long> targetIds = new HashSet<Long>(512);
                        for (Row notChangeD : notChangeDs) {
                            sourceEntryIds.add(notChangeD.getLong(entryEntityName));
                            targetIds.add(notChangeD.getLong("useId"));
                        }
                        logger.info("\u5dee\u91cf\u5f52\u96c6\u5224\u65ad\uff1a\u65b9\u6848\uff1a{}\u6709{}\u6761\u5206\u5f55\u6570\u636e\u672a\u6539\u53d8\uff0c\u5254\u9664", (Object)config.getString("number"), (Object)sourceEntryIds.size());
                        if (!sourceEntryIds.isEmpty()) {
                            final String finalEntryEntityName = entryEntityName;
                            sourceBills = sourceBills.filter(new FilterFunction(){

                                public boolean test(Row row) {
                                    return !sourceEntryIds.contains(row.getLong(finalEntryEntityName));
                                }
                            });
                        }
                        if (!targetIds.isEmpty()) {
                            existsBillDs = existsBillDs.filter(new FilterFunction(){

                                public boolean test(Row row) {
                                    return !targetIds.contains(row.getLong("id"));
                                }
                            });
                        }
                    }
                    logger.info("\u5dee\u91cf\u5f52\u96c6\u5224\u65ad\uff1a\u5dee\u91cf\u5904\u7406,\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - diffTime));
                }
                List partitionIds = BatchUtils.batchDataByEntryId((DataSet)sourceBills, (Integer)batchSize, (String)entryEntityName);
                this.setIdEntryIdCompleteMap(context, existsBillDs, fieldMappingMap);
                logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5206\u6279\uff1a\u65b9\u6848\u7f16\u53f7\uff1a{}\uff0c\u5206\u6279id\u7ed3\u675f\uff0c\u5171:{}\u6279", (Object)config.getString("number"), (Object)partitionIds.size());
                for (int i = 0; i < partitionIds.size(); ++i) {
                    this.refreshProgress(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u65b9\u6848\u6b63\u5728\u5f15\u5165\uff0c\u3010%2$s\u3011/\u3010%3$s\u3011\u6279\u3002", (String)"CompeletionTransferAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]), confignumber, i + 1, partitionIds.size()), 0, 0, true);
                    context.getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u3010%s\u3011\u5206\u6279\u5904\u7406", (String)"CompeletionTransferAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                    context.getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7b2c\u3010%1$s\u3011\u6279\uff0c\u5171\u3010%2$s\u3011\u6279\u3002", (String)"CompeletionTransferAction_8", (String)"macc-cad-mservice", (Object[])new Object[0]), i + 1, partitionIds.size()));
                    long start = TimeServiceHelper.now().getTime();
                    List entryIdList = (List)partitionIds.get(i);
                    logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5206\u6279\uff1a\u5f00\u59cb\u5206\u6279\u4f5c\u4e1a:\u7b2c{}\u6279\uff0c\u5355\u636e\u6570\u91cf{}", (Object)i, (Object)entryIdList.size());
                    if (CadEmptyUtils.isEmpty((List)entryIdList)) continue;
                    QFilter entryIdQf = new QFilter(entryEntityName, "in", (Object)entryIdList);
                    DynamicObjectCollection resResults = QueryServiceHelper.query((String)sourceBillEntity, (String)selectFields, (QFilter[])new QFilter[]{entryIdQf});
                    MaterialPropHelper.queryMaterialPropAndSet((DynamicObjectCollection)resResults, (String)selectFields);
                    IBillTransfer billTransfer = IBillTransfer.getTransferInstance((String)"cad_factnedoutputbill", (String)collectionArgs.getAppNum());
                    BillTransferResult result = billTransfer.doTransfer((DynamicObject[])resResults.toArray((Object[])new DynamicObject[0]), config, configContext);
                    logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5206\u6279\uff1a\u8f6c\u6362\u7ed3\u679c\uff1a{},\u8017\u65f6:{}", (Object)context.getConfigSrcAndTargetBillsMap().size(), (Object)(TimeServiceHelper.now().getTime() - start));
                    context.getConfigSrcAndTargetBillsMap().put((DynamicObject)config, result.getSrcAndTargetBillsMap());
                    for (ICompletionAction action : actions) {
                        long actionTime = System.currentTimeMillis();
                        action.setContext(context);
                        action.execute();
                        logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5206\u6279\uff1a\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5f15\u5165-action\uff1a{},\u8017\u65f6\uff1a{}ms", (Object)action.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - actionTime));
                    }
                    long end = TimeServiceHelper.now().getTime();
                    logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5206\u6279\uff1a\u7b2c{}\u6279\u4f5c\u4e1a\u7ed3\u675f,\u8017\u65f6\uff1a{}", (Object)i, (Object)(end - start));
                    this.getCompletionContext().getFactnedBills().clear();
                    this.getCompletionContext().getWwCompletions().clear();
                }
                context.getConfigSrcAndTargetBillsMap().clear();
                context.getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u3010%s\u3011,\u6570\u636e\u5904\u7406\u5b8c\u6210", (String)"CompeletionTransferAction_9", (String)"macc-cad-mservice", (Object[])new Object[0]), config.getString("number")));
                int delNum = this.deleteFactnedBillForNoSrource(context.getIdEntryIdCompleteMap());
                context.getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5355\u636e\u3010%s\u3011\u6761\u3002", (String)"CompeletionTransferAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]), delNum));
                if ("sca".equals(this.getCompletionContext().getCompletionArgs().getAppNum())) {
                    ScaCompletionWriteCostChangeConfigAction completionWriteCostChangeConfigAction = new ScaCompletionWriteCostChangeConfigAction();
                    completionWriteCostChangeConfigAction.setContext(this.getCompletionContext());
                    completionWriteCostChangeConfigAction.doExecute();
                }
            });
        }
    }

    private void addConfigEntry() {
        CompletionContext completionContext = this.getCompletionContext();
        Map<Long, Set<Long>> acctOrgCostCentersMap = completionContext.getAcctOrgCostCentersMap();
        Map<String, List<Long>> orgMethodCostCenters = completionContext.getOrgMethodCostCenters();
        for (Map.Entry<Long, Set<Long>> orgAndCostCenter : acctOrgCostCentersMap.entrySet()) {
            Long accountOrg = orgAndCostCenter.getKey();
            this.getCompletionContext().getCollectReport().setReProCostCenters(orgMethodCostCenters.get(String.valueOf(accountOrg).concat(CostObjectEnum.BIZTYPE_RO.getValue())));
            this.getCompletionContext().getCollectReport().setFpCostCenters(orgMethodCostCenters.get(String.valueOf(accountOrg).concat(CostObjectEnum.BIZTYPE_SO.getValue())));
            this.getCompletionContext().getCollectReport().setPzCostCenters(orgMethodCostCenters.get(String.valueOf(accountOrg).concat(CostObjectEnum.BIZTYPE_PZ.getValue())));
            this.getCompletionContext().getCollectReport().setFlCostCenters(orgMethodCostCenters.get(String.valueOf(accountOrg).concat(CostObjectEnum.BIZTYPE_FL.getValue())));
            this.getCompletionContext().getCollectReport().setCuCostCenters(orgMethodCostCenters.get(String.valueOf(accountOrg).concat(CostObjectEnum.BIZTYPE_CU.getValue())));
        }
    }

    private void setIdEntryIdCompleteMap(CompletionContext context, DataSet existsBillDs, Map<String, String> fieldMappingMap) {
        if (context.getIdEntryIdCompleteMap().isEmpty()) {
            ArrayList<Long> sourceBillIds = new ArrayList<Long>();
            for (Row row : existsBillDs) {
                sourceBillIds.add(row.getLong("id"));
            }
            Map<String, DynamicObject> existsEntryIdCompleteMap = this.groupEntryIdCompleteMap(sourceBillIds, context.getExistBillNos(), fieldMappingMap.keySet());
            if (!CadEmptyUtils.isEmpty(existsEntryIdCompleteMap)) {
                context.getIdEntryIdCompleteMap().putAll(existsEntryIdCompleteMap);
            }
        }
    }

    private Map<String, Set<Long>> getCostCentersourceTypeDataMap(CollConifgContext configContext) {
        HashMap<String, Set<Long>> costCentersourceTypeDataMap = new HashMap<String, Set<Long>>(16);
        configContext.getCostCenterSourceDataMap().forEach((ccs, obj) -> {
            String[] srcDataStr = ccs.split("@");
            if (srcDataStr.length < 2) {
                return;
            }
            String sourceType = srcDataStr[0];
            Long sourceData = Long.parseLong(srcDataStr[1]);
            costCentersourceTypeDataMap.computeIfAbsent(sourceType, p -> new HashSet(10)).add(sourceData);
        });
        return costCentersourceTypeDataMap;
    }

    private String getSrcEntryEntityName(Map<String, String> fieldMappingMap) {
        String entryEntityName = "";
        if (!CadEmptyUtils.isEmpty(fieldMappingMap)) {
            for (String value : fieldMappingMap.values()) {
                String[] split;
                for (String fieldName : split = org.apache.commons.lang3.StringUtils.split((String)value, (String)",")) {
                    String[] fieldNames = org.apache.commons.lang3.StringUtils.split((String)fieldName, (String)".");
                    if (fieldNames.length <= 1) continue;
                    entryEntityName = fieldNames[0];
                }
            }
        }
        entryEntityName = !CadEmptyUtils.isEmpty((String)entryEntityName) ? entryEntityName.concat(".id") : "id";
        return entryEntityName;
    }

    private boolean checkConfigChanged(DynamicObject config, String entityId) {
        QFilter appNumQf;
        QFilter colObjQf;
        if (StringUtils.isEmpty((String)entityId)) {
            return true;
        }
        Date modifyTime = config.getDate("modifytime");
        String appNum = config.getString("appnum");
        QFilter orgQf = new QFilter("org", "=", (Object)this.getCompletionContext().getCompletionArgs().getAcctOrgId());
        DynamicObjectCollection collectReports = QueryServiceHelper.query((String)"cad_colreport", (String)"coldate", (QFilter[])new QFilter[]{orgQf, colObjQf = new QFilter("colobj", "=", (Object)"mat"), appNumQf = new QFilter("appnum", "=", (Object)appNum)}, (String)"coldate desc", (int)1);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)collectReports)) {
            return ((DynamicObject)collectReports.get(0)).getDate("coldate").compareTo(modifyTime) <= 0;
        }
        return true;
    }

    private List<ICompletionAction> initializeActions(String appNum) {
        ArrayList<ICompletionAction> actionList = new ArrayList<ICompletionAction>();
        switch (appNum) {
            case "sca": {
                actionList.add(new CompletionImportDataConfigAction());
                actionList.add(new CompletionImportDataForFPConfigAction());
                actionList.add(new CompletionImportDataForCUConfigAction());
                actionList.add(new CompletionSaveAction());
                break;
            }
            case "aca": {
                actionList.add(new CompletionImportDataConfigAction());
                actionList.add(new CompletionImportDataForFPConfigAction());
                actionList.add(new AcaCompletionImportDataForPZConfigAction());
                actionList.add(new AcaCompletionImportDataForFLConfigAction());
                actionList.add(new CompletionImportDataForCUConfigAction());
                actionList.add(new CompletionSaveAction());
                break;
            }
        }
        return actionList;
    }

    private CollConifgContext getConfigParam(CompletionContext context, List<Long> orgCostCenterIds) {
        CompletionArgs collectionArgs = context.getCompletionArgs();
        CollConifgContext configContext = new CollConifgContext();
        CollConifgParam param = new CollConifgParam();
        param.setAppnum(collectionArgs.getAppNum());
        param.setCalOrgId(collectionArgs.getAcctOrgId());
        param.setCostAccountId(null);
        Long[] manuOrgIds = new Long[]{};
        if (!CadEmptyUtils.isEmpty(collectionArgs.getManuOrgs())) {
            manuOrgIds = collectionArgs.getManuOrgs().toArray(new Long[0]);
        }
        param.setManuOrgIds(manuOrgIds);
        param.setCostCenterIds(orgCostCenterIds.toArray(new Long[0]));
        param.setTargetEntity("cad_factnedoutputbill");
        configContext.setParam(param);
        List importScopeDate = SysParamHelper.getImportScopeDate((Long)context.getCompletionArgs().getAcctOrgId(), (String)context.getCompletionArgs().getAppNum());
        Map costCenterSourceDataMap = new CostCenterRelationService().getCostCenterSourceDataMap(param.getCostCenterIds(), importScopeDate);
        configContext.setCostCenterSourceDataMap(costCenterSourceDataMap);
        return configContext;
    }

    private Map<String, List<Long>> getBillRangeMap(Long accountOrg, List<Long> costCenters, String targetEntity, String appNum, CollectReport collectReport) {
        Map<String, List<Long>> billRangeMap = new HashMap<String, List<Long>>(16);
        if (CadEmptyUtils.isEmpty((String)targetEntity)) {
            return billRangeMap;
        }
        switch (targetEntity) {
            case "cad_plannedoutputbill": {
                if ("aca".equals(appNum)) {
                    billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"plancollectrange", (String)appNum, (CollectReport)collectReport);
                    break;
                }
                billRangeMap.put("norange", new ArrayList());
                break;
            }
            case "cad_factnedoutputbill": {
                billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"billrange", (String)appNum, (CollectReport)collectReport);
                break;
            }
            case "sca_matusecollect": 
            case "aca_matusecollect": {
                billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"matcollectrange", (String)appNum, (CollectReport)collectReport);
                break;
            }
            case "sca_resourceuse": {
                billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"resourcerange", (String)appNum, (CollectReport)collectReport);
                break;
            }
            default: {
                billRangeMap.put("norange", new ArrayList());
            }
        }
        return billRangeMap;
    }

    public List<DynamicObject> getValidCollConfigList(CompletionContext context, String targetEntity, Set<Long> collconfigIds) {
        ArrayList<DynamicObject> values = new ArrayList<DynamicObject>(context.getRulesMap().values());
        HashSet<String> calMethodTypes = new HashSet<String>(10);
        for (Map.Entry<String, DynamicObject> ruleMap : context.getRulesMap().entrySet()) {
            String key = ruleMap.getKey();
            String[] split = key.split("@");
            if (split.length == 3) {
                calMethodTypes.add(split[1]);
                continue;
            }
            if (split.length != 4) continue;
            calMethodTypes.add(split[2]);
        }
        HashSet calcDimensionIds = new HashSet(10);
        values.forEach(p -> calcDimensionIds.add(p.getLong("costcalcdimension")));
        return ImportServiceHelper.getCollConfigs((Long)context.getCompletionArgs().getAcctOrgId(), (Long)0L, calMethodTypes, calcDimensionIds, (String)targetEntity, (String)context.getCompletionArgs().getAppNum(), collconfigIds);
    }

    private void delHistoryCollConfigData(DynamicObject config, CompletionArgs collectionArgs, Set<Long> allCollconfigIds, Map<Long, Map<String, String>> collConfigRuleMappingMap) {
        if (config == null) {
            return;
        }
        String sourceBillEntity = config.getString("sourcebill.id");
        List<Long> existsIds = this.getExistsCompletBillIds(collectionArgs.getAcctOrgId(), collectionArgs.getCostCenterIds(), collectionArgs.getManuOrgs(), collectionArgs.getMftOrderEntryIds(), collConfigRuleMappingMap.get(config.getLong("id")), sourceBillEntity, collectionArgs.getAppNum(), collectionArgs.getCollectParamMap(), config.getLong("id"), allCollconfigIds);
        if (existsIds == null || existsIds.isEmpty()) {
            return;
        }
        logger.info("\u9700\u8981\u5220\u9664\u7684\u5386\u53f2\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u7684\u5355\u636e\u6570\u91cf\uff1a{}", (Object)existsIds.size());
        Map<String, DynamicObject> idEntryIdCompleteMap = this.groupEntryIdCompleteMap(existsIds, null, null);
        this.getCompletionContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5386\u53f2\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u662f\u5426\u6709\u9700\u8981\u5220\u9664\u7684\u5355\u636e\uff1f", (String)"CompeletionTransferAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), new Object[0]));
        int delNum = this.deleteFactnedBillForNoSrource(idEntryIdCompleteMap);
        this.getCompletionContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5355\u636e%s\u6761\u3002", (String)"CompeletionTransferAction_6", (String)"macc-cad-mservice", (Object[])new Object[0]), delNum));
    }
}

