/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.factedoutput;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.OutSourcePrice;
import kd.macc.cad.common.helper.ResourceAbsorbHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.factedoutput.AbstractCompletionAction;
import kd.macc.cad.mservice.factedoutput.CompletionArgs;

public class CompletionCheckAbsorbAction
extends AbstractCompletionAction {
    private List<Long> costCenters;
    private Map<String, Long> acctManuOrgCosttype;
    private Map<Long, Map<Long, Set<OutSourcePrice>>> costTypeMatOutPrice;

    public CompletionCheckAbsorbAction(List<Long> costCenters, Map<String, Long> acctManuOrgCosttype, Map<Long, Map<Long, Set<OutSourcePrice>>> costTypeMatOutPrice) {
        this.costCenters = costCenters;
        this.acctManuOrgCosttype = acctManuOrgCosttype;
        this.costTypeMatOutPrice = costTypeMatOutPrice;
    }

    @Override
    protected void doExecute() {
        CompletionArgs completionArgs = this.getCompletionContext().getCompletionArgs();
        Long orgId = completionArgs.getAcctOrgId();
        List<Long> manuOrgs = completionArgs.getManuOrgs();
        String appNum = completionArgs.getAppNum();
        if ("sca".equals(appNum)) {
            List<Long> completionIds = this.getExistsCompletBillIds(orgId, this.costCenters, manuOrgs, "im_mdc_omcmplinbill", appNum, completionArgs.getCollectParamMap(), 0L, null);
            Set<Long> unAbsorbBills = this.getUnAbsorbBills(completionIds);
            this.genResourceAbsorb(unAbsorbBills);
        }
    }

    private void genResourceAbsorb(Set<Long> unAbsorbBills) {
        if (!unAbsorbBills.isEmpty()) {
            List partitions = Lists.partition(new ArrayList<Long>(unAbsorbBills), (int)2000);
            for (List partition : partitions) {
                DynamicObject[] completions;
                ArrayList<DynamicObject> outPutAbsorbList = new ArrayList<DynamicObject>(10);
                for (DynamicObject targetBill : completions = BusinessDataServiceHelper.load((Object[])partition.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_factnedoutputbill"))) {
                    for (Map.Entry<String, Long> ele : this.acctManuOrgCosttype.entrySet()) {
                        DynamicObjectCollection entryEntities;
                        String[] split = ele.getKey().split("-");
                        Long costaccount = Long.valueOf(split[0]);
                        Long manuorg = Long.valueOf(split[1]);
                        if (manuorg != 0L && !manuorg.equals(targetBill.getLong("manuorg.id"))) continue;
                        Long costtype = ele.getValue();
                        Long material = targetBill.getLong("material.id");
                        Map<Long, Set<OutSourcePrice>> materialAndOutPrice = this.costTypeMatOutPrice.get(costtype);
                        Set outSourcePrices = materialAndOutPrice.computeIfAbsent(material, v -> new HashSet(16));
                        DynamicObject resourceAbsorb = this.buildResourceAbsorbBill(targetBill, targetBill.getDynamicObjectCollection("entryentity"), costaccount, outSourcePrices);
                        if (resourceAbsorb == null || CadEmptyUtils.isEmpty((DynamicObjectCollection)(entryEntities = resourceAbsorb.getDynamicObjectCollection("entryentity")))) continue;
                        outPutAbsorbList.add(resourceAbsorb);
                    }
                }
                if (CadEmptyUtils.isEmpty(outPutAbsorbList)) continue;
                SaveServiceHelper.save((DynamicObject[])outPutAbsorbList.toArray(new DynamicObject[0]));
            }
        }
    }

    private Set<Long> getUnAbsorbBills(List<Long> existCompletions) {
        HashSet<Long> unAbsorbIds = new HashSet<Long>(32);
        if (!CadEmptyUtils.isEmpty(existCompletions)) {
            List partitions = Lists.partition(existCompletions, (int)2000);
            for (List partition : partitions) {
                unAbsorbIds.addAll(ResourceAbsorbHelper.getUnAbsorbResource((List)partition));
            }
        }
        return unAbsorbIds;
    }
}

