/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.factedoutput;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.config.service.CostObjectService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.mservice.factedoutput.AbstractCompletionAction;
import kd.macc.cad.mservice.factedoutput.CompletionArgs;

public class CompletionConditionAction
extends AbstractCompletionAction {
    private static final Log logger = LogFactory.getLog(CompletionConditionAction.class);

    @Override
    protected void doExecute() {
        CompletionArgs completionArgs = this.getCompletionContext().getCompletionArgs();
        String appNum = completionArgs.getAppNum();
        Long accountOrgId = completionArgs.getAcctOrgId();
        Long org = completionArgs.getAcctOrgId();
        List<Long> costCenterIds = completionArgs.getCostCenterIds();
        List<Long> mftOrderEntryIds = completionArgs.getMftOrderEntryIds();
        Map<String, String> resultInfo = this.getCompletionContext().getResultInfo();
        int totalNum = "aca".equals(appNum) ? 26 : 14;
        this.refreshProgress(ResManager.loadKDString((String)"\u6784\u5efa\u6761\u4ef6\uff0c\u5f52\u96c6\u5f00\u59cb\u3002", (String)"CompletionConditionAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), 1, totalNum, false);
        Map<Long, Set<Long>> acctOrgCostCentersMap = this.getCompletionContext().getAcctOrgCostCentersMap();
        List importScopeDate = SysParamHelper.getImportScopeDate((Long)accountOrgId, (String)appNum);
        this.getCompletionContext().getOrgImportScopeDate().put(accountOrgId, importScopeDate);
        List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)Long.parseLong(RequestContext.get().getUserId()), Collections.singletonList(org), new HashSet<Long>(costCenterIds), (String)"cad_factnedoutputbill", (String)appNum);
        if (CadEmptyUtils.isEmpty((List)enableCostCenters)) {
            return;
        }
        acctOrgCostCentersMap.put(org, new HashSet(enableCostCenters));
        Map rulesMap = null;
        Map costCenterByRules = null;
        Map dimensionAndRuleMap = null;
        if (ImportServiceHelper.isStartCollConfigScheme().booleanValue()) {
            dimensionAndRuleMap = CostObjectService.getDimensionAndRuleMap();
            rulesMap = CostObjectHelper.getCostObjectRulesMap((Long)accountOrgId, (List)enableCostCenters);
            costCenterByRules = CostObjectHelper.groupCostCenterByRules((List)enableCostCenters, (Map)rulesMap);
            CostCenterHelper.getWorkCenter(costCenterIds, (List)importScopeDate, (CollectReport)this.getCompletionContext().getCollectReport());
            CostCenterHelper.getAdminOrg(costCenterIds, (List)importScopeDate, (CollectReport)this.getCompletionContext().getCollectReport());
            CostCenterHelper.getBosOrgs(costCenterIds, (List)importScopeDate, (CollectReport)this.getCompletionContext().getCollectReport());
        } else {
            rulesMap = CostObjectHelper.getRulesMap((Long)org, (List)enableCostCenters);
            costCenterByRules = CostObjectHelper.groupCostCenterByRules((Long)org, (List)enableCostCenters, (Map)rulesMap);
        }
        if (CadEmptyUtils.isEmpty((Map)rulesMap)) {
            MsgUtils.putMsg2Map((String)"tip", (String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"CompletionConditionAction_4", (String)"macc-cad-mservice", (Object[])new Object[0]), resultInfo);
            return;
        }
        if (!CadEmptyUtils.isEmpty((Map)rulesMap)) {
            this.getCompletionContext().getRulesMap().putAll(rulesMap);
        }
        if (!CadEmptyUtils.isEmpty((Map)costCenterByRules)) {
            this.getCompletionContext().getOrgMethodCostCenters().putAll(costCenterByRules);
        }
        if (!CadEmptyUtils.isEmpty((Map)dimensionAndRuleMap)) {
            this.getCompletionContext().getDimensionAndRuleMap().putAll(dimensionAndRuleMap);
        }
        if (CadEmptyUtils.isEmpty(completionArgs.getCollectParamMap()) && CadEmptyUtils.isEmpty(mftOrderEntryIds) && CostObjectService.containNotOrderTypeRule((Long)accountOrgId, (Map)costCenterByRules) && "1".equals(CadBgParamUtils.getCadBgParamForString((String)"autoGenCostObject", (String)"1"))) {
            CostObjectService.generateCostObject((Long)accountOrgId, costCenterIds, completionArgs.getManuOrgs(), null, (String)completionArgs.getAppNum(), (CollectReport)this.getCompletionContext().getCollectReport());
        }
    }

    private Map<Long, Set<Long>> getOrgAndSysImportCostCostCenterMap(Long acctOrgId, Set<Long> costcenters, String appNum, String filterStr, String importType) {
        HashMap<Long, Set<Long>> resultMap = new HashMap<Long, Set<Long>>(16);
        QFilter orgFilter = new QFilter("accountorg", "=", (Object)acctOrgId);
        QFilter appFilter = new QFilter("appnum", "=", (Object)appNum);
        QFilter tabFilter = new QFilter("tab", "=", (Object)"costaccumultabpage");
        DynamicObjectCollection params = QueryServiceHelper.query((String)"cad_sysparam", (String)("accountorg,costcenter," + filterStr), (QFilter[])new QFilter[]{orgFilter, appFilter, tabFilter});
        HashMap<Long, Set> resultByNotCover = new HashMap<Long, Set>(16);
        for (DynamicObject param : params) {
            Long accountorg = param.getLong("accountorg");
            Long costcenter = param.getLong("costcenter");
            String type = param.getString(filterStr);
            if (!importType.equals(type) && !CadEmptyUtils.isEmpty((Long)costcenter)) {
                resultByNotCover.computeIfAbsent(accountorg, k -> new HashSet()).add(costcenter);
            }
            if (importType.equals(type) && !CadEmptyUtils.isEmpty((Long)costcenter) && costcenters.contains(costcenter)) {
                resultMap.computeIfAbsent(accountorg, k -> new HashSet()).add(costcenter);
                continue;
            }
            if (!importType.equals(type) || !CadEmptyUtils.isEmpty((Long)costcenter)) continue;
            List<Long> costCenterList = this.getCostCenterByOrg(accountorg);
            costcenters.retainAll(costCenterList);
            resultMap.computeIfAbsent(accountorg, k -> new HashSet()).addAll(costcenters);
        }
        for (Map.Entry res : resultMap.entrySet()) {
            Set notCovers = (Set)resultByNotCover.get(res.getKey());
            Set values = (Set)res.getValue();
            if (notCovers == null || CadEmptyUtils.isEmpty((Set)notCovers)) continue;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                Object aValue = it.next();
                if (!notCovers.contains(aValue)) continue;
                it.remove();
            }
            resultMap.put((Long)res.getKey(), values);
        }
        return resultMap;
    }

    private List<Long> getCostCenterByOrg(Long orgId) {
        ArrayList<Long> longList = new ArrayList<Long>(8);
        QFilter orgFilter = new QFilter("accountorg", "=", (Object)orgId);
        QFilter orgdutyFilter = new QFilter("orgduty", "=", (Object)4L);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])new QFilter[]{orgFilter, orgdutyFilter}, null, (int)9999);
        for (Object id : ids) {
            longList.add(Long.parseLong(id.toString()));
        }
        return longList;
    }
}

