/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.factedoutput;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.dto.CollectDiff;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.factedoutput.AbstractCompletionAction;

public class CompletionDiffAction
extends AbstractCompletionAction {
    private final Log logger = LogFactory.getLog(CompletionDiffAction.class);
    private List<Long> roCostCenters = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzCostCenters = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> notRoWc = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> notRoOrg = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> notRoAdmin = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> roWc = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> roOrg = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> roAdmin = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzWc = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzOrg = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzAdmin = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> selectedWc = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> selectedOrg = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> selectedAdminOrg = Lists.newArrayListWithExpectedSize((int)8);
    private Map<Long, String> costCenterNameMap = Maps.newHashMapWithExpectedSize((int)32);

    @Override
    protected void doExecute() {
    }

    private int diffScrk(Map<String, Set<Long>> unNeedBillBizTypesMap, Map<String, Set<Long>> unNeedBillInvSchemesMap, Map<Long, String> costCenterRangeMap, String appNum) {
        ArrayList scrkDiffs = Lists.newArrayListWithExpectedSize((int)8);
        DataSet scrkData = this.getScrkData();
        Set<Object> bizTypeIds = Sets.newHashSetWithExpectedSize((int)8);
        if (unNeedBillBizTypesMap != null) {
            bizTypeIds = unNeedBillBizTypesMap.get("im_productinbill");
        }
        Set<Object> invSchemeIds = Sets.newHashSetWithExpectedSize((int)8);
        if (unNeedBillInvSchemesMap != null) {
            invSchemeIds = unNeedBillInvSchemesMap.get("im_productinbill");
        }
        if (!scrkData.isEmpty()) {
            HashSet entryIds = Sets.newHashSetWithExpectedSize((int)32);
            DataSet copy = scrkData.copy();
            for (Row row : copy) {
                entryIds.add(row.getLong("entryid"));
            }
            DataSet gjDataSet = this.getCompleteDataSet(entryIds, appNum);
            DataSet resultDataSet = scrkData.leftJoin(gjDataSet).on("entryid", "sourcebillentry").select(scrkData.getRowMeta().getFieldNames(), gjDataSet.getRowMeta().getFieldNames()).finish();
            if (!resultDataSet.isEmpty()) {
                DataSet unMatchData = resultDataSet.filter("sourcebillentry is null or sourcebillentry = 0");
                DataSet unMatchDataCopy = unMatchData.copy();
                HashSet srcIds = Sets.newHashSetWithExpectedSize((int)8);
                for (Row row : unMatchData) {
                    srcIds.add(row.getLong("id"));
                }
                DataSet costRecords = this.getCostRecords(srcIds);
                unMatchDataCopy = unMatchDataCopy.leftJoin(costRecords).on("id", "bizbillid").select(unMatchDataCopy.getRowMeta().getFieldNames(), costRecords.getRowMeta().getFieldNames()).finish();
                for (Row row : unMatchDataCopy) {
                    Map billNoReasonMap;
                    String srcErrorMsg;
                    String billStatus = row.getString("billstatus");
                    String recordStatus = row.getString("recordstatus");
                    Long bizType = row.getLong("biztype");
                    Long invScheme = row.getLong("invscheme");
                    StringBuilder reasonStr = new StringBuilder();
                    CollectDiff collectDiff = new CollectDiff(row.getString("billno"), row.getInteger("seq"), row.getString("billtype"), row.getDate("bookdate"));
                    if (!"C".equals(billStatus)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"CompletionDiffAction_2", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (StringUtils.isEmpty((Object)recordStatus)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"CompletionDiffAction_3", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    } else if (!"C".equals(recordStatus)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"CompletionDiffAction_4", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (bizTypeIds != null && bizTypeIds.contains(bizType)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u8bbe\u7f6e\u4e3a\u4e0d\u5f52\u96c6", (String)"CompletionDiffAction_5", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (invSchemeIds != null && invSchemeIds.contains(invScheme)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u8bbe\u7f6e\u4e3a\u4e0d\u5f52\u96c6", (String)"CompletionDiffAction_6", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (!StringUtils.isEmpty((Object)(srcErrorMsg = this.checkCostCenterSrcScrt(costCenterRangeMap, row)))) {
                        reasonStr.append(srcErrorMsg).append("\uff1b");
                    }
                    if (!(billNoReasonMap = this.getCompletionContext().getErrorInfMap()).isEmpty() && billNoReasonMap.containsKey(row.getString("billno").concat("@").concat(row.getString("seq")))) {
                        reasonStr.append((String)billNoReasonMap.get(row.getString("billno").concat("@").concat(row.getString("seq"))));
                    }
                    collectDiff.setBillType(row.getString("billtype"));
                    if (reasonStr.length() > 0) {
                        collectDiff.setReason(reasonStr.toString());
                    } else {
                        collectDiff.setReason(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0", (String)"CompletionDiffAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    }
                    scrkDiffs.add(collectDiff);
                }
            }
        }
        if (scrkDiffs.size() > 0) {
            this.getCompletionContext().getCollectReport().getCollectDiffs().addAll(scrkDiffs);
            this.getCompletionContext().getCollectReport().setError(true);
        }
        return scrkDiffs.size();
    }

    private int diffOutCompleteInOut(Map<String, Set<Long>> unNeedBillBizTypesMap, Map<String, Set<Long>> unNeedBillInvSchemesMap, Map<Long, String> costCenterRangeMap, String appNum) {
        ArrayList wwWgrkDiffs = Lists.newArrayListWithExpectedSize((int)8);
        DataSet wgrkData = this.getWwWgrkData();
        if (!wgrkData.isEmpty()) {
            HashSet entryIds = Sets.newHashSetWithExpectedSize((int)32);
            DataSet copy = wgrkData.copy();
            for (Row row : copy) {
                entryIds.add(row.getLong("entryid"));
            }
            DataSet gjDataSet = this.getCompleteDataSet(entryIds, appNum);
            DataSet resultDataSet = wgrkData.leftJoin(gjDataSet).on("entryid", "sourcebillentry").select(wgrkData.getRowMeta().getFieldNames(), gjDataSet.getRowMeta().getFieldNames()).finish();
            if (!resultDataSet.isEmpty()) {
                DataSet unMatchData = resultDataSet.filter("sourcebillentry is null or sourcebillentry = 0");
                DataSet unMatchDataCopy = unMatchData.copy();
                HashSet srcIds = Sets.newHashSetWithExpectedSize((int)8);
                for (Row row : unMatchData) {
                    srcIds.add(row.getLong("id"));
                }
                DataSet costRecords = this.getCostRecords(srcIds);
                unMatchDataCopy = unMatchDataCopy.leftJoin(costRecords).on("id", "bizbillid").select(unMatchDataCopy.getRowMeta().getFieldNames(), costRecords.getRowMeta().getFieldNames()).finish();
                for (Row row : unMatchDataCopy) {
                    Map billNoReasonMap;
                    String srcErrorMsg;
                    String billStatus = row.getString("billstatus");
                    String recordStatus = row.getString("recordstatus");
                    Long bizType = row.getLong("biztype");
                    Long invScheme = row.getLong("invscheme");
                    String entityId = row.getString("entityid");
                    StringBuilder reasonStr = new StringBuilder();
                    CollectDiff collectDiff = new CollectDiff(row.getString("billno"), row.getInteger("seq"), row.getString("billtype"), row.getDate("bookdate"));
                    if (!"C".equals(billStatus)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"CompletionDiffAction_2", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (StringUtils.isEmpty((Object)recordStatus)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"CompletionDiffAction_8", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    } else if (!"C".equals(recordStatus)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"CompletionDiffAction_4", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (unNeedBillBizTypesMap != null && unNeedBillBizTypesMap.containsKey(entityId) && unNeedBillBizTypesMap.get(entityId).contains(bizType)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u8bbe\u7f6e\u4e3a\u4e0d\u5f52\u96c6", (String)"CompletionDiffAction_5", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (unNeedBillInvSchemesMap != null && unNeedBillInvSchemesMap.containsKey(entityId) && unNeedBillInvSchemesMap.get(entityId).contains(invScheme)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u8bbe\u7f6e\u4e3a\u4e0d\u5f52\u96c6", (String)"CompletionDiffAction_6", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (!StringUtils.isEmpty((Object)(srcErrorMsg = this.checkCostCenterSrcWwWg(costCenterRangeMap, row)))) {
                        reasonStr.append(srcErrorMsg).append("\uff1b");
                    }
                    if (!(billNoReasonMap = this.getCompletionContext().getErrorInfMap()).isEmpty() && billNoReasonMap.containsKey(row.getString("billno").concat("@").concat(row.getString("seq")))) {
                        reasonStr.append((String)billNoReasonMap.get(row.getString("billno").concat("@").concat(row.getString("seq"))));
                    }
                    collectDiff.setBillType(row.getString("billtype"));
                    if (reasonStr.length() > 0) {
                        collectDiff.setReason(reasonStr.toString());
                    } else {
                        collectDiff.setReason(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0", (String)"CompletionDiffAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    }
                    wwWgrkDiffs.add(collectDiff);
                }
            }
        }
        if (wwWgrkDiffs.size() > 0) {
            this.getCompletionContext().getCollectReport().getCollectDiffs().addAll(wwWgrkDiffs);
            this.getCompletionContext().getCollectReport().setError(true);
        }
        return wwWgrkDiffs.size();
    }

    private int diffCompleteInOut(Map<String, Set<Long>> unNeedBillBizTypesMap, Map<String, Set<Long>> unNeedBillInvSchemesMap, Map<Long, String> costCenterRangeMap, String appNum) {
        ArrayList wgrkDiffs = Lists.newArrayListWithExpectedSize((int)8);
        DataSet wgrkData = this.getWgrkData();
        if (!wgrkData.isEmpty()) {
            HashSet entryIds = Sets.newHashSetWithExpectedSize((int)32);
            DataSet copy = wgrkData.copy();
            for (Row row : copy) {
                entryIds.add(row.getLong("entryid"));
            }
            DataSet gjDataSet = this.getCompleteDataSet(entryIds, appNum);
            DataSet resultDataSet = wgrkData.leftJoin(gjDataSet).on("entryid", "sourcebillentry").select(wgrkData.getRowMeta().getFieldNames(), gjDataSet.getRowMeta().getFieldNames()).finish();
            if (!resultDataSet.isEmpty()) {
                DataSet unMatchData = resultDataSet.filter("sourcebillentry is null or sourcebillentry = 0");
                DataSet unMatchDataCopy = unMatchData.copy();
                HashSet srcIds = Sets.newHashSetWithExpectedSize((int)8);
                for (Row row : unMatchData) {
                    srcIds.add(row.getLong("id"));
                }
                DataSet costRecords = this.getCostRecords(srcIds);
                unMatchDataCopy = unMatchDataCopy.leftJoin(costRecords).on("id", "bizbillid").select(unMatchData.getRowMeta().getFieldNames(), costRecords.getRowMeta().getFieldNames()).finish();
                for (Row row : unMatchDataCopy) {
                    Map billNoReasonMap;
                    String srcErrorMsg;
                    String billStatus = row.getString("billstatus");
                    String recordStatus = row.getString("recordstatus");
                    Long bizType = row.getLong("biztype");
                    Long invScheme = row.getLong("invscheme");
                    String entityId = row.getString("entityid");
                    Date compareDate = row.getDate("bookdate");
                    StringBuilder reasonStr = new StringBuilder();
                    CollectDiff collectDiff = new CollectDiff(row.getString("billno"), row.getInteger("seq"), row.getString("billtype"), row.getDate("bookdate"));
                    if (!"C".equals(billStatus)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"CompletionDiffAction_2", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (StringUtils.isEmpty((Object)recordStatus)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"CompletionDiffAction_8", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    } else if (!"C".equals(recordStatus)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"CompletionDiffAction_4", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (unNeedBillBizTypesMap != null && unNeedBillBizTypesMap.containsKey(entityId) && unNeedBillBizTypesMap.get(entityId).contains(bizType)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u8bbe\u7f6e\u4e3a\u4e0d\u5f52\u96c6", (String)"CompletionDiffAction_5", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (unNeedBillInvSchemesMap != null && unNeedBillInvSchemesMap.containsKey(entityId) && unNeedBillInvSchemesMap.get(entityId).contains(invScheme)) {
                        reasonStr.append(ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u8bbe\u7f6e\u4e3a\u4e0d\u5f52\u96c6", (String)"CompletionDiffAction_6", (String)"macc-cad-mservice", (Object[])new Object[0])).append(";");
                    }
                    if (!StringUtils.isEmpty((Object)(srcErrorMsg = this.checkCostCenterSrcWgRt(costCenterRangeMap, row)))) {
                        reasonStr.append(srcErrorMsg).append("\uff1b");
                    }
                    if (!(billNoReasonMap = this.getCompletionContext().getErrorInfMap()).isEmpty() && billNoReasonMap.containsKey(row.getString("billno").concat("@").concat(row.getString("seq")))) {
                        reasonStr.append((String)billNoReasonMap.get(row.getString("billno").concat("@").concat(row.getString("seq"))));
                    }
                    collectDiff.setBillType(row.getString("billtype"));
                    if (reasonStr.length() > 0) {
                        collectDiff.setReason(reasonStr.toString());
                    } else {
                        collectDiff.setReason(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0", (String)"CompletionDiffAction_7", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    }
                    wgrkDiffs.add(collectDiff);
                }
            }
        }
        if (wgrkDiffs.size() > 0) {
            this.getCompletionContext().getCollectReport().getCollectDiffs().addAll(wgrkDiffs);
            this.getCompletionContext().getCollectReport().setError(true);
        }
        return wgrkDiffs.size();
    }

    private DataSet getCostRecords(Set<Long> srcIds) {
        QFilter idQf = new QFilter("bizbillid", "in", (Object)srcIds.toArray());
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)"bizbillid,billstatus recordstatus", (QFilter[])new QFilter[]{idQf, billStatusQf}, null);
        return costRecordDs.groupBy(new String[]{"bizbillid", "recordstatus"}).finish();
    }

    private String checkCostCenterSrcWgRt(Map<Long, String> costCenterRangeMap, Row row) {
        boolean adminOrgFlag;
        boolean orgFlag;
        boolean workCenterFlag;
        Long workCenter = row.getLong("workcenter");
        Long org = row.getLong("org");
        Long produceDept = row.getLong("adminorg");
        boolean bl = workCenterFlag = this.roWc.contains(workCenter) || this.pzWc.contains(workCenter);
        if (!workCenterFlag && this.notRoWc.contains(workCenter)) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5206\u6279/\u5206\u7c7b\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5206\u6279/\u5206\u7c7b\u6cd5\u5355\u636e\u6765\u6e90\u4e3a\u751f\u4ea7\u5165/\u9000\u5e93\u5355", (String)"CompletionDiffAction_9", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        boolean bl2 = orgFlag = this.roOrg.contains(org) || this.pzOrg.contains(org);
        if (!orgFlag && this.notRoOrg.contains(org)) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5206\u6279/\u5206\u7c7b\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5206\u6279/\u5206\u7c7b\u6cd5\u5355\u636e\u6765\u6e90\u4e3a\u751f\u4ea7\u5165/\u9000\u5e93\u5355", (String)"CompletionDiffAction_9", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        boolean bl3 = adminOrgFlag = this.roAdmin.contains(produceDept) || this.pzAdmin.contains(produceDept);
        if (!adminOrgFlag && this.notRoAdmin.contains(produceDept)) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5206\u6279/\u5206\u7c7b\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5206\u6279\u5206\u7c7b\u6cd5\u5355\u636e\u6765\u6e90\u4e3a\u751f\u4ea7\u5165/\u9000\u5e93\u5355", (String)"CompletionDiffAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        if (workCenterFlag || orgFlag || adminOrgFlag) {
            Map srcCostCenterMap = this.getCompletionContext().getCollectReport().getSrcCostCenterMap();
            Long cc = 0L;
            if (srcCostCenterMap != null && costCenterRangeMap != null) {
                if (srcCostCenterMap.containsKey(workCenter)) {
                    cc = (Long)srcCostCenterMap.get(workCenter);
                }
                if (srcCostCenterMap.containsKey(org)) {
                    cc = (Long)srcCostCenterMap.get(org);
                }
                if (srcCostCenterMap.containsKey(produceDept)) {
                    cc = (Long)srcCostCenterMap.get(produceDept);
                }
            }
            if (!CadEmptyUtils.isEmpty((Long)cc) && costCenterRangeMap != null) {
                String range = costCenterRangeMap.get(cc);
                if (CadEmptyUtils.isEmpty(costCenterRangeMap) || !StringUtils.isEmpty((Object)range) && range.indexOf("WIPCOMPELETE") == -1) {
                    String ccName = this.costCenterNameMap.get(cc);
                    if (!StringUtils.isEmpty((Object)ccName)) {
                        return String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%s\u201d\u6210\u672c\u5f52\u96c6\u53c2\u6570\u672a\u8bbe\u7f6e\u5f52\u96c6\u5b8c\u5de5\u5165/\u9000\u5e93\u5355\u3002", (String)"CompletionDiffAction_11", (String)"macc-cad-mservice", (Object[])new Object[0]), ccName);
                    }
                    return ResManager.loadKDString((String)"\u6210\u672c\u5f52\u96c6\u53c2\u6570\u672a\u8bbe\u7f6e\u5f52\u96c6\u5b8c\u5de5\u5165/\u9000\u5e93\u5355\u3002", (String)"CompletionDiffAction_12", (String)"macc-cad-mservice", (Object[])new Object[0]);
                }
            }
            if (this.getCompletionContext().isSingleSelected()) {
                if (this.selectedWc.contains(workCenter) || this.selectedOrg.contains(org) || this.selectedAdminOrg.contains(produceDept)) {
                    return null;
                }
                return ResManager.loadKDString((String)"\u672a\u5339\u914d\u4e0a\u9009\u4e2d\u7684\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u8bf7\u9009\u62e9\u4e0d\u9650\u8fdb\u884c\u5bfc\u5165\u3002", (String)"CompletionDiffAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]);
            }
            return null;
        }
        return ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\u5339\u914d\u5931\u8d25\u3002", (String)"CompletionDiffAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]);
    }

    private String checkCostCenterSrcWwWg(Map<Long, String> costCenterRangeMap, Row row) {
        boolean adminOrgFlag;
        boolean orgFlag;
        boolean workCenterFlag;
        Long workCenter = row.getLong("workcenter");
        Long org = row.getLong("org");
        Long produceDept = row.getLong("adminorg");
        boolean bl = workCenterFlag = this.roWc.contains(workCenter) || this.pzWc.contains(workCenter);
        if (!workCenterFlag && this.notRoWc.contains(workCenter)) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5206\u6279/\u5206\u7c7b\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5206\u6279\u5206\u7c7b\u6cd5\u5355\u636e\u6765\u6e90\u4e3a\u751f\u4ea7\u5165/\u9000\u5e93\u5355", (String)"CompletionDiffAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        boolean bl2 = orgFlag = this.roOrg.contains(org) || this.pzOrg.contains(org);
        if (!orgFlag && this.notRoOrg.contains(org)) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5206\u6279/\u5206\u7c7b\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5206\u6279\u5206\u7c7b\u6cd5\u5355\u636e\u6765\u6e90\u4e3a\u751f\u4ea7\u5165/\u9000\u5e93\u5355", (String)"CompletionDiffAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        boolean bl3 = adminOrgFlag = this.roAdmin.contains(produceDept) || this.pzAdmin.contains(produceDept);
        if (!adminOrgFlag && this.notRoAdmin.contains(produceDept)) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5206\u6279/\u5206\u7c7b\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5206\u6279\u5206\u7c7b\u6cd5\u5355\u636e\u6765\u6e90\u4e3a\u751f\u4ea7\u5165/\u9000\u5e93\u5355", (String)"CompletionDiffAction_10", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        if (workCenterFlag || orgFlag || adminOrgFlag) {
            Map srcCostCenterMap = this.getCompletionContext().getCollectReport().getSrcCostCenterMap();
            Long cc = 0L;
            if (srcCostCenterMap != null && costCenterRangeMap != null) {
                if (srcCostCenterMap.containsKey(workCenter)) {
                    cc = (Long)srcCostCenterMap.get(workCenter);
                }
                if (srcCostCenterMap.containsKey(org)) {
                    cc = (Long)srcCostCenterMap.get(org);
                }
                if (srcCostCenterMap.containsKey(produceDept)) {
                    cc = (Long)srcCostCenterMap.get(produceDept);
                }
            }
            if (!CadEmptyUtils.isEmpty((Long)cc) && costCenterRangeMap != null) {
                String range = costCenterRangeMap.get(cc);
                if (CadEmptyUtils.isEmpty(costCenterRangeMap) || !StringUtils.isEmpty((Object)range) && range.indexOf("WWGRK") == -1) {
                    String ccName = this.costCenterNameMap.get(cc);
                    if (!StringUtils.isEmpty((Object)ccName)) {
                        return String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%s\u201d\u6210\u672c\u5f52\u96c6\u53c2\u6570\u672a\u8bbe\u7f6e\u5f52\u96c6\u59d4\u5916\u5b8c\u5de5\u5165/\u9000\u5e93\u5355\u3002", (String)"CompletionDiffAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]), ccName);
                    }
                    return ResManager.loadKDString((String)"\u6210\u672c\u5f52\u96c6\u53c2\u6570\u672a\u8bbe\u7f6e\u5f52\u96c6\u59d4\u5916\u5b8c\u5de5\u5165/\u9000\u5e93\u5355\u3002", (String)"CompletionDiffAction_16", (String)"macc-cad-mservice", (Object[])new Object[0]);
                }
            }
            if (this.getCompletionContext().isSingleSelected()) {
                if (this.selectedWc.contains(workCenter) || this.selectedOrg.contains(org) || this.selectedAdminOrg.contains(produceDept)) {
                    return null;
                }
                return ResManager.loadKDString((String)"\u672a\u5339\u914d\u4e0a\u9009\u4e2d\u7684\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u8bf7\u9009\u62e9\u4e0d\u9650\u8fdb\u884c\u5bfc\u5165\u3002", (String)"CompletionDiffAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]);
            }
            return null;
        }
        return ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\u5339\u914d\u5931\u8d25\u3002", (String)"CompletionDiffAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]);
    }

    private String checkCostCenterSrcScrt(Map<Long, String> costCenterRangeMap, Row row) {
        boolean adminOrgFlag;
        boolean orgFlag;
        boolean workCenterFlag;
        Long workCenter = row.getLong("workcenter");
        Long org = row.getLong("org");
        Long produceDept = row.getLong("adminorg");
        boolean bl = workCenterFlag = this.notRoWc.contains(workCenter) || this.pzWc.contains(workCenter);
        if (!workCenterFlag && this.roWc.contains(workCenter)) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5de5\u5355\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5de5\u5355\u6cd5\u5355\u636e\u6765\u6e90\u4e0d\u4e3a\u751f\u4ea7\u5165/\u9000\u5e93\u5355\u3002", (String)"CompletionDiffAction_17", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        boolean bl2 = orgFlag = this.notRoOrg.contains(org) || this.pzOrg.contains(org);
        if (!orgFlag && this.roOrg.contains(org)) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5de5\u5355\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5de5\u5355\u6cd5\u5355\u636e\u6765\u6e90\u4e0d\u4e3a\u751f\u4ea7\u5165/\u9000\u5e93\u5355\u3002", (String)"CompletionDiffAction_17", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        boolean bl3 = adminOrgFlag = this.notRoAdmin.contains(produceDept) || this.pzAdmin.contains(produceDept);
        if (!adminOrgFlag && this.roAdmin.contains(produceDept)) {
            return ResManager.loadKDString((String)"\u5339\u914d\u4e0a\u5de5\u5355\u6cd5\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u5de5\u5355\u6cd5\u5355\u636e\u6765\u6e90\u4e0d\u4e3a\u751f\u4ea7\u5165/\u9000\u5e93\u5355\u3002", (String)"CompletionDiffAction_17", (String)"macc-cad-mservice", (Object[])new Object[0]);
        }
        if (workCenterFlag || orgFlag || adminOrgFlag) {
            Map srcCostCenterMap = this.getCompletionContext().getCollectReport().getSrcCostCenterMap();
            Long cc = 0L;
            if (srcCostCenterMap != null && costCenterRangeMap != null) {
                if (srcCostCenterMap.containsKey(workCenter)) {
                    cc = (Long)srcCostCenterMap.get(workCenter);
                }
                if (srcCostCenterMap.containsKey(org)) {
                    cc = (Long)srcCostCenterMap.get(org);
                }
                if (srcCostCenterMap.containsKey(produceDept)) {
                    cc = (Long)srcCostCenterMap.get(produceDept);
                }
            }
            if (!CadEmptyUtils.isEmpty((Long)cc) && costCenterRangeMap != null) {
                String range = costCenterRangeMap.get(cc);
                if (CadEmptyUtils.isEmpty(costCenterRangeMap) || !StringUtils.isEmpty((Object)range) && range.indexOf("PRODUCTCOMPELETE") == -1) {
                    String ccName = this.costCenterNameMap.get(cc);
                    if (!StringUtils.isEmpty((Object)ccName)) {
                        return String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%s\u201d\u6210\u672c\u5f52\u96c6\u53c2\u6570\u672a\u8bbe\u7f6e\u5f52\u96c6\u751f\u4ea7\u5165/\u9000\u5e93\u5355\u3002", (String)"CompletionDiffAction_18", (String)"macc-cad-mservice", (Object[])new Object[0]), ccName);
                    }
                    return ResManager.loadKDString((String)"\u6210\u672c\u5f52\u96c6\u53c2\u6570\u672a\u8bbe\u7f6e\u5f52\u96c6\u751f\u4ea7\u5165/\u9000\u5e93\u5355\u3002", (String)"CompletionDiffAction_19", (String)"macc-cad-mservice", (Object[])new Object[0]);
                }
            }
            if (this.getCompletionContext().isSingleSelected()) {
                if (this.selectedWc.contains(workCenter) || this.selectedOrg.contains(org) || this.selectedAdminOrg.contains(produceDept)) {
                    return null;
                }
                return ResManager.loadKDString((String)"\u672a\u5339\u914d\u4e0a\u9009\u4e2d\u7684\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\uff0c\u8bf7\u9009\u62e9\u4e0d\u9650\u8fdb\u884c\u5bfc\u5165\u3002", (String)"CompletionDiffAction_13", (String)"macc-cad-mservice", (Object[])new Object[0]);
            }
            return null;
        }
        return ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\u5339\u914d\u5931\u8d25\u3002", (String)"CompletionDiffAction_14", (String)"macc-cad-mservice", (Object[])new Object[0]);
    }

    private DataSet getCompleteDataSet(Set<Long> entryIds, String appNum) {
        Long orgId = this.getCompletionContext().getCompletionArgs().getAcctOrgId();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter sourceIdQf = new QFilter("sourcebillentry", "in", entryIds);
        QFilter appNumQf = new QFilter("appnum", "=", (Object)appNum);
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cad_factnedoutputbill", (String)"sourcebillentry", (QFilter[])new QFilter[]{orgFilter, sourceIdQf, appNumQf}, null);
    }

    private DataSet getWgrkData() {
        Long orgId = this.getCompletionContext().getCompletionArgs().getAcctOrgId();
        List hasPermInvOrgs = OrgHelper.getUserHasPermStoreOrgsByAccOrg((Long)orgId, (String)"cad_factnedoutputbill", (String)this.getCompletionContext().getCompletionArgs().getAppNum());
        if (hasPermInvOrgs == null || hasPermInvOrgs.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u751f\u4ea7\u7ec4\u7ec7\u4e0e\u5e93\u5b58\u7ec4\u7ec7\u59d4\u6258\u5173\u7cfb\u6216\u5e93\u5b58\u7ec4\u7ec7\u672a\u542f\u7528\u4ed3\u5e93\u3002", (String)"CompletionDiffAction_20", (String)"macc-cad-mservice", (Object[])new Object[0]));
        }
        QFilter orgFilter = new QFilter("org", "in", (Object)hasPermInvOrgs);
        QFilter timeQf = this.getCompletionContext().getCollectReport().getTimeQf();
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_mdc_mftmanuinbill", (String)"id,billno,biztype,invscheme,billentry.workcenterid workcenter,productionorg org,billentry.producedept adminorg,billstatus,billentry.id entryid,billentry.Seq seq,bookdate,0 as probill,'wgrk' as billtype,billtype.billformid.number entityid", (QFilter[])new QFilter[]{orgFilter, timeQf}, (String)"id asc");
    }

    private DataSet getScrkData() {
        Long orgId = this.getCompletionContext().getCompletionArgs().getAcctOrgId();
        List hasPermInvOrgs = OrgHelper.getUserHasPermStoreOrgsByAccOrg((Long)orgId, (String)"cad_factnedoutputbill", (String)this.getCompletionContext().getCompletionArgs().getAppNum());
        if (hasPermInvOrgs == null || hasPermInvOrgs.isEmpty()) {
            hasPermInvOrgs = Lists.newArrayListWithExpectedSize((int)0);
        }
        String selectFields = "id,billno,billstatus,biztype,invscheme,billentry.Seq seq,billentry.id entryid,billentry.material,billentry.productnum,bookdate,billentry.mversion,billentry.auxpty,'-1' workcenter,bizorg org,bizdept adminorg,'scrk' as billtype";
        QFilter orgFilter = new QFilter("org", "in", (Object)hasPermInvOrgs);
        QFilter timeQf = this.getCompletionContext().getCollectReport().getTimeQf();
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_productinbill", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, timeQf}, null);
    }

    private DataSet getWwWgrkData() {
        Long orgId = this.getCompletionContext().getCompletionArgs().getAcctOrgId();
        List hasPermInvOrgs = OrgHelper.getUserHasPermStoreOrgsByAccOrg((Long)orgId, (String)"cad_factnedoutputbill", (String)this.getCompletionContext().getCompletionArgs().getAppNum());
        if (hasPermInvOrgs == null || hasPermInvOrgs.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u751f\u4ea7\u7ec4\u7ec7\u4e0e\u5e93\u5b58\u7ec4\u7ec7\u59d4\u6258\u5173\u7cfb\u6216\u5e93\u5b58\u7ec4\u7ec7\u672a\u542f\u7528\u4ed3\u5e93\u3002", (String)"CompletionDiffAction_20", (String)"macc-cad-mservice", (Object[])new Object[0]));
        }
        QFilter orgFilter = new QFilter("org", "in", (Object)hasPermInvOrgs);
        QFilter timeQf = this.getCompletionContext().getCollectReport().getTimeQf();
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_mdc_omcmplinbill", (String)"id,billno,biztype,invscheme,'-1' workcenter,billentry.entryreqorg org,billentry.producedept adminorg,billstatus,billentry.id entryid,billentry.Seq seq,bookdate,0 as probill,'wwwgrk' as billtype,billtype.billformid.number entityid", (QFilter[])new QFilter[]{orgFilter, timeQf}, (String)"id asc");
    }
}

