/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.factedoutput;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.business.numcheck.CollNumCheckHelper;
import kd.macc.cad.common.dto.CollectDiff;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.CollectReportHelper;
import kd.macc.cad.mservice.factedoutput.AbstractCompletionAction;

public class CompletionDiffForConfigAction
extends AbstractCompletionAction {
    private final Log logger = LogFactory.getLog(CompletionDiffForConfigAction.class);

    @Override
    protected void doExecute() {
        if (!CollectReportHelper.disableCollectReport()) {
            CollectReport collectReport = this.getCompletionContext().getCollectReport();
            this.getCompletionContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u68c0\u67e5\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02", (String)"CompletionDiffForConfigAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
            Map billNoReasonMap = this.getCompletionContext().getErrorInfMap();
            ArrayList diffs = Lists.newArrayListWithExpectedSize((int)8);
            for (Map.Entry billNoReason : billNoReasonMap.entrySet()) {
                String key = (String)billNoReason.getKey();
                String[] split = key.split("@");
                String value = (String)billNoReason.getValue();
                CollectDiff collectDiff = new CollectDiff(split[0], Integer.valueOf(Integer.parseInt(split[1])), split[2], value);
                collectDiff.setSrcbillType(split[2]);
                if (value.length() > 0) {
                    collectDiff.setReason(value);
                }
                diffs.add(collectDiff);
            }
            this.getDiffReason(collectReport.getDateRange(), diffs);
            if (diffs.size() > 0) {
                this.getCompletionContext().getCollectReport().getCollectDiffs().addAll(diffs);
                this.getCompletionContext().getCollectReport().setError(true);
            }
            String desc = ResManager.loadKDString((String)"\u5171\u6709\u5dee\u5f02\u6570\u636e\u201c%s\u201d\u6761\u3002", (String)"CompletionDiffForConfigAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]);
            this.getCompletionContext().getCollectReport().logCheckDesc(String.format(desc, diffs.size()));
            try (TXHandle handle = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{collectReport.transfer2Dynamic(Boolean.FALSE)});
            }
        }
        this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"CompletionDiffForConfigAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, false);
    }

    private void getDiffReason(String daterange, List<CollectDiff> diffs) {
        Long accountOrgId = this.getCompletionContext().getCompletionArgs().getAcctOrgId();
        String appNum = this.getCompletionContext().getCompletionArgs().getAppNum();
        List<Long> costCenterIds = this.getCompletionContext().getCompletionArgs().getCostCenterIds();
        CollNumCheckHelper.getCostCenterDiff((String)"C", (String)daterange, (Long)accountOrgId, (String)appNum, costCenterIds, diffs, null);
    }
}

