/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.factedoutput;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.OutSourcePrice;
import kd.macc.cad.common.enums.CollectStatus;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.EntityPropertyHelper;
import kd.macc.cad.common.helper.ImportInitCostHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.mservice.factedoutput.AbstractCompletionAction;
import org.apache.commons.collections4.CollectionUtils;

@Deprecated
public class CompletionImportDataAction
extends AbstractCompletionAction {
    private Log logger = LogFactory.getLog(CompletionImportDataAction.class);

    @Override
    protected void doExecute() {
        Map<Long, Set<Long>> acctOrgCostCentersMap = this.getCompletionContext().getAcctOrgCostCentersMap();
        String appNum = this.getCompletionContext().getCompletionArgs().getAppNum();
        List<Long> manuOrgs = this.getCompletionContext().getCompletionArgs().getManuOrgs();
        List<Long> mftOrderEntryIds = this.getCompletionContext().getCompletionArgs().getMftOrderEntryIds();
        Map<String, Object> collectParamMap = this.getCompletionContext().getCompletionArgs().getCollectParamMap();
        Map<String, List<Long>> orgMethodCostCenters = this.getCompletionContext().getOrgMethodCostCenters();
        for (Map.Entry<Long, Set<Long>> orgAndCostCenter : acctOrgCostCentersMap.entrySet()) {
            String[] ranges;
            Long accountOrg = orgAndCostCenter.getKey();
            List<Long> orderCostCenters = orgMethodCostCenters.get(String.valueOf(accountOrg).concat(CostObjectEnum.BIZTYPE_RO.getValue()));
            if (CadEmptyUtils.isEmpty(orderCostCenters)) {
                return;
            }
            this.getCompletionContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u83b7\u53d6\u5de5\u5355\u6210\u672c\u6cd5\u6210\u672c\u4e2d\u5fc3", (String)"CompletionImportDataAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
            this.getCompletionContext().getCollectReport().setReProCostCenters(orderCostCenters);
            this.getCompletionContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u5de5\u5355\u6210\u672c\u6cd5\u6210\u672c\u4e2d\u5fc3%s\u4e2a\u3002", (String)"CompletionImportDataAction_26", (String)"macc-cad-mservice", (Object[])new Object[0]), orderCostCenters.size()));
            Map<String, List<Long>> rangeCcsMap = this.getInnerSys(accountOrg, orderCostCenters, appNum);
            Map<Long, String> outSourcePrice = this.getOutSourcePrice(accountOrg, appNum);
            Map<String, Long> accountManuorgAndCosttype = this.getCosttypeMap(manuOrgs);
            Map<Long, Map<Long, Set<OutSourcePrice>>> costtypeAndMaterialAndOutPrice = this.getOurPriceMap(accountManuorgAndCosttype);
            if (rangeCcsMap == null || rangeCcsMap.size() == 0) {
                this.getCompletionContext().getCollectReport().logStatusChange(CollectStatus.REMIND, ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\u8303\u56f4\uff0c\u5de5\u5355\u6cd5\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u7ed3\u675f\u3002", (String)"CompletionImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]));
                this.logger.info("\u6838\u7b97\u7ec4\u7ec7{}\uff0c\u6210\u672c\u4e2d\u5fc3{}\uff0c\u672a\u8bbe\u7f6e\u6210\u672c\u5f52\u96c6\u53c2\u6570", (Object)accountOrg, orderCostCenters);
                return;
            }
            String[] stringArray = ranges = new String[]{"WIPCOMPELETE", "WWGRK"};
            int n = stringArray.length;
            block9: for (int i = 0; i < n; ++i) {
                String range;
                switch (range = stringArray[i]) {
                    case "WIPCOMPELETE": {
                        orderCostCenters = rangeCcsMap.get(range);
                        if (orderCostCenters == null || orderCostCenters.isEmpty()) continue block9;
                        this.importData(accountOrg, orderCostCenters, manuOrgs, mftOrderEntryIds, outSourcePrice, accountManuorgAndCosttype, costtypeAndMaterialAndOutPrice, "im_mdc_mftmanuinbill", appNum, collectParamMap);
                        continue block9;
                    }
                    case "WWGRK": {
                        orderCostCenters = rangeCcsMap.get(range);
                        if (orderCostCenters == null || orderCostCenters.isEmpty()) continue block9;
                        this.importData(accountOrg, orderCostCenters, manuOrgs, mftOrderEntryIds, outSourcePrice, accountManuorgAndCosttype, costtypeAndMaterialAndOutPrice, "im_mdc_omcmplinbill", appNum, collectParamMap);
                    }
                }
            }
        }
    }

    private void importData(Long accountOrg, List<Long> costCenters, List<Long> manuOrgs, List<Long> mftorderentryids, Map<Long, String> outSourcePrice, Map<String, Long> accountManuorgAndCosttype, Map<Long, Map<Long, Set<OutSourcePrice>>> costtypeAndMaterialAndOutPrice, String entityName, String appNum, Map<String, Object> collectParamMap) {
        Map<String, Map<Long, Set<Long>>> resultBillMap = this.getManuBill(entityName, accountOrg, costCenters, manuOrgs, mftorderentryids, appNum, collectParamMap);
        resultBillMap.forEach((billtype, manuOrgAndBillIds) -> {
            for (Map.Entry manuOrgAndBills : manuOrgAndBillIds.entrySet()) {
                Long manuOrgId = (Long)manuOrgAndBills.getKey();
                Set sourceBillIds = (Set)manuOrgAndBills.getValue();
                String lockId = "CompletionImportDataAction@" + appNum + "@" + accountOrg + "@" + manuOrgId;
                DLock lock = DLock.create((String)lockId);
                try {
                    boolean tryLock = lock.tryLock();
                    if (!tryLock) {
                        this.logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6-\u5b58\u5728\u9501\uff1a" + lockId);
                        continue;
                    }
                    DynamicObject[] sourceBills = BusinessDataServiceHelper.load((Object[])sourceBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
                    this.dealManuInBill(accountOrg, costCenters, Collections.singletonList(manuOrgId), sourceBills, outSourcePrice, accountManuorgAndCosttype, costtypeAndMaterialAndOutPrice, entityName, (String)billtype, appNum);
                    this.deleteFactnedBillForNoSrource(accountOrg, costCenters, Collections.singletonList(manuOrgId), sourceBillIds, mftorderentryids, entityName, (String)billtype, appNum);
                    String tmp = String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\uff0c\u5f00\u59cb\u5f52\u96c6\u3002\u6e90\u5355\u7c7b\u578b\uff1a%1$s\uff0c\u6838\u7b97\u7ec4\u7ec7\uff1a%2$s\uff0c\u5b9e\u4f53\uff1a%3$s\uff0c\u6210\u672c\u4e2d\u5fc3\uff1a%4$s\uff0c\u751f\u4ea7\u7ec4\u7ec7\uff1a%5$s\uff0c\u7b26\u5408\u6761\u4ef6\u7684\u6e90\u5355\uff1a%6$s\u3002", (String)"CompletionImportDataAction_22", (String)"macc-cad-mservice", (Object[])new Object[0]), billtype, accountOrg, entityName, costCenters.toString(), manuOrgs == null ? "null" : manuOrgs.toString(), sourceBillIds.toString());
                    while (tmp.length() > 8000) {
                        this.logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6-\u5f52\u96c6\u62fc\u63a5\uff1a" + tmp.substring(0, 8000));
                        tmp = tmp.substring(8000, tmp.length());
                    }
                    this.logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6-\u5f52\u96c6\u62fc\u63a5\uff1a" + tmp);
                    List<DynamicObject> factnedBills = this.getCompletionContext().getFactnedBills();
                    this.save(factnedBills, this.getCompletionContext().getCollectReport());
                    this.getCompletionContext().getFactnedBills().clear();
                }
                catch (Exception ex) {
                    throw ex;
                }
                finally {
                    if (lock == null) continue;
                    lock.close();
                }
            }
        });
    }

    private void deleteFactnedBillForNoSrource(Long accountOrg, List<Long> costCenters, List<Long> manuOrgIds, Set<Long> sourceBillIds, List<Long> mftorderentryids, String entityName, String billtype, String appNum) {
        int delNum = 0;
        this.getCompletionContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u672c\u6279\u662f\u5426\u6709\u9700\u8981\u5220\u9664\u7684\u5355\u636e\u3002", (String)"CompletionImportDataAction_15", (String)"macc-cad-mservice", (Object[])new Object[0]));
        delNum = CadEmptyUtils.isEmpty(mftorderentryids) ? this.deleteFactBillForNotExistSourceBill(accountOrg, costCenters, manuOrgIds, sourceBillIds, billtype, appNum) : this.deleteFactBillForNotExistSourceBillWIP(accountOrg, mftorderentryids, entityName, billtype, appNum);
        this.getCompletionContext().setDelNum(this.getCompletionContext().getDelNum() + delNum);
        this.getCompletionContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u672c\u6279\u9700\u8981\u5220\u9664\u5355\u636e%s\u6761\u3002", (String)"CompletionImportDataAction_27", (String)"macc-cad-mservice", (Object[])new Object[0]), delNum));
    }

    private void dealManuInBill(Long accountOrg, List<Long> costCenters, List<Long> manuOrgs, DynamicObject[] sourceBills, Map<Long, String> outSourcePrice, Map<String, Long> accountManuorgAndCosttype, Map<Long, Map<Long, Set<OutSourcePrice>>> costtypeAndMaterialAndOutPrice, String entityName, String srcBillType, String appNum) {
        this.getCompletionContext().getCollectReport().logReportDetail(String.format(ResManager.loadKDString((String)"\u5206\u6279\u5904\u7406\u6e90\u5355\u6570\u636e\uff0c\u672c\u6279\u6e90\u5355%s\u6761\u3002", (String)"CompletionImportDataAction_28", (String)"macc-cad-mservice", (Object[])new Object[0]), sourceBills.length));
        DynamicObject[] planBills = this.getPlanBySourceBill(sourceBills, appNum, this.getCompletionContext().getCompletionArgs().getMftOrderEntryIds());
        DynamicObject[] exitFacts = null;
        if (!CadEmptyUtils.isEmpty(this.getCompletionContext().getCompletionArgs().getMftOrderEntryIds())) {
            HashSet costobjectIds = Sets.newHashSetWithExpectedSize((int)planBills.length);
            for (DynamicObject obj : planBills) {
                costobjectIds.add(obj.getLong("costobject.id"));
            }
            exitFacts = this.getExitFact(accountOrg, costCenters, manuOrgs, srcBillType, appNum, costobjectIds);
        } else {
            exitFacts = this.getExitFact(accountOrg, costCenters, manuOrgs, srcBillType, appNum, null);
        }
        HashMap<String, DynamicObject> changeFactMap = new HashMap<String, DynamicObject>(16);
        ArrayList<String> existBillNos = new ArrayList<String>(10);
        Set<String> existsIds = this.dealExitsData(sourceBills, planBills, exitFacts, changeFactMap, existBillNos);
        List<Map<String, Date>> importScopeDate = this.getCompletionContext().getOrgImportScopeDate().get(accountOrg);
        Map<String, List<DynamicObject>> costInfo = this.getCenterByBill(entityName, sourceBills, costCenters, importScopeDate);
        ArrayList<DynamicObject> factnedBill = new ArrayList<DynamicObject>();
        Map costSyncInfoMap = ImportInitCostHelper.getCostRecordMap((DynamicObject[])sourceBills);
        HashSet<String> existResoureceBillNos = new HashSet<String>(16);
        ArrayList<DynamicObject> outPutAbsorbList = new ArrayList<DynamicObject>(10);
        HashMap orgCostaccountMap = Maps.newHashMapWithExpectedSize((int)10);
        for (DynamicObject manu : sourceBills) {
            this.logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6-\u6e90\u5355{}\u5f15\u5165\u8d4b\u503c\u5f00\u59cb", (Object)manu.getString("billno"));
            List costSyncInfos = (List)costSyncInfoMap.get(manu.getLong("entryId"));
            if (CollectionUtils.isEmpty((Collection)costSyncInfos)) {
                this.logger.info("\u6e90\u5355{}\u6ca1\u6709\u751f\u6210\u6210\u672c\u6838\u7b97\u8bb0\u5f55!", (Object)manu.getString("billno"));
                continue;
            }
            String billType = manu.getString("invscheme.billform.number");
            boolean notBack = true;
            DynamicObjectCollection manuBillEntry = manu.getDynamicObjectCollection("billentry");
            Set billentrySet = EntityPropertyHelper.getEntryPropertys((String)billType, (String)"billentry");
            for (DynamicObject entry : manuBillEntry) {
                String billNo = "WGRK-" + appNum.toUpperCase() + "-" + manu.getString("billno") + "-" + entry.getString("Seq");
                String sourceId = manu.getString("id") + "-" + entry.getString("id");
                Date bookDate = manu.getDate("bookdate");
                boolean isNeedChangeData = changeFactMap.containsKey(sourceId);
                if (existsIds.contains(sourceId) && !isNeedChangeData) {
                    this.logger.info("\u6e90\u5355{}\u5df2\u5f15\u5165\u4e14\u6ca1\u6709\u53d8\u66f4\u3002", (Object)manu.getString("billno"));
                    continue;
                }
                if (!existsIds.contains(sourceId) && existBillNos.contains(billNo)) {
                    this.logger.info("\u751f\u6210\u7684\u5f52\u96c6\u5355\u5355\u636e\u7f16\u53f7{}\u5df2\u5b58\u5728\u3002", (Object)billNo);
                    continue;
                }
                DynamicObject factned = BusinessDataServiceHelper.newDynamicObject((String)"cad_factnedoutputbill");
                if (changeFactMap.containsKey(sourceId)) {
                    factned = (DynamicObject)changeFactMap.get(sourceId);
                }
                if (!isNeedChangeData) {
                    factned.set("id", (Object)ID.genLongId());
                }
                factned.set("billno", (Object)billNo);
                DynamicObject centerInfo = null;
                Long manuorg = 0L;
                if ("im_mdc_mftmanuinbill".equals(billType)) {
                    centerInfo = CostObjectHelper.getCostCenterBySrcBillDate((Date)bookDate, costInfo.get(manu.getLong("productionorg.id") + "@" + "bos_org"));
                    if (centerInfo == null) {
                        centerInfo = CostObjectHelper.getCostCenterBySrcBillDate((Date)bookDate, costInfo.get(entry.getLong("workcenterid.id") + "@" + "mpdm_workcentre"));
                    }
                    if (centerInfo == null) {
                        centerInfo = billentrySet.contains("producedept") ? CostObjectHelper.getCostCenterBySrcBillDate((Date)bookDate, costInfo.get(entry.getLong("producedept.id") + "@" + "bos_adminorg")) : CostObjectHelper.getCostCenterBySrcBillDate((Date)bookDate, costInfo.get(manu.getLong("bizdept.id") + "@" + "bos_adminorg"));
                    }
                    manuorg = manu.getDynamicObject("productionorg").getLong("id");
                    factned.set("completetype", (Object)"WIPCOMPELETE");
                }
                if ("im_mdc_mftreturnbill".equals(billType)) {
                    centerInfo = CostObjectHelper.getCostCenterBySrcBillDate((Date)bookDate, costInfo.get(manu.getLong("productionorg.id") + "@" + "bos_org"));
                    if (centerInfo == null) {
                        centerInfo = CostObjectHelper.getCostCenterBySrcBillDate((Date)bookDate, costInfo.get(entry.getLong("workcenterid.id") + "@" + "mpdm_workcentre"));
                    }
                    if (centerInfo == null) {
                        centerInfo = billentrySet.contains("producedept") ? CostObjectHelper.getCostCenterBySrcBillDate((Date)bookDate, costInfo.get(entry.getLong("producedept.id") + "@" + "bos_adminorg")) : CostObjectHelper.getCostCenterBySrcBillDate((Date)bookDate, costInfo.get(manu.getLong("bizdept.id") + "@" + "bos_adminorg"));
                    }
                    notBack = false;
                    manuorg = manu.getDynamicObject("productionorg").getLong("id");
                    factned.set("completetype", (Object)"WIPCOMPELETEBACK");
                }
                if ("im_mdc_omcmplinbill".equals(billType)) {
                    centerInfo = CostObjectHelper.getCostCenterBySrcBillDate((Date)bookDate, costInfo.get(entry.getLong("entryreqorg.id") + "@" + "bos_org"));
                    if (centerInfo == null) {
                        centerInfo = CostObjectHelper.getCostCenterBySrcBillDate((Date)bookDate, costInfo.get(entry.getLong("producedept.id") + "@" + "bos_adminorg"));
                    }
                    if (centerInfo == null) {
                        centerInfo = CostObjectHelper.getCostCenterBySrcBillDate((Date)bookDate, costInfo.get(entry.getLong("workcenter.id") + "@" + "mpdm_workcentre"));
                    }
                    manuorg = entry.getDynamicObject("entryreqorg").getLong("id");
                    factned.set("completetype", (Object)"WWGRK");
                }
                factned.set("bizdate", this.getBizDate(manu.getDate("biztime")));
                factned.set("bookdate", this.getBizDate(manu.getDate("bookdate")));
                factned.set("appnum", (Object)appNum);
                factned.set("sourcebill", (Object)Long.parseLong(manu.getPkValue().toString()));
                factned.set("sourcebillentry", (Object)Long.parseLong(entry.getPkValue().toString()));
                factned.set("sourcebiztime", (Object)manu.getDate("biztime"));
                factned.set("producttype", (Object)entry.getString("producttype"));
                factned.set("qualitystatus", (Object)entry.getString("qualitystatus"));
                Long acOrg = centerInfo == null ? 0L : centerInfo.getLong("orgid");
                Long csCen = centerInfo == null ? 0L : centerInfo.getLong("id");
                factned.set("material_id", (Object)entry.getLong("material.masterid.id"));
                factned.set("material", (Object)entry.getLong("material.masterid.id"));
                factned.set("baseunit", (Object)entry.getLong("baseunit.id"));
                BigDecimal completeqty = entry.getBigDecimal("baseqty");
                factned.set("completeqty", (Object)completeqty);
                factned.set("warehouse", (Object)entry.getLong("warehouse.id"));
                factned.set("location", (Object)entry.getLong("location.id"));
                factned.set("batch", (Object)entry.getString("lotnumber"));
                factned.set("wareinorg", (Object)entry.getLong("owner.id"));
                factned.set("billstatus", (Object)"C");
                factned.set("auditor", (Object)Long.valueOf(RequestContext.get().getUserId()));
                factned.set("auditdate", (Object)TimeServiceHelper.now());
                factned.set("srcauditdate", (Object)DateUtils.getPriceDate((Date)manu.getDate("auditdate"), (Date)manu.getDate("bookdate")));
                factned.set("nsrcauditdate", (Object)manu.getDate("auditdate"));
                factned.set("org_id", (Object)acOrg);
                factned.set("org", (Object)acOrg);
                factned.set("costcenter_id", (Object)csCen);
                factned.set("costcenter", (Object)csCen);
                factned.set("manuorg_id", (Object)manuorg);
                factned.set("manuorg", (Object)manuorg);
                if (!isNeedChangeData) {
                    factned.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
                    factned.set("createtime", (Object)TimeServiceHelper.now());
                }
                factned.set("srcbilltype", (Object)billType);
                DynamicObjectCollection entryentity = factned.getDynamicObjectCollection("entryentity");
                entryentity.clear();
                BigDecimal curComplateQty = BigDecimal.ZERO;
                HashMap<Long, Boolean> outSourceMaterialMap = new HashMap<Long, Boolean>(16);
                for (DynamicObject plan : planBills) {
                    if (!plan.getString("costobject.srcbillnumber").equals(entry.getString("manubill")) || !(entry.getString("manuentry") == null ? "" : entry.getString("manuentry")).equals(String.valueOf(plan.getInt("costobject.srcbillrow"))) || plan.getLong("material.id") != entry.getLong("material.masterid.id") || curComplateQty.abs().compareTo(completeqty.abs()) >= 0) continue;
                    DynamicObject newEntity = entryentity.addNew();
                    if (csCen.equals(0L)) {
                        factned.set("costcenter", (Object)plan.getLong("costcenter.id"));
                    }
                    newEntity.set("plannedoutput", (Object)plan);
                    if (centerInfo != null && centerInfo.getLong("id") != plan.getLong("costobject.costcenter.id")) {
                        this.logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u6210\u672c\u4e2d\u5fc3\u4e0e\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e0a\u7684\u6210\u672c\u4e2d\u5fc3\u4e0d\u4e00\u81f4\uff0c\u5199\u5165\u53d1\u751f\u6210\u672c\u4e2d\u5fc3\u3002");
                    }
                    newEntity.set("costobject", (Object)plan.getLong("costobject.id"));
                    DynamicObject costobject = plan.getDynamicObject("costobject");
                    if (costobject != null) {
                        DynamicObject auxpty;
                        DynamicObject bomVersion = costobject.getDynamicObject("bomversion");
                        if (bomVersion != null) {
                            factned.set("version", (Object)bomVersion.getLong("id"));
                        }
                        if ((auxpty = costobject.getDynamicObject("auxpty")) != null) {
                            factned.set("auxpty", (Object)auxpty.getLong("id"));
                        }
                        long materialId = costobject.getLong("material.id");
                        boolean isOutSource = costobject.getBoolean("isoutsource");
                        outSourceMaterialMap.put(materialId, isOutSource);
                    }
                    BigDecimal qty = plan.getBigDecimal("qty");
                    curComplateQty = curComplateQty.add(qty);
                    newEntity.set("qty", (Object)(notBack ? qty : BigDecimal.ZERO.subtract(qty)));
                }
                if ("sca".equals(appNum)) {
                    DynamicObjectCollection entryEntity = factned.getDynamicObjectCollection("entrycost");
                    entryEntity.clear();
                    ImportInitCostHelper.createEntryCost((DynamicObject)factned, (List)costSyncInfos, outSourcePrice, outSourceMaterialMap, (Map)orgCostaccountMap);
                    DynamicObjectCollection entrycost = factned.getDynamicObjectCollection("entrycost");
                    if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entrycost)) {
                        this.getCompletionContext().logErrorMsg(manu.getString("billno").concat("@").concat(entry.getString("seq")), ResManager.loadKDString((String)"\u672a\u627e\u5230\u6e90\u5355\u5bf9\u5e94\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\u3002", (String)"CompletionImportDataAction_18", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        this.logger.info("\u672a\u627e\u5230\u6e90\u5355\u5bf9\u5e94\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\uff0c\u521b\u5efaentrycost\u5931\u8d25\uff0c\u5f15\u5165\u5931\u8d25\uff0c\u6e90\u5355:{}", (Object)manu.getString("billno"));
                        continue;
                    }
                }
                this.doDiff(completeqty, entryentity, notBack);
                HashSet<OutSourcePrice> effectOutSourcePrices = new HashSet<OutSourcePrice>(16);
                if ("im_mdc_omcmplinbill".equals(billType)) {
                    for (Map.Entry<String, Long> ele : accountManuorgAndCosttype.entrySet()) {
                        String[] split = ele.getKey().split("-");
                        Long costaccount = Long.valueOf(split[0]);
                        Long manuorgId = Long.valueOf(split[1]);
                        if (manuorgId != 0L && !manuorgId.equals(factned.getLong("manuorg"))) continue;
                        Long costtype = ele.getValue();
                        Long material = factned.getLong("material");
                        Date srcAuditDate = factned.getDate("srcauditdate");
                        Map<Long, Set<OutSourcePrice>> materialAndOutPrice = costtypeAndMaterialAndOutPrice.get(costtype);
                        Set outSourcePrices = materialAndOutPrice.computeIfAbsent(material, v -> new HashSet(16));
                        for (OutSourcePrice materialPrice : outSourcePrices) {
                            if (srcAuditDate.getTime() < materialPrice.getEffectDate().getTime() || srcAuditDate.getTime() >= materialPrice.getExpDate().getTime()) continue;
                            effectOutSourcePrices.add(materialPrice);
                            DynamicObject resourceAbsorb = this.buildResourceAbsorbBill(factned, entryentity, costaccount, materialPrice);
                            if (resourceAbsorb.getDynamicObjectCollection("entryentity").size() <= 0) continue;
                            resourceAbsorb.set("billno", (Object)this.getResourceAbsorbBillno(factned.getString("billno"), "1", existResoureceBillNos, 1));
                            outPutAbsorbList.add(resourceAbsorb);
                        }
                        existResoureceBillNos.clear();
                    }
                }
                if (entryentity.size() > 0) {
                    if (effectOutSourcePrices.size() == 0 && "im_mdc_omcmplinbill".equals(billType)) {
                        this.getCompletionContext().logErrorMsg(manu.getString("billno").concat("@").concat(entry.getString("seq")), ResManager.loadKDString((String)"\u59d4\u5916\u4ea7\u91cf\u5f52\u96c6\u672a\u7ef4\u62a4\u4ea7\u54c1\u59d4\u5916\u6807\u51c6\u4ef7\u76ee\u8868\u3002", (String)"CompletionImportDataAction_30", (String)"macc-cad-mservice", (Object[])new Object[0]));
                        continue;
                    }
                    factnedBill.add(factned);
                    if (!isNeedChangeData) {
                        this.getCompletionContext().setAddNum(this.getCompletionContext().getAddNum() + 1);
                        continue;
                    }
                    this.getCompletionContext().setUpdateNum(this.getCompletionContext().getUpdateNum() + 1);
                    continue;
                }
                this.getCompletionContext().logErrorMsg(manu.getString("billno").concat("@").concat(entry.getString("seq")), ResManager.loadKDString((String)"\u672a\u627e\u5230\u5df2\u5ba1\u6838\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u3002", (String)"CompletionImportDataAction_19", (String)"macc-cad-mservice", (Object[])new Object[0]));
            }
            this.logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6-\u6e90\u5355{}\u5f15\u5165\u8d4b\u503c\u7ed3\u675f", (Object)manu.getString("billno"));
        }
        if (CadEmptyUtils.isEmpty(factnedBill) || factnedBill.size() <= 0) {
            this.getCompletionContext().getCollectReport().logStatusChange(CollectStatus.REMIND, ResManager.loadKDString((String)"\u672c\u6279\u6ca1\u6709\u9700\u8981\u5bfc\u5165\u7684\u5355\u636e\u3002", (String)"CompletionImportDataAction_20", (String)"macc-cad-mservice", (Object[])new Object[0]));
            this.logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6-\u6ca1\u6709\u9700\u8981\u5f15\u5165\u7684\u5355\u636e");
            return;
        }
        SaveServiceHelper.save((DynamicObject[])outPutAbsorbList.toArray(new DynamicObject[0]));
        this.getCompletionContext().getFactnedBills().addAll(factnedBill);
        this.getCompletionContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5206\u6279\u5904\u7406\u6e90\u5355\u6570\u636e\uff0c\u65b0\u589e\u6216\u4fee\u6539\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355%s\u6761\u3002", (String)"CompletionImportDataAction_29", (String)"macc-cad-mservice", (Object[])new Object[0]), factnedBill.size()));
    }

    private Set<String> dealExitsData(DynamicObject[] sourceBill, DynamicObject[] planBills, DynamicObject[] exitFacts, Map<String, DynamicObject> changeFactMap, List<String> existBillNos) {
        HashSet<Long> exitsPlanIds = new HashSet<Long>(200);
        HashSet<String> exitsSourceIds = new HashSet<String>(200);
        HashMap<Long, Date> dateMap = new HashMap<Long, Date>(16);
        for (DynamicObject manu : sourceBill) {
            dateMap.put(manu.getLong("id"), manu.getDate("auditdate"));
        }
        if (exitFacts.length == 0) {
            return exitsSourceIds;
        }
        for (DynamicObject exitFact : exitFacts) {
            exitsSourceIds.add(exitFact.getString("sourcebill") + "-" + exitFact.getString("sourcebillentry"));
            existBillNos.add(exitFact.getString("billno"));
        }
        Map<String, DynamicObject> idEntryIdCompleteMap = this.groupEntryIdCompleteMap(exitFacts);
        for (DynamicObject planBill : planBills) {
            exitsPlanIds.add(planBill.getLong("id"));
        }
        HashSet<Long> deleteData = new HashSet<Long>(16);
        HashSet<Long> deleteSrcData = new HashSet<Long>(16);
        ArrayList<DynamicObject> costChangeRecords = new ArrayList<DynamicObject>(10);
        for (DynamicObject fact : exitFacts) {
            String factKey = fact.getString("sourcebill") + "-" + fact.getString("sourcebillentry");
            DynamicObjectCollection entryentity = fact.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                if (!exitsPlanIds.contains(entry.getDynamicObject("plannedoutput").getLong("id"))) {
                    deleteData.add(fact.getLong("id"));
                    deleteSrcData.add(fact.getLong("sourcebill"));
                    exitsSourceIds.remove(factKey);
                    if (!CostObjectHelper.isSettlement((Long)entry.getDynamicObject("costobject").getLong("id"))) continue;
                    costChangeRecords.add(fact);
                    continue;
                }
                Long srcBillId = fact.getLong("sourcebill");
                Date nsrcAuditDate = fact.getDate("nsrcauditdate");
                if (nsrcAuditDate == null || dateMap.get(srcBillId) == null || nsrcAuditDate.compareTo((Date)dateMap.get(srcBillId)) == 0) continue;
                changeFactMap.put(factKey, idEntryIdCompleteMap.get(factKey));
            }
        }
        if (!CadEmptyUtils.isEmpty(deleteData) && !CadEmptyUtils.isEmpty(deleteSrcData)) {
            this.deleteFactned(deleteData);
            this.delChangeRecord(deleteSrcData);
        }
        this.getCompletionContext().getUpdateFactnedBills().addAll(costChangeRecords);
        return exitsSourceIds;
    }

    @Override
    protected Object getBizDate(Date date) {
        if (date == null) {
            return TimeServiceHelper.now();
        }
        Calendar now = Calendar.getInstance();
        now.setTime(TimeServiceHelper.now());
        Calendar bizTime = Calendar.getInstance();
        bizTime.setTime(date);
        bizTime.set(11, now.get(11));
        bizTime.set(12, now.get(12));
        bizTime.set(13, now.get(13));
        return bizTime;
    }

    @Override
    protected void doDiff(BigDecimal completeqty, DynamicObjectCollection entryentity, Boolean notBack) {
        if (entryentity.size() == 0) {
            return;
        }
        BigDecimal maxVal = BigDecimal.ZERO;
        BigDecimal sumVal = BigDecimal.ZERO;
        BigDecimal curVal = BigDecimal.ZERO;
        int index = 0;
        for (int i = 0; i < entryentity.size(); ++i) {
            curVal = ((DynamicObject)entryentity.get(i)).getBigDecimal("qty");
            sumVal = sumVal.add(curVal);
            if (!notBack.booleanValue() && i == 0) {
                maxVal = curVal;
            }
            if (maxVal.compareTo(curVal) >= 0) continue;
            maxVal = curVal;
            index = i;
        }
        ((DynamicObject)entryentity.get(index)).set("qty", (Object)maxVal.add(completeqty.subtract(sumVal)));
    }

    private DynamicObject[] getExitFact(Long accountOrg, List<Long> costCenters, List<Long> manuOrgs, String billType, String appNum, Set<Long> costobjectIds) {
        String completetype = "";
        completetype = "im_mdc_mftmanuinbill".equals(billType) ? "WIPCOMPELETE" : ("im_mdc_mftreturnbill".equals(billType) ? "WIPCOMPELETEBACK" : "WWGRK");
        QFilter qfOrg = new QFilter("org", "=", (Object)(CadEmptyUtils.isEmpty((Long)accountOrg) ? Long.valueOf(-1L) : accountOrg));
        QFilter qfCostCenter = new QFilter("costcenter", "in", costCenters);
        QFilter qfAppnum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfSource = new QFilter("completetype", "=", (Object)completetype);
        QFilter manuOrgQf = null;
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            manuOrgQf = new QFilter("manuorg", "in", manuOrgs);
        }
        if (costobjectIds != null) {
            qfCostCenter.and("entryentity.costobject", "in", costobjectIds);
        }
        QFilter qfbizTime = SysParamHelper.getImportTimeScope((Long)accountOrg, (String)"bookdate", (String)appNum);
        String fields = "id,billno,bizdate,bookdate,appnum,org,manuorg,costcenter,srcauditdate,sourcebillentry,sourcebill,sourcebiztime,nsrcauditdate,billstatus,material,baseunit,version,auxpty,invtype,gradeprodgroup,completeqty,warehouse,location,batch,producttype,qualitystatus,wareinorg,srcauxpty,completetype,entrycost,entrycost.costaccount,entrycost.period,entrycost.costtype,entrycost.element,entrycost.subelement,entrycost.currency,entrycost.stdprice,entrycost.amount,entrycost.srcsyncdate,entryentity,entryentity.plannedoutput,entryentity.costobject,entryentity.qty,entryentity.lastqty,creator,createtime,modifier,modifytime,auditor,auditdate,srcbilltype";
        return BusinessDataServiceHelper.load((String)"cad_factnedoutputbill", (String)fields, (QFilter[])new QFilter[]{qfOrg, manuOrgQf, qfCostCenter, qfbizTime, qfAppnum, qfSource});
    }

    private DynamicObject[] getPlanBySourceBill(DynamicObject[] sourceBill, String appNum, List<Long> mftOrderEntryIds) {
        HashSet manubi = new HashSet();
        HashSet materialIds = new HashSet();
        for (DynamicObject source : sourceBill) {
            DynamicObjectCollection billentry = source.getDynamicObjectCollection("billentry");
            billentry.forEach(entry -> {
                manubi.add(entry.getString("manubill"));
                materialIds.add(entry.getLong("material.masterid.id"));
            });
        }
        QFilter qfCostObject = new QFilter("costobject.rule", "=", (Object)"SN");
        QFilter qfCostObjectSource = new QFilter("costobject.srcbillnumber", "in", (Object)manubi.toArray());
        QFilter qfMaterial = new QFilter("material", "in", (Object)materialIds.toArray());
        QFilter qfBillStatu = new QFilter("billstatus", "=", (Object)"C");
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        if (!CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            qfCostObjectSource.and("sourcebillentry", "in", mftOrderEntryIds);
        }
        return BusinessDataServiceHelper.load((String)"cad_plannedoutputbill", (String)"id,accountorg.id,costobject.srcbillnumber,costobject.srcbillrow,material.id,costobject.id,costcenter.id,qty", (QFilter[])new QFilter[]{qfCostObject, qfCostObjectSource, qfMaterial, qfBillStatu, qfAppNum}, null);
    }

    private Map<String, DynamicObject> groupEntryIdCompleteMap(DynamicObject[] exitFacts) {
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>(16);
        if (CadEmptyUtils.isEmpty((Object[])exitFacts)) {
            return resultMap;
        }
        for (DynamicObject fact : exitFacts) {
            resultMap.put(fact.getString("sourcebill") + "-" + fact.getString("sourcebillentry"), fact);
        }
        return resultMap;
    }

    private Set<Long> getNotExitsPlanned(DynamicObjectCollection exitFacts) {
        HashSet<Long> resultIds = new HashSet<Long>(16);
        HashMap<Long, Set> exitsMap = new HashMap<Long, Set>(16);
        for (DynamicObject fact : exitFacts) {
            exitsMap.computeIfAbsent(fact.getLong("plan"), s -> new HashSet(16)).add(fact.getLong("id"));
        }
        if (exitsMap.size() == 0) {
            return resultIds;
        }
        QFilter idQf = new QFilter("id", "in", exitsMap.keySet());
        DynamicObjectCollection planneds = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)"id", (QFilter[])new QFilter[]{idQf});
        for (DynamicObject plannd : planneds) {
            if (CadEmptyUtils.isEmpty((Set)((Set)exitsMap.get(plannd.getLong("id"))))) continue;
            exitsMap.remove(plannd.getLong("id"));
        }
        for (Set value : exitsMap.values()) {
            resultIds.addAll(value);
        }
        return resultIds;
    }

    @Override
    public void deleteFactned(Set<Long> deleteIds) {
        QFilter filter = new QFilter("id", "in", deleteIds);
        DynamicObjectCollection factOutputs = QueryServiceHelper.query((String)"cad_factnedoutputbill", (String)"id,entryentity.plannedoutput plannedoutputid,entryentity.qty qty", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)factOutputs)) {
            return;
        }
        HashMap<Long, BigDecimal> planAndQty = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject factOutput : factOutputs) {
            long plannedoutputid = factOutput.getLong("plannedoutputid");
            if (planAndQty.get(plannedoutputid) == null) {
                planAndQty.put(plannedoutputid, factOutput.getBigDecimal("qty"));
                continue;
            }
            BigDecimal qty = ((BigDecimal)planAndQty.get(plannedoutputid)).add(factOutput.getBigDecimal("qty"));
            planAndQty.put(plannedoutputid, qty);
        }
        Object[] plannedOutputs = BusinessDataServiceHelper.load((Object[])planAndQty.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_plannedoutputbill"));
        if (CadEmptyUtils.isEmpty((Object[])plannedOutputs)) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cad_factnedoutputbill"), (Object[])deleteIds.toArray(new Long[0]));
            return;
        }
        for (Object plan : plannedOutputs) {
            BigDecimal deleteQty = (BigDecimal)planAndQty.get(plan.getLong("id"));
            BigDecimal planQty = plan.getBigDecimal("qty");
            BigDecimal totalinqty = plan.getBigDecimal("totalinqty").subtract(deleteQty);
            BigDecimal wipqty = planQty.subtract(totalinqty);
            if (totalinqty.compareTo(planQty) >= 0) {
                wipqty = BigDecimal.ZERO;
            }
            plan.set("totalinqty", (Object)totalinqty);
            plan.set("wipqty", (Object)wipqty);
        }
        SaveServiceHelper.update((DynamicObject[])plannedOutputs);
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cad_factnedoutputbill"), (Object[])deleteIds.toArray(new Long[0]));
    }

    private int deleteFactBillForNotExistSourceBill(Long accountOrg, List<Long> costCenters, List<Long> manuOrgs, Set<Long> resultBill, String billtype, String appNum) {
        String completetype = "";
        completetype = "im_mdc_mftmanuinbill".equals(billtype) ? "WIPCOMPELETE" : ("im_mdc_mftreturnbill".equals(billtype) ? "WIPCOMPELETEBACK" : "WWGRK");
        if (CadEmptyUtils.isEmpty(resultBill)) {
            this.deleteAll(accountOrg, costCenters, completetype, appNum);
            return 0;
        }
        QFilter qfOrg = new QFilter("org", "=", (Object)(CadEmptyUtils.isEmpty((Long)accountOrg) ? Long.valueOf(-1L) : accountOrg));
        QFilter qfCostCenter = new QFilter("costcenter", "in", costCenters);
        QFilter qfSourceBill = new QFilter("sourcebill", "not in", resultBill);
        QFilter qfSource = new QFilter("completetype", "=", (Object)completetype);
        QFilter qfManuOrg = null;
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            qfManuOrg = new QFilter("manuorg", "in", manuOrgs);
        }
        QFilter qfAppnum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfbizTime = SysParamHelper.getImportTimeScope((Long)accountOrg, (String)"bizdate", (String)appNum);
        qfbizTime = qfbizTime.and(qfSourceBill);
        String selectfield = "id,org,billno,costcenter,sourcebill,sourcebillentry,bizdate biztime,bookdate,sourcebiztime,producttype producttype,qualitystatus qualitystatus,material material.masterid.id,baseunit.id unit.id,version.id mversion.id,auxpty.id,completeqty,warehouse.id,location.id,batch lotnumber,wareinorg.id productionorg.id,srcauditdate,entryentity.id entryid, entryentity.plannedoutput.id plan,entryentity.costobject costobject,entryentity.qty qty";
        DynamicObjectCollection factBillForNotExistSourceBills = QueryServiceHelper.query((String)"cad_factnedoutputbill", (String)selectfield, (QFilter[])new QFilter[]{qfOrg, qfCostCenter, qfManuOrg, qfSourceBill, qfSource, qfAppnum, qfbizTime});
        ArrayList<DynamicObject> costChangeRecords = new ArrayList<DynamicObject>(10);
        HashSet<Long> factIdsByDel = new HashSet<Long>(16);
        HashSet<Long> srcIdsByDel = new HashSet<Long>(16);
        for (DynamicObject factBillForNotExistSourceBill : factBillForNotExistSourceBills) {
            factIdsByDel.add(factBillForNotExistSourceBill.getLong("id"));
            srcIdsByDel.add(factBillForNotExistSourceBill.getLong("sourcebill"));
            if (!CostObjectHelper.isSettlement((Long)factBillForNotExistSourceBill.getLong("costobject"))) continue;
            costChangeRecords.add(factBillForNotExistSourceBill);
        }
        if (!CadEmptyUtils.isEmpty(factIdsByDel) && !CadEmptyUtils.isEmpty(srcIdsByDel)) {
            this.deleteFactned(factIdsByDel);
            this.delChangeRecord(srcIdsByDel);
        }
        this.getCompletionContext().getDelFactnedBills().addAll(costChangeRecords);
        return factIdsByDel.size();
    }

    private int deleteFactBillForNotExistSourceBillWIP(Long accountOrg, List<Long> mftorderentryids, String entityName, String billtype, String appNum) {
        ArrayList<DynamicObject> costChangeRecords = new ArrayList<DynamicObject>(10);
        String completetype = "";
        completetype = "im_mdc_mftmanuinbill".equals(billtype) ? "WIPCOMPELETE" : ("im_mdc_mftreturnbill".equals(billtype) ? "WIPCOMPELETEBACK" : "WWGRK");
        HashSet<Long> factIdsByDel = new HashSet<Long>(16);
        HashSet<Long> srcIdsByDel = new HashSet<Long>(16);
        QFilter qfSourceBill = new QFilter("billentry.manuentryid", "in", mftorderentryids);
        List sourceBillIds = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])new QFilter[]{qfSourceBill}, null, (int)-1);
        DynamicObject[] srcs = BusinessDataServiceHelper.load((Object[])sourceBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        ArrayList<Long> sourceBillsNotAudito = new ArrayList<Long>(10);
        for (DynamicObject src : srcs) {
            if ("C".equals(src.getString("billstatus"))) continue;
            sourceBillsNotAudito.add(src.getLong("id"));
        }
        if (CadEmptyUtils.isEmpty(sourceBillsNotAudito)) {
            return 0;
        }
        String selectfield = "id,org,billno,costcenter,sourcebill,sourcebillentry,bizdate biztime,bookdate,producttype producttype,qualitystatus qualitystatus,material material.masterid.id,baseunit.id unit.id,version.id mversion.id,auxpty.id,completeqty baseqty,warehouse.id,location.id,batch lotnumber,wareinorg.id productionorg.id,srcauditdate,entryentity.id entryid, entryentity.plannedoutput.id plan,entryentity.costobject costobject,entryentity.qty qty";
        QFilter qfSourceType = new QFilter("completetype", "=", (Object)completetype);
        QFilter qfAppnum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfSource = new QFilter("sourcebill", "in", sourceBillsNotAudito);
        QFilter qfbizTime = SysParamHelper.getImportTimeScope((Long)accountOrg, (String)"bookdate", (String)appNum);
        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)"cad_factnedoutputbill", (String)selectfield, (QFilter[])new QFilter[]{qfSource, qfSourceType, qfAppnum, qfbizTime});
        for (DynamicObject sourceBill : sourceBills) {
            factIdsByDel.add(sourceBill.getLong("id"));
            srcIdsByDel.add(sourceBill.getLong("sourcebill"));
            if (!CostObjectHelper.isSettlement((Long)sourceBill.getLong("costobject"))) continue;
            costChangeRecords.add(sourceBill);
        }
        if (!CadEmptyUtils.isEmpty(factIdsByDel) && !CadEmptyUtils.isEmpty(srcIdsByDel)) {
            this.deleteFactned(factIdsByDel);
            this.delChangeRecord(srcIdsByDel);
        }
        this.getCompletionContext().getDelFactnedBills().addAll(costChangeRecords);
        return factIdsByDel.size();
    }

    private void deleteAll(Long accountOrg, List<Long> costCenters, String completetype, String appNum) {
        QFilter qfSource = new QFilter("completetype", "=", (Object)completetype);
        QFilter qfAppnum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfOrg = new QFilter("org", "=", (Object)(CadEmptyUtils.isEmpty((Long)accountOrg) ? Long.valueOf(-1L) : accountOrg));
        QFilter qfCostCenter = new QFilter("costcenter", "in", costCenters);
        QFilter qfbizTime = SysParamHelper.getImportTimeScope((Long)accountOrg, (String)"bizdate", (String)appNum);
        String selectfield = "id,org,billno,costcenter,sourcebill,sourcebillentry,bizdate biztime,bookdate,producttype producttype,qualitystatus qualitystatus,material material.masterid.id,baseunit.id unit.id,version.id mversion.id,auxpty.id,completeqty baseqty,warehouse.id,location.id,batch lotnumber,wareinorg.id productionorg.id,srcauditdate,entryentity.id entryid, entryentity.plannedoutput.id plan,entryentity.costobject costobject,entryentity.qty qty";
        DynamicObjectCollection plannedBill = QueryServiceHelper.query((String)"cad_factnedoutputbill", (String)selectfield, (QFilter[])new QFilter[]{qfSource, qfOrg, qfCostCenter, qfbizTime, qfAppnum});
        ArrayList<DynamicObject> costChangeRecords = new ArrayList<DynamicObject>(10);
        HashSet<Long> deleteIds = new HashSet<Long>(16);
        HashSet<Long> deleteSrcIds = new HashSet<Long>(16);
        for (DynamicObject fact : plannedBill) {
            deleteIds.add(fact.getLong("id"));
            deleteSrcIds.add(fact.getLong("sourcebill"));
            if (!CostObjectHelper.isSettlement((Long)fact.getLong("costobject"))) continue;
            costChangeRecords.add(fact);
        }
        if (!CadEmptyUtils.isEmpty(deleteIds) && !CadEmptyUtils.isEmpty(deleteSrcIds)) {
            this.deleteFactned(deleteIds);
            this.delChangeRecord(deleteSrcIds);
        }
        this.getCompletionContext().getDelFactnedBills().addAll(costChangeRecords);
    }

    private Map<String, Long> getCosttypeMap(List<Long> manuOrgs) {
        HashMap<String, Long> accountManuorgAndCosttype = new HashMap<String, Long>();
        Long acctOrgId = this.getCompletionContext().getCompletionArgs().getAcctOrgId();
        QFilter startQF = new QFilter("org", "=", (Object)acctOrgId);
        startQF.and("entryentity.isinit", "=", (Object)true);
        DynamicObjectCollection sca_startstdcost = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount costaccount", (QFilter[])startQF.toArray());
        Set costaccountSet = sca_startstdcost.stream().map(v -> v.getLong("costaccount")).collect(Collectors.toSet());
        for (Long costaccount : costaccountSet) {
            if (!manuOrgs.isEmpty()) {
                for (Long manuOrg : manuOrgs) {
                    Long costtypeId = CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)costaccount, (Long)acctOrgId, (Long)manuOrg);
                    if (costtypeId == null) continue;
                    accountManuorgAndCosttype.put(costaccount + "-" + manuOrg, costtypeId);
                }
                continue;
            }
            Long costtypeId = CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)costaccount, (Long)acctOrgId, null);
            if (costtypeId == null) continue;
            accountManuorgAndCosttype.put(costaccount + "-0", costtypeId);
        }
        return accountManuorgAndCosttype;
    }

    private Map<Long, Map<Long, Set<OutSourcePrice>>> getOurPriceMap(Map<String, Long> accountManuorgAndCosttype) {
        HashMap<Long, Map<Long, Set<OutSourcePrice>>> costtypeAndMaterialAndOutPrice = new HashMap<Long, Map<Long, Set<OutSourcePrice>>>(16);
        for (Long costtype : accountManuorgAndCosttype.values()) {
            QFilter filter = QFilter.of((String)"billstatus ='C' and costtype =?", (Object[])new Object[]{costtype});
            DynamicObjectCollection allOutSourcePrice = QueryServiceHelper.query((String)"cad_outsourceprice", (String)"id,material,element,subelement,price,effectdate,expdate,keycol,keycolid,entryentity.extelement extelement,entryentity.extsubelement extsubelement,entryentity.amount amount", (QFilter[])new QFilter[]{filter});
            HashMap<Long, Set> map = new HashMap<Long, Set>();
            for (DynamicObject outPriceDO : allOutSourcePrice) {
                long material = outPriceDO.getLong("material");
                Set set = map.computeIfAbsent(material, s -> new HashSet());
                Long element = outPriceDO.getLong("element");
                Long subElement = outPriceDO.getLong("subelement");
                BigDecimal price = outPriceDO.getBigDecimal("price");
                Date effectDate = outPriceDO.getDate("effectdate");
                Date expDate = outPriceDO.getDate("expdate");
                String keycol = outPriceDO.getString("keycol");
                Long keycolid = outPriceDO.getLong("keycolid");
                OutSourcePrice outSource = new OutSourcePrice(Long.valueOf(material), Integer.valueOf(1), element, subElement, price, effectDate, expDate, keycol, keycolid);
                set.add(outSource);
                Long extElement = outPriceDO.getLong("extelement");
                if (CadEmptyUtils.isEmpty((Long)extElement)) continue;
                Long extSubElement = outPriceDO.getLong("extsubelement");
                BigDecimal extPrice = outPriceDO.getBigDecimal("amount");
                OutSourcePrice extOutPrice = new OutSourcePrice(Long.valueOf(material), Integer.valueOf(2), extElement, extSubElement, extPrice, effectDate, expDate, keycol, keycolid);
                set.add(extOutPrice);
            }
            costtypeAndMaterialAndOutPrice.put(costtype, map);
        }
        return costtypeAndMaterialAndOutPrice;
    }
}

